/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.resilience4j;

import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.frameworks.resilience4j.GenericDecoratorAsync;
import com.sap.cloud.sdk.frameworks.resilience4j.TimeLimiterProvider;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class DefaultTimeLimiterProvider
implements TimeLimiterProvider,
GenericDecoratorAsync {
    @Override
    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull ResilienceConfiguration configuration, @Nonnull Callable<T> callable, @Nonnull ExecutorService executor) {
        if (!configuration.timeLimiterConfiguration().isEnabled()) {
            return callable;
        }
        Supplier<Future> futureSupplier = () -> executor.submit(callable);
        TimeLimiter timeLimiter = this.getTimeLimiter(configuration);
        return TimeLimiter.decorateFutureSupplier((TimeLimiter)timeLimiter, futureSupplier);
    }

    @Override
    @Nonnull
    public TimeLimiter getTimeLimiter(@Nonnull ResilienceConfiguration configuration) {
        if (!configuration.timeLimiterConfiguration().isEnabled()) {
            throw new IllegalArgumentException("The provided resilience configuration does not set a timeout.");
        }
        return TimeLimiter.of((TimeLimiterConfig)TimeLimiterConfig.custom().timeoutDuration(configuration.timeLimiterConfiguration().timeoutDuration()).cancelRunningFuture(configuration.timeLimiterConfiguration().shouldCancelRunningFuture()).build());
    }
}

