/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.resilience4j;

import com.google.common.collect.ImmutableMap;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.cache.GenericCacheKey;
import com.sap.cloud.sdk.cloudplatform.cache.SerializableCacheKey;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.resilience.CacheExpirationStrategy;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationKey;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceRuntimeException;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.frameworks.resilience4j.CachingDecorator;
import com.sap.cloud.sdk.frameworks.resilience4j.GenericDecorator;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import javax.cache.spi.CachingProvider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCachingDecorator
implements CachingDecorator,
GenericDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCachingDecorator.class);
    private static final Map<CacheExpirationStrategy, Function<Duration, Factory<ExpiryPolicy>>> EXPIRY_STRATEGY_FACTORY_MAP = ImmutableMap.builder().put((Object)CacheExpirationStrategy.WHEN_LAST_ACCESSED, AccessedExpiryPolicy::factoryOf).put((Object)CacheExpirationStrategy.WHEN_LAST_TOUCHED, TouchedExpiryPolicy::factoryOf).put((Object)CacheExpirationStrategy.WHEN_CREATED, CreatedExpiryPolicy::factoryOf).put((Object)CacheExpirationStrategy.WHEN_LAST_MODIFIED, ModifiedExpiryPolicy::factoryOf).build();

    @Override
    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        String cacheName;
        ResilienceConfiguration.CacheConfiguration cacheConfig = configuration.cacheConfiguration();
        if (!cacheConfig.isEnabled()) {
            return callable;
        }
        CachingProvider cachingProvider = Caching.getCachingProvider();
        CacheManager cacheManager = cachingProvider.getCacheManager();
        Cache cacheInstance = cacheManager.getCache(cacheName = configuration.identifier());
        cacheInstance = cacheInstance == null ? cacheManager.createCache(cacheName, this.createCacheConfiguration(cacheConfig)) : this.recreateCacheOnNewConfiguration(cacheInstance, configuration, cacheManager);
        io.github.resilience4j.cache.Cache cache = io.github.resilience4j.cache.Cache.of((Cache)cacheInstance);
        CheckedFunction1 cachedCallable = io.github.resilience4j.cache.Cache.decorateCallable((io.github.resilience4j.cache.Cache)cache, callable);
        return () -> {
            try {
                CacheKey key;
                ResilienceIsolationKey isolation = ResilienceIsolationKey.of((ResilienceIsolationMode)configuration.isolationMode());
                Tenant tenant = isolation.getTenant();
                Principal principal = isolation.getPrincipal();
                if (cacheConfig.serializable()) {
                    List parameters = StreamSupport.stream(cacheConfig.parameters().spliterator(), false).map(Serializable.class::cast).collect(Collectors.toList());
                    key = SerializableCacheKey.of((Tenant)tenant, (Principal)principal).append(parameters);
                } else {
                    key = CacheKey.of((Tenant)tenant, (Principal)principal).append(cacheConfig.parameters());
                }
                return cachedCallable.unchecked().apply((Object)key);
            }
            catch (Exception e) {
                throw new ResilienceRuntimeException((Throwable)e);
            }
        };
    }

    @Override
    @Nonnull
    @Deprecated
    public <T> Callable<T> decorateCallable(@Nonnull ResilienceConfiguration configuration, @Nonnull Callable<T> callable) {
        return this.decorateCallable(callable, configuration);
    }

    @Nonnull
    protected <T> Configuration<GenericCacheKey<?, ?>, T> createCacheConfiguration(@Nonnull ResilienceConfiguration.CacheConfiguration configuration) {
        Factory<ExpiryPolicy> expiryPolicy = this.createCacheExpiryPolicyFactory(configuration);
        return new MutableConfiguration().setStatisticsEnabled(false).setManagementEnabled(false).setStoreByValue(false).setExpiryPolicyFactory(expiryPolicy);
    }

    @Nonnull
    private <T> Cache<GenericCacheKey<?, ?>, T> recreateCacheOnNewConfiguration(@Nonnull Cache<GenericCacheKey<?, ?>, T> cacheInstance, @Nonnull ResilienceConfiguration resilienceConfiguration, @Nonnull CacheManager cacheManager) {
        Configuration externalCacheConfig = cacheInstance.getConfiguration(Configuration.class);
        if (this.hasExternalCacheConfigurationChanged(resilienceConfiguration, externalCacheConfig)) {
            log.info("ResilienceConfiguration: {}: Destroying cache since a new cache configuration was detected.", (Object)resilienceConfiguration.identifier());
            cacheManager.destroyCache(resilienceConfiguration.identifier());
            return cacheManager.createCache(resilienceConfiguration.identifier(), this.createCacheConfiguration(resilienceConfiguration.cacheConfiguration()));
        }
        return cacheInstance;
    }

    private boolean hasExternalCacheConfigurationChanged(@Nonnull ResilienceConfiguration resilienceConfig, @Nullable Configuration<?, ?> externalCacheConfig) {
        if (!(externalCacheConfig instanceof CompleteConfiguration)) {
            return false;
        }
        Factory externalPolicyFactory = ((CompleteConfiguration)externalCacheConfig).getExpiryPolicyFactory();
        if (externalPolicyFactory == null) {
            return false;
        }
        Object externalRawPolicy = externalPolicyFactory.create();
        if (!(externalRawPolicy instanceof ExpiryPolicy)) {
            return false;
        }
        ResilienceConfiguration.CacheConfiguration cacheConfiguration = resilienceConfig.cacheConfiguration();
        ExpiryPolicy expectedPolicy = (ExpiryPolicy)this.createCacheExpiryPolicyFactory(cacheConfiguration).create();
        ExpiryPolicy externalPolicy = (ExpiryPolicy)externalRawPolicy;
        return !Objects.equals(expectedPolicy.getExpiryForUpdate(), externalPolicy.getExpiryForUpdate()) || !Objects.equals(expectedPolicy.getExpiryForAccess(), externalPolicy.getExpiryForAccess()) || !Objects.equals(expectedPolicy.getExpiryForCreation(), externalPolicy.getExpiryForCreation());
    }

    @Nonnull
    private Factory<ExpiryPolicy> createCacheExpiryPolicyFactory(@Nonnull ResilienceConfiguration.CacheConfiguration cacheConfig) {
        Duration duration = new Duration(TimeUnit.MILLISECONDS, cacheConfig.expirationDuration().toMillis());
        CacheExpirationStrategy expiryStrategyType = cacheConfig.expirationStrategy();
        return this.getExpiryPolicyFactory(expiryStrategyType, duration);
    }

    @Nonnull
    private Factory<ExpiryPolicy> getExpiryPolicyFactory(@Nonnull CacheExpirationStrategy expiryStrategy, @Nonnull Duration cacheDuration) {
        Function<Duration, Factory<ExpiryPolicy>> factoryMethod = EXPIRY_STRATEGY_FACTORY_MAP.get(expiryStrategy);
        if (factoryMethod == null) {
            throw new ShouldNotHappenException("Provided cache expiry strategy is not supported: Missing mapping between the key and JCache expiry policy.");
        }
        return factoryMethod.apply(cacheDuration);
    }
}

