/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.resilience4j;

import com.google.common.collect.Streams;
import com.sap.cloud.sdk.cloudplatform.cache.GenericCacheKey;
import com.sap.cloud.sdk.cloudplatform.resilience.CacheFilter;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorationStrategy;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceRuntimeException;
import com.sap.cloud.sdk.frameworks.resilience4j.DefaultBulkheadProvider;
import com.sap.cloud.sdk.frameworks.resilience4j.DefaultCachingDecorator;
import com.sap.cloud.sdk.frameworks.resilience4j.DefaultCircuitBreakerProvider;
import com.sap.cloud.sdk.frameworks.resilience4j.DefaultRateLimiterProvider;
import com.sap.cloud.sdk.frameworks.resilience4j.DefaultRetryProvider;
import com.sap.cloud.sdk.frameworks.resilience4j.DefaultTimeLimiterProvider;
import com.sap.cloud.sdk.frameworks.resilience4j.GenericDecorator;
import io.vavr.control.Try;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.cache.Cache;
import javax.cache.Caching;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resilience4jDecorationStrategy
implements ResilienceDecorationStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Resilience4jDecorationStrategy.class);
    @Nonnull
    private final List<GenericDecorator> decorators;
    protected static final List<GenericDecorator> DEFAULT_DECORATORS = Arrays.asList(new DefaultBulkheadProvider(), new DefaultTimeLimiterProvider(), new DefaultRateLimiterProvider(), new DefaultCircuitBreakerProvider(), new DefaultCachingDecorator(), new DefaultRetryProvider());

    public Resilience4jDecorationStrategy() {
        this(DEFAULT_DECORATORS);
    }

    public Resilience4jDecorationStrategy(GenericDecorator ... decorators) {
        this(Arrays.stream(decorators).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public void clearCache(@Nonnull ResilienceConfiguration configuration) {
        this.clearCache(configuration, CacheFilter.and((CacheFilter)CacheFilter.keyMatchesTenant(), (CacheFilter[])new CacheFilter[]{CacheFilter.keyMatchesPrincipal(), CacheFilter.keyMatchesParameters()}));
    }

    public void clearCache(@Nonnull ResilienceConfiguration configuration, @Nonnull CacheFilter filter) {
        Cache cache = Caching.getCachingProvider().getCacheManager().getCache(configuration.identifier());
        if (cache == null) {
            return;
        }
        Set keysToClear = Streams.stream((Iterable)cache).filter(entry -> filter.matches(configuration, (GenericCacheKey)entry.getKey(), entry.getValue())).map(Cache.Entry::getKey).collect(Collectors.toSet());
        log.debug("Removing {} entries from the cache with configuration id \"{}\".", (Object)keysToClear.size(), (Object)configuration.identifier());
        cache.removeAll(keysToClear);
    }

    public void clearAllCacheEntries(@Nonnull ResilienceConfiguration configuration) {
        Cache cache = Caching.getCachingProvider().getCacheManager().getCache(configuration.identifier());
        if (cache != null) {
            cache.clear();
        }
    }

    @Nonnull
    public <T> Supplier<T> decorateSupplier(@Nonnull Supplier<T> supplier, @Nonnull ResilienceConfiguration configuration, @Nullable Function<? super Throwable, T> fallbackFunction) {
        Callable<Object> callable = this.decorateCallable(supplier::get, configuration, fallbackFunction);
        return () -> Try.ofCallable((Callable)callable).get();
    }

    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration config, @Nullable Function<? super Throwable, T> fallbackFunction) {
        Callable<Object> decoratedCall = () -> {
            log.debug("Invoking decorated callable {} with applied decorators {} and configuration {}.", new Object[]{callable, this.decorators, config});
            return callable.call();
        };
        for (GenericDecorator deco : this.decorators) {
            log.trace("Decorating callable {} with decorator {}.", callable, (Object)deco);
            decoratedCall = deco.decorateCallable(decoratedCall, config);
        }
        Callable<Object> finalDecoratedCallable = decoratedCall;
        return () -> {
            Try callableResult = Try.ofCallable((Callable)finalDecoratedCallable);
            if (fallbackFunction != null) {
                callableResult = callableResult.recover(fallbackFunction);
            }
            return callableResult.onFailure(t -> {
                throw new ResilienceRuntimeException(t);
            }).get();
        };
    }

    @Nonnull
    @Generated
    public static Resilience4jDecorationStrategyBuilder builder() {
        return new Resilience4jDecorationStrategyBuilder();
    }

    @Nonnull
    @Generated
    public String toString() {
        return "Resilience4jDecorationStrategy(decorators=" + this.decorators + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resilience4jDecorationStrategy)) {
            return false;
        }
        Resilience4jDecorationStrategy other = (Resilience4jDecorationStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<GenericDecorator> this$decorators = this.decorators;
        List<GenericDecorator> other$decorators = other.decorators;
        return !(this$decorators == null ? other$decorators != null : !((Object)this$decorators).equals(other$decorators));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Resilience4jDecorationStrategy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<GenericDecorator> $decorators = this.decorators;
        result = result * 59 + ($decorators == null ? 43 : ((Object)$decorators).hashCode());
        return result;
    }

    @Generated
    private Resilience4jDecorationStrategy(@Nonnull List<GenericDecorator> decorators) {
        if (decorators == null) {
            throw new NullPointerException("decorators is marked non-null but is null");
        }
        this.decorators = decorators;
    }

    public static class Resilience4jDecorationStrategyBuilder {
        @Generated
        private ArrayList<GenericDecorator> decorators;

        @Nonnull
        public Resilience4jDecorationStrategyBuilder defaultDecorators() {
            this.decorators(DEFAULT_DECORATORS);
            return this;
        }

        @Generated
        Resilience4jDecorationStrategyBuilder() {
        }

        @Nonnull
        @Generated
        public Resilience4jDecorationStrategyBuilder decorator(GenericDecorator decorator) {
            if (this.decorators == null) {
                this.decorators = new ArrayList();
            }
            this.decorators.add(decorator);
            return this;
        }

        @Nonnull
        @Generated
        public Resilience4jDecorationStrategyBuilder decorators(@Nonnull Collection<? extends GenericDecorator> decorators) {
            if (decorators == null) {
                throw new NullPointerException("decorators cannot be null");
            }
            if (this.decorators == null) {
                this.decorators = new ArrayList();
            }
            this.decorators.addAll(decorators);
            return this;
        }

        @Nonnull
        @Generated
        public Resilience4jDecorationStrategyBuilder clearDecorators() {
            if (this.decorators != null) {
                this.decorators.clear();
            }
            return this;
        }

        @Nonnull
        @Generated
        public Resilience4jDecorationStrategy build() {
            List<Object> decorators;
            switch (this.decorators == null ? 0 : this.decorators.size()) {
                case 0: {
                    decorators = Collections.emptyList();
                    break;
                }
                case 1: {
                    decorators = Collections.singletonList(this.decorators.get(0));
                    break;
                }
                default: {
                    decorators = Collections.unmodifiableList(new ArrayList<GenericDecorator>(this.decorators));
                }
            }
            return new Resilience4jDecorationStrategy(decorators);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "Resilience4jDecorationStrategy.Resilience4jDecorationStrategyBuilder(decorators=" + this.decorators + ")";
        }
    }
}

