/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.resilience4j;

import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationKey;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.frameworks.resilience4j.CircuitBreakerProvider;
import com.sap.cloud.sdk.frameworks.resilience4j.GenericDecorator;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class DefaultCircuitBreakerProvider
implements CircuitBreakerProvider,
GenericDecorator {
    private static final CircuitBreakerConfig DEFAULT_CIRCUIT_BREAKER_CONFIG = CircuitBreakerConfig.custom().build();
    private final ConcurrentMap<ResilienceIsolationKey, CircuitBreakerRegistry> circuitBreakerRegistries = new ConcurrentHashMap<ResilienceIsolationKey, CircuitBreakerRegistry>();

    private CircuitBreakerRegistry getCircuitBreakerRegistry(@Nonnull ResilienceIsolationKey isolationKey) {
        return this.circuitBreakerRegistries.computeIfAbsent(isolationKey, k -> CircuitBreakerRegistry.of((CircuitBreakerConfig)DEFAULT_CIRCUIT_BREAKER_CONFIG));
    }

    @Override
    @Nonnull
    public CircuitBreaker getCircuitBreaker(@Nonnull ResilienceConfiguration configuration) {
        String identifier = configuration.identifier();
        ResilienceIsolationKey isolationKey = ResilienceIsolationKey.of((ResilienceIsolationMode)configuration.isolationMode());
        CircuitBreakerRegistry circuitBreakerRegistry = this.getCircuitBreakerRegistry(isolationKey);
        CircuitBreakerConfig customCircuitBreakerConfig = CircuitBreakerConfig.custom().failureRateThreshold(configuration.circuitBreakerConfiguration().failureRateThreshold()).waitDurationInOpenState(configuration.circuitBreakerConfiguration().waitDuration()).slidingWindowType(CircuitBreakerConfig.SlidingWindowType.COUNT_BASED).slidingWindowSize(configuration.circuitBreakerConfiguration().closedBufferSize()).minimumNumberOfCalls(configuration.circuitBreakerConfiguration().closedBufferSize()).permittedNumberOfCallsInHalfOpenState(configuration.circuitBreakerConfiguration().halfOpenBufferSize()).build();
        return circuitBreakerRegistry.circuitBreaker(identifier, customCircuitBreakerConfig);
    }

    @Override
    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        if (!configuration.circuitBreakerConfiguration().isEnabled()) {
            return callable;
        }
        return CircuitBreaker.decorateCallable((CircuitBreaker)this.getCircuitBreaker(configuration), callable);
    }
}

