/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.resilience4j;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ImmutableMap;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.cache.GenericCacheKey;
import com.sap.cloud.sdk.cloudplatform.cache.SerializableCacheKey;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.resilience.CacheExpirationStrategy;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationKey;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceRuntimeException;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.frameworks.resilience4j.GenericDecorator;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import javax.cache.spi.CachingProvider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCachingDecorator
implements GenericDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCachingDecorator.class);
    private static final Map<CacheExpirationStrategy, Function<javax.cache.expiry.Duration, Factory<ExpiryPolicy>>> EXPIRY_STRATEGY_FACTORY_MAP = ImmutableMap.builder().put((Object)CacheExpirationStrategy.WHEN_LAST_ACCESSED, AccessedExpiryPolicy::factoryOf).put((Object)CacheExpirationStrategy.WHEN_LAST_TOUCHED, TouchedExpiryPolicy::factoryOf).put((Object)CacheExpirationStrategy.WHEN_CREATED, CreatedExpiryPolicy::factoryOf).put((Object)CacheExpirationStrategy.WHEN_LAST_MODIFIED, ModifiedExpiryPolicy::factoryOf).build();
    static final Cache<GenericCacheKey<?, ?>, Lock> lockCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(30L)).build();

    @Override
    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        if (!configuration.cacheConfiguration().isEnabled()) {
            return callable;
        }
        return this.decorateCallableWithCache(callable, configuration);
    }

    private <T> boolean isCachedValueValid(T cachedValue) {
        return cachedValue != null;
    }

    @Nonnull
    private synchronized <T> Callable<T> decorateCallableWithCache(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        CachingProvider cachingProvider = Caching.getCachingProvider();
        CacheManager cacheManager = cachingProvider.getCacheManager();
        ResilienceConfiguration.CacheConfiguration cacheConfig = configuration.cacheConfiguration();
        String cacheName = configuration.identifier();
        javax.cache.Cache cacheInstance = cacheManager.getCache(cacheName);
        javax.cache.Cache cache = cacheInstance == null ? cacheManager.createCache(cacheName, this.createCacheConfiguration(cacheConfig)) : this.recreateCacheOnNewConfiguration(cacheInstance, configuration, cacheManager);
        return () -> {
            if (cache.isClosed()) {
                log.warn(String.format("Cache with configuration identifier '%s' was closed. Therefore methods decorated using that identifier will not be cached anymore, but instead will be executed directly.", configuration.identifier()));
                return callable.call();
            }
            GenericCacheKey<?, ?> lockCacheKey = DefaultCachingDecorator.determineLockCacheKey(configuration);
            GenericCacheKey<?, ?> dataCacheKey = DefaultCachingDecorator.determineDataCacheKey(configuration);
            Lock lock = (Lock)lockCache.get(lockCacheKey, mapKey -> new ReentrantLock());
            try {
                lock.lock();
                Object value = cache.get(dataCacheKey);
                if (!this.isCachedValueValid(value)) {
                    Object actualValue = callable.call();
                    cache.put(dataCacheKey, actualValue);
                    Object v = actualValue;
                    return v;
                }
                Object object = value;
                return object;
            }
            catch (Exception e) {
                throw new ResilienceRuntimeException((Throwable)e);
            }
            finally {
                lock.unlock();
            }
        };
    }

    private static GenericCacheKey<?, ?> determineLockCacheKey(ResilienceConfiguration configuration) {
        return DefaultCachingDecorator.determineBaseCacheKey(configuration, true);
    }

    private static GenericCacheKey<?, ?> determineDataCacheKey(ResilienceConfiguration configuration) {
        return DefaultCachingDecorator.determineBaseCacheKey(configuration, false);
    }

    private static GenericCacheKey<?, ?> determineBaseCacheKey(ResilienceConfiguration configuration, boolean appendConfigIdentifier) {
        CacheKey key;
        ResilienceConfiguration.CacheConfiguration cacheConfig = configuration.cacheConfiguration();
        ResilienceIsolationKey isolation = ResilienceIsolationKey.of((ResilienceIsolationMode)configuration.isolationMode());
        Tenant tenant = isolation.getTenant();
        Principal principal = isolation.getPrincipal();
        if (cacheConfig.serializable()) {
            List parameters = StreamSupport.stream(cacheConfig.parameters().spliterator(), false).map(Serializable.class::cast).collect(Collectors.toList());
            SerializableCacheKey cacheKey = SerializableCacheKey.of((Tenant)tenant, (Principal)principal).append(parameters);
            if (appendConfigIdentifier) {
                cacheKey.append(Collections.singleton(configuration.identifier()));
            }
            key = cacheKey;
        } else {
            CacheKey cacheKey = CacheKey.of((Tenant)tenant, (Principal)principal).append(cacheConfig.parameters());
            if (appendConfigIdentifier) {
                cacheKey.append(new Object[]{configuration.identifier()});
            }
            key = cacheKey;
        }
        return key;
    }

    @Nonnull
    protected <T> Configuration<GenericCacheKey<?, ?>, T> createCacheConfiguration(@Nonnull ResilienceConfiguration.CacheConfiguration configuration) {
        Factory<ExpiryPolicy> expiryPolicy = this.createCacheExpiryPolicyFactory(configuration);
        return new MutableConfiguration().setStatisticsEnabled(false).setManagementEnabled(false).setStoreByValue(false).setExpiryPolicyFactory(expiryPolicy);
    }

    @Nonnull
    private synchronized <T> javax.cache.Cache<GenericCacheKey<?, ?>, T> recreateCacheOnNewConfiguration(@Nonnull javax.cache.Cache<GenericCacheKey<?, ?>, T> cacheInstance, @Nonnull ResilienceConfiguration resilienceConfiguration, @Nonnull CacheManager cacheManager) {
        Configuration externalCacheConfig = cacheInstance.getConfiguration(Configuration.class);
        if (this.hasExternalCacheConfigurationChanged(resilienceConfiguration, externalCacheConfig)) {
            log.info("ResilienceConfiguration: {}: Destroying cache since a new cache configuration was detected.", (Object)resilienceConfiguration.identifier());
            cacheManager.destroyCache(resilienceConfiguration.identifier());
            return cacheManager.createCache(resilienceConfiguration.identifier(), this.createCacheConfiguration(resilienceConfiguration.cacheConfiguration()));
        }
        return cacheInstance;
    }

    private boolean hasExternalCacheConfigurationChanged(@Nonnull ResilienceConfiguration resilienceConfig, @Nullable Configuration<?, ?> externalCacheConfig) {
        if (!(externalCacheConfig instanceof CompleteConfiguration)) {
            return false;
        }
        Factory externalPolicyFactory = ((CompleteConfiguration)externalCacheConfig).getExpiryPolicyFactory();
        if (externalPolicyFactory == null) {
            return false;
        }
        Object externalRawPolicy = externalPolicyFactory.create();
        if (!(externalRawPolicy instanceof ExpiryPolicy)) {
            return false;
        }
        ResilienceConfiguration.CacheConfiguration cacheConfiguration = resilienceConfig.cacheConfiguration();
        ExpiryPolicy expectedPolicy = (ExpiryPolicy)this.createCacheExpiryPolicyFactory(cacheConfiguration).create();
        ExpiryPolicy externalPolicy = (ExpiryPolicy)externalRawPolicy;
        return !Objects.equals(expectedPolicy.getExpiryForUpdate(), externalPolicy.getExpiryForUpdate()) || !Objects.equals(expectedPolicy.getExpiryForAccess(), externalPolicy.getExpiryForAccess()) || !Objects.equals(expectedPolicy.getExpiryForCreation(), externalPolicy.getExpiryForCreation());
    }

    @Nonnull
    private Factory<ExpiryPolicy> createCacheExpiryPolicyFactory(@Nonnull ResilienceConfiguration.CacheConfiguration cacheConfig) {
        javax.cache.expiry.Duration duration = new javax.cache.expiry.Duration(TimeUnit.MILLISECONDS, cacheConfig.expirationDuration().toMillis());
        CacheExpirationStrategy expiryStrategyType = cacheConfig.expirationStrategy();
        return this.getExpiryPolicyFactory(expiryStrategyType, duration);
    }

    @Nonnull
    private Factory<ExpiryPolicy> getExpiryPolicyFactory(@Nonnull CacheExpirationStrategy expiryStrategy, @Nonnull javax.cache.expiry.Duration cacheDuration) {
        Function<javax.cache.expiry.Duration, Factory<ExpiryPolicy>> factoryMethod = EXPIRY_STRATEGY_FACTORY_MAP.get(expiryStrategy);
        if (factoryMethod == null) {
            throw new ShouldNotHappenException("Provided cache expiry strategy is not supported: Missing mapping between the key and JCache expiry policy.");
        }
        return factoryMethod.apply(cacheDuration);
    }
}

