/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.resilience4j;

import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationKey;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.frameworks.resilience4j.GenericDecorator;
import com.sap.cloud.sdk.frameworks.resilience4j.RateLimiterProvider;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class DefaultRateLimiterProvider
implements RateLimiterProvider,
GenericDecorator {
    private static final RateLimiterConfig DEFAULT_RATE_LIMITER_CONFIG = RateLimiterConfig.custom().build();
    @Nonnull
    private final ConcurrentHashMap<ResilienceIsolationKey, RateLimiterRegistry> rateLimiterRegistries = new ConcurrentHashMap();

    private RateLimiterRegistry getRateLimiterRegistry(@Nonnull ResilienceIsolationKey isolationKey) {
        return this.rateLimiterRegistries.computeIfAbsent(isolationKey, k -> RateLimiterRegistry.of((RateLimiterConfig)DEFAULT_RATE_LIMITER_CONFIG));
    }

    @Override
    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        if (!configuration.rateLimiterConfiguration().isEnabled()) {
            return callable;
        }
        RateLimiter rateLimiter = this.getRateLimiter(configuration);
        return RateLimiter.decorateCallable((RateLimiter)rateLimiter, callable);
    }

    @Override
    @Nonnull
    public RateLimiter getRateLimiter(@Nonnull ResilienceConfiguration configuration) {
        if (!configuration.rateLimiterConfiguration().isEnabled()) {
            throw new IllegalArgumentException("The provided resilience configuration does not set a rate limiter.");
        }
        String identifier = configuration.identifier();
        ResilienceIsolationKey isolationKey = ResilienceIsolationKey.of((ResilienceIsolationMode)configuration.isolationMode());
        RateLimiterRegistry rateLimiterRegistry = this.getRateLimiterRegistry(isolationKey);
        RateLimiterConfig rateLimiterConfig = RateLimiterConfig.custom().limitRefreshPeriod(configuration.rateLimiterConfiguration().limitRefreshPeriod()).limitForPeriod(configuration.rateLimiterConfiguration().limitForPeriod()).timeoutDuration(configuration.rateLimiterConfiguration().timeoutDuration()).build();
        return rateLimiterRegistry.rateLimiter(identifier, rateLimiterConfig);
    }
}

