/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.quality;

import com.sap.cloud.sdk.quality.QualityListenerException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

class ServiceAuditReportWriter {
    private static final String DEFAULT_REPORTS_DIRECTORY = "../s4hana_pipeline/reports/service_audits";
    @Nonnull
    private final Path reportPath;

    ServiceAuditReportWriter(@Nonnull String reportName) {
        this.reportPath = Paths.get("../s4hana_pipeline/reports/service_audits/" + reportName + "_" + UUID.randomUUID() + ".log", new String[0]);
    }

    void writeLine(String lineIdentifier, String ... lineValues) {
        if (!Files.exists(this.reportPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.reportPath.getParent(), new FileAttribute[0]);
                Files.createFile(this.reportPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new QualityListenerException("Error: Creating " + this.reportPath + " failed.", e);
            }
        }
        try {
            StringBuilder builder = new StringBuilder();
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)builder, CSVFormat.DEFAULT);
            ArrayList<String> lineItems = new ArrayList<String>(lineValues.length + 1);
            lineItems.add(lineIdentifier);
            lineItems.addAll(Arrays.asList(lineValues));
            csvPrinter.printRecord(lineItems);
            Files.write(this.reportPath, Collections.singletonList(builder), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new QualityListenerException(e);
        }
    }

    public ServiceAuditReportWriter(@Nonnull Path reportPath) {
        if (reportPath == null) {
            throw new NullPointerException("reportPath is marked non-null but is null");
        }
        this.reportPath = reportPath;
    }
}

