/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.quality;

import javax.annotation.Nullable;

import lombok.NoArgsConstructor;

/**
 * Exception indicating an issue with processing quality listeners.
 */
@NoArgsConstructor
public class QualityListenerException extends RuntimeException
{
    private static final long serialVersionUID = 6394009230373925365L;

    public QualityListenerException( @Nullable final String message )
    {
        super(message);
    }

    public QualityListenerException( @Nullable final Throwable cause )
    {
        super(cause);
    }

    public QualityListenerException( @Nullable final String message, @Nullable final Throwable cause )
    {
        super(message, cause);
    }
}
