/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sap.cloud.sdk.s4hana.connectivity.ErpTypeSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.Request;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.CommitStrategy;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ExceptionPropagatingRemoteFunctionRequestErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Fields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.IgnoringErrorsRemoteFunctionRequestErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Parameter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterKind;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionRequestErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.serialization.BigDecimalConverter;
import com.sap.cloud.sdk.s4hana.serialization.BigIntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.BooleanConverter;
import com.sap.cloud.sdk.s4hana.serialization.ByteConverter;
import com.sap.cloud.sdk.s4hana.serialization.CharacterConverter;
import com.sap.cloud.sdk.s4hana.serialization.DoubleConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.FloatConverter;
import com.sap.cloud.sdk.s4hana.serialization.IntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocaleConverter;
import com.sap.cloud.sdk.s4hana.serialization.LongConverter;
import com.sap.cloud.sdk.s4hana.serialization.ShortConverter;
import com.sap.cloud.sdk.s4hana.serialization.YearConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public abstract class AbstractRemoteFunctionRequest<RequestT extends AbstractRemoteFunctionRequest<RequestT, RequestResultT>, RequestResultT extends AbstractRemoteFunctionRequestResult<RequestT, RequestResultT>>
extends Request<RequestT, RequestResultT> {
    private static final String RETURN_PARAMETER = "RETURN";
    protected final String functionName;
    protected final CommitStrategy commitStrategy;
    protected RemoteFunctionRequestErrorHandler remoteFunctionRequestErrorHandler;
    private final LinkedHashMap<String, Parameter> parametersByName = Maps.newLinkedHashMap();
    private final LinkedHashSet<String> returnParameterNames = Sets.newLinkedHashSet();
    @Nullable
    protected final String constructedByMethod;
    private final Map<Class<?>, ErpTypeConverter<?>> typeConverters = Maps.newIdentityHashMap();

    Iterable<Parameter> getParameters() {
        return this.parametersByName.values();
    }

    protected AbstractRemoteFunctionRequest(@Nonnull String functionName, @Nonnull CommitStrategy commitStrategy, @Nullable String constructedByMethod) {
        this.functionName = functionName;
        this.commitStrategy = commitStrategy;
        this.constructedByMethod = constructedByMethod;
        this.remoteFunctionRequestErrorHandler = new ExceptionPropagatingRemoteFunctionRequestErrorHandler();
        this.withTypeConverters(new ErpTypeSerializer().getTypeConverters());
    }

    @Nonnull
    protected abstract RequestT getThis();

    @Nonnull
    public Collection<ErpTypeConverter<?>> getTypeConverters() {
        return this.typeConverters.values();
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withTypeConverters(@Nonnull Iterable<ErpTypeConverter<?>> typeConverters) {
        for (ErpTypeConverter<?> typeConverter : typeConverters) {
            this.typeConverters.put(typeConverter.getType(), typeConverter);
        }
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withTypeConverters(ErpTypeConverter<?> ... typeConverters) {
        return this.withTypeConverters(Arrays.asList(typeConverters));
    }

    @Nonnull
    public String getFunctionName() {
        return this.functionName;
    }

    @Nonnull
    public CommitStrategy getCommitStrategy() {
        return this.commitStrategy;
    }

    RemoteFunctionRequestErrorHandler getRemoteFunctionRequestErrorHandler() {
        return this.remoteFunctionRequestErrorHandler;
    }

    public boolean isPerformingTransactionalCommit() {
        return this.commitStrategy.isPerformingCommit();
    }

    void addParameter(@Nonnull Parameter parameter) {
        this.parametersByName.put(parameter.getParameterValue().getName(), parameter);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType) {
        this.addParameter(new Parameter(ParameterKind.EXPORTING, Value.ofField(name, null, null)));
        return this;
    }

    @Nonnull
    public <T extends ErpType<T>> AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value) {
        this.addParameter(new Parameter(ParameterKind.EXPORTING, Value.ofField(name, value, null)));
        return this;
    }

    @Nonnull
    public <T> AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        this.addParameter(new Parameter(ParameterKind.EXPORTING, Value.ofField(name, value, typeConverter)));
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Boolean value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)BooleanConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Byte value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)ByteConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable byte[] value) {
        return this.withExporting(name, dataType, value, null);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Character value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)CharacterConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable String value) {
        return this.withExporting(name, dataType, value, null);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Short value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)ShortConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Integer value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)IntegerConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Long value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)LongConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Float value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)FloatConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Double value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)DoubleConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigInteger value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)BigIntegerConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigDecimal value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)BigDecimalConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Locale value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)LocaleConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Year value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)YearConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalDate value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)LocalDateConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalTime value) {
        return this.withExporting(name, dataType, (Object)value, (ErpTypeConverter)LocalTimeConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<RequestT> withExportingFields(@Nonnull String name, @Nonnull String dataType) {
        ArrayList values = new ArrayList();
        this.addParameter(new Parameter(ParameterKind.EXPORTING, Value.ofStructure(name, values)));
        return new ParameterFields<Request>(this.getThis(), values);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withExportingFields(@Nonnull String name, @Nonnull String dataType, @Nonnull Fields fields) {
        return (AbstractRemoteFunctionRequest)((Object)this.withExportingFields(name, dataType).fields(fields, new Fields[0]).end());
    }

    @Nonnull
    public Table<RequestT> withExportingTable(@Nonnull String name, @Nonnull String dataType) {
        ArrayList cells = new ArrayList();
        this.addParameter(new Parameter(ParameterKind.EXPORTING, Value.ofTable(name, cells)));
        return new Table<Request>(this.getThis(), cells);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType) {
        this.addParameter(new Parameter(ParameterKind.IMPORTING, Value.ofField(name, null, null)));
        return this;
    }

    @Nonnull
    public <T extends ErpType<T>> AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value) {
        this.addParameter(new Parameter(ParameterKind.IMPORTING, Value.ofField(name, value, null)));
        return this;
    }

    @Nonnull
    public <T> AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        this.addParameter(new Parameter(ParameterKind.IMPORTING, Value.ofField(name, value, typeConverter)));
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Boolean value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)BooleanConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Byte value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)ByteConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Character value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)CharacterConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable String value) {
        return this.withImporting(name, dataType, value, null);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Short value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)ShortConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Integer value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)IntegerConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Long value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)LongConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Float value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)FloatConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Double value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)DoubleConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigInteger value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)BigIntegerConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigDecimal value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)BigDecimalConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Locale value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)LocaleConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Year value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)YearConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalDate value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)LocalDateConverter.INSTANCE);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalTime value) {
        return this.withImporting(name, dataType, (Object)value, (ErpTypeConverter)LocalTimeConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<RequestT> withImportingFields(@Nonnull String name, @Nonnull String dataType) {
        ArrayList values = new ArrayList();
        this.addParameter(new Parameter(ParameterKind.IMPORTING, Value.ofStructure(name, values)));
        return new ParameterFields<Request>(this.getThis(), values);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImportingFields(@Nonnull String name, @Nonnull String dataType, @Nonnull Fields fields) {
        return (AbstractRemoteFunctionRequest)((Object)this.withImportingFields(name, dataType).fields(fields, new Fields[0]).end());
    }

    @Nonnull
    public Table<RequestT> withImportingTable(@Nonnull String name, @Nonnull String dataType) {
        ArrayList cells = new ArrayList();
        this.addParameter(new Parameter(ParameterKind.IMPORTING, Value.ofTable(name, cells)));
        return new Table<Request>(this.getThis(), cells);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImportingAsReturn(@Nonnull String dataType) {
        return this.withImportingAsReturn(RETURN_PARAMETER, dataType);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withImportingAsReturn(@Nonnull String name, @Nonnull String dataType) {
        this.addParameter(new Parameter(ParameterKind.IMPORTING, Value.ofField(name, null, null)));
        this.returnParameterNames.add(name);
        return this;
    }

    @Nonnull
    public Table<RequestT> withTable(@Nonnull String name, @Nonnull String dataType) {
        ArrayList cells = new ArrayList();
        this.addParameter(new Parameter(ParameterKind.TABLES, Value.ofTable(name, cells)));
        return new Table<Request>(this.getThis(), cells);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withTableAsReturn(@Nonnull String dataType) {
        return this.withTableAsReturn(RETURN_PARAMETER, dataType);
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withTableAsReturn(@Nonnull String name, @Nonnull String dataType) {
        this.addParameter(new Parameter(ParameterKind.TABLES, Value.ofTable(name, new ArrayList())));
        this.returnParameterNames.add(name);
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> withErrorHandler(@Nonnull RemoteFunctionRequestErrorHandler remoteFunctionRequestErrorHandler) {
        this.remoteFunctionRequestErrorHandler = remoteFunctionRequestErrorHandler;
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> ignoringErrors() {
        this.remoteFunctionRequestErrorHandler = new IgnoringErrorsRemoteFunctionRequestErrorHandler();
        return this;
    }

    @Nonnull
    public AbstractRemoteFunctionRequest<RequestT, RequestResultT> propagatingErrorsAsExceptions() {
        this.remoteFunctionRequestErrorHandler = new ExceptionPropagatingRemoteFunctionRequestErrorHandler();
        return this;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractRemoteFunctionRequest)) {
            return false;
        }
        AbstractRemoteFunctionRequest other = (AbstractRemoteFunctionRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$functionName = this.getFunctionName();
        String other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
            return false;
        }
        CommitStrategy this$commitStrategy = this.getCommitStrategy();
        CommitStrategy other$commitStrategy = other.getCommitStrategy();
        if (this$commitStrategy == null ? other$commitStrategy != null : !((Object)((Object)this$commitStrategy)).equals((Object)other$commitStrategy)) {
            return false;
        }
        RemoteFunctionRequestErrorHandler this$remoteFunctionRequestErrorHandler = this.getRemoteFunctionRequestErrorHandler();
        RemoteFunctionRequestErrorHandler other$remoteFunctionRequestErrorHandler = other.getRemoteFunctionRequestErrorHandler();
        if (this$remoteFunctionRequestErrorHandler == null ? other$remoteFunctionRequestErrorHandler != null : !this$remoteFunctionRequestErrorHandler.equals(other$remoteFunctionRequestErrorHandler)) {
            return false;
        }
        LinkedHashMap<String, Parameter> this$parametersByName = this.parametersByName;
        LinkedHashMap<String, Parameter> other$parametersByName = other.parametersByName;
        if (this$parametersByName == null ? other$parametersByName != null : !((Object)this$parametersByName).equals(other$parametersByName)) {
            return false;
        }
        LinkedHashSet<String> this$returnParameterNames = this.getReturnParameterNames();
        LinkedHashSet<String> other$returnParameterNames = other.getReturnParameterNames();
        if (this$returnParameterNames == null ? other$returnParameterNames != null : !((Object)this$returnParameterNames).equals(other$returnParameterNames)) {
            return false;
        }
        String this$constructedByMethod = this.getConstructedByMethod();
        String other$constructedByMethod = other.getConstructedByMethod();
        if (this$constructedByMethod == null ? other$constructedByMethod != null : !this$constructedByMethod.equals(other$constructedByMethod)) {
            return false;
        }
        Collection<ErpTypeConverter<?>> this$typeConverters = this.getTypeConverters();
        Collection<ErpTypeConverter<?>> other$typeConverters = other.getTypeConverters();
        return !(this$typeConverters == null ? other$typeConverters != null : !((Object)this$typeConverters).equals(other$typeConverters));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AbstractRemoteFunctionRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        CommitStrategy $commitStrategy = this.getCommitStrategy();
        result = result * 59 + ($commitStrategy == null ? 43 : ((Object)((Object)$commitStrategy)).hashCode());
        RemoteFunctionRequestErrorHandler $remoteFunctionRequestErrorHandler = this.getRemoteFunctionRequestErrorHandler();
        result = result * 59 + ($remoteFunctionRequestErrorHandler == null ? 43 : $remoteFunctionRequestErrorHandler.hashCode());
        LinkedHashMap<String, Parameter> $parametersByName = this.parametersByName;
        result = result * 59 + ($parametersByName == null ? 43 : ((Object)$parametersByName).hashCode());
        LinkedHashSet<String> $returnParameterNames = this.getReturnParameterNames();
        result = result * 59 + ($returnParameterNames == null ? 43 : ((Object)$returnParameterNames).hashCode());
        String $constructedByMethod = this.getConstructedByMethod();
        result = result * 59 + ($constructedByMethod == null ? 43 : $constructedByMethod.hashCode());
        Collection<ErpTypeConverter<?>> $typeConverters = this.getTypeConverters();
        result = result * 59 + ($typeConverters == null ? 43 : ((Object)$typeConverters).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "AbstractRemoteFunctionRequest(functionName=" + this.getFunctionName() + ", commitStrategy=" + (Object)((Object)this.getCommitStrategy()) + ", remoteFunctionRequestErrorHandler=" + this.getRemoteFunctionRequestErrorHandler() + ", parametersByName=" + this.parametersByName + ", returnParameterNames=" + this.getReturnParameterNames() + ", constructedByMethod=" + this.getConstructedByMethod() + ", typeConverters=" + this.getTypeConverters() + ")";
    }

    @Generated
    LinkedHashSet<String> getReturnParameterNames() {
        return this.returnParameterNames;
    }

    @Nullable
    @Generated
    public String getConstructedByMethod() {
        return this.constructedByMethod;
    }
}

