/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sap.cloud.sdk.result.GsonResultElementFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequestResult;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoRecordFieldIterator;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCoFieldToResultReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JCoFieldToResultReader.class);
    private static final String DATE_TIME_PATTERN = "yyyyMMdd HHmmss";

    @Nullable
    private JsonElement toJsonPrimitive(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return new JsonPrimitive((Boolean)value);
        }
        if (value instanceof Number) {
            return new JsonPrimitive((Number)value);
        }
        if (value instanceof Character) {
            return new JsonPrimitive((Character)value);
        }
        if (value instanceof byte[]) {
            byte[] byteArray = (byte[])value;
            return new JsonPrimitive(new String(byteArray, StandardCharsets.UTF_8));
        }
        if (value instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat(DATE_TIME_PATTERN);
            String dateString = df.format((Date)value);
            return new JsonPrimitive(dateString);
        }
        return new JsonPrimitive(value.toString());
    }

    private JsonObject toJsonObject(JCoStructure structure) {
        JsonObject jsonObject = new JsonObject();
        JCoRecordFieldIterator it = structure.getRecordFieldIterator();
        while (it.hasNextField()) {
            JCoField nestedField = it.nextField();
            JsonElement nested = this.toJsonElement(nestedField);
            jsonObject.add(nestedField.getName(), nested);
        }
        return jsonObject;
    }

    private JsonArray toJsonArray(JCoTable table) {
        JsonArray jsonArray = new JsonArray();
        for (int rowId = 0; rowId < table.getNumRows(); ++rowId) {
            table.setRow(rowId);
            JsonObject jsonObject = new JsonObject();
            JCoRecordFieldIterator it = table.getRecordFieldIterator();
            while (it.hasNextField()) {
                JCoField nestedField = it.nextField();
                JsonElement nested = this.toJsonElement(nestedField);
                jsonObject.add(nestedField.getName(), nested);
            }
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    @Nullable
    private JsonElement toJsonElement(JCoField field) {
        log.trace("Converting {} with name {} to {}.", new Object[]{JCoField.class.getSimpleName(), field.getName(), JsonElement.class.getSimpleName()});
        if (field.isStructure()) {
            return this.toJsonObject(field.getStructure());
        }
        if (field.isTable()) {
            return this.toJsonArray(field.getTable());
        }
        return this.toJsonPrimitive(field.getValue());
    }

    @Nonnull
    public AbstractRemoteFunctionRequestResult.Result newResult(@Nonnull JCoField field, @Nonnull GsonResultElementFactory resultElementFactory) {
        return new AbstractRemoteFunctionRequestResult.Result(field.getName(), resultElementFactory.create(this.toJsonElement(field)));
    }
}

