/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.ImmutableList;
import com.sap.cloud.sdk.quality.QualityListenerException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryListener;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;

final class QueryNotifier {
    private static final List<RemoteFunctionQueryListener> queryListeners = ImmutableList.copyOf(ServiceLoader.load(RemoteFunctionQueryListener.class));

    QueryNotifier() {
    }

    static void notifyQueryListeners(AbstractRemoteFunctionRequest<?, ?> request, String destinationName, Logger logger) {
        for (RemoteFunctionQueryListener queryListener : queryListeners) {
            try {
                queryListener.onQuery(((Object)request).getClass(), destinationName, request.getFunctionName());
            }
            catch (QualityListenerException e) {
                logger.error("Failure while invoking query listener of type " + queryListener.getClass().getName() + ".", (Throwable)e);
            }
        }
    }
}

