/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.s4hana.connectivity.rfc.ValueType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

final class Value<T> {
    @Nonnull
    private final ValueType valueType;
    @Nullable
    private final String name;
    @Nullable
    private final T value;
    @Nullable
    private final ErpTypeConverter<T> typeConverter;

    List<Value<?>> getAsStructure() {
        return (List)this.value;
    }

    List<List<Value<?>>> getAsTable() {
        return (List)this.value;
    }

    @Nonnull
    static <T> Value<T> ofField(@Nonnull String name, @Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        if (value instanceof Iterable) {
            throw new IllegalArgumentException("Instance of Iterable<?> is not allowed as value: " + value);
        }
        if (value instanceof Map) {
            throw new IllegalArgumentException("Instance of Map<?,?> is not allowed as value: " + value);
        }
        return new Value<T>(ValueType.FIELD, name, value, typeConverter);
    }

    @Nonnull
    static <T> Value<T> ofVectorElement(@Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        if (value instanceof Iterable) {
            throw new IllegalArgumentException("Instance of Iterable<?> is not allowed as value: " + value);
        }
        if (value instanceof Map) {
            throw new IllegalArgumentException("Instance of Map<?,?> is not allowed as value: " + value);
        }
        return new Value<T>(ValueType.FIELD, null, value, typeConverter);
    }

    @Nonnull
    static Value<List<Value<?>>> ofStructure(@Nonnull String name, @Nonnull List<Value<?>> values) {
        return new Value(ValueType.STRUCTURE, name, values, null);
    }

    @Nonnull
    static Value<List<List<Value<?>>>> ofTable(@Nonnull String name, @Nonnull List<List<Value<?>>> cells) {
        return new Value(ValueType.TABLE, name, cells, null);
    }

    @Nonnull
    @Generated
    ValueType getValueType() {
        return this.valueType;
    }

    @Nullable
    @Generated
    String getName() {
        return this.name;
    }

    @Nullable
    @Generated
    T getValue() {
        return this.value;
    }

    @Nullable
    @Generated
    ErpTypeConverter<T> getTypeConverter() {
        return this.typeConverter;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value other = (Value)o;
        ValueType this$valueType = this.getValueType();
        ValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !((Object)((Object)this$valueType)).equals((Object)other$valueType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        ErpTypeConverter<T> this$typeConverter = this.getTypeConverter();
        ErpTypeConverter<T> other$typeConverter = other.getTypeConverter();
        return !(this$typeConverter == null ? other$typeConverter != null : !this$typeConverter.equals(other$typeConverter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : ((Object)((Object)$valueType)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        ErpTypeConverter<T> $typeConverter = this.getTypeConverter();
        result = result * 59 + ($typeConverter == null ? 43 : $typeConverter.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "Value(valueType=" + (Object)((Object)this.getValueType()) + ", name=" + this.getName() + ", value=" + this.getValue() + ", typeConverter=" + this.getTypeConverter() + ")";
    }

    @Generated
    private Value(@Nonnull ValueType valueType, @Nullable String name, @Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        this.valueType = valueType;
        this.name = name;
        this.value = value;
        this.typeConverter = typeConverter;
    }
}

