/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.base.CaseFormat;
import javax.annotation.Nonnull;
import lombok.Generated;

class AbapToSoapNameConverter {
    private static final int MAX_LENGTH_FUNCTION_NAME = 30;

    static String abapFunctionNameToSoapMessageName(@Nonnull String functionName) {
        if (functionName.startsWith("BAPI_")) {
            functionName = functionName.substring(4);
        }
        return AbapToSoapNameConverter.abapNameToSoapName(functionName);
    }

    static String abapParameterNameToSoapParameterName(@Nonnull String abapName) {
        return AbapToSoapNameConverter.abapNameToSoapName(abapName);
    }

    static String soapParameterNameToAbapParameterName(String soapName) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, soapName);
    }

    private static String abapNameToSoapName(@Nonnull String abapName) {
        String soapName;
        int indexOfLastUnderscore = abapName.lastIndexOf("_");
        if (indexOfLastUnderscore == -1) {
            soapName = AbapToSoapNameConverter.transformUpperUnderScoreToUpperCamel(abapName);
        } else {
            String abapNameRightOfLastUnderscore = abapName.substring(indexOfLastUnderscore + 1);
            if (AbapToSoapNameConverter.isStringOfTypeNumber(abapNameRightOfLastUnderscore)) {
                String abapNameLeftOfLastUnderscore = abapName.substring(0, indexOfLastUnderscore);
                soapName = AbapToSoapNameConverter.transformUpperUnderScoreToUpperCamel(abapNameLeftOfLastUnderscore) + "_" + abapNameRightOfLastUnderscore;
            } else {
                soapName = AbapToSoapNameConverter.transformUpperUnderScoreToUpperCamel(abapName);
            }
        }
        return soapName;
    }

    private static String transformUpperUnderScoreToUpperCamel(@Nonnull String stringInUpperUnderscore) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, stringInUpperUnderscore);
    }

    private static boolean isStringOfTypeNumber(@Nonnull String s) {
        return s.matches("\\d+");
    }

    static String abapFunctionNameToSoapServiceName(@Nonnull String functionName) {
        String soapServiceName = functionName;
        if (functionName.length() >= 30) {
            StringBuilder builder = new StringBuilder(functionName);
            builder.deleteCharAt(28);
            soapServiceName = builder.toString();
        }
        soapServiceName = soapServiceName.replaceAll("/", "7");
        return "7" + soapServiceName;
    }

    @Generated
    private AbapToSoapNameConverter() {
    }
}

