/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Streams;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomSoapListDeserializer
implements JsonDeserializer<List<?>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomSoapListDeserializer.class);

    CustomSoapListDeserializer() {
    }

    @Nullable
    public List<?> deserialize(@Nonnull JsonElement jsonList, @Nonnull Type typeOfList, @Nonnull JsonDeserializationContext context) throws JsonParseException {
        if (jsonList.isJsonNull()) {
            return null;
        }
        if (jsonList.isJsonPrimitive() && jsonList.getAsJsonPrimitive().isString() && jsonList.getAsString().isEmpty()) {
            return Collections.emptyList();
        }
        if (jsonList.isJsonArray() && typeOfList instanceof ParameterizedType) {
            Type listElementType = ((ParameterizedType)typeOfList).getActualTypeArguments()[0];
            return Streams.stream((Iterable)jsonList.getAsJsonArray()).map(element -> context.deserialize(element, listElementType)).collect(Collectors.toList());
        }
        log.error("Failed to deserialize {} to {}.", (Object)jsonList, (Object)typeOfList);
        throw new JsonParseException("List of type " + typeOfList + " could not be deserialized.");
    }
}

