/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.DefaultRemoteFunctionErrorMapper;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionErrorMapper;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionExceptionPriority;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionRequestErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionExceptionFactory;
import com.sap.cloud.sdk.s4hana.serialization.MessageClass;
import com.sap.cloud.sdk.s4hana.serialization.MessageNumber;
import com.sap.cloud.sdk.s4hana.serialization.RemoteFunctionError;
import com.sap.cloud.sdk.s4hana.serialization.RemoteFunctionMessage;
import io.vavr.control.Option;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import lombok.Generated;

class ExceptionPropagatingRemoteFunctionRequestErrorHandler
implements RemoteFunctionRequestErrorHandler {
    private RemoteFunctionErrorMapper remoteFunctionErrorMapper = new DefaultRemoteFunctionErrorMapper();

    ExceptionPropagatingRemoteFunctionRequestErrorHandler() {
    }

    @Override
    @Nonnull
    public <RequestT extends AbstractRemoteFunctionRequest<RequestT, RequestResultT>, RequestResultT extends AbstractRemoteFunctionRequestResult<RequestT, RequestResultT>> Option<RemoteFunctionException> handleRequestResult(@Nonnull RequestResultT requestResult) {
        List<RemoteFunctionMessage> errors = requestResult.getErrorMessages();
        List<RemoteFunctionMessage> warnings = requestResult.getWarningMessages();
        List<RemoteFunctionMessage> informations = requestResult.getInformationMessages();
        TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> prioritizedExceptions = this.getPrioritizedExceptionsFromMessages(errors);
        if (prioritizedExceptions.isEmpty()) {
            TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> prioritizedWarnings = this.getPrioritizedExceptionsFromMessages(warnings);
            if (prioritizedWarnings.isEmpty()) {
                RemoteFunctionException exception = new RemoteFunctionException(Iterables.concat(errors, warnings, informations));
                return Option.of((Object)((Object)exception));
            }
            return Option.of((Object)((Object)ExceptionPropagatingRemoteFunctionRequestErrorHandler.getWithHighestPriority(prioritizedWarnings)));
        }
        return Option.of((Object)((Object)ExceptionPropagatingRemoteFunctionRequestErrorHandler.getWithHighestPriority(prioritizedExceptions)));
    }

    private static RemoteFunctionException getWithHighestPriority(TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> prioritizedExceptions) {
        return prioritizedExceptions.firstEntry().getValue();
    }

    private TreeMap<RemoteFunctionExceptionPriority, RemoteFunctionException> getPrioritizedExceptionsFromMessages(List<RemoteFunctionMessage> messages) {
        TreeMap prioritizedExceptions = Maps.newTreeMap();
        for (RemoteFunctionMessage message : messages) {
            MessageClass messageClass = message.getMessageClass();
            MessageNumber messageNumber = message.getMessageNumber();
            RemoteFunctionError error = new RemoteFunctionError(messageClass, messageNumber);
            RemoteFunctionExceptionFactory<?> exceptionFactory = this.remoteFunctionErrorMapper.getMapping().get(error);
            RemoteFunctionExceptionPriority priority = this.remoteFunctionErrorMapper.getPriorities().get(error);
            if (exceptionFactory == null) continue;
            Object exceptionSupplier = exceptionFactory.create(message);
            prioritizedExceptions.put(priority, exceptionSupplier);
        }
        return prioritizedExceptions;
    }

    @Generated
    public RemoteFunctionErrorMapper getRemoteFunctionErrorMapper() {
        return this.remoteFunctionErrorMapper;
    }

    @Generated
    public void setRemoteFunctionErrorMapper(RemoteFunctionErrorMapper remoteFunctionErrorMapper) {
        this.remoteFunctionErrorMapper = remoteFunctionErrorMapper;
    }
}

