/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import com.sap.cloud.sdk.result.GsonResultElementFactory;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.s4hana.connectivity.ErpTypeSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestSerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.DefaultJCoFunctionRetriever;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.JCoClientPassportManagerProvider;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.JCoErpNoopConverter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.JCoFieldToResultReader;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.JCoFunctionRetriever;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.MessageResultReader;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Parameter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterKind;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionGsonBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Transaction;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionCommitFailedException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionRollbackFailedException;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.MessageType;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.ext.ClientPassportManager;
import com.sap.conn.jco.ext.Environment;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCoTransaction<RequestT extends AbstractRemoteFunctionRequest<RequestT, RequestResultT>, RequestResultT extends AbstractRemoteFunctionRequestResult<RequestT, RequestResultT>>
implements Transaction<RequestT, RequestResultT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JCoTransaction.class);
    private final JCoDestination jCoDestination;
    private final Supplier<RequestResultT> requestResultFactory;
    static final String ROLLBACK_FUNCTION_NAME = "BAPI_TRANSACTION_ROLLBACK";
    static final String COMMIT_FUNCTION_NAME = "BAPI_TRANSACTION_COMMIT";
    private static final String DATE_TIME_PATTERN = "yyyyMMdd HHmmss";
    private final ErpTypeSerializer erpTypeSerializer = JCoErpNoopConverter.overrideNumbers(new ErpTypeSerializer());
    private final JCoFunctionRetriever jCoFunctionRetriever = new DefaultJCoFunctionRetriever();

    public JCoTransaction(@Nonnull String destinationName, @Nonnull Supplier<RequestResultT> requestResultFactory) throws RemoteFunctionException {
        this.requestResultFactory = requestResultFactory;
        try {
            this.jCoDestination = JCoDestinationManager.getDestination((String)destinationName);
        }
        catch (JCoException e) {
            throw new RemoteFunctionException(e);
        }
        JCoTransaction.registerClientPassportManager();
    }

    private static void registerClientPassportManager() {
        JCoClientPassportManagerProvider provider = (JCoClientPassportManagerProvider)FacadeLocator.getFacade(JCoClientPassportManagerProvider.class).getOrNull();
        if (provider != null) {
            ClientPassportManager manager = provider.getClientPassportManager();
            Environment.registerClientPassportManager((ClientPassportManager)manager);
        }
    }

    @Override
    public void before(@Nonnull Destination destination, @Nonnull RequestT request) {
        if (((AbstractRemoteFunctionRequest)((Object)request)).isPerformingTransactionalCommit()) {
            JCoContext.begin((JCoDestination)this.jCoDestination);
        }
    }

    @Override
    @Nonnull
    public RequestResultT execute(@Nonnull Destination destination, @Nonnull RequestT request) throws RemoteFunctionException {
        try {
            JCoFunction function = this.getJCoFunction(request, this.jCoDestination);
            this.passRequestParameterToJCoFunction(request, function);
            log.debug("Invoking function {} with name.", (Object)function.getName());
            function.execute(this.jCoDestination);
            return this.getRequestResultAfterFunctionInvocation(request, function);
        }
        catch (DestinationAccessException | JCoException e) {
            throw new RemoteFunctionException(e);
        }
    }

    private JCoFunction getJCoFunction(RequestT request, JCoDestination destination) throws JCoException {
        return this.jCoFunctionRetriever.retrieveJCoFunction(((AbstractRemoteFunctionRequest)((Object)request)).getFunctionName(), destination);
    }

    void passRequestParameterToJCoFunction(RequestT request, JCoFunction function) {
        block6: for (Parameter parameter : ((AbstractRemoteFunctionRequest)((Object)request)).getParameters()) {
            JCoParameterList parameterList;
            ParameterKind parameterKind = parameter.getParameterKind();
            Value<?> parameterValue = parameter.getParameterValue();
            switch (parameterKind) {
                case EXPORTING: {
                    parameterList = function.getImportParameterList();
                    break;
                }
                case IMPORTING: {
                    parameterList = function.getExportParameterList();
                    break;
                }
                case TABLES: {
                    parameterList = function.getTableParameterList();
                    break;
                }
                case CHANGING: {
                    parameterList = function.getChangingParameterList();
                    break;
                }
                default: {
                    log.warn("Parameter '{}' of function '{}' has an unsupported parameter type '{}', hence ignoring parameter.", new Object[]{parameterValue.getName(), function.getName(), parameterKind});
                    continue block6;
                }
            }
            if (parameterList == null) {
                log.warn("Parameter '{}' of function '{}' has no parameter list. Ignoring parameter.", (Object)parameterValue.getName(), (Object)function.getName());
                continue;
            }
            this.serializeValue(parameterValue, (JCoRecord)parameterList);
        }
    }

    private void serializeValue(@Nonnull Value<?> value, @Nonnull JCoRecord record) {
        String valueName = value.getName();
        switch (value.getValueType()) {
            case FIELD: {
                Object valueRaw = value.getValue();
                if (valueRaw instanceof byte[]) {
                    record.setValue(valueName, (byte[])valueRaw);
                    break;
                }
                record.setValue(valueName, (String)this.erpTypeSerializer.toErp(valueRaw).get());
                break;
            }
            case TABLE: {
                JCoTable table = record.getTable(valueName);
                List<List<Value<?>>> cells = value.getAsTable();
                boolean isTableVector = !cells.isEmpty() && cells.get(0).size() == 1 && cells.get(0).get(0).getName() == null;
                for (List<Value<?>> row : cells) {
                    table.appendRow();
                    for (Value<?> item : row) {
                        if (isTableVector) {
                            table.setValue(0, (String)this.erpTypeSerializer.toErp(item.getValue()).get());
                            continue;
                        }
                        this.serializeValue(item, (JCoRecord)table);
                    }
                }
                break;
            }
            case STRUCTURE: {
                JCoStructure structure = record.getStructure(valueName);
                for (Value<?> item : value.getAsStructure()) {
                    this.serializeValue(item, (JCoRecord)structure);
                }
                break;
            }
        }
    }

    private RequestResultT getRequestResultAfterFunctionInvocation(@Nonnull RequestT request, @Nonnull JCoFunction functionToInvoke) {
        AbstractRemoteFunctionRequestResult requestResult = (AbstractRemoteFunctionRequestResult)this.requestResultFactory.get();
        requestResult.setRequest(request);
        ArrayList<AbstractRemoteFunctionRequestResult.Result> resultList = new ArrayList<AbstractRemoteFunctionRequestResult.Result>();
        ArrayList typeConverters = Lists.newArrayList(((AbstractRemoteFunctionRequest)((Object)request)).getTypeConverters());
        typeConverters.add(new LocalDateConverter(DATE_TIME_PATTERN));
        typeConverters.add(new LocalTimeConverter(DATE_TIME_PATTERN));
        GsonResultElementFactory resultElementFactory = new GsonResultElementFactory(RemoteFunctionGsonBuilder.newJCoRequestResultGsonBuilder(typeConverters));
        JCoFieldToResultReader resultReader = new JCoFieldToResultReader();
        JCoParameterList exportParameterList = functionToInvoke.getExportParameterList();
        JCoParameterList importParameterList = functionToInvoke.getImportParameterList();
        JCoParameterList changingParameterList = functionToInvoke.getChangingParameterList();
        JCoParameterList tableParameterList = functionToInvoke.getTableParameterList();
        if (exportParameterList != null) {
            for (JCoField field : exportParameterList) {
                log.debug("Converting EXPORTING parameter {} from JCo result.", (Object)field.getName());
                resultList.add(resultReader.newResult(field, resultElementFactory));
            }
        }
        if (importParameterList != null) {
            for (JCoField field : importParameterList) {
                log.debug("Converting IMPORTING parameter {} from JCo result.", (Object)field.getName());
                resultList.add(resultReader.newResult(field, resultElementFactory));
            }
        }
        if (changingParameterList != null) {
            for (JCoField field : changingParameterList) {
                log.debug("Converting CHANGING parameter {} from JCo result.", (Object)field.getName());
                resultList.add(resultReader.newResult(field, resultElementFactory));
            }
        }
        if (tableParameterList != null) {
            for (JCoField field : tableParameterList) {
                log.debug("Converting TABLES parameter {} from JCo result.", (Object)field.getName());
                resultList.add(resultReader.newResult(field, resultElementFactory));
            }
        }
        requestResult.setResultList(resultList);
        for (AbstractRemoteFunctionRequestResult.Result returnParameterResult : this.getReturnParameterResults(requestResult)) {
            ResultElement resultElement = returnParameterResult.getValue();
            ArrayList<ResultElement> elements = new ArrayList<ResultElement>();
            if (resultElement.isResultCollection()) {
                Iterables.addAll(elements, (Iterable)resultElement.getAsCollection());
            } else {
                elements.add(resultElement);
            }
            for (ResultElement element : elements) {
                if (!element.isResultObject()) continue;
                MessageResultReader.addMessageToResult(requestResult, (AbstractRemoteFunctionRequestResult.MessageResult)element.getAsObject().as(AbstractRemoteFunctionRequestResult.MessageResult.class));
            }
        }
        return (RequestResultT)requestResult;
    }

    protected List<AbstractRemoteFunctionRequestResult.Result> getReturnParameterResults(RequestResultT result) {
        LinkedHashSet<String> returnParameterNames = ((AbstractRemoteFunctionRequest)((Object)((AbstractRemoteFunctionRequestResult)result).getRequest())).getReturnParameterNames();
        ArrayList<AbstractRemoteFunctionRequestResult.Result> returnParameterResults = new ArrayList<AbstractRemoteFunctionRequestResult.Result>();
        ArrayList<AbstractRemoteFunctionRequestResult.Result> resultList = ((AbstractRemoteFunctionRequestResult)result).getResultList();
        if (resultList != null) {
            for (AbstractRemoteFunctionRequestResult.Result resultItem : resultList) {
                if (!returnParameterNames.contains(resultItem.getName())) continue;
                returnParameterResults.add(resultItem);
            }
        }
        return returnParameterResults;
    }

    @Override
    public void commit(@Nonnull Destination destination, @Nonnull RequestT request) throws RequestExecutionException {
        ErpBoolean waitValue = ErpBoolean.of((Boolean)((AbstractRemoteFunctionRequest)((Object)request)).getCommitStrategy().isWaitingForCommitToFinish());
        try {
            JCoRepository repo = this.jCoDestination.getRepository();
            JCoFunction commitFunction = repo.getFunction(COMMIT_FUNCTION_NAME);
            commitFunction.getImportParameterList().setValue("WAIT", waitValue.toString());
            commitFunction.execute(this.jCoDestination);
            this.assureCommitResultHasNoErrors(commitFunction, request);
        }
        catch (JCoException e) {
            throw new RequestExecutionException((Throwable)e);
        }
    }

    private void assureCommitResultHasNoErrors(JCoFunction commitFunction, RequestT request) throws RemoteFunctionCommitFailedException {
        JCoParameterList exportParameterList = commitFunction.getExportParameterList();
        JCoStructure bapiReturnStructure = exportParameterList.getStructure("RETURN");
        String bapiReturnType = bapiReturnStructure.getString("TYPE");
        if (MessageType.ERROR.getIdentifier().equals(bapiReturnType)) {
            throw new RemoteFunctionCommitFailedException("Failed to commit BAPI transaction due to an unknown error on ERP side. Please investigate the respective ABAP logs.");
        }
        log.debug("Successfully committed BAPI transaction for request: {}.", request);
    }

    @Override
    public void rollback(@Nonnull Destination destination, @Nonnull RequestT request) throws RequestSerializationException, RequestExecutionException {
        try {
            JCoRepository repo = this.jCoDestination.getRepository();
            JCoFunction rollbackFunction = repo.getFunction(ROLLBACK_FUNCTION_NAME);
            rollbackFunction.execute(this.jCoDestination);
        }
        catch (JCoException e) {
            throw new RemoteFunctionRollbackFailedException(e);
        }
    }

    @Override
    public void after() throws RemoteFunctionException {
        if (JCoContext.isStateful((JCoDestination)this.jCoDestination)) {
            try {
                JCoContext.end((JCoDestination)this.jCoDestination);
            }
            catch (JCoException e) {
                throw new RemoteFunctionException(e);
            }
        }
    }

    @Generated
    JCoTransaction(JCoDestination jCoDestination, Supplier<RequestResultT> requestResultFactory) {
        this.jCoDestination = jCoDestination;
        this.requestResultFactory = requestResultFactory;
    }

    @Generated
    ErpTypeSerializer getErpTypeSerializer() {
        return this.erpTypeSerializer;
    }
}

