/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.RfcDestination;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRepository;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFunctionCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteFunctionCache.class);

    public static void clearCache(@Nonnull Destination destination) throws RemoteFunctionException {
        RemoteFunctionCache.clearCacheInternal(destination, null, null);
    }

    public static void clearCache(@Nonnull Destination destination, @Nonnull String functionName) throws RemoteFunctionException {
        RemoteFunctionCache.clearCacheInternal(destination, null, functionName);
    }

    static void clearCacheInternal(@Nonnull Destination destination, @Nullable JCoRepository jCoRepository, @Nullable String functionName) throws RemoteFunctionException {
        log.debug("Attempting to clear the remote function cache.");
        if (destination.isHttp()) {
            log.debug("{} instances do not use a remote function cache.", HttpDestination.class);
            return;
        }
        if (destination.isRfc()) {
            RemoteFunctionCache.clearCacheForRfcDestination(destination.asRfc(), jCoRepository, functionName);
            return;
        }
        log.debug("{} instances do not use a remote function cache.", destination.getClass());
    }

    private static void clearCacheForRfcDestination(@Nonnull RfcDestination rfcDestination, @Nullable JCoRepository jCoRepository, @Nullable String functionName) throws RemoteFunctionException {
        String destinationName = (String)rfcDestination.get("Name", String.class).getOrElseThrow(() -> new RemoteFunctionException("Failed to clear the remote function cache because " + RfcDestination.class + " does not have a name."));
        try {
            JCoRepository repositoryToClear;
            JCoRepository jCoRepository2 = repositoryToClear = jCoRepository != null ? jCoRepository : JCoDestinationManager.getDestination((String)destinationName).getRepository();
            if (functionName != null) {
                repositoryToClear.removeFunctionTemplateFromCache(functionName);
                log.debug("Cleared the remote function cache for {} with name {} and function with name {}.", new Object[]{RfcDestination.class, destinationName, functionName});
            } else {
                repositoryToClear.clear();
                log.debug("Cleared the remote function cache for {} with name {}.", RfcDestination.class, (Object)destinationName);
            }
        }
        catch (JCoException e) {
            throw new RemoteFunctionException("Failed to clear the remote function cache.", e);
        }
    }
}

