/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.s4hana.connectivity.RequestExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractTransactionFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Transaction;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import io.vavr.control.Option;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFunctionRequestExecutor<RequestT extends AbstractRemoteFunctionRequest<RequestT, RequestResultT>, RequestResultT extends AbstractRemoteFunctionRequestResult<RequestT, RequestResultT>>
implements RequestExecutor<RequestT, RequestResultT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteFunctionRequestExecutor.class);
    private final AbstractTransactionFactory<RequestT, RequestResultT> transactionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public RequestResultT execute(@Nonnull Destination destination, @Nonnull RequestT request) throws RequestExecutionException {
        Transaction<RequestT, RequestResultT> transactionLogic = this.transactionFactory.createTransaction(destination);
        transactionLogic.before(destination, request);
        try {
            RequestResultT requestResult = transactionLogic.execute(destination, request);
            if (((AbstractRemoteFunctionRequestResult)requestResult).hasFailed()) {
                this.handleFailedRequestResult(destination, request, transactionLogic, requestResult);
            } else {
                this.handleSuccessfulRequestResult(destination, request, transactionLogic);
            }
            RequestResultT RequestResultT = requestResult;
            return RequestResultT;
        }
        finally {
            transactionLogic.after();
        }
    }

    private void handleSuccessfulRequestResult(@Nonnull Destination destination, @Nonnull RequestT request, @Nonnull Transaction<RequestT, RequestResultT> transactionLogic) throws RequestExecutionException {
        if (((AbstractRemoteFunctionRequest)((Object)request)).isPerformingTransactionalCommit()) {
            try {
                transactionLogic.commit(destination, request);
            }
            catch (RequestExecutionException e) {
                transactionLogic.rollback(destination, request);
                throw e;
            }
        }
    }

    private void handleFailedRequestResult(@Nonnull Destination destination, @Nonnull RequestT request, @Nonnull Transaction<RequestT, RequestResultT> transactionLogic, @Nonnull RequestResultT requestResult) throws RequestExecutionException {
        Option<RemoteFunctionException> exception = ((AbstractRemoteFunctionRequest)((Object)request)).getRemoteFunctionRequestErrorHandler().handleRequestResult(requestResult);
        if (exception.isDefined()) {
            if (log.isDebugEnabled()) {
                log.debug(request.getClass().getSimpleName() + " failed. Triggering rollback for request: " + request + ".", exception);
            }
            if (((AbstractRemoteFunctionRequest)((Object)request)).isPerformingTransactionalCommit()) {
                transactionLogic.rollback(destination, request);
            }
            throw (RemoteFunctionException)((Object)exception.get());
        }
    }

    @Generated
    public RemoteFunctionRequestExecutor(AbstractTransactionFactory<RequestT, RequestResultT> transactionFactory) {
        this.transactionFactory = transactionFactory;
    }
}

