/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestSerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.CommitStrategy;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Fields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Parameter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterKind;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionRequestErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionRequestExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RfmRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RfmTransactionFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.serialization.BigDecimalConverter;
import com.sap.cloud.sdk.s4hana.serialization.BigIntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.BooleanConverter;
import com.sap.cloud.sdk.s4hana.serialization.ByteConverter;
import com.sap.cloud.sdk.s4hana.serialization.CharacterConverter;
import com.sap.cloud.sdk.s4hana.serialization.DoubleConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.FloatConverter;
import com.sap.cloud.sdk.s4hana.serialization.IntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocaleConverter;
import com.sap.cloud.sdk.s4hana.serialization.LongConverter;
import com.sap.cloud.sdk.s4hana.serialization.ShortConverter;
import com.sap.cloud.sdk.s4hana.serialization.YearConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class RfmRequest
extends AbstractRemoteFunctionRequest<RfmRequest, RfmRequestResult> {
    private final Set<String> exceptionNames = Sets.newHashSet();
    private RfmTransactionFactory transactionFactory = new RfmTransactionFactory();

    @Nonnull
    public RfmRequestResult execute(@Nonnull Destination destination) throws RequestSerializationException, RequestExecutionException, DestinationNotFoundException, DestinationAccessException {
        return new RemoteFunctionRequestExecutor<RfmRequest, RfmRequestResult>(this.transactionFactory).execute(destination, this);
    }

    @Override
    @Nonnull
    protected RfmRequest getThis() {
        return this;
    }

    public RfmRequest(@Nonnull String functionName) throws IllegalArgumentException {
        super(functionName, CommitStrategy.COMMIT_SYNC, Thread.currentThread().getStackTrace()[3].toString());
        this.assertFunctionIsNotBapi(functionName);
    }

    public RfmRequest(@Nonnull String functionName, boolean commit) throws IllegalArgumentException {
        super(functionName, commit ? CommitStrategy.COMMIT_SYNC : CommitStrategy.NO_COMMIT, Thread.currentThread().getStackTrace()[3].toString());
        this.assertFunctionIsNotBapi(functionName);
    }

    public RfmRequest(@Nonnull String functionName, @Nonnull CommitStrategy commitStrategy) throws IllegalArgumentException {
        super(functionName, commitStrategy, Thread.currentThread().getStackTrace()[3].toString());
        this.assertFunctionIsNotBapi(functionName);
    }

    private void assertFunctionIsNotBapi(@Nonnull String functionName) throws IllegalArgumentException {
        if (functionName.toLowerCase(Locale.ENGLISH).startsWith("bapi")) {
            throw new IllegalArgumentException("The given function '" + functionName + "' refers to a BAPI. For calling BAPIs, use " + BapiRequest.class.getSimpleName() + " instead.");
        }
    }

    @Nonnull
    public RfmRequest withTypeConverters(@Nonnull Iterable<ErpTypeConverter<?>> typeConverters) {
        return (RfmRequest)super.withTypeConverters(typeConverters);
    }

    @Nonnull
    public RfmRequest withTypeConverters(ErpTypeConverter<?> ... typeConverters) {
        return (RfmRequest)super.withTypeConverters(typeConverters);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType) {
        return (RfmRequest)super.withExporting(name, dataType);
    }

    @Nonnull
    public <T extends ErpType<T>> RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public <T> RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        return (RfmRequest)super.withExporting(name, dataType, value, typeConverter);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Boolean value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Byte value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable byte[] value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Character value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable String value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Short value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Integer value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Long value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Float value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Double value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigInteger value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigDecimal value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Locale value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Year value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalDate value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalTime value) {
        return (RfmRequest)super.withExporting(name, dataType, value);
    }

    @Override
    @Nonnull
    public ParameterFields<RfmRequest> withExportingFields(@Nonnull String name, @Nonnull String dataType) {
        return super.withExportingFields(name, dataType);
    }

    @Nonnull
    public RfmRequest withExportingFields(@Nonnull String name, @Nonnull String dataType, @Nonnull Fields fields) {
        return (RfmRequest)super.withExportingFields(name, dataType, fields);
    }

    @Override
    @Nonnull
    public Table<RfmRequest> withExportingTable(@Nonnull String name, @Nonnull String dataType) {
        return super.withExportingTable(name, dataType);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType) {
        return (RfmRequest)super.withImporting(name, dataType);
    }

    @Nonnull
    public <T extends ErpType<T>> RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public <T> RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        return (RfmRequest)super.withImporting(name, dataType, value, typeConverter);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Boolean value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Byte value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Character value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable String value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Short value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Integer value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Long value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Float value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Double value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigInteger value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigDecimal value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Locale value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Year value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalDate value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public RfmRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalTime value) {
        return (RfmRequest)super.withImporting(name, dataType, value);
    }

    @Override
    @Nonnull
    public ParameterFields<RfmRequest> withImportingFields(@Nonnull String name, @Nonnull String dataType) {
        return super.withImportingFields(name, dataType);
    }

    @Nonnull
    public RfmRequest withImportingFields(@Nonnull String name, @Nonnull String dataType, @Nonnull Fields fields) {
        return (RfmRequest)super.withImportingFields(name, dataType, fields);
    }

    @Override
    @Nonnull
    public Table<RfmRequest> withImportingTable(@Nonnull String name, @Nonnull String dataType) {
        return super.withImportingTable(name, dataType);
    }

    @Nonnull
    public RfmRequest withImportingAsReturn(@Nonnull String dataType) {
        return (RfmRequest)super.withImportingAsReturn(dataType);
    }

    @Nonnull
    public RfmRequest withImportingAsReturn(@Nonnull String name, @Nonnull String dataType) {
        return (RfmRequest)super.withImportingAsReturn(name, dataType);
    }

    @Override
    @Nonnull
    public Table<RfmRequest> withTable(@Nonnull String name, @Nonnull String dataType) {
        return super.withTable(name, dataType);
    }

    @Nonnull
    public RfmRequest withTableAsReturn(@Nonnull String dataType) {
        return (RfmRequest)super.withTableAsReturn(dataType);
    }

    @Nonnull
    public RfmRequest withTableAsReturn(@Nonnull String name, @Nonnull String dataType) {
        return (RfmRequest)super.withTableAsReturn(name, dataType);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType) {
        this.addParameter(new Parameter(ParameterKind.CHANGING, Value.ofField(name, null, null)));
        return this;
    }

    @Nonnull
    public <T extends ErpType<T>> RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nullable T value) {
        this.addParameter(new Parameter(ParameterKind.CHANGING, Value.ofField(name, value, null)));
        return this;
    }

    @Nonnull
    public <T> RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull T value, @Nullable ErpTypeConverter<T> typeConverter) {
        this.addParameter(new Parameter(ParameterKind.CHANGING, Value.ofField(name, value, typeConverter)));
        return this;
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull Boolean value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)BooleanConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull Byte value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)ByteConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull Character value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)CharacterConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull String value) {
        return this.withChanging(name, dataType, value, null);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull Short value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)ShortConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull Integer value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)IntegerConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull Long value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LongConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull Float value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)FloatConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull Double value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)DoubleConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull BigInteger value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)BigIntegerConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull BigDecimal value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)BigDecimalConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull Locale value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LocaleConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull Year value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)YearConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull LocalDate value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LocalDateConverter.INSTANCE);
    }

    @Nonnull
    public RfmRequest withChanging(@Nonnull String name, @Nonnull String dataType, @Nonnull LocalTime value) {
        return this.withChanging(name, dataType, (Object)value, (ErpTypeConverter)LocalTimeConverter.INSTANCE);
    }

    @Nonnull
    public ParameterFields<RfmRequest> withChangingFields(@Nonnull String name, @Nonnull String dataType) {
        ArrayList values = new ArrayList();
        this.addParameter(new Parameter(ParameterKind.CHANGING, Value.ofStructure(name, values)));
        return new ParameterFields<RfmRequest>(this.getThis(), values);
    }

    @Nonnull
    public RfmRequest withChangingFields(@Nonnull String name, @Nonnull String dataType, @Nonnull Fields fields) {
        return this.withChangingFields(name, dataType).fields(fields, new Fields[0]).end();
    }

    @Nonnull
    public Table<RfmRequest> withChangingTable(@Nonnull String name, @Nonnull String dataType) {
        ArrayList cells = new ArrayList();
        this.addParameter(new Parameter(ParameterKind.CHANGING, Value.ofTable(name, cells)));
        return new Table<RfmRequest>(this.getThis(), cells);
    }

    @Nonnull
    public RfmRequest withException(@Nonnull String name) {
        this.exceptionNames.add(name);
        return this;
    }

    @Nonnull
    public RfmRequest withErrorHandler(@Nonnull RemoteFunctionRequestErrorHandler remoteFunctionRequestErrorHandler) {
        return (RfmRequest)super.withErrorHandler(remoteFunctionRequestErrorHandler);
    }

    @Nonnull
    public RfmRequest ignoringErrors() {
        return (RfmRequest)super.ignoringErrors();
    }

    @Nonnull
    public RfmRequest propagatingErrorsAsExceptions() {
        return (RfmRequest)super.propagatingErrorsAsExceptions();
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RfmRequest)) {
            return false;
        }
        RfmRequest other = (RfmRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<String> this$exceptionNames = this.getExceptionNames();
        Set<String> other$exceptionNames = other.getExceptionNames();
        if (this$exceptionNames == null ? other$exceptionNames != null : !((Object)this$exceptionNames).equals(other$exceptionNames)) {
            return false;
        }
        RfmTransactionFactory this$transactionFactory = this.getTransactionFactory();
        RfmTransactionFactory other$transactionFactory = other.getTransactionFactory();
        return !(this$transactionFactory == null ? other$transactionFactory != null : !this$transactionFactory.equals(other$transactionFactory));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RfmRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set<String> $exceptionNames = this.getExceptionNames();
        result = result * 59 + ($exceptionNames == null ? 43 : ((Object)$exceptionNames).hashCode());
        RfmTransactionFactory $transactionFactory = this.getTransactionFactory();
        result = result * 59 + ($transactionFactory == null ? 43 : $transactionFactory.hashCode());
        return result;
    }

    @Override
    @Nonnull
    @Generated
    public String toString() {
        return "RfmRequest(super=" + super.toString() + ", exceptionNames=" + this.getExceptionNames() + ", transactionFactory=" + this.getTransactionFactory() + ")";
    }

    @Generated
    public Set<String> getExceptionNames() {
        return this.exceptionNames;
    }

    @Generated
    public RfmTransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    @Generated
    void setTransactionFactory(RfmTransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }
}

