/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.s4hana.connectivity.RequestMethod;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbapToSoapNameConverter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequestResult;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

class SoapSerializedRequestBuilder<RequestT extends AbstractRemoteFunctionRequest<RequestT, RequestResultT>, RequestResultT extends AbstractRemoteFunctionRequestResult<RequestT, RequestResultT>> {
    private final RequestT request;
    private final String requestBody;

    private List<Header> getHeaders() {
        LinkedList headers = Lists.newLinkedList();
        headers.addAll(this.request.getCustomHttpHeaders());
        headers.add(new Header("Content-Type", "text/xml"));
        headers.add(new Header("SOAPAction", "urn:sap-com:document:sap:soap:functions:mc-style:_--3" + AbapToSoapNameConverter.abapFunctionNameToSoapServiceName(((AbstractRemoteFunctionRequest)((Object)this.request)).getFunctionName()) + ":" + AbapToSoapNameConverter.abapFunctionNameToSoapMessageName(((AbstractRemoteFunctionRequest)((Object)this.request)).getFunctionName())));
        return headers;
    }

    SerializedRequest<RequestT> build() {
        return new SerializedRequest(this.request, RequestMethod.POST, "/sap/bc/srt/scs_ext/sap/" + AbapToSoapNameConverter.abapFunctionNameToSoapServiceName(((AbstractRemoteFunctionRequest)((Object)this.request)).getFunctionName()), this.getHeaders(), this.requestBody);
    }

    @Generated
    public SoapSerializedRequestBuilder(RequestT request, String requestBody) {
        this.request = request;
        this.requestBody = requestBody;
    }

    @Generated
    public RequestT getRequest() {
        return this.request;
    }

    @Generated
    public String getRequestBody() {
        return this.requestBody;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoapSerializedRequestBuilder)) {
            return false;
        }
        SoapSerializedRequestBuilder other = (SoapSerializedRequestBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestT this$request = this.getRequest();
        RequestT other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        String this$requestBody = this.getRequestBody();
        String other$requestBody = other.getRequestBody();
        return !(this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SoapSerializedRequestBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestT $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        String $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "SoapSerializedRequestBuilder(request=" + this.getRequest() + ", requestBody=" + this.getRequestBody() + ")";
    }
}

