/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableAsVector;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class Table<RequestT> {
    @Nonnull
    private final RequestT request;
    @Nonnull
    private final List<List<Value<?>>> cells;

    public int size() {
        return this.cells.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Nonnull
    public TableAsVector<RequestT> asVector() {
        if (!this.cells.isEmpty()) {
            throw new IllegalStateException("Cannot translate table to a vector when there are already some fields assigned.");
        }
        return new TableAsVector<RequestT>(this.request, this.cells);
    }

    @Nonnull
    public TableRow<RequestT> row() {
        ArrayList values = new ArrayList();
        this.cells.add(values);
        return new TableRow(this, values);
    }

    @Nonnull
    public RequestT end() {
        return this.request;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestT this$request = this.request;
        RequestT other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        List<List<Value<?>>> this$cells = this.cells;
        List<List<Value<?>>> other$cells = other.cells;
        return !(this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Table;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestT $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        List<List<Value<?>>> $cells = this.cells;
        result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "Table(request=" + this.request + ", cells=" + this.cells + ")";
    }

    @Generated
    Table(@Nonnull RequestT request, @Nonnull List<List<Value<?>>> cells) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (cells == null) {
            throw new NullPointerException("cells is marked non-null but is null");
        }
        this.request = request;
        this.cells = cells;
    }
}

