/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.serialization.BigDecimalConverter;
import com.sap.cloud.sdk.s4hana.serialization.BigIntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.BooleanConverter;
import com.sap.cloud.sdk.s4hana.serialization.ByteConverter;
import com.sap.cloud.sdk.s4hana.serialization.CharacterConverter;
import com.sap.cloud.sdk.s4hana.serialization.DoubleConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.FloatConverter;
import com.sap.cloud.sdk.s4hana.serialization.IntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocaleConverter;
import com.sap.cloud.sdk.s4hana.serialization.LongConverter;
import com.sap.cloud.sdk.s4hana.serialization.ShortConverter;
import com.sap.cloud.sdk.s4hana.serialization.YearConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class TableAsVector<RequestT> {
    @Nonnull
    private final RequestT request;
    @Nonnull
    private final List<List<Value<?>>> cells;

    @Nonnull
    public <T extends ErpType<T>> TableAsVector<RequestT> row(@Nonnull T value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, null)));
        return this;
    }

    @Nonnull
    public <T> TableAsVector<RequestT> row(@Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, typeConverter)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable Boolean value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, BooleanConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable Byte value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, ByteConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable Character value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, CharacterConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable String value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, null)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable Short value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, ShortConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable Integer value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, IntegerConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable Long value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, LongConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable Float value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, FloatConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable Double value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, DoubleConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable BigInteger value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, BigIntegerConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable BigDecimal value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, BigDecimalConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable Year value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, YearConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable LocalDate value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, LocalDateConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable LocalTime value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, LocalTimeConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public TableAsVector<RequestT> row(@Nullable Locale value) {
        this.cells.add(Collections.singletonList(Value.ofVectorElement(value, LocaleConverter.INSTANCE)));
        return this;
    }

    @Nonnull
    public RequestT end() {
        return this.request;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableAsVector)) {
            return false;
        }
        TableAsVector other = (TableAsVector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestT this$request = this.request;
        RequestT other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        List<List<Value<?>>> this$cells = this.cells;
        List<List<Value<?>>> other$cells = other.cells;
        return !(this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof TableAsVector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestT $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        List<List<Value<?>>> $cells = this.cells;
        result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "TableAsVector(request=" + this.request + ", cells=" + this.cells + ")";
    }

    @Generated
    TableAsVector(@Nonnull RequestT request, @Nonnull List<List<Value<?>>> cells) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (cells == null) {
            throw new NullPointerException("cells is marked non-null but is null");
        }
        this.request = request;
        this.cells = cells;
    }
}

