/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.result.CollectedResultCollection;
import com.sap.cloud.sdk.result.DefaultCollectedResultCollection;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.s4hana.connectivity.Request;
import com.sap.cloud.sdk.s4hana.connectivity.RequestResult;
import com.sap.cloud.sdk.s4hana.serialization.MessageClass;
import com.sap.cloud.sdk.s4hana.serialization.MessageNumber;
import com.sap.cloud.sdk.s4hana.serialization.MessageType;
import com.sap.cloud.sdk.s4hana.serialization.RemoteFunctionMessage;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteFunctionRequestResult<RequestT extends Request<RequestT, RequestResultT>, RequestResultT extends AbstractRemoteFunctionRequestResult<RequestT, RequestResultT>>
implements RequestResult<RequestT, RequestResultT>,
Iterable<ResultElement> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRemoteFunctionRequestResult.class);
    private RequestT request;
    @Nullable
    @ElementName(value="RESULT")
    private ArrayList<Result> resultList;
    @Nullable
    @ElementName(value="EXCEPTION")
    private ExceptionResult exception;
    private final List<RemoteFunctionMessage> successMessages = new ArrayList<RemoteFunctionMessage>();
    private final List<RemoteFunctionMessage> informationMessages = new ArrayList<RemoteFunctionMessage>();
    private final List<RemoteFunctionMessage> warningMessages = new ArrayList<RemoteFunctionMessage>();
    private final List<RemoteFunctionMessage> errorMessages = new ArrayList<RemoteFunctionMessage>();

    AbstractRemoteFunctionRequestResult() {
    }

    void addSuccessMessage(@Nonnull RemoteFunctionMessage successMessage) {
        this.successMessages.add(successMessage);
    }

    void addInformationMessage(@Nonnull RemoteFunctionMessage informationMessage) {
        this.informationMessages.add(informationMessage);
    }

    void addWarningMessage(@Nonnull RemoteFunctionMessage warningMessage) {
        this.warningMessages.add(warningMessage);
    }

    void addErrorMessage(@Nonnull RemoteFunctionMessage errorMessage) {
        this.errorMessages.add(errorMessage);
    }

    public boolean hasSuccessMessages() {
        return !this.successMessages.isEmpty();
    }

    public boolean hasInformationMessages() {
        return !this.informationMessages.isEmpty();
    }

    public boolean hasWarningMessages() {
        return !this.warningMessages.isEmpty();
    }

    public boolean hasFailed() {
        return !this.wasSuccessful();
    }

    public boolean wasSuccessful() {
        return !this.hasErrorMessages();
    }

    public boolean hasErrorMessages() {
        return !this.errorMessages.isEmpty();
    }

    private ResultElement newResultElement(Result result) {
        return result.getValue();
    }

    public int size() {
        if (this.resultList == null) {
            log.debug("Result list is null, returning 0 for size().");
            return 0;
        }
        return this.resultList.size();
    }

    public boolean isEmpty() {
        if (this.resultList == null) {
            log.debug("Result list is null, returning true for isEmpty().");
            return true;
        }
        return this.resultList.isEmpty();
    }

    public boolean has(@Nonnull String elementName) {
        return this.getIfPresent(elementName).isDefined();
    }

    @Nonnull
    public Option<ResultElement> getIfPresent(@Nonnull String elementName) {
        ResultElement resultElement = this.getResultElement(elementName);
        return Option.of((Object)resultElement);
    }

    @Nullable
    private ResultElement getResultElement(String elementName) throws IllegalArgumentException {
        if (this.resultList == null) {
            log.debug("Result list is null, returning null element.");
            return null;
        }
        for (Result result : this.resultList) {
            if (!elementName.equals(result.getName())) continue;
            return result.getValue();
        }
        return null;
    }

    @Nonnull
    public ResultElement get(int index) throws IndexOutOfBoundsException {
        if (this.resultList == null) {
            throw new IndexOutOfBoundsException("Failed to return element: result list is null.");
        }
        return this.resultList.get(index).getValue();
    }

    @Nonnull
    public ResultElement get(@Nonnull String elementName) throws IllegalArgumentException {
        Option<ResultElement> resultElement = this.getIfPresent(elementName);
        return (ResultElement)resultElement.getOrElseThrow(() -> new IllegalArgumentException("Unable to find element with name '" + elementName + "'."));
    }

    @Nullable
    public CollectedResultCollection collect(@Nonnull String elementName) {
        if (this.resultList == null) {
            log.debug("Result list is null, returning null element.");
            return null;
        }
        return new DefaultCollectedResultCollection(elementName, this.getResultElements());
    }

    @Nonnull
    public ArrayList<ResultElement> getResultElements() {
        if (this.resultList == null) {
            log.debug("Result list is null, returning empty list of elements.");
            return new ArrayList<ResultElement>();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)this.resultList.size());
        for (Result currentResult : this.resultList) {
            result.add(currentResult.getValue());
        }
        return result;
    }

    @Override
    @Nonnull
    public Iterator<ResultElement> iterator() {
        return new ResultElementIterator();
    }

    @Nonnull
    @Generated
    public String toString() {
        return "AbstractRemoteFunctionRequestResult(request=" + this.getRequest() + ", resultList=" + this.getResultList() + ", exception=" + this.getException() + ", successMessages=" + this.getSuccessMessages() + ", informationMessages=" + this.getInformationMessages() + ", warningMessages=" + this.getWarningMessages() + ", errorMessages=" + this.getErrorMessages() + ")";
    }

    @Generated
    public RequestT getRequest() {
        return this.request;
    }

    @Generated
    void setRequest(RequestT request) {
        this.request = request;
    }

    @Nullable
    @Generated
    ArrayList<Result> getResultList() {
        return this.resultList;
    }

    @Generated
    void setResultList(@Nullable ArrayList<Result> resultList) {
        this.resultList = resultList;
    }

    @Nullable
    @Generated
    ExceptionResult getException() {
        return this.exception;
    }

    @Generated
    void setException(@Nullable ExceptionResult exception) {
        this.exception = exception;
    }

    @Generated
    public List<RemoteFunctionMessage> getSuccessMessages() {
        return this.successMessages;
    }

    @Generated
    public List<RemoteFunctionMessage> getInformationMessages() {
        return this.informationMessages;
    }

    @Generated
    public List<RemoteFunctionMessage> getWarningMessages() {
        return this.warningMessages;
    }

    @Generated
    public List<RemoteFunctionMessage> getErrorMessages() {
        return this.errorMessages;
    }

    static class Result {
        @ElementName(value="NAME")
        private final String name;
        @ElementName(value="VALUE")
        private final ResultElement value;

        @Generated
        public Result(String name, ResultElement value) {
            this.name = name;
            this.value = value;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public ResultElement getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ResultElement this$value = this.getValue();
            ResultElement other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Result;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ResultElement $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "AbstractRemoteFunctionRequestResult.Result(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }
    }

    private class ResultElementIterator
    implements Iterator<ResultElement> {
        private int index = 0;

        private ResultElementIterator() {
        }

        @Override
        public boolean hasNext() {
            if (AbstractRemoteFunctionRequestResult.this.resultList == null) {
                log.debug("Result list is null, returning false for hasNext().");
                return false;
            }
            return this.index < AbstractRemoteFunctionRequestResult.this.resultList.size();
        }

        @Override
        @Nonnull
        public ResultElement next() {
            if (AbstractRemoteFunctionRequestResult.this.resultList == null) {
                throw new NoSuchElementException("Cannot return next element, result list is null.");
            }
            return AbstractRemoteFunctionRequestResult.this.newResultElement((Result)AbstractRemoteFunctionRequestResult.this.resultList.get(this.index++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from remote function result.");
        }
    }

    static class ExceptionResult
    extends MessageResult {
        @ElementName(value="NAME")
        String name;
        @ElementName(value="VALUE")
        long parameterKind;

        @Override
        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExceptionResult)) {
                return false;
            }
            ExceptionResult other = (ExceptionResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getParameterKind() != other.getParameterKind()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Override
        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ExceptionResult;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            long $parameterKind = this.getParameterKind();
            result = result * 59 + (int)($parameterKind >>> 32 ^ $parameterKind);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public ExceptionResult() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public long getParameterKind() {
            return this.parameterKind;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setParameterKind(long parameterKind) {
            this.parameterKind = parameterKind;
        }

        @Override
        @Nonnull
        @Generated
        public String toString() {
            return "AbstractRemoteFunctionRequestResult.ExceptionResult(name=" + this.getName() + ", parameterKind=" + this.getParameterKind() + ")";
        }
    }

    static class MessageResult {
        @ElementName(value="TYPE")
        MessageType messageType;
        @ElementName(value="ID")
        MessageClass messageClass;
        @ElementName(value="NUMBER")
        MessageNumber messageNumber;
        @ElementName(value="MESSAGE")
        String messageText;
        @ElementName(value="MESSAGE_V1")
        String messageVariable1;
        @ElementName(value="MESSAGE_V2")
        String messageVariable2;
        @ElementName(value="MESSAGE_V3")
        String messageVariable3;
        @ElementName(value="MESSAGE_V4")
        String messageVariable4;

        @Generated
        public MessageType getMessageType() {
            return this.messageType;
        }

        @Generated
        public MessageClass getMessageClass() {
            return this.messageClass;
        }

        @Generated
        public MessageNumber getMessageNumber() {
            return this.messageNumber;
        }

        @Generated
        public String getMessageText() {
            return this.messageText;
        }

        @Generated
        public String getMessageVariable1() {
            return this.messageVariable1;
        }

        @Generated
        public String getMessageVariable2() {
            return this.messageVariable2;
        }

        @Generated
        public String getMessageVariable3() {
            return this.messageVariable3;
        }

        @Generated
        public String getMessageVariable4() {
            return this.messageVariable4;
        }

        @Generated
        public void setMessageType(MessageType messageType) {
            this.messageType = messageType;
        }

        @Generated
        public void setMessageClass(MessageClass messageClass) {
            this.messageClass = messageClass;
        }

        @Generated
        public void setMessageNumber(MessageNumber messageNumber) {
            this.messageNumber = messageNumber;
        }

        @Generated
        public void setMessageText(String messageText) {
            this.messageText = messageText;
        }

        @Generated
        public void setMessageVariable1(String messageVariable1) {
            this.messageVariable1 = messageVariable1;
        }

        @Generated
        public void setMessageVariable2(String messageVariable2) {
            this.messageVariable2 = messageVariable2;
        }

        @Generated
        public void setMessageVariable3(String messageVariable3) {
            this.messageVariable3 = messageVariable3;
        }

        @Generated
        public void setMessageVariable4(String messageVariable4) {
            this.messageVariable4 = messageVariable4;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageResult)) {
                return false;
            }
            MessageResult other = (MessageResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MessageType this$messageType = this.getMessageType();
            MessageType other$messageType = other.getMessageType();
            if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
                return false;
            }
            MessageClass this$messageClass = this.getMessageClass();
            MessageClass other$messageClass = other.getMessageClass();
            if (this$messageClass == null ? other$messageClass != null : !this$messageClass.equals(other$messageClass)) {
                return false;
            }
            MessageNumber this$messageNumber = this.getMessageNumber();
            MessageNumber other$messageNumber = other.getMessageNumber();
            if (this$messageNumber == null ? other$messageNumber != null : !this$messageNumber.equals(other$messageNumber)) {
                return false;
            }
            String this$messageText = this.getMessageText();
            String other$messageText = other.getMessageText();
            if (this$messageText == null ? other$messageText != null : !this$messageText.equals(other$messageText)) {
                return false;
            }
            String this$messageVariable1 = this.getMessageVariable1();
            String other$messageVariable1 = other.getMessageVariable1();
            if (this$messageVariable1 == null ? other$messageVariable1 != null : !this$messageVariable1.equals(other$messageVariable1)) {
                return false;
            }
            String this$messageVariable2 = this.getMessageVariable2();
            String other$messageVariable2 = other.getMessageVariable2();
            if (this$messageVariable2 == null ? other$messageVariable2 != null : !this$messageVariable2.equals(other$messageVariable2)) {
                return false;
            }
            String this$messageVariable3 = this.getMessageVariable3();
            String other$messageVariable3 = other.getMessageVariable3();
            if (this$messageVariable3 == null ? other$messageVariable3 != null : !this$messageVariable3.equals(other$messageVariable3)) {
                return false;
            }
            String this$messageVariable4 = this.getMessageVariable4();
            String other$messageVariable4 = other.getMessageVariable4();
            return !(this$messageVariable4 == null ? other$messageVariable4 != null : !this$messageVariable4.equals(other$messageVariable4));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof MessageResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MessageType $messageType = this.getMessageType();
            result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
            MessageClass $messageClass = this.getMessageClass();
            result = result * 59 + ($messageClass == null ? 43 : $messageClass.hashCode());
            MessageNumber $messageNumber = this.getMessageNumber();
            result = result * 59 + ($messageNumber == null ? 43 : $messageNumber.hashCode());
            String $messageText = this.getMessageText();
            result = result * 59 + ($messageText == null ? 43 : $messageText.hashCode());
            String $messageVariable1 = this.getMessageVariable1();
            result = result * 59 + ($messageVariable1 == null ? 43 : $messageVariable1.hashCode());
            String $messageVariable2 = this.getMessageVariable2();
            result = result * 59 + ($messageVariable2 == null ? 43 : $messageVariable2.hashCode());
            String $messageVariable3 = this.getMessageVariable3();
            result = result * 59 + ($messageVariable3 == null ? 43 : $messageVariable3.hashCode());
            String $messageVariable4 = this.getMessageVariable4();
            result = result * 59 + ($messageVariable4 == null ? 43 : $messageVariable4.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "AbstractRemoteFunctionRequestResult.MessageResult(messageType=" + this.getMessageType() + ", messageClass=" + this.getMessageClass() + ", messageNumber=" + this.getMessageNumber() + ", messageText=" + this.getMessageText() + ", messageVariable1=" + this.getMessageVariable1() + ", messageVariable2=" + this.getMessageVariable2() + ", messageVariable3=" + this.getMessageVariable3() + ", messageVariable4=" + this.getMessageVariable4() + ")";
        }

        @Generated
        public MessageResult() {
        }
    }
}

