/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestSerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiTransactionFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.CommitStrategy;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Fields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionRequestErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionRequestExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RfmRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class BapiRequest
extends AbstractRemoteFunctionRequest<BapiRequest, BapiRequestResult> {
    @Nonnull
    public BapiRequestResult execute(@Nonnull Destination destination) throws RequestSerializationException, RequestExecutionException, DestinationNotFoundException, DestinationAccessException {
        return new RemoteFunctionRequestExecutor<BapiRequest, BapiRequestResult>(new BapiTransactionFactory()).execute(destination, this);
    }

    @Override
    @Nonnull
    protected BapiRequest getThis() {
        return this;
    }

    public BapiRequest(@Nonnull String functionName) throws IllegalArgumentException {
        super(functionName, CommitStrategy.COMMIT_SYNC, Thread.currentThread().getStackTrace()[2].toString());
        this.assertFunctionIsBapi(functionName);
    }

    public BapiRequest(@Nonnull String functionName, boolean commit) throws IllegalArgumentException {
        super(functionName, commit ? CommitStrategy.COMMIT_SYNC : CommitStrategy.NO_COMMIT, Thread.currentThread().getStackTrace()[2].toString());
        this.assertFunctionIsBapi(functionName);
    }

    public BapiRequest(@Nonnull String functionName, @Nonnull CommitStrategy commitStrategy) throws IllegalArgumentException {
        super(functionName, commitStrategy, Thread.currentThread().getStackTrace()[2].toString());
        this.assertFunctionIsBapi(functionName);
    }

    private void assertFunctionIsBapi(@Nonnull String functionName) throws IllegalArgumentException {
        if (!functionName.toLowerCase(Locale.ENGLISH).startsWith("bapi")) {
            throw new IllegalArgumentException("The given function '" + functionName + "' is not a valid BAPI. For calling remote-enabled functions, use " + RfmRequest.class.getSimpleName() + " instead.");
        }
    }

    @Nonnull
    public BapiRequest withTypeConverters(@Nonnull Iterable<ErpTypeConverter<?>> typeConverters) {
        return (BapiRequest)super.withTypeConverters(typeConverters);
    }

    @Nonnull
    public BapiRequest withTypeConverters(ErpTypeConverter<?> ... typeConverters) {
        return (BapiRequest)super.withTypeConverters(typeConverters);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType) {
        return (BapiRequest)super.withExporting(name, dataType);
    }

    @Nonnull
    public <T extends ErpType<T>> BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public <T> BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        return (BapiRequest)super.withExporting(name, dataType, value, typeConverter);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Boolean value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Byte value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Character value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable String value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Short value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Integer value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Long value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Float value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Double value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigInteger value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigDecimal value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Locale value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable Year value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalDate value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalTime value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Override
    @Nonnull
    public ParameterFields<BapiRequest> withExportingFields(@Nonnull String name, @Nonnull String dataType) {
        return super.withExportingFields(name, dataType);
    }

    @Nonnull
    public BapiRequest withExportingFields(@Nonnull String name, @Nonnull String dataType, @Nonnull Fields fields) {
        return (BapiRequest)super.withExportingFields(name, dataType, fields);
    }

    @Override
    @Nonnull
    public Table<BapiRequest> withExportingTable(@Nonnull String name, @Nonnull String dataType) {
        return super.withExportingTable(name, dataType);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType) {
        return (BapiRequest)super.withImporting(name, dataType);
    }

    @Nonnull
    public <T extends ErpType<T>> BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public <T> BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        return (BapiRequest)super.withImporting(name, dataType, value, typeConverter);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Boolean value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Byte value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withExporting(@Nonnull String name, @Nonnull String dataType, @Nullable byte[] value) {
        return (BapiRequest)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Character value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable String value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Short value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Integer value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Long value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Float value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Double value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigInteger value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable BigDecimal value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Locale value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable Year value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalDate value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiRequest withImporting(@Nonnull String name, @Nonnull String dataType, @Nullable LocalTime value) {
        return (BapiRequest)super.withImporting(name, dataType, value);
    }

    @Override
    @Nonnull
    public ParameterFields<BapiRequest> withImportingFields(@Nonnull String name, @Nonnull String dataType) {
        return super.withImportingFields(name, dataType);
    }

    @Nonnull
    public BapiRequest withImportingFields(@Nonnull String name, @Nonnull String dataType, @Nonnull Fields fields) {
        return (BapiRequest)super.withImportingFields(name, dataType, fields);
    }

    @Override
    @Nonnull
    public Table<BapiRequest> withImportingTable(@Nonnull String name, @Nonnull String dataType) {
        return super.withImportingTable(name, dataType);
    }

    @Nonnull
    public BapiRequest withImportingAsReturn(@Nonnull String dataType) {
        return (BapiRequest)super.withImportingAsReturn(dataType);
    }

    @Nonnull
    public BapiRequest withImportingAsReturn(@Nonnull String name, @Nonnull String dataType) {
        return (BapiRequest)super.withImportingAsReturn(name, dataType);
    }

    @Override
    @Nonnull
    public Table<BapiRequest> withTable(@Nonnull String name, @Nonnull String dataType) {
        return super.withTable(name, dataType);
    }

    @Nonnull
    public BapiRequest withTableAsReturn(@Nonnull String dataType) {
        return (BapiRequest)super.withTableAsReturn(dataType);
    }

    @Nonnull
    public BapiRequest withTableAsReturn(@Nonnull String name, @Nonnull String dataType) {
        return (BapiRequest)super.withTableAsReturn(name, dataType);
    }

    @Nonnull
    public BapiRequest withErrorHandler(@Nonnull RemoteFunctionRequestErrorHandler remoteFunctionRequestErrorHandler) {
        return (BapiRequest)super.withErrorHandler(remoteFunctionRequestErrorHandler);
    }

    @Nonnull
    public BapiRequest ignoringErrors() {
        return (BapiRequest)super.ignoringErrors();
    }

    @Nonnull
    public BapiRequest propagatingErrorsAsExceptions() {
        return (BapiRequest)super.propagatingErrorsAsExceptions();
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BapiRequest)) {
            return false;
        }
        BapiRequest other = (BapiRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof BapiRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Nonnull
    @Generated
    public String toString() {
        return "BapiRequest(super=" + super.toString() + ")";
    }
}

