/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.s4hana.connectivity.ErpTypeSerializer;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.typeconverter.ConvertedObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

class JCoErpNoopConverter<T extends Number>
implements ErpTypeConverter<T> {
    private final Class<T> type;
    private final Function<String, T> deserializer;
    private final Function<T, String> serializer;
    private final Class<String> domainType = String.class;

    @Nonnull
    static ErpTypeSerializer overrideNumbers(@Nonnull ErpTypeSerializer erpTypeSerializer) {
        DecimalFormat numberFormat = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        numberFormat.setMaximumFractionDigits(340);
        ErpTypeConverter[] erpTypeConverterArray = new ErpTypeConverter[6];
        erpTypeConverterArray[0] = new JCoErpNoopConverter<BigInteger>(BigInteger.class, BigInteger::new, numberFormat::format);
        erpTypeConverterArray[1] = new JCoErpNoopConverter<BigDecimal>(BigDecimal.class, BigDecimal::new, numberFormat::format);
        erpTypeConverterArray[2] = new JCoErpNoopConverter<Float>(Float.class, Float::new, numberFormat::format);
        erpTypeConverterArray[3] = new JCoErpNoopConverter<Integer>(Integer.class, Integer::new, numberFormat::format);
        erpTypeConverterArray[4] = new JCoErpNoopConverter<Long>(Long.class, Long::new, numberFormat::format);
        erpTypeConverterArray[5] = new JCoErpNoopConverter<Double>(Double.class, Double::new, numberFormat::format);
        return erpTypeSerializer.withTypeConverters(erpTypeConverterArray);
    }

    @Nonnull
    public ConvertedObject<String> toDomain(@Nullable T object) {
        return object == null ? ConvertedObject.ofNull() : ConvertedObject.of((Object)this.serializer.apply(object));
    }

    @Nonnull
    public ConvertedObject<T> fromDomain(@Nullable String domainObject) {
        return domainObject == null ? ConvertedObject.ofNull() : ConvertedObject.of((Object)((Number)this.deserializer.apply(domainObject)));
    }

    @Generated
    public JCoErpNoopConverter(Class<T> type, Function<String, T> deserializer, Function<T, String> serializer) {
        this.type = type;
        this.deserializer = deserializer;
        this.serializer = serializer;
    }

    @Generated
    public Class<T> getType() {
        return this.type;
    }

    @Generated
    public Class<String> getDomainType() {
        return this.domainType;
    }
}

