/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequestResult;
import com.sap.cloud.sdk.s4hana.serialization.RemoteFunctionMessage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageResultReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageResultReader.class);

    MessageResultReader() {
    }

    static <RequestResultT extends AbstractRemoteFunctionRequestResult<?, RequestResultT>> void addMessageToResult(RequestResultT result, AbstractRemoteFunctionRequestResult.MessageResult messageResult) {
        if (messageResult.getMessageType() == null) {
            log.warn("Ignoring remote function message with unknown type: {}", (Object)messageResult);
            return;
        }
        RemoteFunctionMessage message = new RemoteFunctionMessage(messageResult.getMessageType(), messageResult.getMessageClass(), messageResult.getMessageNumber(), messageResult.getMessageText());
        switch (messageResult.getMessageType()) {
            case SUCCESS: {
                result.addSuccessMessage(message);
                break;
            }
            case INFORMATION: {
                result.addInformationMessage(message);
                break;
            }
            case WARNING: {
                result.addWarningMessage(message);
                break;
            }
            case ERROR: 
            case ABORT: 
            case EXIT: {
                result.addErrorMessage(message);
                break;
            }
        }
    }
}

