/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.json.JsonSanitizer;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.s4hana.connectivity.AbstractRequestSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.ErpTypeSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedRequest;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbapToSoapNameConverter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.MessageResultReader;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Parameter;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterKind;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionGsonBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.SoapNamespace;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.SoapSerializedRequestBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SoapRemoteFunctionRequestSerializer<RequestT extends AbstractRemoteFunctionRequest<RequestT, RequestResultT>, RequestResultT extends AbstractRemoteFunctionRequestResult<RequestT, RequestResultT>>
extends AbstractRequestSerializer<RequestT, RequestResultT> {
    private final Class<RequestResultT> resultType;
    private static final String SOAP_NAMESPACE_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private final ErpTypeSerializer erpTypeSerializer = new ErpTypeSerializer().withTypeConverters(new ErpTypeConverter[]{new LocalDateConverter("yyyy-MM-dd"), new LocalTimeConverter("HH:mm:ss")});

    private Document createNewSoapDocument() throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setExpandEntityReferences(false);
        docBuilderFactory.setFeature(FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
        docBuilderFactory.setFeature(FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        return docBuilder.newDocument();
    }

    private Element createSoapServiceMessageElement(Document soapDocument, String functionName) {
        Element envelopeRootElement = this.createEnvelopeRootDocument(soapDocument);
        soapDocument.appendChild(envelopeRootElement);
        Element envelopeHeaderElement = this.createElementInSoapNamespace(soapDocument, "soapenv:Header");
        envelopeRootElement.appendChild(envelopeHeaderElement);
        Element envelopeBodyElement = this.createElementInSoapNamespace(soapDocument, "soapenv:Body");
        envelopeRootElement.appendChild(envelopeBodyElement);
        String functionNameInSoapFormat = AbapToSoapNameConverter.abapFunctionNameToSoapMessageName(functionName);
        Element soapServiceMessageElement = soapDocument.createElement("urn:" + functionNameInSoapFormat);
        envelopeBodyElement.appendChild(soapServiceMessageElement);
        return soapServiceMessageElement;
    }

    private String serializeSoapEnvelopeWithoutXmlHeaderLine(Document soapDocument) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", null);
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(soapDocument), new StreamResult(writer));
        return writer.toString();
    }

    private Element createEnvelopeRootDocument(Document doc) {
        Element envelopeRootElement = doc.createElementNS(SOAP_NAMESPACE_URI, "soapenv:Envelope");
        envelopeRootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:urn", "urn:sap-com:document:sap:soap:functions:mc-style");
        return envelopeRootElement;
    }

    private Element createElementInSoapNamespace(Document soapDocument, String elementName) {
        return soapDocument.createElementNS(SOAP_NAMESPACE_URI, elementName);
    }

    protected List<AbstractRemoteFunctionRequestResult.Result> getReturnParameterResults(RequestResultT result) {
        LinkedHashSet<String> returnParameterNames = ((AbstractRemoteFunctionRequest)((Object)((AbstractRemoteFunctionRequestResult)result).getRequest())).getReturnParameterNames();
        ArrayList<AbstractRemoteFunctionRequestResult.Result> returnParameterResults = new ArrayList<AbstractRemoteFunctionRequestResult.Result>();
        ArrayList<AbstractRemoteFunctionRequestResult.Result> resultList = ((AbstractRemoteFunctionRequestResult)result).getResultList();
        if (resultList != null) {
            for (AbstractRemoteFunctionRequestResult.Result resultItem : resultList) {
                if (!returnParameterNames.contains(resultItem.getName())) continue;
                returnParameterResults.add(resultItem);
            }
        }
        return returnParameterResults;
    }

    @Nonnull
    protected SerializedRequest<RequestT> serializeRequest(@Nonnull RequestT request) throws ParserConfigurationException, TransformerException {
        Document soapDocument = this.createNewSoapDocument();
        Element soapServiceMessageElement = this.createSoapServiceMessageElement(soapDocument, ((AbstractRemoteFunctionRequest)((Object)request)).getFunctionName());
        for (Parameter parameter : ((AbstractRemoteFunctionRequest)((Object)request)).getParameters()) {
            if (ParameterKind.IMPORTING == parameter.getParameterKind()) continue;
            this.serializeValue(soapDocument, soapServiceMessageElement, parameter.getParameterValue());
        }
        return new SoapSerializedRequestBuilder(request, this.serializeSoapEnvelopeWithoutXmlHeaderLine(soapDocument)).build();
    }

    private void serializeValue(@Nonnull Document soapDocument, @Nonnull Element container, @Nonnull Value<?> value) {
        String currentParameterNameInSoapNamePattern = AbapToSoapNameConverter.abapParameterNameToSoapParameterName(Objects.requireNonNull(value.getName()));
        Element currentParameterElement = soapDocument.createElement(currentParameterNameInSoapNamePattern);
        container.appendChild(currentParameterElement);
        switch (value.getValueType()) {
            case FIELD: {
                currentParameterElement.setTextContent((String)this.erpTypeSerializer.toErp(value.getValue()).orNull());
                break;
            }
            case STRUCTURE: {
                for (Value<?> item : value.getAsStructure()) {
                    this.serializeValue(soapDocument, currentParameterElement, item);
                }
                break;
            }
            case TABLE: {
                List<List<Value<?>>> cells = value.getAsTable();
                boolean isTableVector = !cells.isEmpty() && cells.get(0).size() == 1 && cells.get(0).get(0).getName() == null;
                for (List<Value<?>> values : cells) {
                    Element row = soapDocument.createElement("item");
                    currentParameterElement.appendChild(row);
                    for (Value<?> item : values) {
                        if (isTableVector) {
                            row.setTextContent((String)this.erpTypeSerializer.toErp(item.getValue()).orNull());
                            continue;
                        }
                        this.serializeValue(soapDocument, row, item);
                    }
                }
                break;
            }
        }
    }

    private JsonElement unpackNestedArrays(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonElement nestedArray = jsonObject.get("item");
            if (nestedArray == null) {
                JsonObject rewrittenObject = new JsonObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    JsonElement attribute = (JsonElement)entry.getValue();
                    JsonElement unpacked = this.unpackNestedArrays(attribute);
                    rewrittenObject.add(AbapToSoapNameConverter.soapParameterNameToAbapParameterName(Objects.requireNonNull((String)entry.getKey())), unpacked);
                }
                return rewrittenObject;
            }
            if (nestedArray.isJsonArray()) {
                return this.unpackNestedArrays((JsonElement)nestedArray.getAsJsonArray());
            }
            if (nestedArray.isJsonObject()) {
                JsonArray jsonArray = new JsonArray();
                jsonArray.add(this.unpackNestedArrays(nestedArray));
                return jsonArray;
            }
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement elementInArray = jsonArray.get(i);
                JsonElement unpacked = this.unpackNestedArrays(elementInArray);
                if (unpacked == elementInArray) continue;
                jsonArray.set(i, unpacked);
            }
        }
        return jsonElement;
    }

    @Nonnull
    protected RequestResultT deserializeRequestResult(@Nonnull SerializedRequestResult<RequestT> serializedRequestResult) throws ParserConfigurationException {
        AbstractRemoteFunctionRequest request = (AbstractRemoteFunctionRequest)serializedRequestResult.getRequest();
        JsonElement bodyAsJson = JsonParser.parseString((String)JsonSanitizer.sanitize((String)XML.toJSONObject((String)serializedRequestResult.getBody(), (boolean)true).toString()));
        String resultSoapElementName = (Object)((Object)SoapNamespace.RESPONSE_PREFIX_N0) + ":" + AbapToSoapNameConverter.abapFunctionNameToSoapMessageName(request.getFunctionName()) + "Response";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setValidating(true);
        factory.setFeature(FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
        factory.setFeature(FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
        JsonElement json = this.unpackNestedArrays(bodyAsJson.getAsJsonObject().get((Object)((Object)SoapNamespace.RESPONSE_PREFIX_SOAP_ENV) + ":Envelope").getAsJsonObject().get((Object)((Object)SoapNamespace.RESPONSE_PREFIX_SOAP_ENV) + ":Body").getAsJsonObject().get(resultSoapElementName));
        JsonObject resultObj = new JsonObject();
        JsonArray array = new JsonArray();
        resultObj.add("RESULT", (JsonElement)array);
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if (("XMLNS:" + (Object)((Object)SoapNamespace.RESPONSE_PREFIX_N0)).equalsIgnoreCase((String)entry.getKey())) continue;
            String parameterName = (String)entry.getKey();
            JsonElement parameterValue = (JsonElement)entry.getValue();
            JsonObject obj = new JsonObject();
            obj.addProperty("NAME", parameterName);
            obj.add("VALUE", parameterValue);
            array.add((JsonElement)obj);
        }
        ArrayList typeConverters = Lists.newArrayList(request.getTypeConverters());
        typeConverters.add(new LocalDateConverter("yyyy-MM-dd"));
        typeConverters.add(new LocalTimeConverter("HH:mm:ss"));
        GsonBuilder gsonBuilder = RemoteFunctionGsonBuilder.newSoapRequestResultGsonBuilder(typeConverters);
        AbstractRemoteFunctionRequestResult result = (AbstractRemoteFunctionRequestResult)gsonBuilder.create().fromJson((JsonElement)resultObj, this.resultType);
        result.setRequest(request);
        AbstractRemoteFunctionRequestResult.ExceptionResult exceptionResult = result.getException();
        if (exceptionResult != null) {
            MessageResultReader.addMessageToResult(result, exceptionResult);
        }
        for (AbstractRemoteFunctionRequestResult.Result returnParameterResult : this.getReturnParameterResults(result)) {
            ResultElement resultElement = returnParameterResult.getValue();
            ArrayList<ResultElement> elements = new ArrayList<ResultElement>();
            if (resultElement.isResultCollection()) {
                Iterables.addAll(elements, (Iterable)resultElement.getAsCollection());
            } else {
                elements.add(resultElement);
            }
            for (ResultElement element : elements) {
                if (!element.isResultObject()) continue;
                MessageResultReader.addMessageToResult(result, (AbstractRemoteFunctionRequestResult.MessageResult)element.getAsObject().as(AbstractRemoteFunctionRequestResult.MessageResult.class));
            }
        }
        return (RequestResultT)result;
    }

    @Generated
    public SoapRemoteFunctionRequestSerializer(Class<RequestResultT> resultType) {
        this.resultType = resultType;
    }
}

