/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.s4hana.connectivity.ErpHttpRequestExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.Request;
import com.sap.cloud.sdk.s4hana.connectivity.RequestSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedRequest;
import com.sap.cloud.sdk.s4hana.connectivity.exception.AccessDeniedException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestSerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiRequest;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.SoapNamespace;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.SoapSerializedRequestBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Transaction;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionCommitFailedException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapTransaction<RequestT extends AbstractRemoteFunctionRequest<RequestT, RequestResultT>, RequestResultT extends AbstractRemoteFunctionRequestResult<RequestT, RequestResultT>>
implements Transaction<RequestT, RequestResultT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoapTransaction.class);
    private final RequestSerializer<RequestT, RequestResultT> requestSerializer;
    private final ErpHttpRequestExecutor<RequestT, RequestResultT> requestExecutorLogic;
    private final ErpHttpRequestExecutor<BapiRequest, BapiRequestResult> bapiRequestExecutorLogic;

    @Override
    public void before(@Nonnull Destination destination, @Nonnull RequestT request) {
    }

    @Override
    @Nonnull
    public RequestResultT execute(@Nonnull Destination destination, @Nonnull RequestT request) throws RequestExecutionException {
        try {
            return (RequestResultT)((AbstractRemoteFunctionRequestResult)this.requestExecutorLogic.execute(destination.asHttp(), request, this.requestSerializer));
        }
        catch (RequestExecutionException e) {
            RequestExecutionException alternativeException = this.throwExceptionsBasedOnSoapResponsePayload(e.getMessage());
            throw alternativeException != null ? alternativeException : new RemoteFunctionException(e);
        }
    }

    private RequestExecutionException throwExceptionsBasedOnSoapResponsePayload(String responsePayload) {
        if (responsePayload != null && responsePayload.contains("<faultcode>" + (Object)((Object)SoapNamespace.RESPONSE_PREFIX_SOAP_ENV))) {
            String prefix = "500 Internal Server Error. ";
            if (responsePayload.contains("<faultcode>" + (Object)((Object)SoapNamespace.RESPONSE_PREFIX_SOAP_ENV) + ":Server</faultcode>")) {
                String message = "500 Internal Server Error. The ERP user lacks authorization to call the SOAP service (Authorization Object S_SERVICE). " + responsePayload;
                return new AccessDeniedException(message);
            }
            if (responsePayload.contains("<faultcode>" + (Object)((Object)SoapNamespace.RESPONSE_PREFIX_SOAP_ENV) + ":Client</faultcode>")) {
                String exceptionName = "";
                Pattern pattern = Pattern.compile("<Name>(.+?)</Name>");
                Matcher matcher = pattern.matcher(responsePayload);
                if (matcher.find()) {
                    exceptionName = matcher.group(1);
                }
                String exceptionText = "";
                pattern = Pattern.compile("<Text>(.+?)</Text>");
                matcher = pattern.matcher(responsePayload);
                if (matcher.find()) {
                    exceptionText = matcher.group(1);
                }
                StringBuilder messageStringBuilder = new StringBuilder("500 Internal Server Error.  Exception occurred during execution of SOAP service.");
                if (!exceptionName.isEmpty()) {
                    messageStringBuilder.append(" Exception Name: ").append(exceptionName).append(".");
                }
                if (!exceptionText.isEmpty()) {
                    messageStringBuilder.append(" Exception Text: ").append(exceptionText).append(".");
                }
                return new RequestExecutionException(messageStringBuilder.toString());
            }
        }
        return null;
    }

    @Override
    public void commit(@Nonnull Destination destination, @Nonnull RequestT request) throws RequestSerializationException, RequestExecutionException {
        log.debug("Committing BAPI transaction for request: {}.", request);
        ErpBoolean waitValue = ErpBoolean.of((Boolean)((AbstractRemoteFunctionRequest)((Object)request)).getCommitStrategy().isWaitingForCommitToFinish());
        String requestBody = String.format("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:sap-com:document:sap:soap:functions:mc-style\"><soapenv:Header/><soapenv:Body><urn:TransactionCommit><Wait>%s</Wait></urn:TransactionCommit></soapenv:Body></soapenv:Envelope>", waitValue);
        BapiRequest commitRequest = new BapiRequest("BAPI_TRANSACTION_COMMIT", false);
        SerializedRequest<BapiRequest> serializedRequest = new SoapSerializedRequestBuilder((BapiRequest)commitRequest.withSameCustomHttpHeadersAs((Request)request), requestBody).build();
        String commitResultBody = this.bapiRequestExecutorLogic.execute(destination.asHttp(), serializedRequest);
        if (commitResultBody.contains("150")) {
            throw new RemoteFunctionCommitFailedException("Failed to commit BAPI transaction due to an unknown error on ERP side. Please investigate the respective ABAP logs.");
        }
        log.debug("Successfully committed BAPI transaction for request: {}.", request);
    }

    @Override
    public void rollback(@Nonnull Destination destination, @Nonnull RequestT request) throws RequestSerializationException, RequestExecutionException {
        log.debug("Rolling back BAPI transaction for request: {}.", request);
        SerializedRequest<BapiRequest> serializedRequest = new SoapSerializedRequestBuilder((BapiRequest)new BapiRequest("BAPI_TRANSACTION_ROLLBACK", false).withSameCustomHttpHeadersAs((Request)request), "<x:Envelope xmlns:x=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn1=\"urn:sap-com:document:sap:soap:functions:mc-style\"><x:Header/><x:Body><urn1:TransactionRollback/></x:Body></x:Envelope>").build();
        this.bapiRequestExecutorLogic.execute(destination.asHttp(), serializedRequest);
        log.debug("Successfully rolled back BAPI transaction for request: {}.", request);
    }

    @Override
    public void after() {
    }

    @Generated
    public SoapTransaction(RequestSerializer<RequestT, RequestResultT> requestSerializer, ErpHttpRequestExecutor<RequestT, RequestResultT> requestExecutorLogic, ErpHttpRequestExecutor<BapiRequest, BapiRequestResult> bapiRequestExecutorLogic) {
        this.requestSerializer = requestSerializer;
        this.requestExecutorLogic = requestExecutorLogic;
        this.bapiRequestExecutorLogic = bapiRequestExecutorLogic;
    }
}

