/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.s4hana.connectivity.rfc.Fields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Value;
import com.sap.cloud.sdk.s4hana.serialization.BigDecimalConverter;
import com.sap.cloud.sdk.s4hana.serialization.BigIntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.BooleanConverter;
import com.sap.cloud.sdk.s4hana.serialization.ByteConverter;
import com.sap.cloud.sdk.s4hana.serialization.CharacterConverter;
import com.sap.cloud.sdk.s4hana.serialization.DoubleConverter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.serialization.FloatConverter;
import com.sap.cloud.sdk.s4hana.serialization.IntegerConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalDateConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocalTimeConverter;
import com.sap.cloud.sdk.s4hana.serialization.LocaleConverter;
import com.sap.cloud.sdk.s4hana.serialization.LongConverter;
import com.sap.cloud.sdk.s4hana.serialization.ShortConverter;
import com.sap.cloud.sdk.s4hana.serialization.YearConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class TableRow<RequestT> {
    @Nonnull
    private final Table<RequestT> table;
    @Nonnull
    private final List<Value<?>> values;

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Nonnull
    private <T> TableRow<RequestT> field(@Nonnull Value<T> value) {
        this.values.add(value);
        return this;
    }

    @Nonnull
    public <T extends ErpType<T>> TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable T value) {
        return this.field(Value.ofField(name, value, null));
    }

    @Nonnull
    public <T> TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        return this.field(Value.ofField(name, value, typeConverter));
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable Boolean value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)BooleanConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable Byte value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)ByteConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable Character value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)CharacterConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable String value) {
        return this.field(name, dataType, value, null);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable Short value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)ShortConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable Integer value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)IntegerConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable Long value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LongConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable Float value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)FloatConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable Double value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)DoubleConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable BigInteger value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)BigIntegerConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable BigDecimal value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)BigDecimalConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable Year value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)YearConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable LocalDate value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LocalDateConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable LocalTime value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LocalTimeConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> field(@Nonnull String name, @Nullable String dataType, @Nullable Locale value) {
        return this.field(name, dataType, (Object)value, (ErpTypeConverter)LocaleConverter.INSTANCE);
    }

    @Nonnull
    public TableRow<RequestT> fields(@Nonnull Fields other, Fields ... others) {
        for (Value<?> value : other.valueList) {
            this.field(value);
        }
        for (Fields fields : others) {
            for (Value<?> value : fields.valueList) {
                this.field(value);
            }
        }
        return this;
    }

    @Nonnull
    public Table<TableRow<RequestT>> table(@Nonnull String name, @Nullable String dataType) {
        ArrayList innerTable = new ArrayList();
        this.values.add(Value.ofTable(name, innerTable));
        return new Table<TableRow<RequestT>>(this, innerTable);
    }

    @Nonnull
    public ParameterFields<TableRow<RequestT>> fields(@Nonnull String name, @Nullable String dataType) {
        ArrayList innerFields = new ArrayList();
        this.values.add(Value.ofStructure(name, innerFields));
        return new ParameterFields<TableRow<RequestT>>(this, innerFields);
    }

    @Nonnull
    public TableRow<RequestT> row() {
        return this.table.row();
    }

    @Nonnull
    public RequestT end() {
        return this.table.end();
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableRow)) {
            return false;
        }
        TableRow other = (TableRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Table<RequestT> this$table = this.table;
        Table<RequestT> other$table = other.table;
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        List<Value<?>> this$values = this.values;
        List<Value<?>> other$values = other.values;
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof TableRow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Table<RequestT> $table = this.table;
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        List<Value<?>> $values = this.values;
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "TableRow(table=" + this.table + ", values=" + this.values + ")";
    }

    @Generated
    TableRow(@Nonnull Table<RequestT> table, @Nonnull List<Value<?>> values) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        this.table = table;
        this.values = values;
    }
}

