/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.bank.Bank;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.BankService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultBankService")
public class DefaultBankService
implements ServiceWithNavigableEntities,
BankService {
    @Nonnull
    private final String servicePath;

    public DefaultBankService() {
        this.servicePath = "/sap/opu/odata4/sap/api_bank/srvd_a2x/sap/bank/0001";
    }

    private DefaultBankService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBankService withServicePath(@Nonnull String servicePath) {
        return new DefaultBankService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<Bank> getAllBank() {
        return new GetAllRequestBuilder(this.servicePath, Bank.class, "Bank");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<Bank> countBank() {
        return new CountRequestBuilder(this.servicePath, Bank.class, "Bank");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<Bank> getBankByKey(@Nonnull String bankCountry, @Nonnull String bankInternalID) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("BankCountry", bankCountry);
        key.put("BankInternalID", bankInternalID);
        return new GetByKeyRequestBuilder(this.servicePath, Bank.class, key, "Bank");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<Bank> createBank(@Nonnull Bank bank) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)bank, "Bank");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<Bank> updateBank(@Nonnull Bank bank) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)bank, "Bank");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

