/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingDisputeCaseService;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultContractAccountingDisputeCaseService")
public class DefaultContractAccountingDisputeCaseService
implements ServiceWithNavigableEntities,
ContractAccountingDisputeCaseService {
    @Nonnull
    private final String servicePath;

    public DefaultContractAccountingDisputeCaseService() {
        this.servicePath = "/sap/opu/odata4/sap/api_cadisputecase/srvd_a2x/sap/cadisputecase/0001";
    }

    private DefaultContractAccountingDisputeCaseService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultContractAccountingDisputeCaseService withServicePath(@Nonnull String servicePath) {
        return new DefaultContractAccountingDisputeCaseService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<DisputeCase> getAllDisputeCase() {
        return new GetAllRequestBuilder(this.servicePath, DisputeCase.class, "DisputeCase");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<DisputeCase> countDisputeCase() {
        return new CountRequestBuilder(this.servicePath, DisputeCase.class, "DisputeCase");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<DisputeCase> getDisputeCaseByKey(@Nonnull UUID caseUUID) {
        HashMap<String, UUID> key = new HashMap<String, UUID>();
        key.put("CaseUUID", caseUUID);
        return new GetByKeyRequestBuilder(this.servicePath, DisputeCase.class, key, "DisputeCase");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<DisputeCase> createDisputeCase(@Nonnull DisputeCase disputeCase) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)disputeCase, "DisputeCase");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<DisputeCaseObject> getAllDisputeCaseObject() {
        return new GetAllRequestBuilder(this.servicePath, DisputeCaseObject.class, "DisputeCaseObject");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<DisputeCaseObject> countDisputeCaseObject() {
        return new CountRequestBuilder(this.servicePath, DisputeCaseObject.class, "DisputeCaseObject");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<DisputeCaseObject> getDisputeCaseObjectByKey(@Nonnull UUID caseUUID, @Nonnull String objectType, @Nonnull String objectKey) {
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("CaseUUID", caseUUID);
        key.put("ObjectType", objectType);
        key.put("ObjectKey", objectKey);
        return new GetByKeyRequestBuilder(this.servicePath, DisputeCaseObject.class, key, "DisputeCaseObject");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<DisputeCaseObject> createDisputeCaseObject(@Nonnull DisputeCaseObject disputeCaseObject) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)disputeCaseObject, "DisputeCaseObject");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

