/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.handlingunit.HandlingUnit;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.handlingunit.HandlingUnitItem;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.HandlingUnitService;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultHandlingUnitService")
public class DefaultHandlingUnitService
implements ServiceWithNavigableEntities,
HandlingUnitService {
    @Nonnull
    private final String servicePath;

    public DefaultHandlingUnitService() {
        this.servicePath = "/sap/opu/odata4/sap/api_handlingunit/srvd_a2x/sap/handlingunit/0001";
    }

    private DefaultHandlingUnitService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultHandlingUnitService withServicePath(@Nonnull String servicePath) {
        return new DefaultHandlingUnitService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<HandlingUnit> getAllHandlingUnit() {
        return new GetAllRequestBuilder(this.servicePath, HandlingUnit.class, "HandlingUnit");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<HandlingUnit> countHandlingUnit() {
        return new CountRequestBuilder(this.servicePath, HandlingUnit.class, "HandlingUnit");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<HandlingUnit> getHandlingUnitByKey(@Nonnull String handlingUnitExternalID, @Nonnull String warehouse) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("HandlingUnitExternalID", handlingUnitExternalID);
        key.put("Warehouse", warehouse);
        return new GetByKeyRequestBuilder(this.servicePath, HandlingUnit.class, key, "HandlingUnit");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<HandlingUnit> createHandlingUnit(@Nonnull HandlingUnit handlingUnit) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)handlingUnit, "HandlingUnit");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<HandlingUnitItem> getAllHandlingUnitItem() {
        return new GetAllRequestBuilder(this.servicePath, HandlingUnitItem.class, "HandlingUnitItem");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<HandlingUnitItem> countHandlingUnitItem() {
        return new CountRequestBuilder(this.servicePath, HandlingUnitItem.class, "HandlingUnitItem");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<HandlingUnitItem> getHandlingUnitItemByKey(@Nonnull String handlingUnitExternalID, @Nonnull String warehouse, @Nonnull UUID stockItemUUID) {
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("HandlingUnitExternalID", handlingUnitExternalID);
        key.put("Warehouse", warehouse);
        key.put("StockItemUUID", stockItemUUID);
        return new GetByKeyRequestBuilder(this.servicePath, HandlingUnitItem.class, key, "HandlingUnitItem");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<HandlingUnitItem> createHandlingUnitItem(@Nonnull HandlingUnitItem handlingUnitItem) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)handlingUnitItem, "HandlingUnitItem");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

