/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productgroupdata.ProductGroup;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productgroupdata.ProductGroupText;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductGroupDataService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultProductGroupDataService")
public class DefaultProductGroupDataService
implements ServiceWithNavigableEntities,
ProductGroupDataService {
    @Nonnull
    private final String servicePath;

    public DefaultProductGroupDataService() {
        this.servicePath = "/sap/opu/odata4/sap/api_productgroup_2/srvd_a2x/sap/productgroup/0001";
    }

    private DefaultProductGroupDataService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductGroupDataService withServicePath(@Nonnull String servicePath) {
        return new DefaultProductGroupDataService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ProductGroup> getAllProductGroup() {
        return new GetAllRequestBuilder(this.servicePath, ProductGroup.class, "ProductGroup");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ProductGroup> countProductGroup() {
        return new CountRequestBuilder(this.servicePath, ProductGroup.class, "ProductGroup");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ProductGroup> getProductGroupByKey(@Nonnull String productGroup) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("ProductGroup", productGroup);
        return new GetByKeyRequestBuilder(this.servicePath, ProductGroup.class, key, "ProductGroup");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ProductGroupText> getAllProductGroupText() {
        return new GetAllRequestBuilder(this.servicePath, ProductGroupText.class, "ProductGroupText");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ProductGroupText> countProductGroupText() {
        return new CountRequestBuilder(this.servicePath, ProductGroupText.class, "ProductGroupText");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ProductGroupText> getProductGroupTextByKey(@Nonnull String productGroup, @Nonnull String language) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("ProductGroup", productGroup);
        key.put("Language", language);
        return new GetByKeyRequestBuilder(this.servicePath, ProductGroupText.class, key, "ProductGroupText");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

