/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product.ProductPlant;
import io.vavr.control.Option;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonAdapter(value=GsonVdmAdapterFactory.class)
@JsonSerialize(using=JacksonVdmObjectSerializer.class)
@JsonDeserialize(using=JacksonVdmObjectDeserializer.class)
public class ProductPlantWorkScheduling
extends VdmEntity<ProductPlantWorkScheduling>
implements VdmEntitySet {
    private final String odataType = "com.sap.gateway.srvd_a2x.api_product.v0001.ProductPlantWorkScheduling_Type";
    public static final SimpleProperty<ProductPlantWorkScheduling> ALL_FIELDS = ProductPlantWorkScheduling.all();
    @Nullable
    @ElementName(value="Product")
    private String product;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> PRODUCT = new SimpleProperty.String(ProductPlantWorkScheduling.class, "Product");
    @Nullable
    @ElementName(value="Plant")
    private String plant;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> PLANT = new SimpleProperty.String(ProductPlantWorkScheduling.class, "Plant");
    @Nullable
    @ElementName(value="ProductBaseQuantity")
    @DecimalDescriptor(precision=13, scale=3)
    private BigDecimal productBaseQuantity;
    public static final SimpleProperty.NumericDecimal<ProductPlantWorkScheduling> PRODUCT_BASE_QUANTITY = new SimpleProperty.NumericDecimal(ProductPlantWorkScheduling.class, "ProductBaseQuantity");
    @Nullable
    @ElementName(value="UnlimitedOverDelivIsAllowed")
    private Boolean unlimitedOverDelivIsAllowed;
    public static final SimpleProperty.Boolean<ProductPlantWorkScheduling> UNLIMITED_OVER_DELIV_IS_ALLOWED = new SimpleProperty.Boolean(ProductPlantWorkScheduling.class, "UnlimitedOverDelivIsAllowed");
    @Nullable
    @ElementName(value="OverDeliveryTolerancePercent")
    @DecimalDescriptor(precision=3, scale=1)
    private BigDecimal overDeliveryTolerancePercent;
    public static final SimpleProperty.NumericDecimal<ProductPlantWorkScheduling> OVER_DELIVERY_TOLERANCE_PERCENT = new SimpleProperty.NumericDecimal(ProductPlantWorkScheduling.class, "OverDeliveryTolerancePercent");
    @Nullable
    @ElementName(value="UnderDeliveryTolerancePercent")
    @DecimalDescriptor(precision=3, scale=1)
    private BigDecimal underDeliveryTolerancePercent;
    public static final SimpleProperty.NumericDecimal<ProductPlantWorkScheduling> UNDER_DELIVERY_TOLERANCE_PERCENT = new SimpleProperty.NumericDecimal(ProductPlantWorkScheduling.class, "UnderDeliveryTolerancePercent");
    @Nullable
    @ElementName(value="ProductionInvtryManagedLoc")
    private String productionInvtryManagedLoc;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> PRODUCTION_INVTRY_MANAGED_LOC = new SimpleProperty.String(ProductPlantWorkScheduling.class, "ProductionInvtryManagedLoc");
    @Nullable
    @ElementName(value="ProductionOrderBatchCode")
    private String productionOrderBatchCode;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> PRODUCTION_ORDER_BATCH_CODE = new SimpleProperty.String(ProductPlantWorkScheduling.class, "ProductionOrderBatchCode");
    @Nullable
    @ElementName(value="ProdIsWithdrawnFrmProdnBin")
    private Boolean prodIsWithdrawnFrmProdnBin;
    public static final SimpleProperty.Boolean<ProductPlantWorkScheduling> PROD_IS_WITHDRAWN_FRM_PRODN_BIN = new SimpleProperty.Boolean(ProductPlantWorkScheduling.class, "ProdIsWithdrawnFrmProdnBin");
    @Nullable
    @ElementName(value="TransitionMatrixProductsGroup")
    private String transitionMatrixProductsGroup;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> TRANSITION_MATRIX_PRODUCTS_GROUP = new SimpleProperty.String(ProductPlantWorkScheduling.class, "TransitionMatrixProductsGroup");
    @Nullable
    @ElementName(value="OrderChangeManagementProfile")
    private String orderChangeManagementProfile;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> ORDER_CHANGE_MANAGEMENT_PROFILE = new SimpleProperty.String(ProductPlantWorkScheduling.class, "OrderChangeManagementProfile");
    @Nullable
    @ElementName(value="ProductComponentBackflushCode")
    private String productComponentBackflushCode;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> PRODUCT_COMPONENT_BACKFLUSH_CODE = new SimpleProperty.String(ProductPlantWorkScheduling.class, "ProductComponentBackflushCode");
    @Nullable
    @ElementName(value="SetupAndTeardownTime")
    @DecimalDescriptor(precision=5, scale=2)
    private BigDecimal setupAndTeardownTime;
    public static final SimpleProperty.NumericDecimal<ProductPlantWorkScheduling> SETUP_AND_TEARDOWN_TIME = new SimpleProperty.NumericDecimal(ProductPlantWorkScheduling.class, "SetupAndTeardownTime");
    @Nullable
    @ElementName(value="ProductionSchedulingProfile")
    private String productionSchedulingProfile;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> PRODUCTION_SCHEDULING_PROFILE = new SimpleProperty.String(ProductPlantWorkScheduling.class, "ProductionSchedulingProfile");
    @Nullable
    @ElementName(value="TransitionTime")
    @DecimalDescriptor(precision=5, scale=2)
    private BigDecimal transitionTime;
    public static final SimpleProperty.NumericDecimal<ProductPlantWorkScheduling> TRANSITION_TIME = new SimpleProperty.NumericDecimal(ProductPlantWorkScheduling.class, "TransitionTime");
    @Nullable
    @ElementName(value="ProcessingTimeInDays")
    @DecimalDescriptor(precision=5, scale=2)
    private BigDecimal processingTimeInDays;
    public static final SimpleProperty.NumericDecimal<ProductPlantWorkScheduling> PROCESSING_TIME_IN_DAYS = new SimpleProperty.NumericDecimal(ProductPlantWorkScheduling.class, "ProcessingTimeInDays");
    @Nullable
    @ElementName(value="ProductionSupervisor")
    private String productionSupervisor;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> PRODUCTION_SUPERVISOR = new SimpleProperty.String(ProductPlantWorkScheduling.class, "ProductionSupervisor");
    @Nullable
    @ElementName(value="ProductProductionQuantityUnit")
    private String productProductionQuantityUnit;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> PRODUCT_PRODUCTION_QUANTITY_UNIT = new SimpleProperty.String(ProductPlantWorkScheduling.class, "ProductProductionQuantityUnit");
    @Nullable
    @ElementName(value="ProdProductionQuantityISOUnit")
    private String prodProductionQuantityISOUnit;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> PROD_PRODUCTION_QUANTITY_ISO_UNIT = new SimpleProperty.String(ProductPlantWorkScheduling.class, "ProdProductionQuantityISOUnit");
    @Nullable
    @ElementName(value="BaseUnit")
    private String baseUnit;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> BASE_UNIT = new SimpleProperty.String(ProductPlantWorkScheduling.class, "BaseUnit");
    @Nullable
    @ElementName(value="BaseISOUnit")
    private String baseISOUnit;
    public static final SimpleProperty.String<ProductPlantWorkScheduling> BASE_ISO_UNIT = new SimpleProperty.String(ProductPlantWorkScheduling.class, "BaseISOUnit");
    @ElementName(value="_Product")
    @Nullable
    private Product to_Product;
    @ElementName(value="_ProductPlant")
    @Nullable
    private ProductPlant to_ProductPlant;
    public static final NavigationProperty.Single<ProductPlantWorkScheduling, Product> TO__PRODUCT = new NavigationProperty.Single(ProductPlantWorkScheduling.class, "_Product", Product.class);
    public static final NavigationProperty.Single<ProductPlantWorkScheduling, ProductPlant> TO__PRODUCT_PLANT = new NavigationProperty.Single(ProductPlantWorkScheduling.class, "_ProductPlant", ProductPlant.class);

    @Nonnull
    public Class<ProductPlantWorkScheduling> getType() {
        return ProductPlantWorkScheduling.class;
    }

    public void setProduct(@Nullable String product) {
        this.rememberChangedField("Product", this.product);
        this.product = product;
    }

    public void setPlant(@Nullable String plant) {
        this.rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    public void setProductBaseQuantity(@Nullable BigDecimal productBaseQuantity) {
        this.rememberChangedField("ProductBaseQuantity", this.productBaseQuantity);
        this.productBaseQuantity = productBaseQuantity;
    }

    public void setUnlimitedOverDelivIsAllowed(@Nullable Boolean unlimitedOverDelivIsAllowed) {
        this.rememberChangedField("UnlimitedOverDelivIsAllowed", this.unlimitedOverDelivIsAllowed);
        this.unlimitedOverDelivIsAllowed = unlimitedOverDelivIsAllowed;
    }

    public void setOverDeliveryTolerancePercent(@Nullable BigDecimal overDeliveryTolerancePercent) {
        this.rememberChangedField("OverDeliveryTolerancePercent", this.overDeliveryTolerancePercent);
        this.overDeliveryTolerancePercent = overDeliveryTolerancePercent;
    }

    public void setUnderDeliveryTolerancePercent(@Nullable BigDecimal underDeliveryTolerancePercent) {
        this.rememberChangedField("UnderDeliveryTolerancePercent", this.underDeliveryTolerancePercent);
        this.underDeliveryTolerancePercent = underDeliveryTolerancePercent;
    }

    public void setProductionInvtryManagedLoc(@Nullable String productionInvtryManagedLoc) {
        this.rememberChangedField("ProductionInvtryManagedLoc", this.productionInvtryManagedLoc);
        this.productionInvtryManagedLoc = productionInvtryManagedLoc;
    }

    public void setProductionOrderBatchCode(@Nullable String productionOrderBatchCode) {
        this.rememberChangedField("ProductionOrderBatchCode", this.productionOrderBatchCode);
        this.productionOrderBatchCode = productionOrderBatchCode;
    }

    public void setProdIsWithdrawnFrmProdnBin(@Nullable Boolean prodIsWithdrawnFrmProdnBin) {
        this.rememberChangedField("ProdIsWithdrawnFrmProdnBin", this.prodIsWithdrawnFrmProdnBin);
        this.prodIsWithdrawnFrmProdnBin = prodIsWithdrawnFrmProdnBin;
    }

    public void setTransitionMatrixProductsGroup(@Nullable String transitionMatrixProductsGroup) {
        this.rememberChangedField("TransitionMatrixProductsGroup", this.transitionMatrixProductsGroup);
        this.transitionMatrixProductsGroup = transitionMatrixProductsGroup;
    }

    public void setOrderChangeManagementProfile(@Nullable String orderChangeManagementProfile) {
        this.rememberChangedField("OrderChangeManagementProfile", this.orderChangeManagementProfile);
        this.orderChangeManagementProfile = orderChangeManagementProfile;
    }

    public void setProductComponentBackflushCode(@Nullable String productComponentBackflushCode) {
        this.rememberChangedField("ProductComponentBackflushCode", this.productComponentBackflushCode);
        this.productComponentBackflushCode = productComponentBackflushCode;
    }

    public void setSetupAndTeardownTime(@Nullable BigDecimal setupAndTeardownTime) {
        this.rememberChangedField("SetupAndTeardownTime", this.setupAndTeardownTime);
        this.setupAndTeardownTime = setupAndTeardownTime;
    }

    public void setProductionSchedulingProfile(@Nullable String productionSchedulingProfile) {
        this.rememberChangedField("ProductionSchedulingProfile", this.productionSchedulingProfile);
        this.productionSchedulingProfile = productionSchedulingProfile;
    }

    public void setTransitionTime(@Nullable BigDecimal transitionTime) {
        this.rememberChangedField("TransitionTime", this.transitionTime);
        this.transitionTime = transitionTime;
    }

    public void setProcessingTimeInDays(@Nullable BigDecimal processingTimeInDays) {
        this.rememberChangedField("ProcessingTimeInDays", this.processingTimeInDays);
        this.processingTimeInDays = processingTimeInDays;
    }

    public void setProductionSupervisor(@Nullable String productionSupervisor) {
        this.rememberChangedField("ProductionSupervisor", this.productionSupervisor);
        this.productionSupervisor = productionSupervisor;
    }

    public void setProductProductionQuantityUnit(@Nullable String productProductionQuantityUnit) {
        this.rememberChangedField("ProductProductionQuantityUnit", this.productProductionQuantityUnit);
        this.productProductionQuantityUnit = productProductionQuantityUnit;
    }

    public void setProdProductionQuantityISOUnit(@Nullable String prodProductionQuantityISOUnit) {
        this.rememberChangedField("ProdProductionQuantityISOUnit", this.prodProductionQuantityISOUnit);
        this.prodProductionQuantityISOUnit = prodProductionQuantityISOUnit;
    }

    public void setBaseUnit(@Nullable String baseUnit) {
        this.rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    public void setBaseISOUnit(@Nullable String baseISOUnit) {
        this.rememberChangedField("BaseISOUnit", this.baseISOUnit);
        this.baseISOUnit = baseISOUnit;
    }

    protected String getEntityCollection() {
        return "ProductPlantWorkScheduling";
    }

    @Nonnull
    protected ODataEntityKey getKey() {
        ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("Product", (Object)this.getProduct());
        entityKey.addKeyProperty("Plant", (Object)this.getPlant());
        return entityKey;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("Product", this.getProduct());
        values.put("Plant", this.getPlant());
        values.put("ProductBaseQuantity", this.getProductBaseQuantity());
        values.put("UnlimitedOverDelivIsAllowed", this.getUnlimitedOverDelivIsAllowed());
        values.put("OverDeliveryTolerancePercent", this.getOverDeliveryTolerancePercent());
        values.put("UnderDeliveryTolerancePercent", this.getUnderDeliveryTolerancePercent());
        values.put("ProductionInvtryManagedLoc", this.getProductionInvtryManagedLoc());
        values.put("ProductionOrderBatchCode", this.getProductionOrderBatchCode());
        values.put("ProdIsWithdrawnFrmProdnBin", this.getProdIsWithdrawnFrmProdnBin());
        values.put("TransitionMatrixProductsGroup", this.getTransitionMatrixProductsGroup());
        values.put("OrderChangeManagementProfile", this.getOrderChangeManagementProfile());
        values.put("ProductComponentBackflushCode", this.getProductComponentBackflushCode());
        values.put("SetupAndTeardownTime", this.getSetupAndTeardownTime());
        values.put("ProductionSchedulingProfile", this.getProductionSchedulingProfile());
        values.put("TransitionTime", this.getTransitionTime());
        values.put("ProcessingTimeInDays", this.getProcessingTimeInDays());
        values.put("ProductionSupervisor", this.getProductionSupervisor());
        values.put("ProductProductionQuantityUnit", this.getProductProductionQuantityUnit());
        values.put("ProdProductionQuantityISOUnit", this.getProdProductionQuantityISOUnit());
        values.put("BaseUnit", this.getBaseUnit());
        values.put("BaseISOUnit", this.getBaseISOUnit());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Map inputMap;
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("Product") && ((value = values.remove("Product")) == null || !value.equals(this.getProduct()))) {
            this.setProduct((String)value);
        }
        if (values.containsKey("Plant") && ((value = values.remove("Plant")) == null || !value.equals(this.getPlant()))) {
            this.setPlant((String)value);
        }
        if (values.containsKey("ProductBaseQuantity") && ((value = values.remove("ProductBaseQuantity")) == null || !value.equals(this.getProductBaseQuantity()))) {
            this.setProductBaseQuantity((BigDecimal)value);
        }
        if (values.containsKey("UnlimitedOverDelivIsAllowed") && ((value = values.remove("UnlimitedOverDelivIsAllowed")) == null || !value.equals(this.getUnlimitedOverDelivIsAllowed()))) {
            this.setUnlimitedOverDelivIsAllowed((Boolean)value);
        }
        if (values.containsKey("OverDeliveryTolerancePercent") && ((value = values.remove("OverDeliveryTolerancePercent")) == null || !value.equals(this.getOverDeliveryTolerancePercent()))) {
            this.setOverDeliveryTolerancePercent((BigDecimal)value);
        }
        if (values.containsKey("UnderDeliveryTolerancePercent") && ((value = values.remove("UnderDeliveryTolerancePercent")) == null || !value.equals(this.getUnderDeliveryTolerancePercent()))) {
            this.setUnderDeliveryTolerancePercent((BigDecimal)value);
        }
        if (values.containsKey("ProductionInvtryManagedLoc") && ((value = values.remove("ProductionInvtryManagedLoc")) == null || !value.equals(this.getProductionInvtryManagedLoc()))) {
            this.setProductionInvtryManagedLoc((String)value);
        }
        if (values.containsKey("ProductionOrderBatchCode") && ((value = values.remove("ProductionOrderBatchCode")) == null || !value.equals(this.getProductionOrderBatchCode()))) {
            this.setProductionOrderBatchCode((String)value);
        }
        if (values.containsKey("ProdIsWithdrawnFrmProdnBin") && ((value = values.remove("ProdIsWithdrawnFrmProdnBin")) == null || !value.equals(this.getProdIsWithdrawnFrmProdnBin()))) {
            this.setProdIsWithdrawnFrmProdnBin((Boolean)value);
        }
        if (values.containsKey("TransitionMatrixProductsGroup") && ((value = values.remove("TransitionMatrixProductsGroup")) == null || !value.equals(this.getTransitionMatrixProductsGroup()))) {
            this.setTransitionMatrixProductsGroup((String)value);
        }
        if (values.containsKey("OrderChangeManagementProfile") && ((value = values.remove("OrderChangeManagementProfile")) == null || !value.equals(this.getOrderChangeManagementProfile()))) {
            this.setOrderChangeManagementProfile((String)value);
        }
        if (values.containsKey("ProductComponentBackflushCode") && ((value = values.remove("ProductComponentBackflushCode")) == null || !value.equals(this.getProductComponentBackflushCode()))) {
            this.setProductComponentBackflushCode((String)value);
        }
        if (values.containsKey("SetupAndTeardownTime") && ((value = values.remove("SetupAndTeardownTime")) == null || !value.equals(this.getSetupAndTeardownTime()))) {
            this.setSetupAndTeardownTime((BigDecimal)value);
        }
        if (values.containsKey("ProductionSchedulingProfile") && ((value = values.remove("ProductionSchedulingProfile")) == null || !value.equals(this.getProductionSchedulingProfile()))) {
            this.setProductionSchedulingProfile((String)value);
        }
        if (values.containsKey("TransitionTime") && ((value = values.remove("TransitionTime")) == null || !value.equals(this.getTransitionTime()))) {
            this.setTransitionTime((BigDecimal)value);
        }
        if (values.containsKey("ProcessingTimeInDays") && ((value = values.remove("ProcessingTimeInDays")) == null || !value.equals(this.getProcessingTimeInDays()))) {
            this.setProcessingTimeInDays((BigDecimal)value);
        }
        if (values.containsKey("ProductionSupervisor") && ((value = values.remove("ProductionSupervisor")) == null || !value.equals(this.getProductionSupervisor()))) {
            this.setProductionSupervisor((String)value);
        }
        if (values.containsKey("ProductProductionQuantityUnit") && ((value = values.remove("ProductProductionQuantityUnit")) == null || !value.equals(this.getProductProductionQuantityUnit()))) {
            this.setProductProductionQuantityUnit((String)value);
        }
        if (values.containsKey("ProdProductionQuantityISOUnit") && ((value = values.remove("ProdProductionQuantityISOUnit")) == null || !value.equals(this.getProdProductionQuantityISOUnit()))) {
            this.setProdProductionQuantityISOUnit((String)value);
        }
        if (values.containsKey("BaseUnit") && ((value = values.remove("BaseUnit")) == null || !value.equals(this.getBaseUnit()))) {
            this.setBaseUnit((String)value);
        }
        if (values.containsKey("BaseISOUnit") && ((value = values.remove("BaseISOUnit")) == null || !value.equals(this.getBaseISOUnit()))) {
            this.setBaseISOUnit((String)value);
        }
        if (values.containsKey("_Product") && (value = values.remove("_Product")) instanceof Map) {
            if (this.to_Product == null) {
                this.to_Product = new Product();
            }
            inputMap = (Map)value;
            this.to_Product.fromMap(inputMap);
        }
        if (values.containsKey("_ProductPlant") && (value = values.remove("_ProductPlant")) instanceof Map) {
            if (this.to_ProductPlant == null) {
                this.to_ProductPlant = new ProductPlant();
            }
            inputMap = (Map)value;
            this.to_ProductPlant.fromMap(inputMap);
        }
        super.fromMap((Map)values);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata4/sap/api_product/srvd_a2x/sap/product/0001";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.to_Product != null) {
            values.put("_Product", this.to_Product);
        }
        if (this.to_ProductPlant != null) {
            values.put("_ProductPlant", this.to_ProductPlant);
        }
        return values;
    }

    @Nonnull
    public Option<Product> getProductIfPresent() {
        return Option.of((Object)((Object)this.to_Product));
    }

    public void setProduct(Product value) {
        this.to_Product = value;
    }

    @Nonnull
    public Option<ProductPlant> getProductPlantIfPresent() {
        return Option.of((Object)((Object)this.to_ProductPlant));
    }

    public void setProductPlant(ProductPlant value) {
        this.to_ProductPlant = value;
    }

    @Nonnull
    @Generated
    public static ProductPlantWorkSchedulingBuilder builder() {
        return new ProductPlantWorkSchedulingBuilder();
    }

    @Nullable
    @Generated
    public String getProduct() {
        return this.product;
    }

    @Nullable
    @Generated
    public String getPlant() {
        return this.plant;
    }

    @Nullable
    @Generated
    public BigDecimal getProductBaseQuantity() {
        return this.productBaseQuantity;
    }

    @Nullable
    @Generated
    public Boolean getUnlimitedOverDelivIsAllowed() {
        return this.unlimitedOverDelivIsAllowed;
    }

    @Nullable
    @Generated
    public BigDecimal getOverDeliveryTolerancePercent() {
        return this.overDeliveryTolerancePercent;
    }

    @Nullable
    @Generated
    public BigDecimal getUnderDeliveryTolerancePercent() {
        return this.underDeliveryTolerancePercent;
    }

    @Nullable
    @Generated
    public String getProductionInvtryManagedLoc() {
        return this.productionInvtryManagedLoc;
    }

    @Nullable
    @Generated
    public String getProductionOrderBatchCode() {
        return this.productionOrderBatchCode;
    }

    @Nullable
    @Generated
    public Boolean getProdIsWithdrawnFrmProdnBin() {
        return this.prodIsWithdrawnFrmProdnBin;
    }

    @Nullable
    @Generated
    public String getTransitionMatrixProductsGroup() {
        return this.transitionMatrixProductsGroup;
    }

    @Nullable
    @Generated
    public String getOrderChangeManagementProfile() {
        return this.orderChangeManagementProfile;
    }

    @Nullable
    @Generated
    public String getProductComponentBackflushCode() {
        return this.productComponentBackflushCode;
    }

    @Nullable
    @Generated
    public BigDecimal getSetupAndTeardownTime() {
        return this.setupAndTeardownTime;
    }

    @Nullable
    @Generated
    public String getProductionSchedulingProfile() {
        return this.productionSchedulingProfile;
    }

    @Nullable
    @Generated
    public BigDecimal getTransitionTime() {
        return this.transitionTime;
    }

    @Nullable
    @Generated
    public BigDecimal getProcessingTimeInDays() {
        return this.processingTimeInDays;
    }

    @Nullable
    @Generated
    public String getProductionSupervisor() {
        return this.productionSupervisor;
    }

    @Nullable
    @Generated
    public String getProductProductionQuantityUnit() {
        return this.productProductionQuantityUnit;
    }

    @Nullable
    @Generated
    public String getProdProductionQuantityISOUnit() {
        return this.prodProductionQuantityISOUnit;
    }

    @Nullable
    @Generated
    public String getBaseUnit() {
        return this.baseUnit;
    }

    @Nullable
    @Generated
    public String getBaseISOUnit() {
        return this.baseISOUnit;
    }

    @Generated
    public ProductPlantWorkScheduling() {
    }

    @Generated
    public ProductPlantWorkScheduling(@Nullable String product, @Nullable String plant, @Nullable BigDecimal productBaseQuantity, @Nullable Boolean unlimitedOverDelivIsAllowed, @Nullable BigDecimal overDeliveryTolerancePercent, @Nullable BigDecimal underDeliveryTolerancePercent, @Nullable String productionInvtryManagedLoc, @Nullable String productionOrderBatchCode, @Nullable Boolean prodIsWithdrawnFrmProdnBin, @Nullable String transitionMatrixProductsGroup, @Nullable String orderChangeManagementProfile, @Nullable String productComponentBackflushCode, @Nullable BigDecimal setupAndTeardownTime, @Nullable String productionSchedulingProfile, @Nullable BigDecimal transitionTime, @Nullable BigDecimal processingTimeInDays, @Nullable String productionSupervisor, @Nullable String productProductionQuantityUnit, @Nullable String prodProductionQuantityISOUnit, @Nullable String baseUnit, @Nullable String baseISOUnit, @Nullable Product to_Product, @Nullable ProductPlant to_ProductPlant) {
        this.product = product;
        this.plant = plant;
        this.productBaseQuantity = productBaseQuantity;
        this.unlimitedOverDelivIsAllowed = unlimitedOverDelivIsAllowed;
        this.overDeliveryTolerancePercent = overDeliveryTolerancePercent;
        this.underDeliveryTolerancePercent = underDeliveryTolerancePercent;
        this.productionInvtryManagedLoc = productionInvtryManagedLoc;
        this.productionOrderBatchCode = productionOrderBatchCode;
        this.prodIsWithdrawnFrmProdnBin = prodIsWithdrawnFrmProdnBin;
        this.transitionMatrixProductsGroup = transitionMatrixProductsGroup;
        this.orderChangeManagementProfile = orderChangeManagementProfile;
        this.productComponentBackflushCode = productComponentBackflushCode;
        this.setupAndTeardownTime = setupAndTeardownTime;
        this.productionSchedulingProfile = productionSchedulingProfile;
        this.transitionTime = transitionTime;
        this.processingTimeInDays = processingTimeInDays;
        this.productionSupervisor = productionSupervisor;
        this.productProductionQuantityUnit = productProductionQuantityUnit;
        this.prodProductionQuantityISOUnit = prodProductionQuantityISOUnit;
        this.baseUnit = baseUnit;
        this.baseISOUnit = baseISOUnit;
        this.to_Product = to_Product;
        this.to_ProductPlant = to_ProductPlant;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "ProductPlantWorkScheduling(super=" + super.toString() + ", odataType=" + this.odataType + ", product=" + this.product + ", plant=" + this.plant + ", productBaseQuantity=" + this.productBaseQuantity + ", unlimitedOverDelivIsAllowed=" + this.unlimitedOverDelivIsAllowed + ", overDeliveryTolerancePercent=" + this.overDeliveryTolerancePercent + ", underDeliveryTolerancePercent=" + this.underDeliveryTolerancePercent + ", productionInvtryManagedLoc=" + this.productionInvtryManagedLoc + ", productionOrderBatchCode=" + this.productionOrderBatchCode + ", prodIsWithdrawnFrmProdnBin=" + this.prodIsWithdrawnFrmProdnBin + ", transitionMatrixProductsGroup=" + this.transitionMatrixProductsGroup + ", orderChangeManagementProfile=" + this.orderChangeManagementProfile + ", productComponentBackflushCode=" + this.productComponentBackflushCode + ", setupAndTeardownTime=" + this.setupAndTeardownTime + ", productionSchedulingProfile=" + this.productionSchedulingProfile + ", transitionTime=" + this.transitionTime + ", processingTimeInDays=" + this.processingTimeInDays + ", productionSupervisor=" + this.productionSupervisor + ", productProductionQuantityUnit=" + this.productProductionQuantityUnit + ", prodProductionQuantityISOUnit=" + this.prodProductionQuantityISOUnit + ", baseUnit=" + this.baseUnit + ", baseISOUnit=" + this.baseISOUnit + ", to_Product=" + (Object)((Object)this.to_Product) + ", to_ProductPlant=" + (Object)((Object)this.to_ProductPlant) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductPlantWorkScheduling)) {
            return false;
        }
        ProductPlantWorkScheduling other = (ProductPlantWorkScheduling)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$unlimitedOverDelivIsAllowed = this.unlimitedOverDelivIsAllowed;
        Boolean other$unlimitedOverDelivIsAllowed = other.unlimitedOverDelivIsAllowed;
        if (this$unlimitedOverDelivIsAllowed == null ? other$unlimitedOverDelivIsAllowed != null : !((Object)this$unlimitedOverDelivIsAllowed).equals(other$unlimitedOverDelivIsAllowed)) {
            return false;
        }
        Boolean this$prodIsWithdrawnFrmProdnBin = this.prodIsWithdrawnFrmProdnBin;
        Boolean other$prodIsWithdrawnFrmProdnBin = other.prodIsWithdrawnFrmProdnBin;
        if (this$prodIsWithdrawnFrmProdnBin == null ? other$prodIsWithdrawnFrmProdnBin != null : !((Object)this$prodIsWithdrawnFrmProdnBin).equals(other$prodIsWithdrawnFrmProdnBin)) {
            return false;
        }
        String this$odataType = this.odataType;
        String other$odataType = other.odataType;
        if (this$odataType == null ? other$odataType != null : !this$odataType.equals(other$odataType)) {
            return false;
        }
        String this$product = this.product;
        String other$product = other.product;
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        String this$plant = this.plant;
        String other$plant = other.plant;
        if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
            return false;
        }
        BigDecimal this$productBaseQuantity = this.productBaseQuantity;
        BigDecimal other$productBaseQuantity = other.productBaseQuantity;
        if (this$productBaseQuantity == null ? other$productBaseQuantity != null : !((Object)this$productBaseQuantity).equals(other$productBaseQuantity)) {
            return false;
        }
        BigDecimal this$overDeliveryTolerancePercent = this.overDeliveryTolerancePercent;
        BigDecimal other$overDeliveryTolerancePercent = other.overDeliveryTolerancePercent;
        if (this$overDeliveryTolerancePercent == null ? other$overDeliveryTolerancePercent != null : !((Object)this$overDeliveryTolerancePercent).equals(other$overDeliveryTolerancePercent)) {
            return false;
        }
        BigDecimal this$underDeliveryTolerancePercent = this.underDeliveryTolerancePercent;
        BigDecimal other$underDeliveryTolerancePercent = other.underDeliveryTolerancePercent;
        if (this$underDeliveryTolerancePercent == null ? other$underDeliveryTolerancePercent != null : !((Object)this$underDeliveryTolerancePercent).equals(other$underDeliveryTolerancePercent)) {
            return false;
        }
        String this$productionInvtryManagedLoc = this.productionInvtryManagedLoc;
        String other$productionInvtryManagedLoc = other.productionInvtryManagedLoc;
        if (this$productionInvtryManagedLoc == null ? other$productionInvtryManagedLoc != null : !this$productionInvtryManagedLoc.equals(other$productionInvtryManagedLoc)) {
            return false;
        }
        String this$productionOrderBatchCode = this.productionOrderBatchCode;
        String other$productionOrderBatchCode = other.productionOrderBatchCode;
        if (this$productionOrderBatchCode == null ? other$productionOrderBatchCode != null : !this$productionOrderBatchCode.equals(other$productionOrderBatchCode)) {
            return false;
        }
        String this$transitionMatrixProductsGroup = this.transitionMatrixProductsGroup;
        String other$transitionMatrixProductsGroup = other.transitionMatrixProductsGroup;
        if (this$transitionMatrixProductsGroup == null ? other$transitionMatrixProductsGroup != null : !this$transitionMatrixProductsGroup.equals(other$transitionMatrixProductsGroup)) {
            return false;
        }
        String this$orderChangeManagementProfile = this.orderChangeManagementProfile;
        String other$orderChangeManagementProfile = other.orderChangeManagementProfile;
        if (this$orderChangeManagementProfile == null ? other$orderChangeManagementProfile != null : !this$orderChangeManagementProfile.equals(other$orderChangeManagementProfile)) {
            return false;
        }
        String this$productComponentBackflushCode = this.productComponentBackflushCode;
        String other$productComponentBackflushCode = other.productComponentBackflushCode;
        if (this$productComponentBackflushCode == null ? other$productComponentBackflushCode != null : !this$productComponentBackflushCode.equals(other$productComponentBackflushCode)) {
            return false;
        }
        BigDecimal this$setupAndTeardownTime = this.setupAndTeardownTime;
        BigDecimal other$setupAndTeardownTime = other.setupAndTeardownTime;
        if (this$setupAndTeardownTime == null ? other$setupAndTeardownTime != null : !((Object)this$setupAndTeardownTime).equals(other$setupAndTeardownTime)) {
            return false;
        }
        String this$productionSchedulingProfile = this.productionSchedulingProfile;
        String other$productionSchedulingProfile = other.productionSchedulingProfile;
        if (this$productionSchedulingProfile == null ? other$productionSchedulingProfile != null : !this$productionSchedulingProfile.equals(other$productionSchedulingProfile)) {
            return false;
        }
        BigDecimal this$transitionTime = this.transitionTime;
        BigDecimal other$transitionTime = other.transitionTime;
        if (this$transitionTime == null ? other$transitionTime != null : !((Object)this$transitionTime).equals(other$transitionTime)) {
            return false;
        }
        BigDecimal this$processingTimeInDays = this.processingTimeInDays;
        BigDecimal other$processingTimeInDays = other.processingTimeInDays;
        if (this$processingTimeInDays == null ? other$processingTimeInDays != null : !((Object)this$processingTimeInDays).equals(other$processingTimeInDays)) {
            return false;
        }
        String this$productionSupervisor = this.productionSupervisor;
        String other$productionSupervisor = other.productionSupervisor;
        if (this$productionSupervisor == null ? other$productionSupervisor != null : !this$productionSupervisor.equals(other$productionSupervisor)) {
            return false;
        }
        String this$productProductionQuantityUnit = this.productProductionQuantityUnit;
        String other$productProductionQuantityUnit = other.productProductionQuantityUnit;
        if (this$productProductionQuantityUnit == null ? other$productProductionQuantityUnit != null : !this$productProductionQuantityUnit.equals(other$productProductionQuantityUnit)) {
            return false;
        }
        String this$prodProductionQuantityISOUnit = this.prodProductionQuantityISOUnit;
        String other$prodProductionQuantityISOUnit = other.prodProductionQuantityISOUnit;
        if (this$prodProductionQuantityISOUnit == null ? other$prodProductionQuantityISOUnit != null : !this$prodProductionQuantityISOUnit.equals(other$prodProductionQuantityISOUnit)) {
            return false;
        }
        String this$baseUnit = this.baseUnit;
        String other$baseUnit = other.baseUnit;
        if (this$baseUnit == null ? other$baseUnit != null : !this$baseUnit.equals(other$baseUnit)) {
            return false;
        }
        String this$baseISOUnit = this.baseISOUnit;
        String other$baseISOUnit = other.baseISOUnit;
        if (this$baseISOUnit == null ? other$baseISOUnit != null : !this$baseISOUnit.equals(other$baseISOUnit)) {
            return false;
        }
        Product this$to_Product = this.to_Product;
        Product other$to_Product = other.to_Product;
        if (this$to_Product == null ? other$to_Product != null : !((Object)((Object)this$to_Product)).equals((Object)other$to_Product)) {
            return false;
        }
        ProductPlant this$to_ProductPlant = this.to_ProductPlant;
        ProductPlant other$to_ProductPlant = other.to_ProductPlant;
        return !(this$to_ProductPlant == null ? other$to_ProductPlant != null : !((Object)((Object)this$to_ProductPlant)).equals((Object)other$to_ProductPlant));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ProductPlantWorkScheduling;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $unlimitedOverDelivIsAllowed = this.unlimitedOverDelivIsAllowed;
        result = result * 59 + ($unlimitedOverDelivIsAllowed == null ? 43 : ((Object)$unlimitedOverDelivIsAllowed).hashCode());
        Boolean $prodIsWithdrawnFrmProdnBin = this.prodIsWithdrawnFrmProdnBin;
        result = result * 59 + ($prodIsWithdrawnFrmProdnBin == null ? 43 : ((Object)$prodIsWithdrawnFrmProdnBin).hashCode());
        String $odataType = this.odataType;
        result = result * 59 + ($odataType == null ? 43 : $odataType.hashCode());
        String $product = this.product;
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        String $plant = this.plant;
        result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
        BigDecimal $productBaseQuantity = this.productBaseQuantity;
        result = result * 59 + ($productBaseQuantity == null ? 43 : ((Object)$productBaseQuantity).hashCode());
        BigDecimal $overDeliveryTolerancePercent = this.overDeliveryTolerancePercent;
        result = result * 59 + ($overDeliveryTolerancePercent == null ? 43 : ((Object)$overDeliveryTolerancePercent).hashCode());
        BigDecimal $underDeliveryTolerancePercent = this.underDeliveryTolerancePercent;
        result = result * 59 + ($underDeliveryTolerancePercent == null ? 43 : ((Object)$underDeliveryTolerancePercent).hashCode());
        String $productionInvtryManagedLoc = this.productionInvtryManagedLoc;
        result = result * 59 + ($productionInvtryManagedLoc == null ? 43 : $productionInvtryManagedLoc.hashCode());
        String $productionOrderBatchCode = this.productionOrderBatchCode;
        result = result * 59 + ($productionOrderBatchCode == null ? 43 : $productionOrderBatchCode.hashCode());
        String $transitionMatrixProductsGroup = this.transitionMatrixProductsGroup;
        result = result * 59 + ($transitionMatrixProductsGroup == null ? 43 : $transitionMatrixProductsGroup.hashCode());
        String $orderChangeManagementProfile = this.orderChangeManagementProfile;
        result = result * 59 + ($orderChangeManagementProfile == null ? 43 : $orderChangeManagementProfile.hashCode());
        String $productComponentBackflushCode = this.productComponentBackflushCode;
        result = result * 59 + ($productComponentBackflushCode == null ? 43 : $productComponentBackflushCode.hashCode());
        BigDecimal $setupAndTeardownTime = this.setupAndTeardownTime;
        result = result * 59 + ($setupAndTeardownTime == null ? 43 : ((Object)$setupAndTeardownTime).hashCode());
        String $productionSchedulingProfile = this.productionSchedulingProfile;
        result = result * 59 + ($productionSchedulingProfile == null ? 43 : $productionSchedulingProfile.hashCode());
        BigDecimal $transitionTime = this.transitionTime;
        result = result * 59 + ($transitionTime == null ? 43 : ((Object)$transitionTime).hashCode());
        BigDecimal $processingTimeInDays = this.processingTimeInDays;
        result = result * 59 + ($processingTimeInDays == null ? 43 : ((Object)$processingTimeInDays).hashCode());
        String $productionSupervisor = this.productionSupervisor;
        result = result * 59 + ($productionSupervisor == null ? 43 : $productionSupervisor.hashCode());
        String $productProductionQuantityUnit = this.productProductionQuantityUnit;
        result = result * 59 + ($productProductionQuantityUnit == null ? 43 : $productProductionQuantityUnit.hashCode());
        String $prodProductionQuantityISOUnit = this.prodProductionQuantityISOUnit;
        result = result * 59 + ($prodProductionQuantityISOUnit == null ? 43 : $prodProductionQuantityISOUnit.hashCode());
        String $baseUnit = this.baseUnit;
        result = result * 59 + ($baseUnit == null ? 43 : $baseUnit.hashCode());
        String $baseISOUnit = this.baseISOUnit;
        result = result * 59 + ($baseISOUnit == null ? 43 : $baseISOUnit.hashCode());
        Product $to_Product = this.to_Product;
        result = result * 59 + ($to_Product == null ? 43 : ((Object)((Object)$to_Product)).hashCode());
        ProductPlant $to_ProductPlant = this.to_ProductPlant;
        result = result * 59 + ($to_ProductPlant == null ? 43 : ((Object)((Object)$to_ProductPlant)).hashCode());
        return result;
    }

    @Generated
    public String getOdataType() {
        return this.odataType;
    }

    public static final class ProductPlantWorkSchedulingBuilder {
        @Generated
        private String plant;
        @Generated
        private BigDecimal productBaseQuantity;
        @Generated
        private Boolean unlimitedOverDelivIsAllowed;
        @Generated
        private BigDecimal overDeliveryTolerancePercent;
        @Generated
        private BigDecimal underDeliveryTolerancePercent;
        @Generated
        private String productionInvtryManagedLoc;
        @Generated
        private String productionOrderBatchCode;
        @Generated
        private Boolean prodIsWithdrawnFrmProdnBin;
        @Generated
        private String transitionMatrixProductsGroup;
        @Generated
        private String orderChangeManagementProfile;
        @Generated
        private String productComponentBackflushCode;
        @Generated
        private BigDecimal setupAndTeardownTime;
        @Generated
        private String productionSchedulingProfile;
        @Generated
        private BigDecimal transitionTime;
        @Generated
        private BigDecimal processingTimeInDays;
        @Generated
        private String productionSupervisor;
        @Generated
        private String productProductionQuantityUnit;
        @Generated
        private String prodProductionQuantityISOUnit;
        @Generated
        private String baseUnit;
        @Generated
        private String baseISOUnit;
        private Product to_Product;
        private String product = null;
        private ProductPlant to_ProductPlant;

        private ProductPlantWorkSchedulingBuilder to_Product(Product value) {
            this.to_Product = value;
            return this;
        }

        @Nonnull
        public ProductPlantWorkSchedulingBuilder product(Product value) {
            return this.to_Product(value);
        }

        @Nonnull
        public ProductPlantWorkSchedulingBuilder product(String value) {
            this.product = value;
            return this;
        }

        private ProductPlantWorkSchedulingBuilder to_ProductPlant(ProductPlant value) {
            this.to_ProductPlant = value;
            return this;
        }

        @Nonnull
        public ProductPlantWorkSchedulingBuilder productPlant(ProductPlant value) {
            return this.to_ProductPlant(value);
        }

        @Generated
        ProductPlantWorkSchedulingBuilder() {
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder plant(@Nullable String plant) {
            this.plant = plant;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder productBaseQuantity(@Nullable BigDecimal productBaseQuantity) {
            this.productBaseQuantity = productBaseQuantity;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder unlimitedOverDelivIsAllowed(@Nullable Boolean unlimitedOverDelivIsAllowed) {
            this.unlimitedOverDelivIsAllowed = unlimitedOverDelivIsAllowed;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder overDeliveryTolerancePercent(@Nullable BigDecimal overDeliveryTolerancePercent) {
            this.overDeliveryTolerancePercent = overDeliveryTolerancePercent;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder underDeliveryTolerancePercent(@Nullable BigDecimal underDeliveryTolerancePercent) {
            this.underDeliveryTolerancePercent = underDeliveryTolerancePercent;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder productionInvtryManagedLoc(@Nullable String productionInvtryManagedLoc) {
            this.productionInvtryManagedLoc = productionInvtryManagedLoc;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder productionOrderBatchCode(@Nullable String productionOrderBatchCode) {
            this.productionOrderBatchCode = productionOrderBatchCode;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder prodIsWithdrawnFrmProdnBin(@Nullable Boolean prodIsWithdrawnFrmProdnBin) {
            this.prodIsWithdrawnFrmProdnBin = prodIsWithdrawnFrmProdnBin;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder transitionMatrixProductsGroup(@Nullable String transitionMatrixProductsGroup) {
            this.transitionMatrixProductsGroup = transitionMatrixProductsGroup;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder orderChangeManagementProfile(@Nullable String orderChangeManagementProfile) {
            this.orderChangeManagementProfile = orderChangeManagementProfile;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder productComponentBackflushCode(@Nullable String productComponentBackflushCode) {
            this.productComponentBackflushCode = productComponentBackflushCode;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder setupAndTeardownTime(@Nullable BigDecimal setupAndTeardownTime) {
            this.setupAndTeardownTime = setupAndTeardownTime;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder productionSchedulingProfile(@Nullable String productionSchedulingProfile) {
            this.productionSchedulingProfile = productionSchedulingProfile;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder transitionTime(@Nullable BigDecimal transitionTime) {
            this.transitionTime = transitionTime;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder processingTimeInDays(@Nullable BigDecimal processingTimeInDays) {
            this.processingTimeInDays = processingTimeInDays;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder productionSupervisor(@Nullable String productionSupervisor) {
            this.productionSupervisor = productionSupervisor;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder productProductionQuantityUnit(@Nullable String productProductionQuantityUnit) {
            this.productProductionQuantityUnit = productProductionQuantityUnit;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder prodProductionQuantityISOUnit(@Nullable String prodProductionQuantityISOUnit) {
            this.prodProductionQuantityISOUnit = prodProductionQuantityISOUnit;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder baseUnit(@Nullable String baseUnit) {
            this.baseUnit = baseUnit;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkSchedulingBuilder baseISOUnit(@Nullable String baseISOUnit) {
            this.baseISOUnit = baseISOUnit;
            return this;
        }

        @Nonnull
        @Generated
        public ProductPlantWorkScheduling build() {
            return new ProductPlantWorkScheduling(this.product, this.plant, this.productBaseQuantity, this.unlimitedOverDelivIsAllowed, this.overDeliveryTolerancePercent, this.underDeliveryTolerancePercent, this.productionInvtryManagedLoc, this.productionOrderBatchCode, this.prodIsWithdrawnFrmProdnBin, this.transitionMatrixProductsGroup, this.orderChangeManagementProfile, this.productComponentBackflushCode, this.setupAndTeardownTime, this.productionSchedulingProfile, this.transitionTime, this.processingTimeInDays, this.productionSupervisor, this.productProductionQuantityUnit, this.prodProductionQuantityISOUnit, this.baseUnit, this.baseISOUnit, this.to_Product, this.to_ProductPlant);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "ProductPlantWorkScheduling.ProductPlantWorkSchedulingBuilder(product=" + this.product + ", plant=" + this.plant + ", productBaseQuantity=" + this.productBaseQuantity + ", unlimitedOverDelivIsAllowed=" + this.unlimitedOverDelivIsAllowed + ", overDeliveryTolerancePercent=" + this.overDeliveryTolerancePercent + ", underDeliveryTolerancePercent=" + this.underDeliveryTolerancePercent + ", productionInvtryManagedLoc=" + this.productionInvtryManagedLoc + ", productionOrderBatchCode=" + this.productionOrderBatchCode + ", prodIsWithdrawnFrmProdnBin=" + this.prodIsWithdrawnFrmProdnBin + ", transitionMatrixProductsGroup=" + this.transitionMatrixProductsGroup + ", orderChangeManagementProfile=" + this.orderChangeManagementProfile + ", productComponentBackflushCode=" + this.productComponentBackflushCode + ", setupAndTeardownTime=" + this.setupAndTeardownTime + ", productionSchedulingProfile=" + this.productionSchedulingProfile + ", transitionTime=" + this.transitionTime + ", processingTimeInDays=" + this.processingTimeInDays + ", productionSupervisor=" + this.productionSupervisor + ", productProductionQuantityUnit=" + this.productProductionQuantityUnit + ", prodProductionQuantityISOUnit=" + this.prodProductionQuantityISOUnit + ", baseUnit=" + this.baseUnit + ", baseISOUnit=" + this.baseISOUnit + ", to_Product=" + (Object)((Object)this.to_Product) + ", to_ProductPlant=" + (Object)((Object)this.to_ProductPlant) + ")";
        }
    }
}

