/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product.ProductValuationAccounting;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product.ProductValuationCosting;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product.ProductValuationLedgerAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product.ProductValuationLedgerPrices;
import io.vavr.control.Option;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonAdapter(value=GsonVdmAdapterFactory.class)
@JsonSerialize(using=JacksonVdmObjectSerializer.class)
@JsonDeserialize(using=JacksonVdmObjectDeserializer.class)
public class ProductValuation
extends VdmEntity<ProductValuation>
implements VdmEntitySet {
    private final String odataType = "com.sap.gateway.srvd_a2x.api_product.v0001.ProductValuation_Type";
    public static final SimpleProperty<ProductValuation> ALL_FIELDS = ProductValuation.all();
    @Nullable
    @ElementName(value="Product")
    private String product;
    public static final SimpleProperty.String<ProductValuation> PRODUCT = new SimpleProperty.String(ProductValuation.class, "Product");
    @Nullable
    @ElementName(value="ValuationArea")
    private String valuationArea;
    public static final SimpleProperty.String<ProductValuation> VALUATION_AREA = new SimpleProperty.String(ProductValuation.class, "ValuationArea");
    @Nullable
    @ElementName(value="ValuationType")
    private String valuationType;
    public static final SimpleProperty.String<ProductValuation> VALUATION_TYPE = new SimpleProperty.String(ProductValuation.class, "ValuationType");
    @Nullable
    @ElementName(value="ValuationClass")
    private String valuationClass;
    public static final SimpleProperty.String<ProductValuation> VALUATION_CLASS = new SimpleProperty.String(ProductValuation.class, "ValuationClass");
    @Nullable
    @ElementName(value="PriceDeterminationControl")
    private String priceDeterminationControl;
    public static final SimpleProperty.String<ProductValuation> PRICE_DETERMINATION_CONTROL = new SimpleProperty.String(ProductValuation.class, "PriceDeterminationControl");
    @Nullable
    @ElementName(value="StandardPrice")
    @DecimalDescriptor(precision=11, scale=0)
    private BigDecimal standardPrice;
    public static final SimpleProperty.NumericDecimal<ProductValuation> STANDARD_PRICE = new SimpleProperty.NumericDecimal(ProductValuation.class, "StandardPrice");
    @Nullable
    @ElementName(value="ProductPriceUnitQuantity")
    @DecimalDescriptor(precision=5, scale=0)
    private BigDecimal productPriceUnitQuantity;
    public static final SimpleProperty.NumericDecimal<ProductValuation> PRODUCT_PRICE_UNIT_QUANTITY = new SimpleProperty.NumericDecimal(ProductValuation.class, "ProductPriceUnitQuantity");
    @Nullable
    @ElementName(value="InventoryValuationProcedure")
    private String inventoryValuationProcedure;
    public static final SimpleProperty.String<ProductValuation> INVENTORY_VALUATION_PROCEDURE = new SimpleProperty.String(ProductValuation.class, "InventoryValuationProcedure");
    @Nullable
    @ElementName(value="MovingAveragePrice")
    @DecimalDescriptor(precision=11, scale=0)
    private BigDecimal movingAveragePrice;
    public static final SimpleProperty.NumericDecimal<ProductValuation> MOVING_AVERAGE_PRICE = new SimpleProperty.NumericDecimal(ProductValuation.class, "MovingAveragePrice");
    @Nullable
    @ElementName(value="ValuationCategory")
    private String valuationCategory;
    public static final SimpleProperty.String<ProductValuation> VALUATION_CATEGORY = new SimpleProperty.String(ProductValuation.class, "ValuationCategory");
    @Nullable
    @ElementName(value="ProductUsageType")
    private String productUsageType;
    public static final SimpleProperty.String<ProductValuation> PRODUCT_USAGE_TYPE = new SimpleProperty.String(ProductValuation.class, "ProductUsageType");
    @Nullable
    @ElementName(value="ProductOriginType")
    private String productOriginType;
    public static final SimpleProperty.String<ProductValuation> PRODUCT_ORIGIN_TYPE = new SimpleProperty.String(ProductValuation.class, "ProductOriginType");
    @Nullable
    @ElementName(value="IsProducedInhouse")
    private Boolean isProducedInhouse;
    public static final SimpleProperty.Boolean<ProductValuation> IS_PRODUCED_INHOUSE = new SimpleProperty.Boolean(ProductValuation.class, "IsProducedInhouse");
    @Nullable
    @ElementName(value="IsMarkedForDeletion")
    private Boolean isMarkedForDeletion;
    public static final SimpleProperty.Boolean<ProductValuation> IS_MARKED_FOR_DELETION = new SimpleProperty.Boolean(ProductValuation.class, "IsMarkedForDeletion");
    @Nullable
    @ElementName(value="ValuationClassSalesOrderStock")
    private String valuationClassSalesOrderStock;
    public static final SimpleProperty.String<ProductValuation> VALUATION_CLASS_SALES_ORDER_STOCK = new SimpleProperty.String(ProductValuation.class, "ValuationClassSalesOrderStock");
    @Nullable
    @ElementName(value="ProjectStockValuationClass")
    private String projectStockValuationClass;
    public static final SimpleProperty.String<ProductValuation> PROJECT_STOCK_VALUATION_CLASS = new SimpleProperty.String(ProductValuation.class, "ProjectStockValuationClass");
    @Nullable
    @ElementName(value="Currency")
    private String currency;
    public static final SimpleProperty.String<ProductValuation> CURRENCY = new SimpleProperty.String(ProductValuation.class, "Currency");
    @Nullable
    @ElementName(value="BaseUnit")
    private String baseUnit;
    public static final SimpleProperty.String<ProductValuation> BASE_UNIT = new SimpleProperty.String(ProductValuation.class, "BaseUnit");
    @Nullable
    @ElementName(value="BaseISOUnit")
    private String baseISOUnit;
    public static final SimpleProperty.String<ProductValuation> BASE_ISO_UNIT = new SimpleProperty.String(ProductValuation.class, "BaseISOUnit");
    @ElementName(value="_Product")
    @Nullable
    private Product to_Product;
    @ElementName(value="_ProductValuationAccounting")
    @Nullable
    private ProductValuationAccounting to_ProductValuationAccounting;
    @ElementName(value="_ProductValuationCosting")
    @Nullable
    private ProductValuationCosting to_ProductValuationCosting;
    @ElementName(value="_ProductValuationLedgerAccount")
    private List<ProductValuationLedgerAccount> to_ProductValuationLedgerAccount;
    @ElementName(value="_ProductValuationLedgerPrices")
    private List<ProductValuationLedgerPrices> to_ProductValuationLedgerPrices;
    public static final NavigationProperty.Single<ProductValuation, Product> TO__PRODUCT = new NavigationProperty.Single(ProductValuation.class, "_Product", Product.class);
    public static final NavigationProperty.Single<ProductValuation, ProductValuationAccounting> TO__PRODUCT_VALUATION_ACCOUNTING = new NavigationProperty.Single(ProductValuation.class, "_ProductValuationAccounting", ProductValuationAccounting.class);
    public static final NavigationProperty.Single<ProductValuation, ProductValuationCosting> TO__PRODUCT_VALUATION_COSTING = new NavigationProperty.Single(ProductValuation.class, "_ProductValuationCosting", ProductValuationCosting.class);
    public static final NavigationProperty.Collection<ProductValuation, ProductValuationLedgerAccount> TO__PRODUCT_VALUATION_LEDGER_ACCOUNT = new NavigationProperty.Collection(ProductValuation.class, "_ProductValuationLedgerAccount", ProductValuationLedgerAccount.class);
    public static final NavigationProperty.Collection<ProductValuation, ProductValuationLedgerPrices> TO__PRODUCT_VALUATION_LEDGER_PRICES = new NavigationProperty.Collection(ProductValuation.class, "_ProductValuationLedgerPrices", ProductValuationLedgerPrices.class);

    @Nonnull
    public Class<ProductValuation> getType() {
        return ProductValuation.class;
    }

    public void setProduct(@Nullable String product) {
        this.rememberChangedField("Product", this.product);
        this.product = product;
    }

    public void setValuationArea(@Nullable String valuationArea) {
        this.rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    public void setValuationType(@Nullable String valuationType) {
        this.rememberChangedField("ValuationType", this.valuationType);
        this.valuationType = valuationType;
    }

    public void setValuationClass(@Nullable String valuationClass) {
        this.rememberChangedField("ValuationClass", this.valuationClass);
        this.valuationClass = valuationClass;
    }

    public void setPriceDeterminationControl(@Nullable String priceDeterminationControl) {
        this.rememberChangedField("PriceDeterminationControl", this.priceDeterminationControl);
        this.priceDeterminationControl = priceDeterminationControl;
    }

    public void setStandardPrice(@Nullable BigDecimal standardPrice) {
        this.rememberChangedField("StandardPrice", this.standardPrice);
        this.standardPrice = standardPrice;
    }

    public void setProductPriceUnitQuantity(@Nullable BigDecimal productPriceUnitQuantity) {
        this.rememberChangedField("ProductPriceUnitQuantity", this.productPriceUnitQuantity);
        this.productPriceUnitQuantity = productPriceUnitQuantity;
    }

    public void setInventoryValuationProcedure(@Nullable String inventoryValuationProcedure) {
        this.rememberChangedField("InventoryValuationProcedure", this.inventoryValuationProcedure);
        this.inventoryValuationProcedure = inventoryValuationProcedure;
    }

    public void setMovingAveragePrice(@Nullable BigDecimal movingAveragePrice) {
        this.rememberChangedField("MovingAveragePrice", this.movingAveragePrice);
        this.movingAveragePrice = movingAveragePrice;
    }

    public void setValuationCategory(@Nullable String valuationCategory) {
        this.rememberChangedField("ValuationCategory", this.valuationCategory);
        this.valuationCategory = valuationCategory;
    }

    public void setProductUsageType(@Nullable String productUsageType) {
        this.rememberChangedField("ProductUsageType", this.productUsageType);
        this.productUsageType = productUsageType;
    }

    public void setProductOriginType(@Nullable String productOriginType) {
        this.rememberChangedField("ProductOriginType", this.productOriginType);
        this.productOriginType = productOriginType;
    }

    public void setIsProducedInhouse(@Nullable Boolean isProducedInhouse) {
        this.rememberChangedField("IsProducedInhouse", this.isProducedInhouse);
        this.isProducedInhouse = isProducedInhouse;
    }

    public void setIsMarkedForDeletion(@Nullable Boolean isMarkedForDeletion) {
        this.rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    public void setValuationClassSalesOrderStock(@Nullable String valuationClassSalesOrderStock) {
        this.rememberChangedField("ValuationClassSalesOrderStock", this.valuationClassSalesOrderStock);
        this.valuationClassSalesOrderStock = valuationClassSalesOrderStock;
    }

    public void setProjectStockValuationClass(@Nullable String projectStockValuationClass) {
        this.rememberChangedField("ProjectStockValuationClass", this.projectStockValuationClass);
        this.projectStockValuationClass = projectStockValuationClass;
    }

    public void setCurrency(@Nullable String currency) {
        this.rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    public void setBaseUnit(@Nullable String baseUnit) {
        this.rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    public void setBaseISOUnit(@Nullable String baseISOUnit) {
        this.rememberChangedField("BaseISOUnit", this.baseISOUnit);
        this.baseISOUnit = baseISOUnit;
    }

    protected String getEntityCollection() {
        return "ProductValuation";
    }

    @Nonnull
    protected ODataEntityKey getKey() {
        ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("Product", (Object)this.getProduct());
        entityKey.addKeyProperty("ValuationArea", (Object)this.getValuationArea());
        entityKey.addKeyProperty("ValuationType", (Object)this.getValuationType());
        return entityKey;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("Product", this.getProduct());
        values.put("ValuationArea", this.getValuationArea());
        values.put("ValuationType", this.getValuationType());
        values.put("ValuationClass", this.getValuationClass());
        values.put("PriceDeterminationControl", this.getPriceDeterminationControl());
        values.put("StandardPrice", this.getStandardPrice());
        values.put("ProductPriceUnitQuantity", this.getProductPriceUnitQuantity());
        values.put("InventoryValuationProcedure", this.getInventoryValuationProcedure());
        values.put("MovingAveragePrice", this.getMovingAveragePrice());
        values.put("ValuationCategory", this.getValuationCategory());
        values.put("ProductUsageType", this.getProductUsageType());
        values.put("ProductOriginType", this.getProductOriginType());
        values.put("IsProducedInhouse", this.getIsProducedInhouse());
        values.put("IsMarkedForDeletion", this.getIsMarkedForDeletion());
        values.put("ValuationClassSalesOrderStock", this.getValuationClassSalesOrderStock());
        values.put("ProjectStockValuationClass", this.getProjectStockValuationClass());
        values.put("Currency", this.getCurrency());
        values.put("BaseUnit", this.getBaseUnit());
        values.put("BaseISOUnit", this.getBaseISOUnit());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Map inputMap;
        VdmEntity entity;
        Map inputMap2;
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("Product") && ((value = values.remove("Product")) == null || !value.equals(this.getProduct()))) {
            this.setProduct((String)value);
        }
        if (values.containsKey("ValuationArea") && ((value = values.remove("ValuationArea")) == null || !value.equals(this.getValuationArea()))) {
            this.setValuationArea((String)value);
        }
        if (values.containsKey("ValuationType") && ((value = values.remove("ValuationType")) == null || !value.equals(this.getValuationType()))) {
            this.setValuationType((String)value);
        }
        if (values.containsKey("ValuationClass") && ((value = values.remove("ValuationClass")) == null || !value.equals(this.getValuationClass()))) {
            this.setValuationClass((String)value);
        }
        if (values.containsKey("PriceDeterminationControl") && ((value = values.remove("PriceDeterminationControl")) == null || !value.equals(this.getPriceDeterminationControl()))) {
            this.setPriceDeterminationControl((String)value);
        }
        if (values.containsKey("StandardPrice") && ((value = values.remove("StandardPrice")) == null || !value.equals(this.getStandardPrice()))) {
            this.setStandardPrice((BigDecimal)value);
        }
        if (values.containsKey("ProductPriceUnitQuantity") && ((value = values.remove("ProductPriceUnitQuantity")) == null || !value.equals(this.getProductPriceUnitQuantity()))) {
            this.setProductPriceUnitQuantity((BigDecimal)value);
        }
        if (values.containsKey("InventoryValuationProcedure") && ((value = values.remove("InventoryValuationProcedure")) == null || !value.equals(this.getInventoryValuationProcedure()))) {
            this.setInventoryValuationProcedure((String)value);
        }
        if (values.containsKey("MovingAveragePrice") && ((value = values.remove("MovingAveragePrice")) == null || !value.equals(this.getMovingAveragePrice()))) {
            this.setMovingAveragePrice((BigDecimal)value);
        }
        if (values.containsKey("ValuationCategory") && ((value = values.remove("ValuationCategory")) == null || !value.equals(this.getValuationCategory()))) {
            this.setValuationCategory((String)value);
        }
        if (values.containsKey("ProductUsageType") && ((value = values.remove("ProductUsageType")) == null || !value.equals(this.getProductUsageType()))) {
            this.setProductUsageType((String)value);
        }
        if (values.containsKey("ProductOriginType") && ((value = values.remove("ProductOriginType")) == null || !value.equals(this.getProductOriginType()))) {
            this.setProductOriginType((String)value);
        }
        if (values.containsKey("IsProducedInhouse") && ((value = values.remove("IsProducedInhouse")) == null || !value.equals(this.getIsProducedInhouse()))) {
            this.setIsProducedInhouse((Boolean)value);
        }
        if (values.containsKey("IsMarkedForDeletion") && ((value = values.remove("IsMarkedForDeletion")) == null || !value.equals(this.getIsMarkedForDeletion()))) {
            this.setIsMarkedForDeletion((Boolean)value);
        }
        if (values.containsKey("ValuationClassSalesOrderStock") && ((value = values.remove("ValuationClassSalesOrderStock")) == null || !value.equals(this.getValuationClassSalesOrderStock()))) {
            this.setValuationClassSalesOrderStock((String)value);
        }
        if (values.containsKey("ProjectStockValuationClass") && ((value = values.remove("ProjectStockValuationClass")) == null || !value.equals(this.getProjectStockValuationClass()))) {
            this.setProjectStockValuationClass((String)value);
        }
        if (values.containsKey("Currency") && ((value = values.remove("Currency")) == null || !value.equals(this.getCurrency()))) {
            this.setCurrency((String)value);
        }
        if (values.containsKey("BaseUnit") && ((value = values.remove("BaseUnit")) == null || !value.equals(this.getBaseUnit()))) {
            this.setBaseUnit((String)value);
        }
        if (values.containsKey("BaseISOUnit") && ((value = values.remove("BaseISOUnit")) == null || !value.equals(this.getBaseISOUnit()))) {
            this.setBaseISOUnit((String)value);
        }
        if (values.containsKey("_Product") && (value = values.remove("_Product")) instanceof Map) {
            if (this.to_Product == null) {
                this.to_Product = new Product();
            }
            inputMap2 = (Map)value;
            this.to_Product.fromMap(inputMap2);
        }
        if (values.containsKey("_ProductValuationAccounting") && (value = values.remove("_ProductValuationAccounting")) instanceof Map) {
            if (this.to_ProductValuationAccounting == null) {
                this.to_ProductValuationAccounting = new ProductValuationAccounting();
            }
            inputMap2 = (Map)value;
            this.to_ProductValuationAccounting.fromMap(inputMap2);
        }
        if (values.containsKey("_ProductValuationCosting") && (value = values.remove("_ProductValuationCosting")) instanceof Map) {
            if (this.to_ProductValuationCosting == null) {
                this.to_ProductValuationCosting = new ProductValuationCosting();
            }
            inputMap2 = (Map)value;
            this.to_ProductValuationCosting.fromMap(inputMap2);
        }
        if (values.containsKey("_ProductValuationLedgerAccount") && (value = values.remove("_ProductValuationLedgerAccount")) instanceof Iterable) {
            this.to_ProductValuationLedgerAccount = this.to_ProductValuationLedgerAccount == null ? Lists.newArrayList() : Lists.newArrayList(this.to_ProductValuationLedgerAccount);
            int i = 0;
            for (Object item : (Iterable)value) {
                if (!(item instanceof Map)) continue;
                if (this.to_ProductValuationLedgerAccount.size() > i) {
                    entity = this.to_ProductValuationLedgerAccount.get(i);
                } else {
                    entity = new ProductValuationLedgerAccount();
                    this.to_ProductValuationLedgerAccount.add((ProductValuationLedgerAccount)entity);
                }
                ++i;
                inputMap = (Map)item;
                entity.fromMap(inputMap);
            }
        }
        if (values.containsKey("_ProductValuationLedgerPrices") && (value = values.remove("_ProductValuationLedgerPrices")) instanceof Iterable) {
            this.to_ProductValuationLedgerPrices = this.to_ProductValuationLedgerPrices == null ? Lists.newArrayList() : Lists.newArrayList(this.to_ProductValuationLedgerPrices);
            int i = 0;
            for (Object item : (Iterable)value) {
                if (!(item instanceof Map)) continue;
                if (this.to_ProductValuationLedgerPrices.size() > i) {
                    entity = this.to_ProductValuationLedgerPrices.get(i);
                } else {
                    entity = new ProductValuationLedgerPrices();
                    this.to_ProductValuationLedgerPrices.add((ProductValuationLedgerPrices)entity);
                }
                ++i;
                inputMap = (Map)item;
                entity.fromMap(inputMap);
            }
        }
        super.fromMap((Map)values);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata4/sap/api_product/srvd_a2x/sap/product/0001";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.to_Product != null) {
            values.put("_Product", this.to_Product);
        }
        if (this.to_ProductValuationAccounting != null) {
            values.put("_ProductValuationAccounting", this.to_ProductValuationAccounting);
        }
        if (this.to_ProductValuationCosting != null) {
            values.put("_ProductValuationCosting", this.to_ProductValuationCosting);
        }
        if (this.to_ProductValuationLedgerAccount != null) {
            values.put("_ProductValuationLedgerAccount", this.to_ProductValuationLedgerAccount);
        }
        if (this.to_ProductValuationLedgerPrices != null) {
            values.put("_ProductValuationLedgerPrices", this.to_ProductValuationLedgerPrices);
        }
        return values;
    }

    @Nonnull
    public Option<Product> getProductIfPresent() {
        return Option.of((Object)((Object)this.to_Product));
    }

    public void setProduct(Product value) {
        this.to_Product = value;
    }

    @Nonnull
    public Option<ProductValuationAccounting> getProductValuationAccountingIfPresent() {
        return Option.of((Object)((Object)this.to_ProductValuationAccounting));
    }

    public void setProductValuationAccounting(ProductValuationAccounting value) {
        this.to_ProductValuationAccounting = value;
    }

    @Nonnull
    public Option<ProductValuationCosting> getProductValuationCostingIfPresent() {
        return Option.of((Object)((Object)this.to_ProductValuationCosting));
    }

    public void setProductValuationCosting(ProductValuationCosting value) {
        this.to_ProductValuationCosting = value;
    }

    @Nonnull
    public Option<List<ProductValuationLedgerAccount>> getProductValuationLedgerAccountIfPresent() {
        return Option.of(this.to_ProductValuationLedgerAccount);
    }

    public void setProductValuationLedgerAccount(@Nonnull List<ProductValuationLedgerAccount> value) {
        if (this.to_ProductValuationLedgerAccount == null) {
            this.to_ProductValuationLedgerAccount = Lists.newArrayList();
        }
        this.to_ProductValuationLedgerAccount.clear();
        this.to_ProductValuationLedgerAccount.addAll(value);
    }

    public void addProductValuationLedgerAccount(ProductValuationLedgerAccount ... entity) {
        if (this.to_ProductValuationLedgerAccount == null) {
            this.to_ProductValuationLedgerAccount = Lists.newArrayList();
        }
        this.to_ProductValuationLedgerAccount.addAll(Lists.newArrayList((Object[])entity));
    }

    @Nonnull
    public Option<List<ProductValuationLedgerPrices>> getProductValuationLedgerPricesIfPresent() {
        return Option.of(this.to_ProductValuationLedgerPrices);
    }

    public void setProductValuationLedgerPrices(@Nonnull List<ProductValuationLedgerPrices> value) {
        if (this.to_ProductValuationLedgerPrices == null) {
            this.to_ProductValuationLedgerPrices = Lists.newArrayList();
        }
        this.to_ProductValuationLedgerPrices.clear();
        this.to_ProductValuationLedgerPrices.addAll(value);
    }

    public void addProductValuationLedgerPrices(ProductValuationLedgerPrices ... entity) {
        if (this.to_ProductValuationLedgerPrices == null) {
            this.to_ProductValuationLedgerPrices = Lists.newArrayList();
        }
        this.to_ProductValuationLedgerPrices.addAll(Lists.newArrayList((Object[])entity));
    }

    @Nonnull
    @Generated
    public static ProductValuationBuilder builder() {
        return new ProductValuationBuilder();
    }

    @Nullable
    @Generated
    public String getProduct() {
        return this.product;
    }

    @Nullable
    @Generated
    public String getValuationArea() {
        return this.valuationArea;
    }

    @Nullable
    @Generated
    public String getValuationType() {
        return this.valuationType;
    }

    @Nullable
    @Generated
    public String getValuationClass() {
        return this.valuationClass;
    }

    @Nullable
    @Generated
    public String getPriceDeterminationControl() {
        return this.priceDeterminationControl;
    }

    @Nullable
    @Generated
    public BigDecimal getStandardPrice() {
        return this.standardPrice;
    }

    @Nullable
    @Generated
    public BigDecimal getProductPriceUnitQuantity() {
        return this.productPriceUnitQuantity;
    }

    @Nullable
    @Generated
    public String getInventoryValuationProcedure() {
        return this.inventoryValuationProcedure;
    }

    @Nullable
    @Generated
    public BigDecimal getMovingAveragePrice() {
        return this.movingAveragePrice;
    }

    @Nullable
    @Generated
    public String getValuationCategory() {
        return this.valuationCategory;
    }

    @Nullable
    @Generated
    public String getProductUsageType() {
        return this.productUsageType;
    }

    @Nullable
    @Generated
    public String getProductOriginType() {
        return this.productOriginType;
    }

    @Nullable
    @Generated
    public Boolean getIsProducedInhouse() {
        return this.isProducedInhouse;
    }

    @Nullable
    @Generated
    public Boolean getIsMarkedForDeletion() {
        return this.isMarkedForDeletion;
    }

    @Nullable
    @Generated
    public String getValuationClassSalesOrderStock() {
        return this.valuationClassSalesOrderStock;
    }

    @Nullable
    @Generated
    public String getProjectStockValuationClass() {
        return this.projectStockValuationClass;
    }

    @Nullable
    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Nullable
    @Generated
    public String getBaseUnit() {
        return this.baseUnit;
    }

    @Nullable
    @Generated
    public String getBaseISOUnit() {
        return this.baseISOUnit;
    }

    @Generated
    public ProductValuation() {
    }

    @Generated
    public ProductValuation(@Nullable String product, @Nullable String valuationArea, @Nullable String valuationType, @Nullable String valuationClass, @Nullable String priceDeterminationControl, @Nullable BigDecimal standardPrice, @Nullable BigDecimal productPriceUnitQuantity, @Nullable String inventoryValuationProcedure, @Nullable BigDecimal movingAveragePrice, @Nullable String valuationCategory, @Nullable String productUsageType, @Nullable String productOriginType, @Nullable Boolean isProducedInhouse, @Nullable Boolean isMarkedForDeletion, @Nullable String valuationClassSalesOrderStock, @Nullable String projectStockValuationClass, @Nullable String currency, @Nullable String baseUnit, @Nullable String baseISOUnit, @Nullable Product to_Product, @Nullable ProductValuationAccounting to_ProductValuationAccounting, @Nullable ProductValuationCosting to_ProductValuationCosting, List<ProductValuationLedgerAccount> to_ProductValuationLedgerAccount, List<ProductValuationLedgerPrices> to_ProductValuationLedgerPrices) {
        this.product = product;
        this.valuationArea = valuationArea;
        this.valuationType = valuationType;
        this.valuationClass = valuationClass;
        this.priceDeterminationControl = priceDeterminationControl;
        this.standardPrice = standardPrice;
        this.productPriceUnitQuantity = productPriceUnitQuantity;
        this.inventoryValuationProcedure = inventoryValuationProcedure;
        this.movingAveragePrice = movingAveragePrice;
        this.valuationCategory = valuationCategory;
        this.productUsageType = productUsageType;
        this.productOriginType = productOriginType;
        this.isProducedInhouse = isProducedInhouse;
        this.isMarkedForDeletion = isMarkedForDeletion;
        this.valuationClassSalesOrderStock = valuationClassSalesOrderStock;
        this.projectStockValuationClass = projectStockValuationClass;
        this.currency = currency;
        this.baseUnit = baseUnit;
        this.baseISOUnit = baseISOUnit;
        this.to_Product = to_Product;
        this.to_ProductValuationAccounting = to_ProductValuationAccounting;
        this.to_ProductValuationCosting = to_ProductValuationCosting;
        this.to_ProductValuationLedgerAccount = to_ProductValuationLedgerAccount;
        this.to_ProductValuationLedgerPrices = to_ProductValuationLedgerPrices;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "ProductValuation(super=" + super.toString() + ", odataType=" + this.odataType + ", product=" + this.product + ", valuationArea=" + this.valuationArea + ", valuationType=" + this.valuationType + ", valuationClass=" + this.valuationClass + ", priceDeterminationControl=" + this.priceDeterminationControl + ", standardPrice=" + this.standardPrice + ", productPriceUnitQuantity=" + this.productPriceUnitQuantity + ", inventoryValuationProcedure=" + this.inventoryValuationProcedure + ", movingAveragePrice=" + this.movingAveragePrice + ", valuationCategory=" + this.valuationCategory + ", productUsageType=" + this.productUsageType + ", productOriginType=" + this.productOriginType + ", isProducedInhouse=" + this.isProducedInhouse + ", isMarkedForDeletion=" + this.isMarkedForDeletion + ", valuationClassSalesOrderStock=" + this.valuationClassSalesOrderStock + ", projectStockValuationClass=" + this.projectStockValuationClass + ", currency=" + this.currency + ", baseUnit=" + this.baseUnit + ", baseISOUnit=" + this.baseISOUnit + ", to_Product=" + (Object)((Object)this.to_Product) + ", to_ProductValuationAccounting=" + (Object)((Object)this.to_ProductValuationAccounting) + ", to_ProductValuationCosting=" + (Object)((Object)this.to_ProductValuationCosting) + ", to_ProductValuationLedgerAccount=" + this.to_ProductValuationLedgerAccount + ", to_ProductValuationLedgerPrices=" + this.to_ProductValuationLedgerPrices + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductValuation)) {
            return false;
        }
        ProductValuation other = (ProductValuation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isProducedInhouse = this.isProducedInhouse;
        Boolean other$isProducedInhouse = other.isProducedInhouse;
        if (this$isProducedInhouse == null ? other$isProducedInhouse != null : !((Object)this$isProducedInhouse).equals(other$isProducedInhouse)) {
            return false;
        }
        Boolean this$isMarkedForDeletion = this.isMarkedForDeletion;
        Boolean other$isMarkedForDeletion = other.isMarkedForDeletion;
        if (this$isMarkedForDeletion == null ? other$isMarkedForDeletion != null : !((Object)this$isMarkedForDeletion).equals(other$isMarkedForDeletion)) {
            return false;
        }
        String this$odataType = this.odataType;
        String other$odataType = other.odataType;
        if (this$odataType == null ? other$odataType != null : !this$odataType.equals(other$odataType)) {
            return false;
        }
        String this$product = this.product;
        String other$product = other.product;
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        String this$valuationArea = this.valuationArea;
        String other$valuationArea = other.valuationArea;
        if (this$valuationArea == null ? other$valuationArea != null : !this$valuationArea.equals(other$valuationArea)) {
            return false;
        }
        String this$valuationType = this.valuationType;
        String other$valuationType = other.valuationType;
        if (this$valuationType == null ? other$valuationType != null : !this$valuationType.equals(other$valuationType)) {
            return false;
        }
        String this$valuationClass = this.valuationClass;
        String other$valuationClass = other.valuationClass;
        if (this$valuationClass == null ? other$valuationClass != null : !this$valuationClass.equals(other$valuationClass)) {
            return false;
        }
        String this$priceDeterminationControl = this.priceDeterminationControl;
        String other$priceDeterminationControl = other.priceDeterminationControl;
        if (this$priceDeterminationControl == null ? other$priceDeterminationControl != null : !this$priceDeterminationControl.equals(other$priceDeterminationControl)) {
            return false;
        }
        BigDecimal this$standardPrice = this.standardPrice;
        BigDecimal other$standardPrice = other.standardPrice;
        if (this$standardPrice == null ? other$standardPrice != null : !((Object)this$standardPrice).equals(other$standardPrice)) {
            return false;
        }
        BigDecimal this$productPriceUnitQuantity = this.productPriceUnitQuantity;
        BigDecimal other$productPriceUnitQuantity = other.productPriceUnitQuantity;
        if (this$productPriceUnitQuantity == null ? other$productPriceUnitQuantity != null : !((Object)this$productPriceUnitQuantity).equals(other$productPriceUnitQuantity)) {
            return false;
        }
        String this$inventoryValuationProcedure = this.inventoryValuationProcedure;
        String other$inventoryValuationProcedure = other.inventoryValuationProcedure;
        if (this$inventoryValuationProcedure == null ? other$inventoryValuationProcedure != null : !this$inventoryValuationProcedure.equals(other$inventoryValuationProcedure)) {
            return false;
        }
        BigDecimal this$movingAveragePrice = this.movingAveragePrice;
        BigDecimal other$movingAveragePrice = other.movingAveragePrice;
        if (this$movingAveragePrice == null ? other$movingAveragePrice != null : !((Object)this$movingAveragePrice).equals(other$movingAveragePrice)) {
            return false;
        }
        String this$valuationCategory = this.valuationCategory;
        String other$valuationCategory = other.valuationCategory;
        if (this$valuationCategory == null ? other$valuationCategory != null : !this$valuationCategory.equals(other$valuationCategory)) {
            return false;
        }
        String this$productUsageType = this.productUsageType;
        String other$productUsageType = other.productUsageType;
        if (this$productUsageType == null ? other$productUsageType != null : !this$productUsageType.equals(other$productUsageType)) {
            return false;
        }
        String this$productOriginType = this.productOriginType;
        String other$productOriginType = other.productOriginType;
        if (this$productOriginType == null ? other$productOriginType != null : !this$productOriginType.equals(other$productOriginType)) {
            return false;
        }
        String this$valuationClassSalesOrderStock = this.valuationClassSalesOrderStock;
        String other$valuationClassSalesOrderStock = other.valuationClassSalesOrderStock;
        if (this$valuationClassSalesOrderStock == null ? other$valuationClassSalesOrderStock != null : !this$valuationClassSalesOrderStock.equals(other$valuationClassSalesOrderStock)) {
            return false;
        }
        String this$projectStockValuationClass = this.projectStockValuationClass;
        String other$projectStockValuationClass = other.projectStockValuationClass;
        if (this$projectStockValuationClass == null ? other$projectStockValuationClass != null : !this$projectStockValuationClass.equals(other$projectStockValuationClass)) {
            return false;
        }
        String this$currency = this.currency;
        String other$currency = other.currency;
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$baseUnit = this.baseUnit;
        String other$baseUnit = other.baseUnit;
        if (this$baseUnit == null ? other$baseUnit != null : !this$baseUnit.equals(other$baseUnit)) {
            return false;
        }
        String this$baseISOUnit = this.baseISOUnit;
        String other$baseISOUnit = other.baseISOUnit;
        if (this$baseISOUnit == null ? other$baseISOUnit != null : !this$baseISOUnit.equals(other$baseISOUnit)) {
            return false;
        }
        Product this$to_Product = this.to_Product;
        Product other$to_Product = other.to_Product;
        if (this$to_Product == null ? other$to_Product != null : !((Object)((Object)this$to_Product)).equals((Object)other$to_Product)) {
            return false;
        }
        ProductValuationAccounting this$to_ProductValuationAccounting = this.to_ProductValuationAccounting;
        ProductValuationAccounting other$to_ProductValuationAccounting = other.to_ProductValuationAccounting;
        if (this$to_ProductValuationAccounting == null ? other$to_ProductValuationAccounting != null : !((Object)((Object)this$to_ProductValuationAccounting)).equals((Object)other$to_ProductValuationAccounting)) {
            return false;
        }
        ProductValuationCosting this$to_ProductValuationCosting = this.to_ProductValuationCosting;
        ProductValuationCosting other$to_ProductValuationCosting = other.to_ProductValuationCosting;
        if (this$to_ProductValuationCosting == null ? other$to_ProductValuationCosting != null : !((Object)((Object)this$to_ProductValuationCosting)).equals((Object)other$to_ProductValuationCosting)) {
            return false;
        }
        List<ProductValuationLedgerAccount> this$to_ProductValuationLedgerAccount = this.to_ProductValuationLedgerAccount;
        List<ProductValuationLedgerAccount> other$to_ProductValuationLedgerAccount = other.to_ProductValuationLedgerAccount;
        if (this$to_ProductValuationLedgerAccount == null ? other$to_ProductValuationLedgerAccount != null : !((Object)this$to_ProductValuationLedgerAccount).equals(other$to_ProductValuationLedgerAccount)) {
            return false;
        }
        List<ProductValuationLedgerPrices> this$to_ProductValuationLedgerPrices = this.to_ProductValuationLedgerPrices;
        List<ProductValuationLedgerPrices> other$to_ProductValuationLedgerPrices = other.to_ProductValuationLedgerPrices;
        return !(this$to_ProductValuationLedgerPrices == null ? other$to_ProductValuationLedgerPrices != null : !((Object)this$to_ProductValuationLedgerPrices).equals(other$to_ProductValuationLedgerPrices));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ProductValuation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isProducedInhouse = this.isProducedInhouse;
        result = result * 59 + ($isProducedInhouse == null ? 43 : ((Object)$isProducedInhouse).hashCode());
        Boolean $isMarkedForDeletion = this.isMarkedForDeletion;
        result = result * 59 + ($isMarkedForDeletion == null ? 43 : ((Object)$isMarkedForDeletion).hashCode());
        String $odataType = this.odataType;
        result = result * 59 + ($odataType == null ? 43 : $odataType.hashCode());
        String $product = this.product;
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        String $valuationArea = this.valuationArea;
        result = result * 59 + ($valuationArea == null ? 43 : $valuationArea.hashCode());
        String $valuationType = this.valuationType;
        result = result * 59 + ($valuationType == null ? 43 : $valuationType.hashCode());
        String $valuationClass = this.valuationClass;
        result = result * 59 + ($valuationClass == null ? 43 : $valuationClass.hashCode());
        String $priceDeterminationControl = this.priceDeterminationControl;
        result = result * 59 + ($priceDeterminationControl == null ? 43 : $priceDeterminationControl.hashCode());
        BigDecimal $standardPrice = this.standardPrice;
        result = result * 59 + ($standardPrice == null ? 43 : ((Object)$standardPrice).hashCode());
        BigDecimal $productPriceUnitQuantity = this.productPriceUnitQuantity;
        result = result * 59 + ($productPriceUnitQuantity == null ? 43 : ((Object)$productPriceUnitQuantity).hashCode());
        String $inventoryValuationProcedure = this.inventoryValuationProcedure;
        result = result * 59 + ($inventoryValuationProcedure == null ? 43 : $inventoryValuationProcedure.hashCode());
        BigDecimal $movingAveragePrice = this.movingAveragePrice;
        result = result * 59 + ($movingAveragePrice == null ? 43 : ((Object)$movingAveragePrice).hashCode());
        String $valuationCategory = this.valuationCategory;
        result = result * 59 + ($valuationCategory == null ? 43 : $valuationCategory.hashCode());
        String $productUsageType = this.productUsageType;
        result = result * 59 + ($productUsageType == null ? 43 : $productUsageType.hashCode());
        String $productOriginType = this.productOriginType;
        result = result * 59 + ($productOriginType == null ? 43 : $productOriginType.hashCode());
        String $valuationClassSalesOrderStock = this.valuationClassSalesOrderStock;
        result = result * 59 + ($valuationClassSalesOrderStock == null ? 43 : $valuationClassSalesOrderStock.hashCode());
        String $projectStockValuationClass = this.projectStockValuationClass;
        result = result * 59 + ($projectStockValuationClass == null ? 43 : $projectStockValuationClass.hashCode());
        String $currency = this.currency;
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $baseUnit = this.baseUnit;
        result = result * 59 + ($baseUnit == null ? 43 : $baseUnit.hashCode());
        String $baseISOUnit = this.baseISOUnit;
        result = result * 59 + ($baseISOUnit == null ? 43 : $baseISOUnit.hashCode());
        Product $to_Product = this.to_Product;
        result = result * 59 + ($to_Product == null ? 43 : ((Object)((Object)$to_Product)).hashCode());
        ProductValuationAccounting $to_ProductValuationAccounting = this.to_ProductValuationAccounting;
        result = result * 59 + ($to_ProductValuationAccounting == null ? 43 : ((Object)((Object)$to_ProductValuationAccounting)).hashCode());
        ProductValuationCosting $to_ProductValuationCosting = this.to_ProductValuationCosting;
        result = result * 59 + ($to_ProductValuationCosting == null ? 43 : ((Object)((Object)$to_ProductValuationCosting)).hashCode());
        List<ProductValuationLedgerAccount> $to_ProductValuationLedgerAccount = this.to_ProductValuationLedgerAccount;
        result = result * 59 + ($to_ProductValuationLedgerAccount == null ? 43 : ((Object)$to_ProductValuationLedgerAccount).hashCode());
        List<ProductValuationLedgerPrices> $to_ProductValuationLedgerPrices = this.to_ProductValuationLedgerPrices;
        result = result * 59 + ($to_ProductValuationLedgerPrices == null ? 43 : ((Object)$to_ProductValuationLedgerPrices).hashCode());
        return result;
    }

    @Generated
    public String getOdataType() {
        return this.odataType;
    }

    public static final class ProductValuationBuilder {
        @Generated
        private String valuationArea;
        @Generated
        private String valuationType;
        @Generated
        private String valuationClass;
        @Generated
        private String priceDeterminationControl;
        @Generated
        private BigDecimal standardPrice;
        @Generated
        private BigDecimal productPriceUnitQuantity;
        @Generated
        private String inventoryValuationProcedure;
        @Generated
        private BigDecimal movingAveragePrice;
        @Generated
        private String valuationCategory;
        @Generated
        private String productUsageType;
        @Generated
        private String productOriginType;
        @Generated
        private Boolean isProducedInhouse;
        @Generated
        private Boolean isMarkedForDeletion;
        @Generated
        private String valuationClassSalesOrderStock;
        @Generated
        private String projectStockValuationClass;
        @Generated
        private String currency;
        @Generated
        private String baseUnit;
        @Generated
        private String baseISOUnit;
        private Product to_Product;
        private String product = null;
        private ProductValuationAccounting to_ProductValuationAccounting;
        private ProductValuationCosting to_ProductValuationCosting;
        private List<ProductValuationLedgerAccount> to_ProductValuationLedgerAccount = Lists.newArrayList();
        private List<ProductValuationLedgerPrices> to_ProductValuationLedgerPrices = Lists.newArrayList();

        private ProductValuationBuilder to_Product(Product value) {
            this.to_Product = value;
            return this;
        }

        @Nonnull
        public ProductValuationBuilder product(Product value) {
            return this.to_Product(value);
        }

        @Nonnull
        public ProductValuationBuilder product(String value) {
            this.product = value;
            return this;
        }

        private ProductValuationBuilder to_ProductValuationAccounting(ProductValuationAccounting value) {
            this.to_ProductValuationAccounting = value;
            return this;
        }

        @Nonnull
        public ProductValuationBuilder productValuationAccounting(ProductValuationAccounting value) {
            return this.to_ProductValuationAccounting(value);
        }

        private ProductValuationBuilder to_ProductValuationCosting(ProductValuationCosting value) {
            this.to_ProductValuationCosting = value;
            return this;
        }

        @Nonnull
        public ProductValuationBuilder productValuationCosting(ProductValuationCosting value) {
            return this.to_ProductValuationCosting(value);
        }

        private ProductValuationBuilder to_ProductValuationLedgerAccount(List<ProductValuationLedgerAccount> value) {
            this.to_ProductValuationLedgerAccount.addAll(value);
            return this;
        }

        @Nonnull
        public ProductValuationBuilder productValuationLedgerAccount(ProductValuationLedgerAccount ... value) {
            return this.to_ProductValuationLedgerAccount(Lists.newArrayList((Object[])value));
        }

        private ProductValuationBuilder to_ProductValuationLedgerPrices(List<ProductValuationLedgerPrices> value) {
            this.to_ProductValuationLedgerPrices.addAll(value);
            return this;
        }

        @Nonnull
        public ProductValuationBuilder productValuationLedgerPrices(ProductValuationLedgerPrices ... value) {
            return this.to_ProductValuationLedgerPrices(Lists.newArrayList((Object[])value));
        }

        @Generated
        ProductValuationBuilder() {
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder valuationArea(@Nullable String valuationArea) {
            this.valuationArea = valuationArea;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder valuationType(@Nullable String valuationType) {
            this.valuationType = valuationType;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder valuationClass(@Nullable String valuationClass) {
            this.valuationClass = valuationClass;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder priceDeterminationControl(@Nullable String priceDeterminationControl) {
            this.priceDeterminationControl = priceDeterminationControl;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder standardPrice(@Nullable BigDecimal standardPrice) {
            this.standardPrice = standardPrice;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder productPriceUnitQuantity(@Nullable BigDecimal productPriceUnitQuantity) {
            this.productPriceUnitQuantity = productPriceUnitQuantity;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder inventoryValuationProcedure(@Nullable String inventoryValuationProcedure) {
            this.inventoryValuationProcedure = inventoryValuationProcedure;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder movingAveragePrice(@Nullable BigDecimal movingAveragePrice) {
            this.movingAveragePrice = movingAveragePrice;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder valuationCategory(@Nullable String valuationCategory) {
            this.valuationCategory = valuationCategory;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder productUsageType(@Nullable String productUsageType) {
            this.productUsageType = productUsageType;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder productOriginType(@Nullable String productOriginType) {
            this.productOriginType = productOriginType;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder isProducedInhouse(@Nullable Boolean isProducedInhouse) {
            this.isProducedInhouse = isProducedInhouse;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder isMarkedForDeletion(@Nullable Boolean isMarkedForDeletion) {
            this.isMarkedForDeletion = isMarkedForDeletion;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder valuationClassSalesOrderStock(@Nullable String valuationClassSalesOrderStock) {
            this.valuationClassSalesOrderStock = valuationClassSalesOrderStock;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder projectStockValuationClass(@Nullable String projectStockValuationClass) {
            this.projectStockValuationClass = projectStockValuationClass;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder currency(@Nullable String currency) {
            this.currency = currency;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder baseUnit(@Nullable String baseUnit) {
            this.baseUnit = baseUnit;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationBuilder baseISOUnit(@Nullable String baseISOUnit) {
            this.baseISOUnit = baseISOUnit;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuation build() {
            return new ProductValuation(this.product, this.valuationArea, this.valuationType, this.valuationClass, this.priceDeterminationControl, this.standardPrice, this.productPriceUnitQuantity, this.inventoryValuationProcedure, this.movingAveragePrice, this.valuationCategory, this.productUsageType, this.productOriginType, this.isProducedInhouse, this.isMarkedForDeletion, this.valuationClassSalesOrderStock, this.projectStockValuationClass, this.currency, this.baseUnit, this.baseISOUnit, this.to_Product, this.to_ProductValuationAccounting, this.to_ProductValuationCosting, this.to_ProductValuationLedgerAccount, this.to_ProductValuationLedgerPrices);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "ProductValuation.ProductValuationBuilder(product=" + this.product + ", valuationArea=" + this.valuationArea + ", valuationType=" + this.valuationType + ", valuationClass=" + this.valuationClass + ", priceDeterminationControl=" + this.priceDeterminationControl + ", standardPrice=" + this.standardPrice + ", productPriceUnitQuantity=" + this.productPriceUnitQuantity + ", inventoryValuationProcedure=" + this.inventoryValuationProcedure + ", movingAveragePrice=" + this.movingAveragePrice + ", valuationCategory=" + this.valuationCategory + ", productUsageType=" + this.productUsageType + ", productOriginType=" + this.productOriginType + ", isProducedInhouse=" + this.isProducedInhouse + ", isMarkedForDeletion=" + this.isMarkedForDeletion + ", valuationClassSalesOrderStock=" + this.valuationClassSalesOrderStock + ", projectStockValuationClass=" + this.projectStockValuationClass + ", currency=" + this.currency + ", baseUnit=" + this.baseUnit + ", baseISOUnit=" + this.baseISOUnit + ", to_Product=" + (Object)((Object)this.to_Product) + ", to_ProductValuationAccounting=" + (Object)((Object)this.to_ProductValuationAccounting) + ", to_ProductValuationCosting=" + (Object)((Object)this.to_ProductValuationCosting) + ", to_ProductValuationLedgerAccount=" + this.to_ProductValuationLedgerAccount + ", to_ProductValuationLedgerPrices=" + this.to_ProductValuationLedgerPrices + ")";
        }
    }
}

