/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.product.ProductValuation;
import io.vavr.control.Option;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonAdapter(value=GsonVdmAdapterFactory.class)
@JsonSerialize(using=JacksonVdmObjectSerializer.class)
@JsonDeserialize(using=JacksonVdmObjectDeserializer.class)
public class ProductValuationAccounting
extends VdmEntity<ProductValuationAccounting>
implements VdmEntitySet {
    private final String odataType = "com.sap.gateway.srvd_a2x.api_product.v0001.ProductValuationAccounting_Type";
    public static final SimpleProperty<ProductValuationAccounting> ALL_FIELDS = ProductValuationAccounting.all();
    @Nullable
    @ElementName(value="Product")
    private String product;
    public static final SimpleProperty.String<ProductValuationAccounting> PRODUCT = new SimpleProperty.String(ProductValuationAccounting.class, "Product");
    @Nullable
    @ElementName(value="ValuationArea")
    private String valuationArea;
    public static final SimpleProperty.String<ProductValuationAccounting> VALUATION_AREA = new SimpleProperty.String(ProductValuationAccounting.class, "ValuationArea");
    @Nullable
    @ElementName(value="ValuationType")
    private String valuationType;
    public static final SimpleProperty.String<ProductValuationAccounting> VALUATION_TYPE = new SimpleProperty.String(ProductValuationAccounting.class, "ValuationType");
    @Nullable
    @ElementName(value="CommercialPrice1InCoCodeCrcy")
    @DecimalDescriptor(precision=11, scale=0)
    private BigDecimal commercialPrice1InCoCodeCrcy;
    public static final SimpleProperty.NumericDecimal<ProductValuationAccounting> COMMERCIAL_PRICE1_IN_CO_CODE_CRCY = new SimpleProperty.NumericDecimal(ProductValuationAccounting.class, "CommercialPrice1InCoCodeCrcy");
    @Nullable
    @ElementName(value="CommercialPrice2InCoCodeCrcy")
    @DecimalDescriptor(precision=11, scale=0)
    private BigDecimal commercialPrice2InCoCodeCrcy;
    public static final SimpleProperty.NumericDecimal<ProductValuationAccounting> COMMERCIAL_PRICE2_IN_CO_CODE_CRCY = new SimpleProperty.NumericDecimal(ProductValuationAccounting.class, "CommercialPrice2InCoCodeCrcy");
    @Nullable
    @ElementName(value="CommercialPrice3InCoCodeCrcy")
    @DecimalDescriptor(precision=11, scale=0)
    private BigDecimal commercialPrice3InCoCodeCrcy;
    public static final SimpleProperty.NumericDecimal<ProductValuationAccounting> COMMERCIAL_PRICE3_IN_CO_CODE_CRCY = new SimpleProperty.NumericDecimal(ProductValuationAccounting.class, "CommercialPrice3InCoCodeCrcy");
    @Nullable
    @ElementName(value="DevaluationYearCount")
    private String devaluationYearCount;
    public static final SimpleProperty.String<ProductValuationAccounting> DEVALUATION_YEAR_COUNT = new SimpleProperty.String(ProductValuationAccounting.class, "DevaluationYearCount");
    @Nullable
    @ElementName(value="FuturePrice")
    @DecimalDescriptor(precision=11, scale=0)
    private BigDecimal futurePrice;
    public static final SimpleProperty.NumericDecimal<ProductValuationAccounting> FUTURE_PRICE = new SimpleProperty.NumericDecimal(ProductValuationAccounting.class, "FuturePrice");
    @Nullable
    @ElementName(value="FuturePriceValidityStartDate")
    private LocalDate futurePriceValidityStartDate;
    public static final SimpleProperty.Date<ProductValuationAccounting> FUTURE_PRICE_VALIDITY_START_DATE = new SimpleProperty.Date(ProductValuationAccounting.class, "FuturePriceValidityStartDate");
    @Nullable
    @ElementName(value="LIFOValuationPoolNumber")
    private String lIFOValuationPoolNumber;
    public static final SimpleProperty.String<ProductValuationAccounting> LIFO_VALUATION_POOL_NUMBER = new SimpleProperty.String(ProductValuationAccounting.class, "LIFOValuationPoolNumber");
    @Nullable
    @ElementName(value="TaxPricel1InCoCodeCrcy")
    @DecimalDescriptor(precision=11, scale=0)
    private BigDecimal taxPricel1InCoCodeCrcy;
    public static final SimpleProperty.NumericDecimal<ProductValuationAccounting> TAX_PRICEL1_IN_CO_CODE_CRCY = new SimpleProperty.NumericDecimal(ProductValuationAccounting.class, "TaxPricel1InCoCodeCrcy");
    @Nullable
    @ElementName(value="TaxPrice2InCoCodeCrcy")
    @DecimalDescriptor(precision=11, scale=0)
    private BigDecimal taxPrice2InCoCodeCrcy;
    public static final SimpleProperty.NumericDecimal<ProductValuationAccounting> TAX_PRICE2_IN_CO_CODE_CRCY = new SimpleProperty.NumericDecimal(ProductValuationAccounting.class, "TaxPrice2InCoCodeCrcy");
    @Nullable
    @ElementName(value="TaxPrice3InCoCodeCrcy")
    @DecimalDescriptor(precision=11, scale=0)
    private BigDecimal taxPrice3InCoCodeCrcy;
    public static final SimpleProperty.NumericDecimal<ProductValuationAccounting> TAX_PRICE3_IN_CO_CODE_CRCY = new SimpleProperty.NumericDecimal(ProductValuationAccounting.class, "TaxPrice3InCoCodeCrcy");
    @Nullable
    @ElementName(value="TaxBasedPricesPriceUnitQty")
    @DecimalDescriptor(precision=5, scale=0)
    private BigDecimal taxBasedPricesPriceUnitQty;
    public static final SimpleProperty.NumericDecimal<ProductValuationAccounting> TAX_BASED_PRICES_PRICE_UNIT_QTY = new SimpleProperty.NumericDecimal(ProductValuationAccounting.class, "TaxBasedPricesPriceUnitQty");
    @Nullable
    @ElementName(value="IsLIFOAndFIFORelevant")
    private Boolean isLIFOAndFIFORelevant;
    public static final SimpleProperty.Boolean<ProductValuationAccounting> IS_LIFO_AND_FIFO_RELEVANT = new SimpleProperty.Boolean(ProductValuationAccounting.class, "IsLIFOAndFIFORelevant");
    @Nullable
    @ElementName(value="Currency")
    private String currency;
    public static final SimpleProperty.String<ProductValuationAccounting> CURRENCY = new SimpleProperty.String(ProductValuationAccounting.class, "Currency");
    @Nullable
    @ElementName(value="BaseUnit")
    private String baseUnit;
    public static final SimpleProperty.String<ProductValuationAccounting> BASE_UNIT = new SimpleProperty.String(ProductValuationAccounting.class, "BaseUnit");
    @Nullable
    @ElementName(value="BaseISOUnit")
    private String baseISOUnit;
    public static final SimpleProperty.String<ProductValuationAccounting> BASE_ISO_UNIT = new SimpleProperty.String(ProductValuationAccounting.class, "BaseISOUnit");
    @ElementName(value="_Product")
    @Nullable
    private Product to_Product;
    @ElementName(value="_ProductValuation")
    @Nullable
    private ProductValuation to_ProductValuation;
    public static final NavigationProperty.Single<ProductValuationAccounting, Product> TO__PRODUCT = new NavigationProperty.Single(ProductValuationAccounting.class, "_Product", Product.class);
    public static final NavigationProperty.Single<ProductValuationAccounting, ProductValuation> TO__PRODUCT_VALUATION = new NavigationProperty.Single(ProductValuationAccounting.class, "_ProductValuation", ProductValuation.class);

    @Nonnull
    public Class<ProductValuationAccounting> getType() {
        return ProductValuationAccounting.class;
    }

    public void setProduct(@Nullable String product) {
        this.rememberChangedField("Product", this.product);
        this.product = product;
    }

    public void setValuationArea(@Nullable String valuationArea) {
        this.rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    public void setValuationType(@Nullable String valuationType) {
        this.rememberChangedField("ValuationType", this.valuationType);
        this.valuationType = valuationType;
    }

    public void setCommercialPrice1InCoCodeCrcy(@Nullable BigDecimal commercialPrice1InCoCodeCrcy) {
        this.rememberChangedField("CommercialPrice1InCoCodeCrcy", this.commercialPrice1InCoCodeCrcy);
        this.commercialPrice1InCoCodeCrcy = commercialPrice1InCoCodeCrcy;
    }

    public void setCommercialPrice2InCoCodeCrcy(@Nullable BigDecimal commercialPrice2InCoCodeCrcy) {
        this.rememberChangedField("CommercialPrice2InCoCodeCrcy", this.commercialPrice2InCoCodeCrcy);
        this.commercialPrice2InCoCodeCrcy = commercialPrice2InCoCodeCrcy;
    }

    public void setCommercialPrice3InCoCodeCrcy(@Nullable BigDecimal commercialPrice3InCoCodeCrcy) {
        this.rememberChangedField("CommercialPrice3InCoCodeCrcy", this.commercialPrice3InCoCodeCrcy);
        this.commercialPrice3InCoCodeCrcy = commercialPrice3InCoCodeCrcy;
    }

    public void setDevaluationYearCount(@Nullable String devaluationYearCount) {
        this.rememberChangedField("DevaluationYearCount", this.devaluationYearCount);
        this.devaluationYearCount = devaluationYearCount;
    }

    public void setFuturePrice(@Nullable BigDecimal futurePrice) {
        this.rememberChangedField("FuturePrice", this.futurePrice);
        this.futurePrice = futurePrice;
    }

    public void setFuturePriceValidityStartDate(@Nullable LocalDate futurePriceValidityStartDate) {
        this.rememberChangedField("FuturePriceValidityStartDate", this.futurePriceValidityStartDate);
        this.futurePriceValidityStartDate = futurePriceValidityStartDate;
    }

    public void setLIFOValuationPoolNumber(@Nullable String lIFOValuationPoolNumber) {
        this.rememberChangedField("LIFOValuationPoolNumber", this.lIFOValuationPoolNumber);
        this.lIFOValuationPoolNumber = lIFOValuationPoolNumber;
    }

    public void setTaxPricel1InCoCodeCrcy(@Nullable BigDecimal taxPricel1InCoCodeCrcy) {
        this.rememberChangedField("TaxPricel1InCoCodeCrcy", this.taxPricel1InCoCodeCrcy);
        this.taxPricel1InCoCodeCrcy = taxPricel1InCoCodeCrcy;
    }

    public void setTaxPrice2InCoCodeCrcy(@Nullable BigDecimal taxPrice2InCoCodeCrcy) {
        this.rememberChangedField("TaxPrice2InCoCodeCrcy", this.taxPrice2InCoCodeCrcy);
        this.taxPrice2InCoCodeCrcy = taxPrice2InCoCodeCrcy;
    }

    public void setTaxPrice3InCoCodeCrcy(@Nullable BigDecimal taxPrice3InCoCodeCrcy) {
        this.rememberChangedField("TaxPrice3InCoCodeCrcy", this.taxPrice3InCoCodeCrcy);
        this.taxPrice3InCoCodeCrcy = taxPrice3InCoCodeCrcy;
    }

    public void setTaxBasedPricesPriceUnitQty(@Nullable BigDecimal taxBasedPricesPriceUnitQty) {
        this.rememberChangedField("TaxBasedPricesPriceUnitQty", this.taxBasedPricesPriceUnitQty);
        this.taxBasedPricesPriceUnitQty = taxBasedPricesPriceUnitQty;
    }

    public void setIsLIFOAndFIFORelevant(@Nullable Boolean isLIFOAndFIFORelevant) {
        this.rememberChangedField("IsLIFOAndFIFORelevant", this.isLIFOAndFIFORelevant);
        this.isLIFOAndFIFORelevant = isLIFOAndFIFORelevant;
    }

    public void setCurrency(@Nullable String currency) {
        this.rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    public void setBaseUnit(@Nullable String baseUnit) {
        this.rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    public void setBaseISOUnit(@Nullable String baseISOUnit) {
        this.rememberChangedField("BaseISOUnit", this.baseISOUnit);
        this.baseISOUnit = baseISOUnit;
    }

    protected String getEntityCollection() {
        return "ProductValuationAccounting";
    }

    @Nonnull
    protected ODataEntityKey getKey() {
        ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("Product", (Object)this.getProduct());
        entityKey.addKeyProperty("ValuationArea", (Object)this.getValuationArea());
        entityKey.addKeyProperty("ValuationType", (Object)this.getValuationType());
        return entityKey;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("Product", this.getProduct());
        values.put("ValuationArea", this.getValuationArea());
        values.put("ValuationType", this.getValuationType());
        values.put("CommercialPrice1InCoCodeCrcy", this.getCommercialPrice1InCoCodeCrcy());
        values.put("CommercialPrice2InCoCodeCrcy", this.getCommercialPrice2InCoCodeCrcy());
        values.put("CommercialPrice3InCoCodeCrcy", this.getCommercialPrice3InCoCodeCrcy());
        values.put("DevaluationYearCount", this.getDevaluationYearCount());
        values.put("FuturePrice", this.getFuturePrice());
        values.put("FuturePriceValidityStartDate", this.getFuturePriceValidityStartDate());
        values.put("LIFOValuationPoolNumber", this.getLIFOValuationPoolNumber());
        values.put("TaxPricel1InCoCodeCrcy", this.getTaxPricel1InCoCodeCrcy());
        values.put("TaxPrice2InCoCodeCrcy", this.getTaxPrice2InCoCodeCrcy());
        values.put("TaxPrice3InCoCodeCrcy", this.getTaxPrice3InCoCodeCrcy());
        values.put("TaxBasedPricesPriceUnitQty", this.getTaxBasedPricesPriceUnitQty());
        values.put("IsLIFOAndFIFORelevant", this.getIsLIFOAndFIFORelevant());
        values.put("Currency", this.getCurrency());
        values.put("BaseUnit", this.getBaseUnit());
        values.put("BaseISOUnit", this.getBaseISOUnit());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Map inputMap;
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("Product") && ((value = values.remove("Product")) == null || !value.equals(this.getProduct()))) {
            this.setProduct((String)value);
        }
        if (values.containsKey("ValuationArea") && ((value = values.remove("ValuationArea")) == null || !value.equals(this.getValuationArea()))) {
            this.setValuationArea((String)value);
        }
        if (values.containsKey("ValuationType") && ((value = values.remove("ValuationType")) == null || !value.equals(this.getValuationType()))) {
            this.setValuationType((String)value);
        }
        if (values.containsKey("CommercialPrice1InCoCodeCrcy") && ((value = values.remove("CommercialPrice1InCoCodeCrcy")) == null || !value.equals(this.getCommercialPrice1InCoCodeCrcy()))) {
            this.setCommercialPrice1InCoCodeCrcy((BigDecimal)value);
        }
        if (values.containsKey("CommercialPrice2InCoCodeCrcy") && ((value = values.remove("CommercialPrice2InCoCodeCrcy")) == null || !value.equals(this.getCommercialPrice2InCoCodeCrcy()))) {
            this.setCommercialPrice2InCoCodeCrcy((BigDecimal)value);
        }
        if (values.containsKey("CommercialPrice3InCoCodeCrcy") && ((value = values.remove("CommercialPrice3InCoCodeCrcy")) == null || !value.equals(this.getCommercialPrice3InCoCodeCrcy()))) {
            this.setCommercialPrice3InCoCodeCrcy((BigDecimal)value);
        }
        if (values.containsKey("DevaluationYearCount") && ((value = values.remove("DevaluationYearCount")) == null || !value.equals(this.getDevaluationYearCount()))) {
            this.setDevaluationYearCount((String)value);
        }
        if (values.containsKey("FuturePrice") && ((value = values.remove("FuturePrice")) == null || !value.equals(this.getFuturePrice()))) {
            this.setFuturePrice((BigDecimal)value);
        }
        if (values.containsKey("FuturePriceValidityStartDate") && ((value = values.remove("FuturePriceValidityStartDate")) == null || !value.equals(this.getFuturePriceValidityStartDate()))) {
            this.setFuturePriceValidityStartDate((LocalDate)value);
        }
        if (values.containsKey("LIFOValuationPoolNumber") && ((value = values.remove("LIFOValuationPoolNumber")) == null || !value.equals(this.getLIFOValuationPoolNumber()))) {
            this.setLIFOValuationPoolNumber((String)value);
        }
        if (values.containsKey("TaxPricel1InCoCodeCrcy") && ((value = values.remove("TaxPricel1InCoCodeCrcy")) == null || !value.equals(this.getTaxPricel1InCoCodeCrcy()))) {
            this.setTaxPricel1InCoCodeCrcy((BigDecimal)value);
        }
        if (values.containsKey("TaxPrice2InCoCodeCrcy") && ((value = values.remove("TaxPrice2InCoCodeCrcy")) == null || !value.equals(this.getTaxPrice2InCoCodeCrcy()))) {
            this.setTaxPrice2InCoCodeCrcy((BigDecimal)value);
        }
        if (values.containsKey("TaxPrice3InCoCodeCrcy") && ((value = values.remove("TaxPrice3InCoCodeCrcy")) == null || !value.equals(this.getTaxPrice3InCoCodeCrcy()))) {
            this.setTaxPrice3InCoCodeCrcy((BigDecimal)value);
        }
        if (values.containsKey("TaxBasedPricesPriceUnitQty") && ((value = values.remove("TaxBasedPricesPriceUnitQty")) == null || !value.equals(this.getTaxBasedPricesPriceUnitQty()))) {
            this.setTaxBasedPricesPriceUnitQty((BigDecimal)value);
        }
        if (values.containsKey("IsLIFOAndFIFORelevant") && ((value = values.remove("IsLIFOAndFIFORelevant")) == null || !value.equals(this.getIsLIFOAndFIFORelevant()))) {
            this.setIsLIFOAndFIFORelevant((Boolean)value);
        }
        if (values.containsKey("Currency") && ((value = values.remove("Currency")) == null || !value.equals(this.getCurrency()))) {
            this.setCurrency((String)value);
        }
        if (values.containsKey("BaseUnit") && ((value = values.remove("BaseUnit")) == null || !value.equals(this.getBaseUnit()))) {
            this.setBaseUnit((String)value);
        }
        if (values.containsKey("BaseISOUnit") && ((value = values.remove("BaseISOUnit")) == null || !value.equals(this.getBaseISOUnit()))) {
            this.setBaseISOUnit((String)value);
        }
        if (values.containsKey("_Product") && (value = values.remove("_Product")) instanceof Map) {
            if (this.to_Product == null) {
                this.to_Product = new Product();
            }
            inputMap = (Map)value;
            this.to_Product.fromMap(inputMap);
        }
        if (values.containsKey("_ProductValuation") && (value = values.remove("_ProductValuation")) instanceof Map) {
            if (this.to_ProductValuation == null) {
                this.to_ProductValuation = new ProductValuation();
            }
            inputMap = (Map)value;
            this.to_ProductValuation.fromMap(inputMap);
        }
        super.fromMap((Map)values);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata4/sap/api_product/srvd_a2x/sap/product/0001";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.to_Product != null) {
            values.put("_Product", this.to_Product);
        }
        if (this.to_ProductValuation != null) {
            values.put("_ProductValuation", this.to_ProductValuation);
        }
        return values;
    }

    @Nonnull
    public Option<Product> getProductIfPresent() {
        return Option.of((Object)((Object)this.to_Product));
    }

    public void setProduct(Product value) {
        this.to_Product = value;
    }

    @Nonnull
    public Option<ProductValuation> getProductValuationIfPresent() {
        return Option.of((Object)((Object)this.to_ProductValuation));
    }

    public void setProductValuation(ProductValuation value) {
        this.to_ProductValuation = value;
    }

    @Nonnull
    @Generated
    public static ProductValuationAccountingBuilder builder() {
        return new ProductValuationAccountingBuilder();
    }

    @Nullable
    @Generated
    public String getProduct() {
        return this.product;
    }

    @Nullable
    @Generated
    public String getValuationArea() {
        return this.valuationArea;
    }

    @Nullable
    @Generated
    public String getValuationType() {
        return this.valuationType;
    }

    @Nullable
    @Generated
    public BigDecimal getCommercialPrice1InCoCodeCrcy() {
        return this.commercialPrice1InCoCodeCrcy;
    }

    @Nullable
    @Generated
    public BigDecimal getCommercialPrice2InCoCodeCrcy() {
        return this.commercialPrice2InCoCodeCrcy;
    }

    @Nullable
    @Generated
    public BigDecimal getCommercialPrice3InCoCodeCrcy() {
        return this.commercialPrice3InCoCodeCrcy;
    }

    @Nullable
    @Generated
    public String getDevaluationYearCount() {
        return this.devaluationYearCount;
    }

    @Nullable
    @Generated
    public BigDecimal getFuturePrice() {
        return this.futurePrice;
    }

    @Nullable
    @Generated
    public LocalDate getFuturePriceValidityStartDate() {
        return this.futurePriceValidityStartDate;
    }

    @Nullable
    @Generated
    public String getLIFOValuationPoolNumber() {
        return this.lIFOValuationPoolNumber;
    }

    @Nullable
    @Generated
    public BigDecimal getTaxPricel1InCoCodeCrcy() {
        return this.taxPricel1InCoCodeCrcy;
    }

    @Nullable
    @Generated
    public BigDecimal getTaxPrice2InCoCodeCrcy() {
        return this.taxPrice2InCoCodeCrcy;
    }

    @Nullable
    @Generated
    public BigDecimal getTaxPrice3InCoCodeCrcy() {
        return this.taxPrice3InCoCodeCrcy;
    }

    @Nullable
    @Generated
    public BigDecimal getTaxBasedPricesPriceUnitQty() {
        return this.taxBasedPricesPriceUnitQty;
    }

    @Nullable
    @Generated
    public Boolean getIsLIFOAndFIFORelevant() {
        return this.isLIFOAndFIFORelevant;
    }

    @Nullable
    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Nullable
    @Generated
    public String getBaseUnit() {
        return this.baseUnit;
    }

    @Nullable
    @Generated
    public String getBaseISOUnit() {
        return this.baseISOUnit;
    }

    @Generated
    public ProductValuationAccounting() {
    }

    @Generated
    public ProductValuationAccounting(@Nullable String product, @Nullable String valuationArea, @Nullable String valuationType, @Nullable BigDecimal commercialPrice1InCoCodeCrcy, @Nullable BigDecimal commercialPrice2InCoCodeCrcy, @Nullable BigDecimal commercialPrice3InCoCodeCrcy, @Nullable String devaluationYearCount, @Nullable BigDecimal futurePrice, @Nullable LocalDate futurePriceValidityStartDate, @Nullable String lIFOValuationPoolNumber, @Nullable BigDecimal taxPricel1InCoCodeCrcy, @Nullable BigDecimal taxPrice2InCoCodeCrcy, @Nullable BigDecimal taxPrice3InCoCodeCrcy, @Nullable BigDecimal taxBasedPricesPriceUnitQty, @Nullable Boolean isLIFOAndFIFORelevant, @Nullable String currency, @Nullable String baseUnit, @Nullable String baseISOUnit, @Nullable Product to_Product, @Nullable ProductValuation to_ProductValuation) {
        this.product = product;
        this.valuationArea = valuationArea;
        this.valuationType = valuationType;
        this.commercialPrice1InCoCodeCrcy = commercialPrice1InCoCodeCrcy;
        this.commercialPrice2InCoCodeCrcy = commercialPrice2InCoCodeCrcy;
        this.commercialPrice3InCoCodeCrcy = commercialPrice3InCoCodeCrcy;
        this.devaluationYearCount = devaluationYearCount;
        this.futurePrice = futurePrice;
        this.futurePriceValidityStartDate = futurePriceValidityStartDate;
        this.lIFOValuationPoolNumber = lIFOValuationPoolNumber;
        this.taxPricel1InCoCodeCrcy = taxPricel1InCoCodeCrcy;
        this.taxPrice2InCoCodeCrcy = taxPrice2InCoCodeCrcy;
        this.taxPrice3InCoCodeCrcy = taxPrice3InCoCodeCrcy;
        this.taxBasedPricesPriceUnitQty = taxBasedPricesPriceUnitQty;
        this.isLIFOAndFIFORelevant = isLIFOAndFIFORelevant;
        this.currency = currency;
        this.baseUnit = baseUnit;
        this.baseISOUnit = baseISOUnit;
        this.to_Product = to_Product;
        this.to_ProductValuation = to_ProductValuation;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "ProductValuationAccounting(super=" + super.toString() + ", odataType=" + this.odataType + ", product=" + this.product + ", valuationArea=" + this.valuationArea + ", valuationType=" + this.valuationType + ", commercialPrice1InCoCodeCrcy=" + this.commercialPrice1InCoCodeCrcy + ", commercialPrice2InCoCodeCrcy=" + this.commercialPrice2InCoCodeCrcy + ", commercialPrice3InCoCodeCrcy=" + this.commercialPrice3InCoCodeCrcy + ", devaluationYearCount=" + this.devaluationYearCount + ", futurePrice=" + this.futurePrice + ", futurePriceValidityStartDate=" + this.futurePriceValidityStartDate + ", lIFOValuationPoolNumber=" + this.lIFOValuationPoolNumber + ", taxPricel1InCoCodeCrcy=" + this.taxPricel1InCoCodeCrcy + ", taxPrice2InCoCodeCrcy=" + this.taxPrice2InCoCodeCrcy + ", taxPrice3InCoCodeCrcy=" + this.taxPrice3InCoCodeCrcy + ", taxBasedPricesPriceUnitQty=" + this.taxBasedPricesPriceUnitQty + ", isLIFOAndFIFORelevant=" + this.isLIFOAndFIFORelevant + ", currency=" + this.currency + ", baseUnit=" + this.baseUnit + ", baseISOUnit=" + this.baseISOUnit + ", to_Product=" + (Object)((Object)this.to_Product) + ", to_ProductValuation=" + (Object)((Object)this.to_ProductValuation) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductValuationAccounting)) {
            return false;
        }
        ProductValuationAccounting other = (ProductValuationAccounting)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isLIFOAndFIFORelevant = this.isLIFOAndFIFORelevant;
        Boolean other$isLIFOAndFIFORelevant = other.isLIFOAndFIFORelevant;
        if (this$isLIFOAndFIFORelevant == null ? other$isLIFOAndFIFORelevant != null : !((Object)this$isLIFOAndFIFORelevant).equals(other$isLIFOAndFIFORelevant)) {
            return false;
        }
        String this$odataType = this.odataType;
        String other$odataType = other.odataType;
        if (this$odataType == null ? other$odataType != null : !this$odataType.equals(other$odataType)) {
            return false;
        }
        String this$product = this.product;
        String other$product = other.product;
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        String this$valuationArea = this.valuationArea;
        String other$valuationArea = other.valuationArea;
        if (this$valuationArea == null ? other$valuationArea != null : !this$valuationArea.equals(other$valuationArea)) {
            return false;
        }
        String this$valuationType = this.valuationType;
        String other$valuationType = other.valuationType;
        if (this$valuationType == null ? other$valuationType != null : !this$valuationType.equals(other$valuationType)) {
            return false;
        }
        BigDecimal this$commercialPrice1InCoCodeCrcy = this.commercialPrice1InCoCodeCrcy;
        BigDecimal other$commercialPrice1InCoCodeCrcy = other.commercialPrice1InCoCodeCrcy;
        if (this$commercialPrice1InCoCodeCrcy == null ? other$commercialPrice1InCoCodeCrcy != null : !((Object)this$commercialPrice1InCoCodeCrcy).equals(other$commercialPrice1InCoCodeCrcy)) {
            return false;
        }
        BigDecimal this$commercialPrice2InCoCodeCrcy = this.commercialPrice2InCoCodeCrcy;
        BigDecimal other$commercialPrice2InCoCodeCrcy = other.commercialPrice2InCoCodeCrcy;
        if (this$commercialPrice2InCoCodeCrcy == null ? other$commercialPrice2InCoCodeCrcy != null : !((Object)this$commercialPrice2InCoCodeCrcy).equals(other$commercialPrice2InCoCodeCrcy)) {
            return false;
        }
        BigDecimal this$commercialPrice3InCoCodeCrcy = this.commercialPrice3InCoCodeCrcy;
        BigDecimal other$commercialPrice3InCoCodeCrcy = other.commercialPrice3InCoCodeCrcy;
        if (this$commercialPrice3InCoCodeCrcy == null ? other$commercialPrice3InCoCodeCrcy != null : !((Object)this$commercialPrice3InCoCodeCrcy).equals(other$commercialPrice3InCoCodeCrcy)) {
            return false;
        }
        String this$devaluationYearCount = this.devaluationYearCount;
        String other$devaluationYearCount = other.devaluationYearCount;
        if (this$devaluationYearCount == null ? other$devaluationYearCount != null : !this$devaluationYearCount.equals(other$devaluationYearCount)) {
            return false;
        }
        BigDecimal this$futurePrice = this.futurePrice;
        BigDecimal other$futurePrice = other.futurePrice;
        if (this$futurePrice == null ? other$futurePrice != null : !((Object)this$futurePrice).equals(other$futurePrice)) {
            return false;
        }
        LocalDate this$futurePriceValidityStartDate = this.futurePriceValidityStartDate;
        LocalDate other$futurePriceValidityStartDate = other.futurePriceValidityStartDate;
        if (this$futurePriceValidityStartDate == null ? other$futurePriceValidityStartDate != null : !((Object)this$futurePriceValidityStartDate).equals(other$futurePriceValidityStartDate)) {
            return false;
        }
        String this$lIFOValuationPoolNumber = this.lIFOValuationPoolNumber;
        String other$lIFOValuationPoolNumber = other.lIFOValuationPoolNumber;
        if (this$lIFOValuationPoolNumber == null ? other$lIFOValuationPoolNumber != null : !this$lIFOValuationPoolNumber.equals(other$lIFOValuationPoolNumber)) {
            return false;
        }
        BigDecimal this$taxPricel1InCoCodeCrcy = this.taxPricel1InCoCodeCrcy;
        BigDecimal other$taxPricel1InCoCodeCrcy = other.taxPricel1InCoCodeCrcy;
        if (this$taxPricel1InCoCodeCrcy == null ? other$taxPricel1InCoCodeCrcy != null : !((Object)this$taxPricel1InCoCodeCrcy).equals(other$taxPricel1InCoCodeCrcy)) {
            return false;
        }
        BigDecimal this$taxPrice2InCoCodeCrcy = this.taxPrice2InCoCodeCrcy;
        BigDecimal other$taxPrice2InCoCodeCrcy = other.taxPrice2InCoCodeCrcy;
        if (this$taxPrice2InCoCodeCrcy == null ? other$taxPrice2InCoCodeCrcy != null : !((Object)this$taxPrice2InCoCodeCrcy).equals(other$taxPrice2InCoCodeCrcy)) {
            return false;
        }
        BigDecimal this$taxPrice3InCoCodeCrcy = this.taxPrice3InCoCodeCrcy;
        BigDecimal other$taxPrice3InCoCodeCrcy = other.taxPrice3InCoCodeCrcy;
        if (this$taxPrice3InCoCodeCrcy == null ? other$taxPrice3InCoCodeCrcy != null : !((Object)this$taxPrice3InCoCodeCrcy).equals(other$taxPrice3InCoCodeCrcy)) {
            return false;
        }
        BigDecimal this$taxBasedPricesPriceUnitQty = this.taxBasedPricesPriceUnitQty;
        BigDecimal other$taxBasedPricesPriceUnitQty = other.taxBasedPricesPriceUnitQty;
        if (this$taxBasedPricesPriceUnitQty == null ? other$taxBasedPricesPriceUnitQty != null : !((Object)this$taxBasedPricesPriceUnitQty).equals(other$taxBasedPricesPriceUnitQty)) {
            return false;
        }
        String this$currency = this.currency;
        String other$currency = other.currency;
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$baseUnit = this.baseUnit;
        String other$baseUnit = other.baseUnit;
        if (this$baseUnit == null ? other$baseUnit != null : !this$baseUnit.equals(other$baseUnit)) {
            return false;
        }
        String this$baseISOUnit = this.baseISOUnit;
        String other$baseISOUnit = other.baseISOUnit;
        if (this$baseISOUnit == null ? other$baseISOUnit != null : !this$baseISOUnit.equals(other$baseISOUnit)) {
            return false;
        }
        Product this$to_Product = this.to_Product;
        Product other$to_Product = other.to_Product;
        if (this$to_Product == null ? other$to_Product != null : !((Object)((Object)this$to_Product)).equals((Object)other$to_Product)) {
            return false;
        }
        ProductValuation this$to_ProductValuation = this.to_ProductValuation;
        ProductValuation other$to_ProductValuation = other.to_ProductValuation;
        return !(this$to_ProductValuation == null ? other$to_ProductValuation != null : !((Object)((Object)this$to_ProductValuation)).equals((Object)other$to_ProductValuation));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ProductValuationAccounting;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isLIFOAndFIFORelevant = this.isLIFOAndFIFORelevant;
        result = result * 59 + ($isLIFOAndFIFORelevant == null ? 43 : ((Object)$isLIFOAndFIFORelevant).hashCode());
        String $odataType = this.odataType;
        result = result * 59 + ($odataType == null ? 43 : $odataType.hashCode());
        String $product = this.product;
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        String $valuationArea = this.valuationArea;
        result = result * 59 + ($valuationArea == null ? 43 : $valuationArea.hashCode());
        String $valuationType = this.valuationType;
        result = result * 59 + ($valuationType == null ? 43 : $valuationType.hashCode());
        BigDecimal $commercialPrice1InCoCodeCrcy = this.commercialPrice1InCoCodeCrcy;
        result = result * 59 + ($commercialPrice1InCoCodeCrcy == null ? 43 : ((Object)$commercialPrice1InCoCodeCrcy).hashCode());
        BigDecimal $commercialPrice2InCoCodeCrcy = this.commercialPrice2InCoCodeCrcy;
        result = result * 59 + ($commercialPrice2InCoCodeCrcy == null ? 43 : ((Object)$commercialPrice2InCoCodeCrcy).hashCode());
        BigDecimal $commercialPrice3InCoCodeCrcy = this.commercialPrice3InCoCodeCrcy;
        result = result * 59 + ($commercialPrice3InCoCodeCrcy == null ? 43 : ((Object)$commercialPrice3InCoCodeCrcy).hashCode());
        String $devaluationYearCount = this.devaluationYearCount;
        result = result * 59 + ($devaluationYearCount == null ? 43 : $devaluationYearCount.hashCode());
        BigDecimal $futurePrice = this.futurePrice;
        result = result * 59 + ($futurePrice == null ? 43 : ((Object)$futurePrice).hashCode());
        LocalDate $futurePriceValidityStartDate = this.futurePriceValidityStartDate;
        result = result * 59 + ($futurePriceValidityStartDate == null ? 43 : ((Object)$futurePriceValidityStartDate).hashCode());
        String $lIFOValuationPoolNumber = this.lIFOValuationPoolNumber;
        result = result * 59 + ($lIFOValuationPoolNumber == null ? 43 : $lIFOValuationPoolNumber.hashCode());
        BigDecimal $taxPricel1InCoCodeCrcy = this.taxPricel1InCoCodeCrcy;
        result = result * 59 + ($taxPricel1InCoCodeCrcy == null ? 43 : ((Object)$taxPricel1InCoCodeCrcy).hashCode());
        BigDecimal $taxPrice2InCoCodeCrcy = this.taxPrice2InCoCodeCrcy;
        result = result * 59 + ($taxPrice2InCoCodeCrcy == null ? 43 : ((Object)$taxPrice2InCoCodeCrcy).hashCode());
        BigDecimal $taxPrice3InCoCodeCrcy = this.taxPrice3InCoCodeCrcy;
        result = result * 59 + ($taxPrice3InCoCodeCrcy == null ? 43 : ((Object)$taxPrice3InCoCodeCrcy).hashCode());
        BigDecimal $taxBasedPricesPriceUnitQty = this.taxBasedPricesPriceUnitQty;
        result = result * 59 + ($taxBasedPricesPriceUnitQty == null ? 43 : ((Object)$taxBasedPricesPriceUnitQty).hashCode());
        String $currency = this.currency;
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $baseUnit = this.baseUnit;
        result = result * 59 + ($baseUnit == null ? 43 : $baseUnit.hashCode());
        String $baseISOUnit = this.baseISOUnit;
        result = result * 59 + ($baseISOUnit == null ? 43 : $baseISOUnit.hashCode());
        Product $to_Product = this.to_Product;
        result = result * 59 + ($to_Product == null ? 43 : ((Object)((Object)$to_Product)).hashCode());
        ProductValuation $to_ProductValuation = this.to_ProductValuation;
        result = result * 59 + ($to_ProductValuation == null ? 43 : ((Object)((Object)$to_ProductValuation)).hashCode());
        return result;
    }

    @Generated
    public String getOdataType() {
        return this.odataType;
    }

    public static final class ProductValuationAccountingBuilder {
        @Generated
        private String valuationArea;
        @Generated
        private String valuationType;
        @Generated
        private BigDecimal commercialPrice1InCoCodeCrcy;
        @Generated
        private BigDecimal commercialPrice2InCoCodeCrcy;
        @Generated
        private BigDecimal commercialPrice3InCoCodeCrcy;
        @Generated
        private String devaluationYearCount;
        @Generated
        private BigDecimal futurePrice;
        @Generated
        private LocalDate futurePriceValidityStartDate;
        @Generated
        private String lIFOValuationPoolNumber;
        @Generated
        private BigDecimal taxPricel1InCoCodeCrcy;
        @Generated
        private BigDecimal taxPrice2InCoCodeCrcy;
        @Generated
        private BigDecimal taxPrice3InCoCodeCrcy;
        @Generated
        private BigDecimal taxBasedPricesPriceUnitQty;
        @Generated
        private Boolean isLIFOAndFIFORelevant;
        @Generated
        private String currency;
        @Generated
        private String baseUnit;
        @Generated
        private String baseISOUnit;
        private Product to_Product;
        private String product = null;
        private ProductValuation to_ProductValuation;

        private ProductValuationAccountingBuilder to_Product(Product value) {
            this.to_Product = value;
            return this;
        }

        @Nonnull
        public ProductValuationAccountingBuilder product(Product value) {
            return this.to_Product(value);
        }

        @Nonnull
        public ProductValuationAccountingBuilder product(String value) {
            this.product = value;
            return this;
        }

        private ProductValuationAccountingBuilder to_ProductValuation(ProductValuation value) {
            this.to_ProductValuation = value;
            return this;
        }

        @Nonnull
        public ProductValuationAccountingBuilder productValuation(ProductValuation value) {
            return this.to_ProductValuation(value);
        }

        @Generated
        ProductValuationAccountingBuilder() {
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder valuationArea(@Nullable String valuationArea) {
            this.valuationArea = valuationArea;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder valuationType(@Nullable String valuationType) {
            this.valuationType = valuationType;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder commercialPrice1InCoCodeCrcy(@Nullable BigDecimal commercialPrice1InCoCodeCrcy) {
            this.commercialPrice1InCoCodeCrcy = commercialPrice1InCoCodeCrcy;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder commercialPrice2InCoCodeCrcy(@Nullable BigDecimal commercialPrice2InCoCodeCrcy) {
            this.commercialPrice2InCoCodeCrcy = commercialPrice2InCoCodeCrcy;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder commercialPrice3InCoCodeCrcy(@Nullable BigDecimal commercialPrice3InCoCodeCrcy) {
            this.commercialPrice3InCoCodeCrcy = commercialPrice3InCoCodeCrcy;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder devaluationYearCount(@Nullable String devaluationYearCount) {
            this.devaluationYearCount = devaluationYearCount;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder futurePrice(@Nullable BigDecimal futurePrice) {
            this.futurePrice = futurePrice;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder futurePriceValidityStartDate(@Nullable LocalDate futurePriceValidityStartDate) {
            this.futurePriceValidityStartDate = futurePriceValidityStartDate;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder lIFOValuationPoolNumber(@Nullable String lIFOValuationPoolNumber) {
            this.lIFOValuationPoolNumber = lIFOValuationPoolNumber;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder taxPricel1InCoCodeCrcy(@Nullable BigDecimal taxPricel1InCoCodeCrcy) {
            this.taxPricel1InCoCodeCrcy = taxPricel1InCoCodeCrcy;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder taxPrice2InCoCodeCrcy(@Nullable BigDecimal taxPrice2InCoCodeCrcy) {
            this.taxPrice2InCoCodeCrcy = taxPrice2InCoCodeCrcy;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder taxPrice3InCoCodeCrcy(@Nullable BigDecimal taxPrice3InCoCodeCrcy) {
            this.taxPrice3InCoCodeCrcy = taxPrice3InCoCodeCrcy;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder taxBasedPricesPriceUnitQty(@Nullable BigDecimal taxBasedPricesPriceUnitQty) {
            this.taxBasedPricesPriceUnitQty = taxBasedPricesPriceUnitQty;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder isLIFOAndFIFORelevant(@Nullable Boolean isLIFOAndFIFORelevant) {
            this.isLIFOAndFIFORelevant = isLIFOAndFIFORelevant;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder currency(@Nullable String currency) {
            this.currency = currency;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder baseUnit(@Nullable String baseUnit) {
            this.baseUnit = baseUnit;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccountingBuilder baseISOUnit(@Nullable String baseISOUnit) {
            this.baseISOUnit = baseISOUnit;
            return this;
        }

        @Nonnull
        @Generated
        public ProductValuationAccounting build() {
            return new ProductValuationAccounting(this.product, this.valuationArea, this.valuationType, this.commercialPrice1InCoCodeCrcy, this.commercialPrice2InCoCodeCrcy, this.commercialPrice3InCoCodeCrcy, this.devaluationYearCount, this.futurePrice, this.futurePriceValidityStartDate, this.lIFOValuationPoolNumber, this.taxPricel1InCoCodeCrcy, this.taxPrice2InCoCodeCrcy, this.taxPrice3InCoCodeCrcy, this.taxBasedPricesPriceUnitQty, this.isLIFOAndFIFORelevant, this.currency, this.baseUnit, this.baseISOUnit, this.to_Product, this.to_ProductValuation);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "ProductValuationAccounting.ProductValuationAccountingBuilder(product=" + this.product + ", valuationArea=" + this.valuationArea + ", valuationType=" + this.valuationType + ", commercialPrice1InCoCodeCrcy=" + this.commercialPrice1InCoCodeCrcy + ", commercialPrice2InCoCodeCrcy=" + this.commercialPrice2InCoCodeCrcy + ", commercialPrice3InCoCodeCrcy=" + this.commercialPrice3InCoCodeCrcy + ", devaluationYearCount=" + this.devaluationYearCount + ", futurePrice=" + this.futurePrice + ", futurePriceValidityStartDate=" + this.futurePriceValidityStartDate + ", lIFOValuationPoolNumber=" + this.lIFOValuationPoolNumber + ", taxPricel1InCoCodeCrcy=" + this.taxPricel1InCoCodeCrcy + ", taxPrice2InCoCodeCrcy=" + this.taxPrice2InCoCodeCrcy + ", taxPrice3InCoCodeCrcy=" + this.taxPrice3InCoCodeCrcy + ", taxBasedPricesPriceUnitQty=" + this.taxBasedPricesPriceUnitQty + ", isLIFOAndFIFORelevant=" + this.isLIFOAndFIFORelevant + ", currency=" + this.currency + ", baseUnit=" + this.baseUnit + ", baseISOUnit=" + this.baseISOUnit + ", to_Product=" + (Object)((Object)this.to_Product) + ", to_ProductValuation=" + (Object)((Object)this.to_ProductValuation) + ")";
        }
    }
}

