/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.warrantyclaim;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer;
import com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction;
import com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.warrantyclaim.SAP__Message;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.warrantyclaim.WarrantyClaim;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.warrantyclaim.WarrantyClaimVersion;
import io.vavr.control.Option;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonAdapter(value=GsonVdmAdapterFactory.class)
@JsonSerialize(using=JacksonVdmObjectSerializer.class)
@JsonDeserialize(using=JacksonVdmObjectDeserializer.class)
public class WarrantyClaimItem
extends VdmEntity<WarrantyClaimItem>
implements VdmEntitySet {
    private final String odataType = "com.sap.gateway.srvd_a2x.api_warrantyclaim.v0001.WarrantyClaimItem_Type";
    public static final SimpleProperty<WarrantyClaimItem> ALL_FIELDS = WarrantyClaimItem.all();
    @Nullable
    @ElementName(value="WrntyItemUUID")
    private UUID wrntyItemUUID;
    public static final SimpleProperty.Guid<WarrantyClaimItem> WRNTY_ITEM_UUID = new SimpleProperty.Guid(WarrantyClaimItem.class, "WrntyItemUUID");
    @Nullable
    @ElementName(value="WrntyClaimHeaderUUID")
    private UUID wrntyClaimHeaderUUID;
    public static final SimpleProperty.Guid<WarrantyClaimItem> WRNTY_CLAIM_HEADER_UUID = new SimpleProperty.Guid(WarrantyClaimItem.class, "WrntyClaimHeaderUUID");
    @Nullable
    @ElementName(value="WrntyVersionUUID")
    private UUID wrntyVersionUUID;
    public static final SimpleProperty.Guid<WarrantyClaimItem> WRNTY_VERSION_UUID = new SimpleProperty.Guid(WarrantyClaimItem.class, "WrntyVersionUUID");
    @Nullable
    @ElementName(value="WarrantyItemKey")
    private String warrantyItemKey;
    public static final SimpleProperty.String<WarrantyClaimItem> WARRANTY_ITEM_KEY = new SimpleProperty.String(WarrantyClaimItem.class, "WarrantyItemKey");
    @Nullable
    @ElementName(value="WarrantyClaimItemNumber")
    private String warrantyClaimItemNumber;
    public static final SimpleProperty.String<WarrantyClaimItem> WARRANTY_CLAIM_ITEM_NUMBER = new SimpleProperty.String(WarrantyClaimItem.class, "WarrantyClaimItemNumber");
    @Nullable
    @ElementName(value="WrntyControllingItemType")
    private String wrntyControllingItemType;
    public static final SimpleProperty.String<WarrantyClaimItem> WRNTY_CONTROLLING_ITEM_TYPE = new SimpleProperty.String(WarrantyClaimItem.class, "WrntyControllingItemType");
    @Nullable
    @ElementName(value="WarrantyItemType")
    private String warrantyItemType;
    public static final SimpleProperty.String<WarrantyClaimItem> WARRANTY_ITEM_TYPE = new SimpleProperty.String(WarrantyClaimItem.class, "WarrantyItemType");
    @Nullable
    @ElementName(value="WarrantyClaimCatalog")
    private String warrantyClaimCatalog;
    public static final SimpleProperty.String<WarrantyClaimItem> WARRANTY_CLAIM_CATALOG = new SimpleProperty.String(WarrantyClaimItem.class, "WarrantyClaimCatalog");
    @Nullable
    @ElementName(value="WarrantyClaimItemDefectCode")
    private String warrantyClaimItemDefectCode;
    public static final SimpleProperty.String<WarrantyClaimItem> WARRANTY_CLAIM_ITEM_DEFECT_CODE = new SimpleProperty.String(WarrantyClaimItem.class, "WarrantyClaimItemDefectCode");
    @Nullable
    @ElementName(value="WrntyClaimQuantity")
    @DecimalDescriptor(precision=15, scale=3)
    private BigDecimal wrntyClaimQuantity;
    public static final SimpleProperty.NumericDecimal<WarrantyClaimItem> WRNTY_CLAIM_QUANTITY = new SimpleProperty.NumericDecimal(WarrantyClaimItem.class, "WrntyClaimQuantity");
    @Nullable
    @ElementName(value="QuantityUnit")
    private String quantityUnit;
    public static final SimpleProperty.String<WarrantyClaimItem> QUANTITY_UNIT = new SimpleProperty.String(WarrantyClaimItem.class, "QuantityUnit");
    @Nullable
    @ElementName(value="WarrantyClaimItemDecisionCode")
    private String warrantyClaimItemDecisionCode;
    public static final SimpleProperty.String<WarrantyClaimItem> WARRANTY_CLAIM_ITEM_DECISION_CODE = new SimpleProperty.String(WarrantyClaimItem.class, "WarrantyClaimItemDecisionCode");
    @Nullable
    @ElementName(value="WrntyClmPartsIsCausingDamage")
    private String wrntyClmPartsIsCausingDamage;
    public static final SimpleProperty.String<WarrantyClaimItem> WRNTY_CLM_PARTS_IS_CAUSING_DAMAGE = new SimpleProperty.String(WarrantyClaimItem.class, "WrntyClmPartsIsCausingDamage");
    @Nullable
    @ElementName(value="WrntyReimburserClaimAmount")
    @DecimalDescriptor(precision=13, scale=0)
    private BigDecimal wrntyReimburserClaimAmount;
    public static final SimpleProperty.NumericDecimal<WarrantyClaimItem> WRNTY_REIMBURSER_CLAIM_AMOUNT = new SimpleProperty.NumericDecimal(WarrantyClaimItem.class, "WrntyReimburserClaimAmount");
    @Nullable
    @ElementName(value="WrntyClaimantClaimAmount")
    @DecimalDescriptor(precision=13, scale=0)
    private BigDecimal wrntyClaimantClaimAmount;
    public static final SimpleProperty.NumericDecimal<WarrantyClaimItem> WRNTY_CLAIMANT_CLAIM_AMOUNT = new SimpleProperty.NumericDecimal(WarrantyClaimItem.class, "WrntyClaimantClaimAmount");
    @Nullable
    @ElementName(value="WrntyClaimedApprovedAmount")
    @DecimalDescriptor(precision=13, scale=0)
    private BigDecimal wrntyClaimedApprovedAmount;
    public static final SimpleProperty.NumericDecimal<WarrantyClaimItem> WRNTY_CLAIMED_APPROVED_AMOUNT = new SimpleProperty.NumericDecimal(WarrantyClaimItem.class, "WrntyClaimedApprovedAmount");
    @Nullable
    @ElementName(value="WrntyReimburseApprovedAmount")
    @DecimalDescriptor(precision=13, scale=0)
    private BigDecimal wrntyReimburseApprovedAmount;
    public static final SimpleProperty.NumericDecimal<WarrantyClaimItem> WRNTY_REIMBURSE_APPROVED_AMOUNT = new SimpleProperty.NumericDecimal(WarrantyClaimItem.class, "WrntyReimburseApprovedAmount");
    @Nullable
    @ElementName(value="WrntyCurrencyCode")
    private String wrntyCurrencyCode;
    public static final SimpleProperty.String<WarrantyClaimItem> WRNTY_CURRENCY_CODE = new SimpleProperty.String(WarrantyClaimItem.class, "WrntyCurrencyCode");
    @Nullable
    @ElementName(value="WrntyClaimItemPriceCndnAmount")
    @DecimalDescriptor(precision=24, scale=9)
    private BigDecimal wrntyClaimItemPriceCndnAmount;
    public static final SimpleProperty.NumericDecimal<WarrantyClaimItem> WRNTY_CLAIM_ITEM_PRICE_CNDN_AMOUNT = new SimpleProperty.NumericDecimal(WarrantyClaimItem.class, "WrntyClaimItemPriceCndnAmount");
    @Nullable
    @ElementName(value="WrntyClaimItemPriceCndnCrcy")
    private String wrntyClaimItemPriceCndnCrcy;
    public static final SimpleProperty.String<WarrantyClaimItem> WRNTY_CLAIM_ITEM_PRICE_CNDN_CRCY = new SimpleProperty.String(WarrantyClaimItem.class, "WrntyClaimItemPriceCndnCrcy");
    @Nullable
    @ElementName(value="WrntyClmItmDfltCndnType")
    private String wrntyClmItmDfltCndnType;
    public static final SimpleProperty.String<WarrantyClaimItem> WRNTY_CLM_ITM_DFLT_CNDN_TYPE = new SimpleProperty.String(WarrantyClaimItem.class, "WrntyClmItmDfltCndnType");
    @Nullable
    @ElementName(value="Material")
    private String material;
    public static final SimpleProperty.String<WarrantyClaimItem> MATERIAL = new SimpleProperty.String(WarrantyClaimItem.class, "Material");
    @Nullable
    @ElementName(value="WrntyReturnPartsFrmCustStatus")
    private String wrntyReturnPartsFrmCustStatus;
    public static final SimpleProperty.String<WarrantyClaimItem> WRNTY_RETURN_PARTS_FRM_CUST_STATUS = new SimpleProperty.String(WarrantyClaimItem.class, "WrntyReturnPartsFrmCustStatus");
    @Nullable
    @ElementName(value="WrntyReturnPartsToSuplrStatus")
    private String wrntyReturnPartsToSuplrStatus;
    public static final SimpleProperty.String<WarrantyClaimItem> WRNTY_RETURN_PARTS_TO_SUPLR_STATUS = new SimpleProperty.String(WarrantyClaimItem.class, "WrntyReturnPartsToSuplrStatus");
    @Nullable
    @ElementName(value="WrntyItemSuplrRetPartsDate")
    private LocalDate wrntyItemSuplrRetPartsDate;
    public static final SimpleProperty.Date<WarrantyClaimItem> WRNTY_ITEM_SUPLR_RET_PARTS_DATE = new SimpleProperty.Date(WarrantyClaimItem.class, "WrntyItemSuplrRetPartsDate");
    @Nullable
    @ElementName(value="WrntyItemCustRetPartsDate")
    private LocalDate wrntyItemCustRetPartsDate;
    public static final SimpleProperty.Date<WarrantyClaimItem> WRNTY_ITEM_CUST_RET_PARTS_DATE = new SimpleProperty.Date(WarrantyClaimItem.class, "WrntyItemCustRetPartsDate");
    @Nullable
    @ElementName(value="WrntyItmSuplrRetPartsDelivDate")
    private LocalDate wrntyItmSuplrRetPartsDelivDate;
    public static final SimpleProperty.Date<WarrantyClaimItem> WRNTY_ITM_SUPLR_RET_PARTS_DELIV_DATE = new SimpleProperty.Date(WarrantyClaimItem.class, "WrntyItmSuplrRetPartsDelivDate");
    @Nullable
    @ElementName(value="WrntyItmCustRetPartsDelivDate")
    private LocalDate wrntyItmCustRetPartsDelivDate;
    public static final SimpleProperty.Date<WarrantyClaimItem> WRNTY_ITM_CUST_RET_PARTS_DELIV_DATE = new SimpleProperty.Date(WarrantyClaimItem.class, "WrntyItmCustRetPartsDelivDate");
    @Nullable
    @ElementName(value="WarrantyClaimItemTaxCode")
    private String warrantyClaimItemTaxCode;
    public static final SimpleProperty.String<WarrantyClaimItem> WARRANTY_CLAIM_ITEM_TAX_CODE = new SimpleProperty.String(WarrantyClaimItem.class, "WarrantyClaimItemTaxCode");
    @Nullable
    @ElementName(value="WrntyClaimCreationDate")
    private LocalDate wrntyClaimCreationDate;
    public static final SimpleProperty.Date<WarrantyClaimItem> WRNTY_CLAIM_CREATION_DATE = new SimpleProperty.Date(WarrantyClaimItem.class, "WrntyClaimCreationDate");
    @Nullable
    @ElementName(value="CreatedByUser")
    private String createdByUser;
    public static final SimpleProperty.String<WarrantyClaimItem> CREATED_BY_USER = new SimpleProperty.String(WarrantyClaimItem.class, "CreatedByUser");
    @Nullable
    @ElementName(value="WrntyClaimChangedDate")
    private LocalDate wrntyClaimChangedDate;
    public static final SimpleProperty.Date<WarrantyClaimItem> WRNTY_CLAIM_CHANGED_DATE = new SimpleProperty.Date(WarrantyClaimItem.class, "WrntyClaimChangedDate");
    @Nullable
    @ElementName(value="LastChangedByUser")
    private String lastChangedByUser;
    public static final SimpleProperty.String<WarrantyClaimItem> LAST_CHANGED_BY_USER = new SimpleProperty.String(WarrantyClaimItem.class, "LastChangedByUser");
    @Nullable
    @ElementName(value="WarrantyClaimChangeDateTime")
    private OffsetDateTime warrantyClaimChangeDateTime;
    public static final SimpleProperty.DateTime<WarrantyClaimItem> WARRANTY_CLAIM_CHANGE_DATE_TIME = new SimpleProperty.DateTime(WarrantyClaimItem.class, "WarrantyClaimChangeDateTime");
    @Nullable
    @ElementName(value="SAP__Messages")
    private Collection<SAP__Message> _Messages;
    public static final ComplexProperty.Collection<WarrantyClaimItem, SAP__Message> _MESSAGES = new ComplexProperty.Collection(WarrantyClaimItem.class, "SAP__Messages", SAP__Message.class);
    @ElementName(value="_WrntyClaimHeader")
    @Nullable
    private WarrantyClaim to_WrntyClaimHeader;
    @ElementName(value="_WrntyClaimVersion")
    @Nullable
    private WarrantyClaimVersion to_WrntyClaimVersion;
    public static final NavigationProperty.Single<WarrantyClaimItem, WarrantyClaim> TO__WRNTY_CLAIM_HEADER = new NavigationProperty.Single(WarrantyClaimItem.class, "_WrntyClaimHeader", WarrantyClaim.class);
    public static final NavigationProperty.Single<WarrantyClaimItem, WarrantyClaimVersion> TO__WRNTY_CLAIM_VERSION = new NavigationProperty.Single(WarrantyClaimItem.class, "_WrntyClaimVersion", WarrantyClaimVersion.class);

    @Nonnull
    public Class<WarrantyClaimItem> getType() {
        return WarrantyClaimItem.class;
    }

    public void setWrntyItemUUID(@Nullable UUID wrntyItemUUID) {
        this.rememberChangedField("WrntyItemUUID", this.wrntyItemUUID);
        this.wrntyItemUUID = wrntyItemUUID;
    }

    public void setWrntyClaimHeaderUUID(@Nullable UUID wrntyClaimHeaderUUID) {
        this.rememberChangedField("WrntyClaimHeaderUUID", this.wrntyClaimHeaderUUID);
        this.wrntyClaimHeaderUUID = wrntyClaimHeaderUUID;
    }

    public void setWrntyVersionUUID(@Nullable UUID wrntyVersionUUID) {
        this.rememberChangedField("WrntyVersionUUID", this.wrntyVersionUUID);
        this.wrntyVersionUUID = wrntyVersionUUID;
    }

    public void setWarrantyItemKey(@Nullable String warrantyItemKey) {
        this.rememberChangedField("WarrantyItemKey", this.warrantyItemKey);
        this.warrantyItemKey = warrantyItemKey;
    }

    public void setWarrantyClaimItemNumber(@Nullable String warrantyClaimItemNumber) {
        this.rememberChangedField("WarrantyClaimItemNumber", this.warrantyClaimItemNumber);
        this.warrantyClaimItemNumber = warrantyClaimItemNumber;
    }

    public void setWrntyControllingItemType(@Nullable String wrntyControllingItemType) {
        this.rememberChangedField("WrntyControllingItemType", this.wrntyControllingItemType);
        this.wrntyControllingItemType = wrntyControllingItemType;
    }

    public void setWarrantyItemType(@Nullable String warrantyItemType) {
        this.rememberChangedField("WarrantyItemType", this.warrantyItemType);
        this.warrantyItemType = warrantyItemType;
    }

    public void setWarrantyClaimCatalog(@Nullable String warrantyClaimCatalog) {
        this.rememberChangedField("WarrantyClaimCatalog", this.warrantyClaimCatalog);
        this.warrantyClaimCatalog = warrantyClaimCatalog;
    }

    public void setWarrantyClaimItemDefectCode(@Nullable String warrantyClaimItemDefectCode) {
        this.rememberChangedField("WarrantyClaimItemDefectCode", this.warrantyClaimItemDefectCode);
        this.warrantyClaimItemDefectCode = warrantyClaimItemDefectCode;
    }

    public void setWrntyClaimQuantity(@Nullable BigDecimal wrntyClaimQuantity) {
        this.rememberChangedField("WrntyClaimQuantity", this.wrntyClaimQuantity);
        this.wrntyClaimQuantity = wrntyClaimQuantity;
    }

    public void setQuantityUnit(@Nullable String quantityUnit) {
        this.rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    public void setWarrantyClaimItemDecisionCode(@Nullable String warrantyClaimItemDecisionCode) {
        this.rememberChangedField("WarrantyClaimItemDecisionCode", this.warrantyClaimItemDecisionCode);
        this.warrantyClaimItemDecisionCode = warrantyClaimItemDecisionCode;
    }

    public void setWrntyClmPartsIsCausingDamage(@Nullable String wrntyClmPartsIsCausingDamage) {
        this.rememberChangedField("WrntyClmPartsIsCausingDamage", this.wrntyClmPartsIsCausingDamage);
        this.wrntyClmPartsIsCausingDamage = wrntyClmPartsIsCausingDamage;
    }

    public void setWrntyReimburserClaimAmount(@Nullable BigDecimal wrntyReimburserClaimAmount) {
        this.rememberChangedField("WrntyReimburserClaimAmount", this.wrntyReimburserClaimAmount);
        this.wrntyReimburserClaimAmount = wrntyReimburserClaimAmount;
    }

    public void setWrntyClaimantClaimAmount(@Nullable BigDecimal wrntyClaimantClaimAmount) {
        this.rememberChangedField("WrntyClaimantClaimAmount", this.wrntyClaimantClaimAmount);
        this.wrntyClaimantClaimAmount = wrntyClaimantClaimAmount;
    }

    public void setWrntyClaimedApprovedAmount(@Nullable BigDecimal wrntyClaimedApprovedAmount) {
        this.rememberChangedField("WrntyClaimedApprovedAmount", this.wrntyClaimedApprovedAmount);
        this.wrntyClaimedApprovedAmount = wrntyClaimedApprovedAmount;
    }

    public void setWrntyReimburseApprovedAmount(@Nullable BigDecimal wrntyReimburseApprovedAmount) {
        this.rememberChangedField("WrntyReimburseApprovedAmount", this.wrntyReimburseApprovedAmount);
        this.wrntyReimburseApprovedAmount = wrntyReimburseApprovedAmount;
    }

    public void setWrntyCurrencyCode(@Nullable String wrntyCurrencyCode) {
        this.rememberChangedField("WrntyCurrencyCode", this.wrntyCurrencyCode);
        this.wrntyCurrencyCode = wrntyCurrencyCode;
    }

    public void setWrntyClaimItemPriceCndnAmount(@Nullable BigDecimal wrntyClaimItemPriceCndnAmount) {
        this.rememberChangedField("WrntyClaimItemPriceCndnAmount", this.wrntyClaimItemPriceCndnAmount);
        this.wrntyClaimItemPriceCndnAmount = wrntyClaimItemPriceCndnAmount;
    }

    public void setWrntyClaimItemPriceCndnCrcy(@Nullable String wrntyClaimItemPriceCndnCrcy) {
        this.rememberChangedField("WrntyClaimItemPriceCndnCrcy", this.wrntyClaimItemPriceCndnCrcy);
        this.wrntyClaimItemPriceCndnCrcy = wrntyClaimItemPriceCndnCrcy;
    }

    public void setWrntyClmItmDfltCndnType(@Nullable String wrntyClmItmDfltCndnType) {
        this.rememberChangedField("WrntyClmItmDfltCndnType", this.wrntyClmItmDfltCndnType);
        this.wrntyClmItmDfltCndnType = wrntyClmItmDfltCndnType;
    }

    public void setMaterial(@Nullable String material) {
        this.rememberChangedField("Material", this.material);
        this.material = material;
    }

    public void setWrntyReturnPartsFrmCustStatus(@Nullable String wrntyReturnPartsFrmCustStatus) {
        this.rememberChangedField("WrntyReturnPartsFrmCustStatus", this.wrntyReturnPartsFrmCustStatus);
        this.wrntyReturnPartsFrmCustStatus = wrntyReturnPartsFrmCustStatus;
    }

    public void setWrntyReturnPartsToSuplrStatus(@Nullable String wrntyReturnPartsToSuplrStatus) {
        this.rememberChangedField("WrntyReturnPartsToSuplrStatus", this.wrntyReturnPartsToSuplrStatus);
        this.wrntyReturnPartsToSuplrStatus = wrntyReturnPartsToSuplrStatus;
    }

    public void setWrntyItemSuplrRetPartsDate(@Nullable LocalDate wrntyItemSuplrRetPartsDate) {
        this.rememberChangedField("WrntyItemSuplrRetPartsDate", this.wrntyItemSuplrRetPartsDate);
        this.wrntyItemSuplrRetPartsDate = wrntyItemSuplrRetPartsDate;
    }

    public void setWrntyItemCustRetPartsDate(@Nullable LocalDate wrntyItemCustRetPartsDate) {
        this.rememberChangedField("WrntyItemCustRetPartsDate", this.wrntyItemCustRetPartsDate);
        this.wrntyItemCustRetPartsDate = wrntyItemCustRetPartsDate;
    }

    public void setWrntyItmSuplrRetPartsDelivDate(@Nullable LocalDate wrntyItmSuplrRetPartsDelivDate) {
        this.rememberChangedField("WrntyItmSuplrRetPartsDelivDate", this.wrntyItmSuplrRetPartsDelivDate);
        this.wrntyItmSuplrRetPartsDelivDate = wrntyItmSuplrRetPartsDelivDate;
    }

    public void setWrntyItmCustRetPartsDelivDate(@Nullable LocalDate wrntyItmCustRetPartsDelivDate) {
        this.rememberChangedField("WrntyItmCustRetPartsDelivDate", this.wrntyItmCustRetPartsDelivDate);
        this.wrntyItmCustRetPartsDelivDate = wrntyItmCustRetPartsDelivDate;
    }

    public void setWarrantyClaimItemTaxCode(@Nullable String warrantyClaimItemTaxCode) {
        this.rememberChangedField("WarrantyClaimItemTaxCode", this.warrantyClaimItemTaxCode);
        this.warrantyClaimItemTaxCode = warrantyClaimItemTaxCode;
    }

    public void setWrntyClaimCreationDate(@Nullable LocalDate wrntyClaimCreationDate) {
        this.rememberChangedField("WrntyClaimCreationDate", this.wrntyClaimCreationDate);
        this.wrntyClaimCreationDate = wrntyClaimCreationDate;
    }

    public void setCreatedByUser(@Nullable String createdByUser) {
        this.rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    public void setWrntyClaimChangedDate(@Nullable LocalDate wrntyClaimChangedDate) {
        this.rememberChangedField("WrntyClaimChangedDate", this.wrntyClaimChangedDate);
        this.wrntyClaimChangedDate = wrntyClaimChangedDate;
    }

    public void setLastChangedByUser(@Nullable String lastChangedByUser) {
        this.rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    public void setWarrantyClaimChangeDateTime(@Nullable OffsetDateTime warrantyClaimChangeDateTime) {
        this.rememberChangedField("WarrantyClaimChangeDateTime", this.warrantyClaimChangeDateTime);
        this.warrantyClaimChangeDateTime = warrantyClaimChangeDateTime;
    }

    public void set_Messages(@Nullable Collection<SAP__Message> _Messages) {
        this.rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    protected String getEntityCollection() {
        return "WarrantyClaimItem";
    }

    @Nonnull
    protected ODataEntityKey getKey() {
        ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("WrntyItemUUID", (Object)this.getWrntyItemUUID());
        return entityKey;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("WrntyItemUUID", this.getWrntyItemUUID());
        values.put("WrntyClaimHeaderUUID", this.getWrntyClaimHeaderUUID());
        values.put("WrntyVersionUUID", this.getWrntyVersionUUID());
        values.put("WarrantyItemKey", this.getWarrantyItemKey());
        values.put("WarrantyClaimItemNumber", this.getWarrantyClaimItemNumber());
        values.put("WrntyControllingItemType", this.getWrntyControllingItemType());
        values.put("WarrantyItemType", this.getWarrantyItemType());
        values.put("WarrantyClaimCatalog", this.getWarrantyClaimCatalog());
        values.put("WarrantyClaimItemDefectCode", this.getWarrantyClaimItemDefectCode());
        values.put("WrntyClaimQuantity", this.getWrntyClaimQuantity());
        values.put("QuantityUnit", this.getQuantityUnit());
        values.put("WarrantyClaimItemDecisionCode", this.getWarrantyClaimItemDecisionCode());
        values.put("WrntyClmPartsIsCausingDamage", this.getWrntyClmPartsIsCausingDamage());
        values.put("WrntyReimburserClaimAmount", this.getWrntyReimburserClaimAmount());
        values.put("WrntyClaimantClaimAmount", this.getWrntyClaimantClaimAmount());
        values.put("WrntyClaimedApprovedAmount", this.getWrntyClaimedApprovedAmount());
        values.put("WrntyReimburseApprovedAmount", this.getWrntyReimburseApprovedAmount());
        values.put("WrntyCurrencyCode", this.getWrntyCurrencyCode());
        values.put("WrntyClaimItemPriceCndnAmount", this.getWrntyClaimItemPriceCndnAmount());
        values.put("WrntyClaimItemPriceCndnCrcy", this.getWrntyClaimItemPriceCndnCrcy());
        values.put("WrntyClmItmDfltCndnType", this.getWrntyClmItmDfltCndnType());
        values.put("Material", this.getMaterial());
        values.put("WrntyReturnPartsFrmCustStatus", this.getWrntyReturnPartsFrmCustStatus());
        values.put("WrntyReturnPartsToSuplrStatus", this.getWrntyReturnPartsToSuplrStatus());
        values.put("WrntyItemSuplrRetPartsDate", this.getWrntyItemSuplrRetPartsDate());
        values.put("WrntyItemCustRetPartsDate", this.getWrntyItemCustRetPartsDate());
        values.put("WrntyItmSuplrRetPartsDelivDate", this.getWrntyItmSuplrRetPartsDelivDate());
        values.put("WrntyItmCustRetPartsDelivDate", this.getWrntyItmCustRetPartsDelivDate());
        values.put("WarrantyClaimItemTaxCode", this.getWarrantyClaimItemTaxCode());
        values.put("WrntyClaimCreationDate", this.getWrntyClaimCreationDate());
        values.put("CreatedByUser", this.getCreatedByUser());
        values.put("WrntyClaimChangedDate", this.getWrntyClaimChangedDate());
        values.put("LastChangedByUser", this.getLastChangedByUser());
        values.put("WarrantyClaimChangeDateTime", this.getWarrantyClaimChangeDateTime());
        values.put("SAP__Messages", this.get_Messages());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Map inputMap;
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("WrntyItemUUID") && ((value = values.remove("WrntyItemUUID")) == null || !value.equals(this.getWrntyItemUUID()))) {
            this.setWrntyItemUUID((UUID)value);
        }
        if (values.containsKey("WrntyClaimHeaderUUID") && ((value = values.remove("WrntyClaimHeaderUUID")) == null || !value.equals(this.getWrntyClaimHeaderUUID()))) {
            this.setWrntyClaimHeaderUUID((UUID)value);
        }
        if (values.containsKey("WrntyVersionUUID") && ((value = values.remove("WrntyVersionUUID")) == null || !value.equals(this.getWrntyVersionUUID()))) {
            this.setWrntyVersionUUID((UUID)value);
        }
        if (values.containsKey("WarrantyItemKey") && ((value = values.remove("WarrantyItemKey")) == null || !value.equals(this.getWarrantyItemKey()))) {
            this.setWarrantyItemKey((String)value);
        }
        if (values.containsKey("WarrantyClaimItemNumber") && ((value = values.remove("WarrantyClaimItemNumber")) == null || !value.equals(this.getWarrantyClaimItemNumber()))) {
            this.setWarrantyClaimItemNumber((String)value);
        }
        if (values.containsKey("WrntyControllingItemType") && ((value = values.remove("WrntyControllingItemType")) == null || !value.equals(this.getWrntyControllingItemType()))) {
            this.setWrntyControllingItemType((String)value);
        }
        if (values.containsKey("WarrantyItemType") && ((value = values.remove("WarrantyItemType")) == null || !value.equals(this.getWarrantyItemType()))) {
            this.setWarrantyItemType((String)value);
        }
        if (values.containsKey("WarrantyClaimCatalog") && ((value = values.remove("WarrantyClaimCatalog")) == null || !value.equals(this.getWarrantyClaimCatalog()))) {
            this.setWarrantyClaimCatalog((String)value);
        }
        if (values.containsKey("WarrantyClaimItemDefectCode") && ((value = values.remove("WarrantyClaimItemDefectCode")) == null || !value.equals(this.getWarrantyClaimItemDefectCode()))) {
            this.setWarrantyClaimItemDefectCode((String)value);
        }
        if (values.containsKey("WrntyClaimQuantity") && ((value = values.remove("WrntyClaimQuantity")) == null || !value.equals(this.getWrntyClaimQuantity()))) {
            this.setWrntyClaimQuantity((BigDecimal)value);
        }
        if (values.containsKey("QuantityUnit") && ((value = values.remove("QuantityUnit")) == null || !value.equals(this.getQuantityUnit()))) {
            this.setQuantityUnit((String)value);
        }
        if (values.containsKey("WarrantyClaimItemDecisionCode") && ((value = values.remove("WarrantyClaimItemDecisionCode")) == null || !value.equals(this.getWarrantyClaimItemDecisionCode()))) {
            this.setWarrantyClaimItemDecisionCode((String)value);
        }
        if (values.containsKey("WrntyClmPartsIsCausingDamage") && ((value = values.remove("WrntyClmPartsIsCausingDamage")) == null || !value.equals(this.getWrntyClmPartsIsCausingDamage()))) {
            this.setWrntyClmPartsIsCausingDamage((String)value);
        }
        if (values.containsKey("WrntyReimburserClaimAmount") && ((value = values.remove("WrntyReimburserClaimAmount")) == null || !value.equals(this.getWrntyReimburserClaimAmount()))) {
            this.setWrntyReimburserClaimAmount((BigDecimal)value);
        }
        if (values.containsKey("WrntyClaimantClaimAmount") && ((value = values.remove("WrntyClaimantClaimAmount")) == null || !value.equals(this.getWrntyClaimantClaimAmount()))) {
            this.setWrntyClaimantClaimAmount((BigDecimal)value);
        }
        if (values.containsKey("WrntyClaimedApprovedAmount") && ((value = values.remove("WrntyClaimedApprovedAmount")) == null || !value.equals(this.getWrntyClaimedApprovedAmount()))) {
            this.setWrntyClaimedApprovedAmount((BigDecimal)value);
        }
        if (values.containsKey("WrntyReimburseApprovedAmount") && ((value = values.remove("WrntyReimburseApprovedAmount")) == null || !value.equals(this.getWrntyReimburseApprovedAmount()))) {
            this.setWrntyReimburseApprovedAmount((BigDecimal)value);
        }
        if (values.containsKey("WrntyCurrencyCode") && ((value = values.remove("WrntyCurrencyCode")) == null || !value.equals(this.getWrntyCurrencyCode()))) {
            this.setWrntyCurrencyCode((String)value);
        }
        if (values.containsKey("WrntyClaimItemPriceCndnAmount") && ((value = values.remove("WrntyClaimItemPriceCndnAmount")) == null || !value.equals(this.getWrntyClaimItemPriceCndnAmount()))) {
            this.setWrntyClaimItemPriceCndnAmount((BigDecimal)value);
        }
        if (values.containsKey("WrntyClaimItemPriceCndnCrcy") && ((value = values.remove("WrntyClaimItemPriceCndnCrcy")) == null || !value.equals(this.getWrntyClaimItemPriceCndnCrcy()))) {
            this.setWrntyClaimItemPriceCndnCrcy((String)value);
        }
        if (values.containsKey("WrntyClmItmDfltCndnType") && ((value = values.remove("WrntyClmItmDfltCndnType")) == null || !value.equals(this.getWrntyClmItmDfltCndnType()))) {
            this.setWrntyClmItmDfltCndnType((String)value);
        }
        if (values.containsKey("Material") && ((value = values.remove("Material")) == null || !value.equals(this.getMaterial()))) {
            this.setMaterial((String)value);
        }
        if (values.containsKey("WrntyReturnPartsFrmCustStatus") && ((value = values.remove("WrntyReturnPartsFrmCustStatus")) == null || !value.equals(this.getWrntyReturnPartsFrmCustStatus()))) {
            this.setWrntyReturnPartsFrmCustStatus((String)value);
        }
        if (values.containsKey("WrntyReturnPartsToSuplrStatus") && ((value = values.remove("WrntyReturnPartsToSuplrStatus")) == null || !value.equals(this.getWrntyReturnPartsToSuplrStatus()))) {
            this.setWrntyReturnPartsToSuplrStatus((String)value);
        }
        if (values.containsKey("WrntyItemSuplrRetPartsDate") && ((value = values.remove("WrntyItemSuplrRetPartsDate")) == null || !value.equals(this.getWrntyItemSuplrRetPartsDate()))) {
            this.setWrntyItemSuplrRetPartsDate((LocalDate)value);
        }
        if (values.containsKey("WrntyItemCustRetPartsDate") && ((value = values.remove("WrntyItemCustRetPartsDate")) == null || !value.equals(this.getWrntyItemCustRetPartsDate()))) {
            this.setWrntyItemCustRetPartsDate((LocalDate)value);
        }
        if (values.containsKey("WrntyItmSuplrRetPartsDelivDate") && ((value = values.remove("WrntyItmSuplrRetPartsDelivDate")) == null || !value.equals(this.getWrntyItmSuplrRetPartsDelivDate()))) {
            this.setWrntyItmSuplrRetPartsDelivDate((LocalDate)value);
        }
        if (values.containsKey("WrntyItmCustRetPartsDelivDate") && ((value = values.remove("WrntyItmCustRetPartsDelivDate")) == null || !value.equals(this.getWrntyItmCustRetPartsDelivDate()))) {
            this.setWrntyItmCustRetPartsDelivDate((LocalDate)value);
        }
        if (values.containsKey("WarrantyClaimItemTaxCode") && ((value = values.remove("WarrantyClaimItemTaxCode")) == null || !value.equals(this.getWarrantyClaimItemTaxCode()))) {
            this.setWarrantyClaimItemTaxCode((String)value);
        }
        if (values.containsKey("WrntyClaimCreationDate") && ((value = values.remove("WrntyClaimCreationDate")) == null || !value.equals(this.getWrntyClaimCreationDate()))) {
            this.setWrntyClaimCreationDate((LocalDate)value);
        }
        if (values.containsKey("CreatedByUser") && ((value = values.remove("CreatedByUser")) == null || !value.equals(this.getCreatedByUser()))) {
            this.setCreatedByUser((String)value);
        }
        if (values.containsKey("WrntyClaimChangedDate") && ((value = values.remove("WrntyClaimChangedDate")) == null || !value.equals(this.getWrntyClaimChangedDate()))) {
            this.setWrntyClaimChangedDate((LocalDate)value);
        }
        if (values.containsKey("LastChangedByUser") && ((value = values.remove("LastChangedByUser")) == null || !value.equals(this.getLastChangedByUser()))) {
            this.setLastChangedByUser((String)value);
        }
        if (values.containsKey("WarrantyClaimChangeDateTime") && ((value = values.remove("WarrantyClaimChangeDateTime")) == null || !value.equals(this.getWarrantyClaimChangeDateTime()))) {
            this.setWarrantyClaimChangeDateTime((OffsetDateTime)value);
        }
        if (values.containsKey("SAP__Messages")) {
            value = values.remove("SAP__Messages");
            if (value instanceof Iterable) {
                LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                for (Object properties : (Iterable)value) {
                    if (!(properties instanceof Map)) continue;
                    SAP__Message item = new SAP__Message();
                    Map inputMap2 = (Map)value;
                    item.fromMap(inputMap2);
                    _Messages.add(item);
                }
                this.set_Messages(_Messages);
            }
            if (value == null && this.get_Messages() != null) {
                this.set_Messages(null);
            }
        }
        if (values.containsKey("_WrntyClaimHeader") && (value = values.remove("_WrntyClaimHeader")) instanceof Map) {
            if (this.to_WrntyClaimHeader == null) {
                this.to_WrntyClaimHeader = new WarrantyClaim();
            }
            inputMap = (Map)value;
            this.to_WrntyClaimHeader.fromMap(inputMap);
        }
        if (values.containsKey("_WrntyClaimVersion") && (value = values.remove("_WrntyClaimVersion")) instanceof Map) {
            if (this.to_WrntyClaimVersion == null) {
                this.to_WrntyClaimVersion = new WarrantyClaimVersion();
            }
            inputMap = (Map)value;
            this.to_WrntyClaimVersion.fromMap(inputMap);
        }
        super.fromMap((Map)values);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata4/sap/api_warrantyclaim/srvd_a2x/sap/warrantyclaim/0001";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.to_WrntyClaimHeader != null) {
            values.put("_WrntyClaimHeader", this.to_WrntyClaimHeader);
        }
        if (this.to_WrntyClaimVersion != null) {
            values.put("_WrntyClaimVersion", this.to_WrntyClaimVersion);
        }
        return values;
    }

    @Nonnull
    public Option<WarrantyClaim> getWrntyClaimHeaderIfPresent() {
        return Option.of((Object)((Object)this.to_WrntyClaimHeader));
    }

    public void setWrntyClaimHeader(WarrantyClaim value) {
        this.to_WrntyClaimHeader = value;
    }

    @Nonnull
    public Option<WarrantyClaimVersion> getWrntyClaimVersionIfPresent() {
        return Option.of((Object)((Object)this.to_WrntyClaimVersion));
    }

    public void setWrntyClaimVersion(WarrantyClaimVersion value) {
        this.to_WrntyClaimVersion = value;
    }

    @Nonnull
    public static BoundAction.SingleToSingle<WarrantyClaimItem, WarrantyClaimItem> confirmCustomerReturnParts() {
        Map parameters = Collections.emptyMap();
        return new BoundAction.SingleToSingle(WarrantyClaimItem.class, WarrantyClaimItem.class, "com.sap.gateway.srvd_a2x.api_warrantyclaim.v0001.ConfirmCustomerReturnParts", parameters);
    }

    @Nonnull
    @Generated
    public static WarrantyClaimItemBuilder builder() {
        return new WarrantyClaimItemBuilder();
    }

    @Nullable
    @Generated
    public UUID getWrntyItemUUID() {
        return this.wrntyItemUUID;
    }

    @Nullable
    @Generated
    public UUID getWrntyClaimHeaderUUID() {
        return this.wrntyClaimHeaderUUID;
    }

    @Nullable
    @Generated
    public UUID getWrntyVersionUUID() {
        return this.wrntyVersionUUID;
    }

    @Nullable
    @Generated
    public String getWarrantyItemKey() {
        return this.warrantyItemKey;
    }

    @Nullable
    @Generated
    public String getWarrantyClaimItemNumber() {
        return this.warrantyClaimItemNumber;
    }

    @Nullable
    @Generated
    public String getWrntyControllingItemType() {
        return this.wrntyControllingItemType;
    }

    @Nullable
    @Generated
    public String getWarrantyItemType() {
        return this.warrantyItemType;
    }

    @Nullable
    @Generated
    public String getWarrantyClaimCatalog() {
        return this.warrantyClaimCatalog;
    }

    @Nullable
    @Generated
    public String getWarrantyClaimItemDefectCode() {
        return this.warrantyClaimItemDefectCode;
    }

    @Nullable
    @Generated
    public BigDecimal getWrntyClaimQuantity() {
        return this.wrntyClaimQuantity;
    }

    @Nullable
    @Generated
    public String getQuantityUnit() {
        return this.quantityUnit;
    }

    @Nullable
    @Generated
    public String getWarrantyClaimItemDecisionCode() {
        return this.warrantyClaimItemDecisionCode;
    }

    @Nullable
    @Generated
    public String getWrntyClmPartsIsCausingDamage() {
        return this.wrntyClmPartsIsCausingDamage;
    }

    @Nullable
    @Generated
    public BigDecimal getWrntyReimburserClaimAmount() {
        return this.wrntyReimburserClaimAmount;
    }

    @Nullable
    @Generated
    public BigDecimal getWrntyClaimantClaimAmount() {
        return this.wrntyClaimantClaimAmount;
    }

    @Nullable
    @Generated
    public BigDecimal getWrntyClaimedApprovedAmount() {
        return this.wrntyClaimedApprovedAmount;
    }

    @Nullable
    @Generated
    public BigDecimal getWrntyReimburseApprovedAmount() {
        return this.wrntyReimburseApprovedAmount;
    }

    @Nullable
    @Generated
    public String getWrntyCurrencyCode() {
        return this.wrntyCurrencyCode;
    }

    @Nullable
    @Generated
    public BigDecimal getWrntyClaimItemPriceCndnAmount() {
        return this.wrntyClaimItemPriceCndnAmount;
    }

    @Nullable
    @Generated
    public String getWrntyClaimItemPriceCndnCrcy() {
        return this.wrntyClaimItemPriceCndnCrcy;
    }

    @Nullable
    @Generated
    public String getWrntyClmItmDfltCndnType() {
        return this.wrntyClmItmDfltCndnType;
    }

    @Nullable
    @Generated
    public String getMaterial() {
        return this.material;
    }

    @Nullable
    @Generated
    public String getWrntyReturnPartsFrmCustStatus() {
        return this.wrntyReturnPartsFrmCustStatus;
    }

    @Nullable
    @Generated
    public String getWrntyReturnPartsToSuplrStatus() {
        return this.wrntyReturnPartsToSuplrStatus;
    }

    @Nullable
    @Generated
    public LocalDate getWrntyItemSuplrRetPartsDate() {
        return this.wrntyItemSuplrRetPartsDate;
    }

    @Nullable
    @Generated
    public LocalDate getWrntyItemCustRetPartsDate() {
        return this.wrntyItemCustRetPartsDate;
    }

    @Nullable
    @Generated
    public LocalDate getWrntyItmSuplrRetPartsDelivDate() {
        return this.wrntyItmSuplrRetPartsDelivDate;
    }

    @Nullable
    @Generated
    public LocalDate getWrntyItmCustRetPartsDelivDate() {
        return this.wrntyItmCustRetPartsDelivDate;
    }

    @Nullable
    @Generated
    public String getWarrantyClaimItemTaxCode() {
        return this.warrantyClaimItemTaxCode;
    }

    @Nullable
    @Generated
    public LocalDate getWrntyClaimCreationDate() {
        return this.wrntyClaimCreationDate;
    }

    @Nullable
    @Generated
    public String getCreatedByUser() {
        return this.createdByUser;
    }

    @Nullable
    @Generated
    public LocalDate getWrntyClaimChangedDate() {
        return this.wrntyClaimChangedDate;
    }

    @Nullable
    @Generated
    public String getLastChangedByUser() {
        return this.lastChangedByUser;
    }

    @Nullable
    @Generated
    public OffsetDateTime getWarrantyClaimChangeDateTime() {
        return this.warrantyClaimChangeDateTime;
    }

    @Nullable
    @Generated
    public Collection<SAP__Message> get_Messages() {
        return this._Messages;
    }

    @Generated
    public WarrantyClaimItem() {
    }

    @Generated
    public WarrantyClaimItem(@Nullable UUID wrntyItemUUID, @Nullable UUID wrntyClaimHeaderUUID, @Nullable UUID wrntyVersionUUID, @Nullable String warrantyItemKey, @Nullable String warrantyClaimItemNumber, @Nullable String wrntyControllingItemType, @Nullable String warrantyItemType, @Nullable String warrantyClaimCatalog, @Nullable String warrantyClaimItemDefectCode, @Nullable BigDecimal wrntyClaimQuantity, @Nullable String quantityUnit, @Nullable String warrantyClaimItemDecisionCode, @Nullable String wrntyClmPartsIsCausingDamage, @Nullable BigDecimal wrntyReimburserClaimAmount, @Nullable BigDecimal wrntyClaimantClaimAmount, @Nullable BigDecimal wrntyClaimedApprovedAmount, @Nullable BigDecimal wrntyReimburseApprovedAmount, @Nullable String wrntyCurrencyCode, @Nullable BigDecimal wrntyClaimItemPriceCndnAmount, @Nullable String wrntyClaimItemPriceCndnCrcy, @Nullable String wrntyClmItmDfltCndnType, @Nullable String material, @Nullable String wrntyReturnPartsFrmCustStatus, @Nullable String wrntyReturnPartsToSuplrStatus, @Nullable LocalDate wrntyItemSuplrRetPartsDate, @Nullable LocalDate wrntyItemCustRetPartsDate, @Nullable LocalDate wrntyItmSuplrRetPartsDelivDate, @Nullable LocalDate wrntyItmCustRetPartsDelivDate, @Nullable String warrantyClaimItemTaxCode, @Nullable LocalDate wrntyClaimCreationDate, @Nullable String createdByUser, @Nullable LocalDate wrntyClaimChangedDate, @Nullable String lastChangedByUser, @Nullable OffsetDateTime warrantyClaimChangeDateTime, @Nullable Collection<SAP__Message> _Messages, @Nullable WarrantyClaim to_WrntyClaimHeader, @Nullable WarrantyClaimVersion to_WrntyClaimVersion) {
        this.wrntyItemUUID = wrntyItemUUID;
        this.wrntyClaimHeaderUUID = wrntyClaimHeaderUUID;
        this.wrntyVersionUUID = wrntyVersionUUID;
        this.warrantyItemKey = warrantyItemKey;
        this.warrantyClaimItemNumber = warrantyClaimItemNumber;
        this.wrntyControllingItemType = wrntyControllingItemType;
        this.warrantyItemType = warrantyItemType;
        this.warrantyClaimCatalog = warrantyClaimCatalog;
        this.warrantyClaimItemDefectCode = warrantyClaimItemDefectCode;
        this.wrntyClaimQuantity = wrntyClaimQuantity;
        this.quantityUnit = quantityUnit;
        this.warrantyClaimItemDecisionCode = warrantyClaimItemDecisionCode;
        this.wrntyClmPartsIsCausingDamage = wrntyClmPartsIsCausingDamage;
        this.wrntyReimburserClaimAmount = wrntyReimburserClaimAmount;
        this.wrntyClaimantClaimAmount = wrntyClaimantClaimAmount;
        this.wrntyClaimedApprovedAmount = wrntyClaimedApprovedAmount;
        this.wrntyReimburseApprovedAmount = wrntyReimburseApprovedAmount;
        this.wrntyCurrencyCode = wrntyCurrencyCode;
        this.wrntyClaimItemPriceCndnAmount = wrntyClaimItemPriceCndnAmount;
        this.wrntyClaimItemPriceCndnCrcy = wrntyClaimItemPriceCndnCrcy;
        this.wrntyClmItmDfltCndnType = wrntyClmItmDfltCndnType;
        this.material = material;
        this.wrntyReturnPartsFrmCustStatus = wrntyReturnPartsFrmCustStatus;
        this.wrntyReturnPartsToSuplrStatus = wrntyReturnPartsToSuplrStatus;
        this.wrntyItemSuplrRetPartsDate = wrntyItemSuplrRetPartsDate;
        this.wrntyItemCustRetPartsDate = wrntyItemCustRetPartsDate;
        this.wrntyItmSuplrRetPartsDelivDate = wrntyItmSuplrRetPartsDelivDate;
        this.wrntyItmCustRetPartsDelivDate = wrntyItmCustRetPartsDelivDate;
        this.warrantyClaimItemTaxCode = warrantyClaimItemTaxCode;
        this.wrntyClaimCreationDate = wrntyClaimCreationDate;
        this.createdByUser = createdByUser;
        this.wrntyClaimChangedDate = wrntyClaimChangedDate;
        this.lastChangedByUser = lastChangedByUser;
        this.warrantyClaimChangeDateTime = warrantyClaimChangeDateTime;
        this._Messages = _Messages;
        this.to_WrntyClaimHeader = to_WrntyClaimHeader;
        this.to_WrntyClaimVersion = to_WrntyClaimVersion;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "WarrantyClaimItem(super=" + super.toString() + ", odataType=" + this.odataType + ", wrntyItemUUID=" + this.wrntyItemUUID + ", wrntyClaimHeaderUUID=" + this.wrntyClaimHeaderUUID + ", wrntyVersionUUID=" + this.wrntyVersionUUID + ", warrantyItemKey=" + this.warrantyItemKey + ", warrantyClaimItemNumber=" + this.warrantyClaimItemNumber + ", wrntyControllingItemType=" + this.wrntyControllingItemType + ", warrantyItemType=" + this.warrantyItemType + ", warrantyClaimCatalog=" + this.warrantyClaimCatalog + ", warrantyClaimItemDefectCode=" + this.warrantyClaimItemDefectCode + ", wrntyClaimQuantity=" + this.wrntyClaimQuantity + ", quantityUnit=" + this.quantityUnit + ", warrantyClaimItemDecisionCode=" + this.warrantyClaimItemDecisionCode + ", wrntyClmPartsIsCausingDamage=" + this.wrntyClmPartsIsCausingDamage + ", wrntyReimburserClaimAmount=" + this.wrntyReimburserClaimAmount + ", wrntyClaimantClaimAmount=" + this.wrntyClaimantClaimAmount + ", wrntyClaimedApprovedAmount=" + this.wrntyClaimedApprovedAmount + ", wrntyReimburseApprovedAmount=" + this.wrntyReimburseApprovedAmount + ", wrntyCurrencyCode=" + this.wrntyCurrencyCode + ", wrntyClaimItemPriceCndnAmount=" + this.wrntyClaimItemPriceCndnAmount + ", wrntyClaimItemPriceCndnCrcy=" + this.wrntyClaimItemPriceCndnCrcy + ", wrntyClmItmDfltCndnType=" + this.wrntyClmItmDfltCndnType + ", material=" + this.material + ", wrntyReturnPartsFrmCustStatus=" + this.wrntyReturnPartsFrmCustStatus + ", wrntyReturnPartsToSuplrStatus=" + this.wrntyReturnPartsToSuplrStatus + ", wrntyItemSuplrRetPartsDate=" + this.wrntyItemSuplrRetPartsDate + ", wrntyItemCustRetPartsDate=" + this.wrntyItemCustRetPartsDate + ", wrntyItmSuplrRetPartsDelivDate=" + this.wrntyItmSuplrRetPartsDelivDate + ", wrntyItmCustRetPartsDelivDate=" + this.wrntyItmCustRetPartsDelivDate + ", warrantyClaimItemTaxCode=" + this.warrantyClaimItemTaxCode + ", wrntyClaimCreationDate=" + this.wrntyClaimCreationDate + ", createdByUser=" + this.createdByUser + ", wrntyClaimChangedDate=" + this.wrntyClaimChangedDate + ", lastChangedByUser=" + this.lastChangedByUser + ", warrantyClaimChangeDateTime=" + this.warrantyClaimChangeDateTime + ", _Messages=" + this._Messages + ", to_WrntyClaimHeader=" + (Object)((Object)this.to_WrntyClaimHeader) + ", to_WrntyClaimVersion=" + (Object)((Object)this.to_WrntyClaimVersion) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WarrantyClaimItem)) {
            return false;
        }
        WarrantyClaimItem other = (WarrantyClaimItem)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$odataType = this.odataType;
        String other$odataType = other.odataType;
        if (this$odataType == null ? other$odataType != null : !this$odataType.equals(other$odataType)) {
            return false;
        }
        UUID this$wrntyItemUUID = this.wrntyItemUUID;
        UUID other$wrntyItemUUID = other.wrntyItemUUID;
        if (this$wrntyItemUUID == null ? other$wrntyItemUUID != null : !((Object)this$wrntyItemUUID).equals(other$wrntyItemUUID)) {
            return false;
        }
        UUID this$wrntyClaimHeaderUUID = this.wrntyClaimHeaderUUID;
        UUID other$wrntyClaimHeaderUUID = other.wrntyClaimHeaderUUID;
        if (this$wrntyClaimHeaderUUID == null ? other$wrntyClaimHeaderUUID != null : !((Object)this$wrntyClaimHeaderUUID).equals(other$wrntyClaimHeaderUUID)) {
            return false;
        }
        UUID this$wrntyVersionUUID = this.wrntyVersionUUID;
        UUID other$wrntyVersionUUID = other.wrntyVersionUUID;
        if (this$wrntyVersionUUID == null ? other$wrntyVersionUUID != null : !((Object)this$wrntyVersionUUID).equals(other$wrntyVersionUUID)) {
            return false;
        }
        String this$warrantyItemKey = this.warrantyItemKey;
        String other$warrantyItemKey = other.warrantyItemKey;
        if (this$warrantyItemKey == null ? other$warrantyItemKey != null : !this$warrantyItemKey.equals(other$warrantyItemKey)) {
            return false;
        }
        String this$warrantyClaimItemNumber = this.warrantyClaimItemNumber;
        String other$warrantyClaimItemNumber = other.warrantyClaimItemNumber;
        if (this$warrantyClaimItemNumber == null ? other$warrantyClaimItemNumber != null : !this$warrantyClaimItemNumber.equals(other$warrantyClaimItemNumber)) {
            return false;
        }
        String this$wrntyControllingItemType = this.wrntyControllingItemType;
        String other$wrntyControllingItemType = other.wrntyControllingItemType;
        if (this$wrntyControllingItemType == null ? other$wrntyControllingItemType != null : !this$wrntyControllingItemType.equals(other$wrntyControllingItemType)) {
            return false;
        }
        String this$warrantyItemType = this.warrantyItemType;
        String other$warrantyItemType = other.warrantyItemType;
        if (this$warrantyItemType == null ? other$warrantyItemType != null : !this$warrantyItemType.equals(other$warrantyItemType)) {
            return false;
        }
        String this$warrantyClaimCatalog = this.warrantyClaimCatalog;
        String other$warrantyClaimCatalog = other.warrantyClaimCatalog;
        if (this$warrantyClaimCatalog == null ? other$warrantyClaimCatalog != null : !this$warrantyClaimCatalog.equals(other$warrantyClaimCatalog)) {
            return false;
        }
        String this$warrantyClaimItemDefectCode = this.warrantyClaimItemDefectCode;
        String other$warrantyClaimItemDefectCode = other.warrantyClaimItemDefectCode;
        if (this$warrantyClaimItemDefectCode == null ? other$warrantyClaimItemDefectCode != null : !this$warrantyClaimItemDefectCode.equals(other$warrantyClaimItemDefectCode)) {
            return false;
        }
        BigDecimal this$wrntyClaimQuantity = this.wrntyClaimQuantity;
        BigDecimal other$wrntyClaimQuantity = other.wrntyClaimQuantity;
        if (this$wrntyClaimQuantity == null ? other$wrntyClaimQuantity != null : !((Object)this$wrntyClaimQuantity).equals(other$wrntyClaimQuantity)) {
            return false;
        }
        String this$quantityUnit = this.quantityUnit;
        String other$quantityUnit = other.quantityUnit;
        if (this$quantityUnit == null ? other$quantityUnit != null : !this$quantityUnit.equals(other$quantityUnit)) {
            return false;
        }
        String this$warrantyClaimItemDecisionCode = this.warrantyClaimItemDecisionCode;
        String other$warrantyClaimItemDecisionCode = other.warrantyClaimItemDecisionCode;
        if (this$warrantyClaimItemDecisionCode == null ? other$warrantyClaimItemDecisionCode != null : !this$warrantyClaimItemDecisionCode.equals(other$warrantyClaimItemDecisionCode)) {
            return false;
        }
        String this$wrntyClmPartsIsCausingDamage = this.wrntyClmPartsIsCausingDamage;
        String other$wrntyClmPartsIsCausingDamage = other.wrntyClmPartsIsCausingDamage;
        if (this$wrntyClmPartsIsCausingDamage == null ? other$wrntyClmPartsIsCausingDamage != null : !this$wrntyClmPartsIsCausingDamage.equals(other$wrntyClmPartsIsCausingDamage)) {
            return false;
        }
        BigDecimal this$wrntyReimburserClaimAmount = this.wrntyReimburserClaimAmount;
        BigDecimal other$wrntyReimburserClaimAmount = other.wrntyReimburserClaimAmount;
        if (this$wrntyReimburserClaimAmount == null ? other$wrntyReimburserClaimAmount != null : !((Object)this$wrntyReimburserClaimAmount).equals(other$wrntyReimburserClaimAmount)) {
            return false;
        }
        BigDecimal this$wrntyClaimantClaimAmount = this.wrntyClaimantClaimAmount;
        BigDecimal other$wrntyClaimantClaimAmount = other.wrntyClaimantClaimAmount;
        if (this$wrntyClaimantClaimAmount == null ? other$wrntyClaimantClaimAmount != null : !((Object)this$wrntyClaimantClaimAmount).equals(other$wrntyClaimantClaimAmount)) {
            return false;
        }
        BigDecimal this$wrntyClaimedApprovedAmount = this.wrntyClaimedApprovedAmount;
        BigDecimal other$wrntyClaimedApprovedAmount = other.wrntyClaimedApprovedAmount;
        if (this$wrntyClaimedApprovedAmount == null ? other$wrntyClaimedApprovedAmount != null : !((Object)this$wrntyClaimedApprovedAmount).equals(other$wrntyClaimedApprovedAmount)) {
            return false;
        }
        BigDecimal this$wrntyReimburseApprovedAmount = this.wrntyReimburseApprovedAmount;
        BigDecimal other$wrntyReimburseApprovedAmount = other.wrntyReimburseApprovedAmount;
        if (this$wrntyReimburseApprovedAmount == null ? other$wrntyReimburseApprovedAmount != null : !((Object)this$wrntyReimburseApprovedAmount).equals(other$wrntyReimburseApprovedAmount)) {
            return false;
        }
        String this$wrntyCurrencyCode = this.wrntyCurrencyCode;
        String other$wrntyCurrencyCode = other.wrntyCurrencyCode;
        if (this$wrntyCurrencyCode == null ? other$wrntyCurrencyCode != null : !this$wrntyCurrencyCode.equals(other$wrntyCurrencyCode)) {
            return false;
        }
        BigDecimal this$wrntyClaimItemPriceCndnAmount = this.wrntyClaimItemPriceCndnAmount;
        BigDecimal other$wrntyClaimItemPriceCndnAmount = other.wrntyClaimItemPriceCndnAmount;
        if (this$wrntyClaimItemPriceCndnAmount == null ? other$wrntyClaimItemPriceCndnAmount != null : !((Object)this$wrntyClaimItemPriceCndnAmount).equals(other$wrntyClaimItemPriceCndnAmount)) {
            return false;
        }
        String this$wrntyClaimItemPriceCndnCrcy = this.wrntyClaimItemPriceCndnCrcy;
        String other$wrntyClaimItemPriceCndnCrcy = other.wrntyClaimItemPriceCndnCrcy;
        if (this$wrntyClaimItemPriceCndnCrcy == null ? other$wrntyClaimItemPriceCndnCrcy != null : !this$wrntyClaimItemPriceCndnCrcy.equals(other$wrntyClaimItemPriceCndnCrcy)) {
            return false;
        }
        String this$wrntyClmItmDfltCndnType = this.wrntyClmItmDfltCndnType;
        String other$wrntyClmItmDfltCndnType = other.wrntyClmItmDfltCndnType;
        if (this$wrntyClmItmDfltCndnType == null ? other$wrntyClmItmDfltCndnType != null : !this$wrntyClmItmDfltCndnType.equals(other$wrntyClmItmDfltCndnType)) {
            return false;
        }
        String this$material = this.material;
        String other$material = other.material;
        if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
            return false;
        }
        String this$wrntyReturnPartsFrmCustStatus = this.wrntyReturnPartsFrmCustStatus;
        String other$wrntyReturnPartsFrmCustStatus = other.wrntyReturnPartsFrmCustStatus;
        if (this$wrntyReturnPartsFrmCustStatus == null ? other$wrntyReturnPartsFrmCustStatus != null : !this$wrntyReturnPartsFrmCustStatus.equals(other$wrntyReturnPartsFrmCustStatus)) {
            return false;
        }
        String this$wrntyReturnPartsToSuplrStatus = this.wrntyReturnPartsToSuplrStatus;
        String other$wrntyReturnPartsToSuplrStatus = other.wrntyReturnPartsToSuplrStatus;
        if (this$wrntyReturnPartsToSuplrStatus == null ? other$wrntyReturnPartsToSuplrStatus != null : !this$wrntyReturnPartsToSuplrStatus.equals(other$wrntyReturnPartsToSuplrStatus)) {
            return false;
        }
        LocalDate this$wrntyItemSuplrRetPartsDate = this.wrntyItemSuplrRetPartsDate;
        LocalDate other$wrntyItemSuplrRetPartsDate = other.wrntyItemSuplrRetPartsDate;
        if (this$wrntyItemSuplrRetPartsDate == null ? other$wrntyItemSuplrRetPartsDate != null : !((Object)this$wrntyItemSuplrRetPartsDate).equals(other$wrntyItemSuplrRetPartsDate)) {
            return false;
        }
        LocalDate this$wrntyItemCustRetPartsDate = this.wrntyItemCustRetPartsDate;
        LocalDate other$wrntyItemCustRetPartsDate = other.wrntyItemCustRetPartsDate;
        if (this$wrntyItemCustRetPartsDate == null ? other$wrntyItemCustRetPartsDate != null : !((Object)this$wrntyItemCustRetPartsDate).equals(other$wrntyItemCustRetPartsDate)) {
            return false;
        }
        LocalDate this$wrntyItmSuplrRetPartsDelivDate = this.wrntyItmSuplrRetPartsDelivDate;
        LocalDate other$wrntyItmSuplrRetPartsDelivDate = other.wrntyItmSuplrRetPartsDelivDate;
        if (this$wrntyItmSuplrRetPartsDelivDate == null ? other$wrntyItmSuplrRetPartsDelivDate != null : !((Object)this$wrntyItmSuplrRetPartsDelivDate).equals(other$wrntyItmSuplrRetPartsDelivDate)) {
            return false;
        }
        LocalDate this$wrntyItmCustRetPartsDelivDate = this.wrntyItmCustRetPartsDelivDate;
        LocalDate other$wrntyItmCustRetPartsDelivDate = other.wrntyItmCustRetPartsDelivDate;
        if (this$wrntyItmCustRetPartsDelivDate == null ? other$wrntyItmCustRetPartsDelivDate != null : !((Object)this$wrntyItmCustRetPartsDelivDate).equals(other$wrntyItmCustRetPartsDelivDate)) {
            return false;
        }
        String this$warrantyClaimItemTaxCode = this.warrantyClaimItemTaxCode;
        String other$warrantyClaimItemTaxCode = other.warrantyClaimItemTaxCode;
        if (this$warrantyClaimItemTaxCode == null ? other$warrantyClaimItemTaxCode != null : !this$warrantyClaimItemTaxCode.equals(other$warrantyClaimItemTaxCode)) {
            return false;
        }
        LocalDate this$wrntyClaimCreationDate = this.wrntyClaimCreationDate;
        LocalDate other$wrntyClaimCreationDate = other.wrntyClaimCreationDate;
        if (this$wrntyClaimCreationDate == null ? other$wrntyClaimCreationDate != null : !((Object)this$wrntyClaimCreationDate).equals(other$wrntyClaimCreationDate)) {
            return false;
        }
        String this$createdByUser = this.createdByUser;
        String other$createdByUser = other.createdByUser;
        if (this$createdByUser == null ? other$createdByUser != null : !this$createdByUser.equals(other$createdByUser)) {
            return false;
        }
        LocalDate this$wrntyClaimChangedDate = this.wrntyClaimChangedDate;
        LocalDate other$wrntyClaimChangedDate = other.wrntyClaimChangedDate;
        if (this$wrntyClaimChangedDate == null ? other$wrntyClaimChangedDate != null : !((Object)this$wrntyClaimChangedDate).equals(other$wrntyClaimChangedDate)) {
            return false;
        }
        String this$lastChangedByUser = this.lastChangedByUser;
        String other$lastChangedByUser = other.lastChangedByUser;
        if (this$lastChangedByUser == null ? other$lastChangedByUser != null : !this$lastChangedByUser.equals(other$lastChangedByUser)) {
            return false;
        }
        OffsetDateTime this$warrantyClaimChangeDateTime = this.warrantyClaimChangeDateTime;
        OffsetDateTime other$warrantyClaimChangeDateTime = other.warrantyClaimChangeDateTime;
        if (this$warrantyClaimChangeDateTime == null ? other$warrantyClaimChangeDateTime != null : !((Object)this$warrantyClaimChangeDateTime).equals(other$warrantyClaimChangeDateTime)) {
            return false;
        }
        Collection<SAP__Message> this$_Messages = this._Messages;
        Collection<SAP__Message> other$_Messages = other._Messages;
        if (this$_Messages == null ? other$_Messages != null : !((Object)this$_Messages).equals(other$_Messages)) {
            return false;
        }
        WarrantyClaim this$to_WrntyClaimHeader = this.to_WrntyClaimHeader;
        WarrantyClaim other$to_WrntyClaimHeader = other.to_WrntyClaimHeader;
        if (this$to_WrntyClaimHeader == null ? other$to_WrntyClaimHeader != null : !((Object)((Object)this$to_WrntyClaimHeader)).equals((Object)other$to_WrntyClaimHeader)) {
            return false;
        }
        WarrantyClaimVersion this$to_WrntyClaimVersion = this.to_WrntyClaimVersion;
        WarrantyClaimVersion other$to_WrntyClaimVersion = other.to_WrntyClaimVersion;
        return !(this$to_WrntyClaimVersion == null ? other$to_WrntyClaimVersion != null : !((Object)((Object)this$to_WrntyClaimVersion)).equals((Object)other$to_WrntyClaimVersion));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof WarrantyClaimItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $odataType = this.odataType;
        result = result * 59 + ($odataType == null ? 43 : $odataType.hashCode());
        UUID $wrntyItemUUID = this.wrntyItemUUID;
        result = result * 59 + ($wrntyItemUUID == null ? 43 : ((Object)$wrntyItemUUID).hashCode());
        UUID $wrntyClaimHeaderUUID = this.wrntyClaimHeaderUUID;
        result = result * 59 + ($wrntyClaimHeaderUUID == null ? 43 : ((Object)$wrntyClaimHeaderUUID).hashCode());
        UUID $wrntyVersionUUID = this.wrntyVersionUUID;
        result = result * 59 + ($wrntyVersionUUID == null ? 43 : ((Object)$wrntyVersionUUID).hashCode());
        String $warrantyItemKey = this.warrantyItemKey;
        result = result * 59 + ($warrantyItemKey == null ? 43 : $warrantyItemKey.hashCode());
        String $warrantyClaimItemNumber = this.warrantyClaimItemNumber;
        result = result * 59 + ($warrantyClaimItemNumber == null ? 43 : $warrantyClaimItemNumber.hashCode());
        String $wrntyControllingItemType = this.wrntyControllingItemType;
        result = result * 59 + ($wrntyControllingItemType == null ? 43 : $wrntyControllingItemType.hashCode());
        String $warrantyItemType = this.warrantyItemType;
        result = result * 59 + ($warrantyItemType == null ? 43 : $warrantyItemType.hashCode());
        String $warrantyClaimCatalog = this.warrantyClaimCatalog;
        result = result * 59 + ($warrantyClaimCatalog == null ? 43 : $warrantyClaimCatalog.hashCode());
        String $warrantyClaimItemDefectCode = this.warrantyClaimItemDefectCode;
        result = result * 59 + ($warrantyClaimItemDefectCode == null ? 43 : $warrantyClaimItemDefectCode.hashCode());
        BigDecimal $wrntyClaimQuantity = this.wrntyClaimQuantity;
        result = result * 59 + ($wrntyClaimQuantity == null ? 43 : ((Object)$wrntyClaimQuantity).hashCode());
        String $quantityUnit = this.quantityUnit;
        result = result * 59 + ($quantityUnit == null ? 43 : $quantityUnit.hashCode());
        String $warrantyClaimItemDecisionCode = this.warrantyClaimItemDecisionCode;
        result = result * 59 + ($warrantyClaimItemDecisionCode == null ? 43 : $warrantyClaimItemDecisionCode.hashCode());
        String $wrntyClmPartsIsCausingDamage = this.wrntyClmPartsIsCausingDamage;
        result = result * 59 + ($wrntyClmPartsIsCausingDamage == null ? 43 : $wrntyClmPartsIsCausingDamage.hashCode());
        BigDecimal $wrntyReimburserClaimAmount = this.wrntyReimburserClaimAmount;
        result = result * 59 + ($wrntyReimburserClaimAmount == null ? 43 : ((Object)$wrntyReimburserClaimAmount).hashCode());
        BigDecimal $wrntyClaimantClaimAmount = this.wrntyClaimantClaimAmount;
        result = result * 59 + ($wrntyClaimantClaimAmount == null ? 43 : ((Object)$wrntyClaimantClaimAmount).hashCode());
        BigDecimal $wrntyClaimedApprovedAmount = this.wrntyClaimedApprovedAmount;
        result = result * 59 + ($wrntyClaimedApprovedAmount == null ? 43 : ((Object)$wrntyClaimedApprovedAmount).hashCode());
        BigDecimal $wrntyReimburseApprovedAmount = this.wrntyReimburseApprovedAmount;
        result = result * 59 + ($wrntyReimburseApprovedAmount == null ? 43 : ((Object)$wrntyReimburseApprovedAmount).hashCode());
        String $wrntyCurrencyCode = this.wrntyCurrencyCode;
        result = result * 59 + ($wrntyCurrencyCode == null ? 43 : $wrntyCurrencyCode.hashCode());
        BigDecimal $wrntyClaimItemPriceCndnAmount = this.wrntyClaimItemPriceCndnAmount;
        result = result * 59 + ($wrntyClaimItemPriceCndnAmount == null ? 43 : ((Object)$wrntyClaimItemPriceCndnAmount).hashCode());
        String $wrntyClaimItemPriceCndnCrcy = this.wrntyClaimItemPriceCndnCrcy;
        result = result * 59 + ($wrntyClaimItemPriceCndnCrcy == null ? 43 : $wrntyClaimItemPriceCndnCrcy.hashCode());
        String $wrntyClmItmDfltCndnType = this.wrntyClmItmDfltCndnType;
        result = result * 59 + ($wrntyClmItmDfltCndnType == null ? 43 : $wrntyClmItmDfltCndnType.hashCode());
        String $material = this.material;
        result = result * 59 + ($material == null ? 43 : $material.hashCode());
        String $wrntyReturnPartsFrmCustStatus = this.wrntyReturnPartsFrmCustStatus;
        result = result * 59 + ($wrntyReturnPartsFrmCustStatus == null ? 43 : $wrntyReturnPartsFrmCustStatus.hashCode());
        String $wrntyReturnPartsToSuplrStatus = this.wrntyReturnPartsToSuplrStatus;
        result = result * 59 + ($wrntyReturnPartsToSuplrStatus == null ? 43 : $wrntyReturnPartsToSuplrStatus.hashCode());
        LocalDate $wrntyItemSuplrRetPartsDate = this.wrntyItemSuplrRetPartsDate;
        result = result * 59 + ($wrntyItemSuplrRetPartsDate == null ? 43 : ((Object)$wrntyItemSuplrRetPartsDate).hashCode());
        LocalDate $wrntyItemCustRetPartsDate = this.wrntyItemCustRetPartsDate;
        result = result * 59 + ($wrntyItemCustRetPartsDate == null ? 43 : ((Object)$wrntyItemCustRetPartsDate).hashCode());
        LocalDate $wrntyItmSuplrRetPartsDelivDate = this.wrntyItmSuplrRetPartsDelivDate;
        result = result * 59 + ($wrntyItmSuplrRetPartsDelivDate == null ? 43 : ((Object)$wrntyItmSuplrRetPartsDelivDate).hashCode());
        LocalDate $wrntyItmCustRetPartsDelivDate = this.wrntyItmCustRetPartsDelivDate;
        result = result * 59 + ($wrntyItmCustRetPartsDelivDate == null ? 43 : ((Object)$wrntyItmCustRetPartsDelivDate).hashCode());
        String $warrantyClaimItemTaxCode = this.warrantyClaimItemTaxCode;
        result = result * 59 + ($warrantyClaimItemTaxCode == null ? 43 : $warrantyClaimItemTaxCode.hashCode());
        LocalDate $wrntyClaimCreationDate = this.wrntyClaimCreationDate;
        result = result * 59 + ($wrntyClaimCreationDate == null ? 43 : ((Object)$wrntyClaimCreationDate).hashCode());
        String $createdByUser = this.createdByUser;
        result = result * 59 + ($createdByUser == null ? 43 : $createdByUser.hashCode());
        LocalDate $wrntyClaimChangedDate = this.wrntyClaimChangedDate;
        result = result * 59 + ($wrntyClaimChangedDate == null ? 43 : ((Object)$wrntyClaimChangedDate).hashCode());
        String $lastChangedByUser = this.lastChangedByUser;
        result = result * 59 + ($lastChangedByUser == null ? 43 : $lastChangedByUser.hashCode());
        OffsetDateTime $warrantyClaimChangeDateTime = this.warrantyClaimChangeDateTime;
        result = result * 59 + ($warrantyClaimChangeDateTime == null ? 43 : ((Object)$warrantyClaimChangeDateTime).hashCode());
        Collection<SAP__Message> $_Messages = this._Messages;
        result = result * 59 + ($_Messages == null ? 43 : ((Object)$_Messages).hashCode());
        WarrantyClaim $to_WrntyClaimHeader = this.to_WrntyClaimHeader;
        result = result * 59 + ($to_WrntyClaimHeader == null ? 43 : ((Object)((Object)$to_WrntyClaimHeader)).hashCode());
        WarrantyClaimVersion $to_WrntyClaimVersion = this.to_WrntyClaimVersion;
        result = result * 59 + ($to_WrntyClaimVersion == null ? 43 : ((Object)((Object)$to_WrntyClaimVersion)).hashCode());
        return result;
    }

    @Generated
    public String getOdataType() {
        return this.odataType;
    }

    public static final class WarrantyClaimItemBuilder {
        @Generated
        private UUID wrntyItemUUID;
        @Generated
        private UUID wrntyClaimHeaderUUID;
        @Generated
        private UUID wrntyVersionUUID;
        @Generated
        private String warrantyItemKey;
        @Generated
        private String warrantyClaimItemNumber;
        @Generated
        private String wrntyControllingItemType;
        @Generated
        private String warrantyItemType;
        @Generated
        private String warrantyClaimCatalog;
        @Generated
        private String warrantyClaimItemDefectCode;
        @Generated
        private BigDecimal wrntyClaimQuantity;
        @Generated
        private String quantityUnit;
        @Generated
        private String warrantyClaimItemDecisionCode;
        @Generated
        private String wrntyClmPartsIsCausingDamage;
        @Generated
        private BigDecimal wrntyReimburserClaimAmount;
        @Generated
        private BigDecimal wrntyClaimantClaimAmount;
        @Generated
        private BigDecimal wrntyClaimedApprovedAmount;
        @Generated
        private BigDecimal wrntyReimburseApprovedAmount;
        @Generated
        private String wrntyCurrencyCode;
        @Generated
        private BigDecimal wrntyClaimItemPriceCndnAmount;
        @Generated
        private String wrntyClaimItemPriceCndnCrcy;
        @Generated
        private String wrntyClmItmDfltCndnType;
        @Generated
        private String material;
        @Generated
        private String wrntyReturnPartsFrmCustStatus;
        @Generated
        private String wrntyReturnPartsToSuplrStatus;
        @Generated
        private LocalDate wrntyItemSuplrRetPartsDate;
        @Generated
        private LocalDate wrntyItemCustRetPartsDate;
        @Generated
        private LocalDate wrntyItmSuplrRetPartsDelivDate;
        @Generated
        private LocalDate wrntyItmCustRetPartsDelivDate;
        @Generated
        private String warrantyClaimItemTaxCode;
        @Generated
        private LocalDate wrntyClaimCreationDate;
        @Generated
        private String createdByUser;
        @Generated
        private LocalDate wrntyClaimChangedDate;
        @Generated
        private String lastChangedByUser;
        @Generated
        private OffsetDateTime warrantyClaimChangeDateTime;
        @Generated
        private Collection<SAP__Message> _Messages;
        private WarrantyClaim to_WrntyClaimHeader;
        private WarrantyClaimVersion to_WrntyClaimVersion;

        private WarrantyClaimItemBuilder to_WrntyClaimHeader(WarrantyClaim value) {
            this.to_WrntyClaimHeader = value;
            return this;
        }

        @Nonnull
        public WarrantyClaimItemBuilder wrntyClaimHeader(WarrantyClaim value) {
            return this.to_WrntyClaimHeader(value);
        }

        private WarrantyClaimItemBuilder to_WrntyClaimVersion(WarrantyClaimVersion value) {
            this.to_WrntyClaimVersion = value;
            return this;
        }

        @Nonnull
        public WarrantyClaimItemBuilder wrntyClaimVersion(WarrantyClaimVersion value) {
            return this.to_WrntyClaimVersion(value);
        }

        @Generated
        WarrantyClaimItemBuilder() {
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyItemUUID(@Nullable UUID wrntyItemUUID) {
            this.wrntyItemUUID = wrntyItemUUID;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyClaimHeaderUUID(@Nullable UUID wrntyClaimHeaderUUID) {
            this.wrntyClaimHeaderUUID = wrntyClaimHeaderUUID;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyVersionUUID(@Nullable UUID wrntyVersionUUID) {
            this.wrntyVersionUUID = wrntyVersionUUID;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder warrantyItemKey(@Nullable String warrantyItemKey) {
            this.warrantyItemKey = warrantyItemKey;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder warrantyClaimItemNumber(@Nullable String warrantyClaimItemNumber) {
            this.warrantyClaimItemNumber = warrantyClaimItemNumber;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyControllingItemType(@Nullable String wrntyControllingItemType) {
            this.wrntyControllingItemType = wrntyControllingItemType;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder warrantyItemType(@Nullable String warrantyItemType) {
            this.warrantyItemType = warrantyItemType;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder warrantyClaimCatalog(@Nullable String warrantyClaimCatalog) {
            this.warrantyClaimCatalog = warrantyClaimCatalog;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder warrantyClaimItemDefectCode(@Nullable String warrantyClaimItemDefectCode) {
            this.warrantyClaimItemDefectCode = warrantyClaimItemDefectCode;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyClaimQuantity(@Nullable BigDecimal wrntyClaimQuantity) {
            this.wrntyClaimQuantity = wrntyClaimQuantity;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder quantityUnit(@Nullable String quantityUnit) {
            this.quantityUnit = quantityUnit;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder warrantyClaimItemDecisionCode(@Nullable String warrantyClaimItemDecisionCode) {
            this.warrantyClaimItemDecisionCode = warrantyClaimItemDecisionCode;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyClmPartsIsCausingDamage(@Nullable String wrntyClmPartsIsCausingDamage) {
            this.wrntyClmPartsIsCausingDamage = wrntyClmPartsIsCausingDamage;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyReimburserClaimAmount(@Nullable BigDecimal wrntyReimburserClaimAmount) {
            this.wrntyReimburserClaimAmount = wrntyReimburserClaimAmount;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyClaimantClaimAmount(@Nullable BigDecimal wrntyClaimantClaimAmount) {
            this.wrntyClaimantClaimAmount = wrntyClaimantClaimAmount;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyClaimedApprovedAmount(@Nullable BigDecimal wrntyClaimedApprovedAmount) {
            this.wrntyClaimedApprovedAmount = wrntyClaimedApprovedAmount;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyReimburseApprovedAmount(@Nullable BigDecimal wrntyReimburseApprovedAmount) {
            this.wrntyReimburseApprovedAmount = wrntyReimburseApprovedAmount;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyCurrencyCode(@Nullable String wrntyCurrencyCode) {
            this.wrntyCurrencyCode = wrntyCurrencyCode;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyClaimItemPriceCndnAmount(@Nullable BigDecimal wrntyClaimItemPriceCndnAmount) {
            this.wrntyClaimItemPriceCndnAmount = wrntyClaimItemPriceCndnAmount;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyClaimItemPriceCndnCrcy(@Nullable String wrntyClaimItemPriceCndnCrcy) {
            this.wrntyClaimItemPriceCndnCrcy = wrntyClaimItemPriceCndnCrcy;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyClmItmDfltCndnType(@Nullable String wrntyClmItmDfltCndnType) {
            this.wrntyClmItmDfltCndnType = wrntyClmItmDfltCndnType;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder material(@Nullable String material) {
            this.material = material;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyReturnPartsFrmCustStatus(@Nullable String wrntyReturnPartsFrmCustStatus) {
            this.wrntyReturnPartsFrmCustStatus = wrntyReturnPartsFrmCustStatus;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyReturnPartsToSuplrStatus(@Nullable String wrntyReturnPartsToSuplrStatus) {
            this.wrntyReturnPartsToSuplrStatus = wrntyReturnPartsToSuplrStatus;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyItemSuplrRetPartsDate(@Nullable LocalDate wrntyItemSuplrRetPartsDate) {
            this.wrntyItemSuplrRetPartsDate = wrntyItemSuplrRetPartsDate;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyItemCustRetPartsDate(@Nullable LocalDate wrntyItemCustRetPartsDate) {
            this.wrntyItemCustRetPartsDate = wrntyItemCustRetPartsDate;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyItmSuplrRetPartsDelivDate(@Nullable LocalDate wrntyItmSuplrRetPartsDelivDate) {
            this.wrntyItmSuplrRetPartsDelivDate = wrntyItmSuplrRetPartsDelivDate;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyItmCustRetPartsDelivDate(@Nullable LocalDate wrntyItmCustRetPartsDelivDate) {
            this.wrntyItmCustRetPartsDelivDate = wrntyItmCustRetPartsDelivDate;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder warrantyClaimItemTaxCode(@Nullable String warrantyClaimItemTaxCode) {
            this.warrantyClaimItemTaxCode = warrantyClaimItemTaxCode;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyClaimCreationDate(@Nullable LocalDate wrntyClaimCreationDate) {
            this.wrntyClaimCreationDate = wrntyClaimCreationDate;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder createdByUser(@Nullable String createdByUser) {
            this.createdByUser = createdByUser;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder wrntyClaimChangedDate(@Nullable LocalDate wrntyClaimChangedDate) {
            this.wrntyClaimChangedDate = wrntyClaimChangedDate;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder lastChangedByUser(@Nullable String lastChangedByUser) {
            this.lastChangedByUser = lastChangedByUser;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder warrantyClaimChangeDateTime(@Nullable OffsetDateTime warrantyClaimChangeDateTime) {
            this.warrantyClaimChangeDateTime = warrantyClaimChangeDateTime;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItemBuilder _Messages(@Nullable Collection<SAP__Message> _Messages) {
            this._Messages = _Messages;
            return this;
        }

        @Nonnull
        @Generated
        public WarrantyClaimItem build() {
            return new WarrantyClaimItem(this.wrntyItemUUID, this.wrntyClaimHeaderUUID, this.wrntyVersionUUID, this.warrantyItemKey, this.warrantyClaimItemNumber, this.wrntyControllingItemType, this.warrantyItemType, this.warrantyClaimCatalog, this.warrantyClaimItemDefectCode, this.wrntyClaimQuantity, this.quantityUnit, this.warrantyClaimItemDecisionCode, this.wrntyClmPartsIsCausingDamage, this.wrntyReimburserClaimAmount, this.wrntyClaimantClaimAmount, this.wrntyClaimedApprovedAmount, this.wrntyReimburseApprovedAmount, this.wrntyCurrencyCode, this.wrntyClaimItemPriceCndnAmount, this.wrntyClaimItemPriceCndnCrcy, this.wrntyClmItmDfltCndnType, this.material, this.wrntyReturnPartsFrmCustStatus, this.wrntyReturnPartsToSuplrStatus, this.wrntyItemSuplrRetPartsDate, this.wrntyItemCustRetPartsDate, this.wrntyItmSuplrRetPartsDelivDate, this.wrntyItmCustRetPartsDelivDate, this.warrantyClaimItemTaxCode, this.wrntyClaimCreationDate, this.createdByUser, this.wrntyClaimChangedDate, this.lastChangedByUser, this.warrantyClaimChangeDateTime, this._Messages, this.to_WrntyClaimHeader, this.to_WrntyClaimVersion);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "WarrantyClaimItem.WarrantyClaimItemBuilder(wrntyItemUUID=" + this.wrntyItemUUID + ", wrntyClaimHeaderUUID=" + this.wrntyClaimHeaderUUID + ", wrntyVersionUUID=" + this.wrntyVersionUUID + ", warrantyItemKey=" + this.warrantyItemKey + ", warrantyClaimItemNumber=" + this.warrantyClaimItemNumber + ", wrntyControllingItemType=" + this.wrntyControllingItemType + ", warrantyItemType=" + this.warrantyItemType + ", warrantyClaimCatalog=" + this.warrantyClaimCatalog + ", warrantyClaimItemDefectCode=" + this.warrantyClaimItemDefectCode + ", wrntyClaimQuantity=" + this.wrntyClaimQuantity + ", quantityUnit=" + this.quantityUnit + ", warrantyClaimItemDecisionCode=" + this.warrantyClaimItemDecisionCode + ", wrntyClmPartsIsCausingDamage=" + this.wrntyClmPartsIsCausingDamage + ", wrntyReimburserClaimAmount=" + this.wrntyReimburserClaimAmount + ", wrntyClaimantClaimAmount=" + this.wrntyClaimantClaimAmount + ", wrntyClaimedApprovedAmount=" + this.wrntyClaimedApprovedAmount + ", wrntyReimburseApprovedAmount=" + this.wrntyReimburseApprovedAmount + ", wrntyCurrencyCode=" + this.wrntyCurrencyCode + ", wrntyClaimItemPriceCndnAmount=" + this.wrntyClaimItemPriceCndnAmount + ", wrntyClaimItemPriceCndnCrcy=" + this.wrntyClaimItemPriceCndnCrcy + ", wrntyClmItmDfltCndnType=" + this.wrntyClmItmDfltCndnType + ", material=" + this.material + ", wrntyReturnPartsFrmCustStatus=" + this.wrntyReturnPartsFrmCustStatus + ", wrntyReturnPartsToSuplrStatus=" + this.wrntyReturnPartsToSuplrStatus + ", wrntyItemSuplrRetPartsDate=" + this.wrntyItemSuplrRetPartsDate + ", wrntyItemCustRetPartsDate=" + this.wrntyItemCustRetPartsDate + ", wrntyItmSuplrRetPartsDelivDate=" + this.wrntyItmSuplrRetPartsDelivDate + ", wrntyItmCustRetPartsDelivDate=" + this.wrntyItmCustRetPartsDelivDate + ", warrantyClaimItemTaxCode=" + this.warrantyClaimItemTaxCode + ", wrntyClaimCreationDate=" + this.wrntyClaimCreationDate + ", createdByUser=" + this.createdByUser + ", wrntyClaimChangedDate=" + this.wrntyClaimChangedDate + ", lastChangedByUser=" + this.lastChangedByUser + ", warrantyClaimChangeDateTime=" + this.warrantyClaimChangeDateTime + ", _Messages=" + this._Messages + ", to_WrntyClaimHeader=" + (Object)((Object)this.to_WrntyClaimHeader) + ", to_WrntyClaimVersion=" + (Object)((Object)this.to_WrntyClaimVersion) + ")";
        }
    }
}

