/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.bankv2.Bank;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.bankv2.BankAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.BankV2Service;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultBankV2Service")
public class DefaultBankV2Service
implements ServiceWithNavigableEntities,
BankV2Service {
    @Nonnull
    private final String servicePath;

    public DefaultBankV2Service() {
        this.servicePath = "/sap/opu/odata4/sap/api_bank/srvd_a2x/sap/bank/0002";
    }

    private DefaultBankV2Service(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBankV2Service withServicePath(@Nonnull String servicePath) {
        return new DefaultBankV2Service(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<Bank> getAllBank() {
        return new GetAllRequestBuilder(this.servicePath, Bank.class, "Bank");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<Bank> countBank() {
        return new CountRequestBuilder(this.servicePath, Bank.class, "Bank");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<Bank> getBankByKey(String bankCountry, String bankInternalID) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("BankCountry", bankCountry);
        key.put("BankInternalID", bankInternalID);
        return new GetByKeyRequestBuilder(this.servicePath, Bank.class, key, "Bank");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<Bank> createBank(@Nonnull Bank bank) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)bank, "Bank");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<Bank> updateBank(@Nonnull Bank bank) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)bank, "Bank");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<BankAddress> getAllBankAddress() {
        return new GetAllRequestBuilder(this.servicePath, BankAddress.class, "BankAddress");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<BankAddress> countBankAddress() {
        return new CountRequestBuilder(this.servicePath, BankAddress.class, "BankAddress");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<BankAddress> getBankAddressByKey(String bankCountry, String bankInternalID, String addressRepresentationCode) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("BankCountry", bankCountry);
        key.put("BankInternalID", bankInternalID);
        key.put("AddressRepresentationCode", addressRepresentationCode);
        return new GetByKeyRequestBuilder(this.servicePath, BankAddress.class, key, "BankAddress");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<BankAddress> updateBankAddress(@Nonnull BankAddress bankAddress) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)bankAddress, "BankAddress");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<BankAddress> deleteBankAddress(@Nonnull BankAddress bankAddress) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)bankAddress, "BankAddress");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

