/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.configurationprofile.VarCnfHistoricalProfile;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.configurationprofile.VariantConfigurationProfile;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConfigurationProfileService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultConfigurationProfileService")
public class DefaultConfigurationProfileService
implements ServiceWithNavigableEntities,
ConfigurationProfileService {
    @Nonnull
    private final String servicePath;

    public DefaultConfigurationProfileService() {
        this.servicePath = "/sap/opu/odata4/sap/api_varcnfprofile/srvd_a2x/sap/varconfigurationprofile/0001";
    }

    private DefaultConfigurationProfileService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultConfigurationProfileService withServicePath(@Nonnull String servicePath) {
        return new DefaultConfigurationProfileService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<VarCnfHistoricalProfile> getAllVarCnfHistoricalProfile() {
        return new GetAllRequestBuilder(this.servicePath, VarCnfHistoricalProfile.class, "VarCnfHistoricalProfile");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<VarCnfHistoricalProfile> countVarCnfHistoricalProfile() {
        return new CountRequestBuilder(this.servicePath, VarCnfHistoricalProfile.class, "VarCnfHistoricalProfile");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<VarCnfHistoricalProfile> getVarCnfHistoricalProfileByKey(String product, String varConfigurationProfileName, String changeNumber) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("Product", product);
        key.put("VarConfigurationProfileName", varConfigurationProfileName);
        key.put("ChangeNumber", changeNumber);
        return new GetByKeyRequestBuilder(this.servicePath, VarCnfHistoricalProfile.class, key, "VarCnfHistoricalProfile");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<VarCnfHistoricalProfile> updateVarCnfHistoricalProfile(@Nonnull VarCnfHistoricalProfile varCnfHistoricalProfile) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)varCnfHistoricalProfile, "VarCnfHistoricalProfile");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<VariantConfigurationProfile> getAllVariantConfigurationProfile() {
        return new GetAllRequestBuilder(this.servicePath, VariantConfigurationProfile.class, "VariantConfigurationProfile");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<VariantConfigurationProfile> countVariantConfigurationProfile() {
        return new CountRequestBuilder(this.servicePath, VariantConfigurationProfile.class, "VariantConfigurationProfile");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<VariantConfigurationProfile> getVariantConfigurationProfileByKey(String product, String varConfigurationProfileName) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("Product", product);
        key.put("VarConfigurationProfileName", varConfigurationProfileName);
        return new GetByKeyRequestBuilder(this.servicePath, VariantConfigurationProfile.class, key, "VariantConfigurationProfile");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<VariantConfigurationProfile> createVariantConfigurationProfile(@Nonnull VariantConfigurationProfile variantConfigurationProfile) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)variantConfigurationProfile, "VariantConfigurationProfile");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<VariantConfigurationProfile> deleteVariantConfigurationProfile(@Nonnull VariantConfigurationProfile variantConfigurationProfile) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)variantConfigurationProfile, "VariantConfigurationProfile");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

