/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.consolidationindustry.CnsldtnIndustry;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.consolidationindustry.CnsldtnIndustryText;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConsolidationIndustryService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultConsolidationIndustryService")
public class DefaultConsolidationIndustryService
implements ServiceWithNavigableEntities,
ConsolidationIndustryService {
    @Nonnull
    private final String servicePath;

    public DefaultConsolidationIndustryService() {
        this.servicePath = "/sap/opu/odata4/sap/api_cnsldtnindustry/srvd_a2x/sap/cnsldtnindustry/0001";
    }

    private DefaultConsolidationIndustryService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultConsolidationIndustryService withServicePath(@Nonnull String servicePath) {
        return new DefaultConsolidationIndustryService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<CnsldtnIndustry> getAllCnsldtnIndustry() {
        return new GetAllRequestBuilder(this.servicePath, CnsldtnIndustry.class, "CnsldtnIndustry");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<CnsldtnIndustry> countCnsldtnIndustry() {
        return new CountRequestBuilder(this.servicePath, CnsldtnIndustry.class, "CnsldtnIndustry");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<CnsldtnIndustry> getCnsldtnIndustryByKey(String industry) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("Industry", industry);
        return new GetByKeyRequestBuilder(this.servicePath, CnsldtnIndustry.class, key, "CnsldtnIndustry");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<CnsldtnIndustry> createCnsldtnIndustry(@Nonnull CnsldtnIndustry cnsldtnIndustry) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)cnsldtnIndustry, "CnsldtnIndustry");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<CnsldtnIndustry> updateCnsldtnIndustry(@Nonnull CnsldtnIndustry cnsldtnIndustry) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)cnsldtnIndustry, "CnsldtnIndustry");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<CnsldtnIndustry> deleteCnsldtnIndustry(@Nonnull CnsldtnIndustry cnsldtnIndustry) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)cnsldtnIndustry, "CnsldtnIndustry");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<CnsldtnIndustryText> getAllCnsldtnIndustryText() {
        return new GetAllRequestBuilder(this.servicePath, CnsldtnIndustryText.class, "CnsldtnIndustryText");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<CnsldtnIndustryText> countCnsldtnIndustryText() {
        return new CountRequestBuilder(this.servicePath, CnsldtnIndustryText.class, "CnsldtnIndustryText");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<CnsldtnIndustryText> getCnsldtnIndustryTextByKey(String language, String industry) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("Language", language);
        key.put("Industry", industry);
        return new GetByKeyRequestBuilder(this.servicePath, CnsldtnIndustryText.class, key, "CnsldtnIndustryText");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<CnsldtnIndustryText> updateCnsldtnIndustryText(@Nonnull CnsldtnIndustryText cnsldtnIndustryText) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)cnsldtnIndustryText, "CnsldtnIndustryText");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<CnsldtnIndustryText> deleteCnsldtnIndustryText(@Nonnull CnsldtnIndustryText cnsldtnIndustryText) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)cnsldtnIndustryText, "CnsldtnIndustryText");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

