/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccount.ContractAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccount.ContractAccountPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultContractAccountService")
public class DefaultContractAccountService
implements ServiceWithNavigableEntities,
ContractAccountService {
    @Nonnull
    private final String servicePath;

    public DefaultContractAccountService() {
        this.servicePath = "/sap/opu/odata4/sap/api_contractaccount/srvd_a2x/sap/contractaccount/0001";
    }

    private DefaultContractAccountService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultContractAccountService withServicePath(@Nonnull String servicePath) {
        return new DefaultContractAccountService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ContractAccount> getAllContractAccount() {
        return new GetAllRequestBuilder(this.servicePath, ContractAccount.class, "ContractAccount");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ContractAccount> countContractAccount() {
        return new CountRequestBuilder(this.servicePath, ContractAccount.class, "ContractAccount");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ContractAccount> getContractAccountByKey(String contractAccount) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("ContractAccount", contractAccount);
        return new GetByKeyRequestBuilder(this.servicePath, ContractAccount.class, key, "ContractAccount");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ContractAccountPartner> getAllContractAccountPartner() {
        return new GetAllRequestBuilder(this.servicePath, ContractAccountPartner.class, "ContractAccountPartner");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ContractAccountPartner> countContractAccountPartner() {
        return new CountRequestBuilder(this.servicePath, ContractAccountPartner.class, "ContractAccountPartner");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ContractAccountPartner> getContractAccountPartnerByKey(String contractAccount, String businessPartner) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("ContractAccount", contractAccount);
        key.put("BusinessPartner", businessPartner);
        return new GetByKeyRequestBuilder(this.servicePath, ContractAccountPartner.class, key, "ContractAccountPartner");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

