/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage.CADocBPItem;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage.CADocBPItemBusLock;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage.CADocBPItemLogical;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage.CADocBPItemPaymentData;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage.CADocGLItem;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage.CADocGLItemPaymentData;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage.CADocHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingDocumentManageService;
import java.time.LocalDate;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultContractAccountingDocumentManageService")
public class DefaultContractAccountingDocumentManageService
implements ServiceWithNavigableEntities,
ContractAccountingDocumentManageService {
    @Nonnull
    private final String servicePath;

    public DefaultContractAccountingDocumentManageService() {
        this.servicePath = "/sap/opu/odata4/sap/api_cadocumentmanage/srvd_a2x/sap/cadocumentmanage/0001";
    }

    private DefaultContractAccountingDocumentManageService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultContractAccountingDocumentManageService withServicePath(@Nonnull String servicePath) {
        return new DefaultContractAccountingDocumentManageService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<CADocBPItem> getAllBPItem() {
        return new GetAllRequestBuilder(this.servicePath, CADocBPItem.class, "BPItem");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<CADocBPItem> countBPItem() {
        return new CountRequestBuilder(this.servicePath, CADocBPItem.class, "BPItem");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<CADocBPItem> getBPItemByKey(String cADocumentNumber, String cARepetitionItemNumber, String cABPItemNumber, String cASubItemNumber) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("CADocumentNumber", cADocumentNumber);
        key.put("CARepetitionItemNumber", cARepetitionItemNumber);
        key.put("CABPItemNumber", cABPItemNumber);
        key.put("CASubItemNumber", cASubItemNumber);
        return new GetByKeyRequestBuilder(this.servicePath, CADocBPItem.class, key, "BPItem");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<CADocBPItem> createBPItem(@Nonnull CADocBPItem cADocBPItem) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)cADocBPItem, "BPItem");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<CADocBPItem> updateBPItem(@Nonnull CADocBPItem cADocBPItem) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)cADocBPItem, "BPItem");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<CADocBPItemBusLock> getAllBPItemBusLock() {
        return new GetAllRequestBuilder(this.servicePath, CADocBPItemBusLock.class, "BPItemBusLock");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<CADocBPItemBusLock> countBPItemBusLock() {
        return new CountRequestBuilder(this.servicePath, CADocBPItemBusLock.class, "BPItemBusLock");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<CADocBPItemBusLock> getBPItemBusLockByKey(String cADocumentNumber, String cARepetitionItemNumber, String cABPItemNumber, String cASubItemNumber, String cABusinessProcess, String cABusinessLockReason, LocalDate cABusinessLockValidFrom, LocalDate cABusinessLockValidTo) {
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("CADocumentNumber", cADocumentNumber);
        key.put("CARepetitionItemNumber", cARepetitionItemNumber);
        key.put("CABPItemNumber", cABPItemNumber);
        key.put("CASubItemNumber", cASubItemNumber);
        key.put("CABusinessProcess", cABusinessProcess);
        key.put("CABusinessLockReason", cABusinessLockReason);
        key.put("CABusinessLockValidFrom", cABusinessLockValidFrom);
        key.put("CABusinessLockValidTo", cABusinessLockValidTo);
        return new GetByKeyRequestBuilder(this.servicePath, CADocBPItemBusLock.class, key, "BPItemBusLock");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<CADocBPItemBusLock> createBPItemBusLock(@Nonnull CADocBPItemBusLock cADocBPItemBusLock) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)cADocBPItemBusLock, "BPItemBusLock");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<CADocBPItemBusLock> deleteBPItemBusLock(@Nonnull CADocBPItemBusLock cADocBPItemBusLock) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)cADocBPItemBusLock, "BPItemBusLock");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<CADocBPItemLogical> getAllBPItemLogical() {
        return new GetAllRequestBuilder(this.servicePath, CADocBPItemLogical.class, "BPItemLogical");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<CADocBPItemLogical> countBPItemLogical() {
        return new CountRequestBuilder(this.servicePath, CADocBPItemLogical.class, "BPItemLogical");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<CADocBPItemLogical> getBPItemLogicalByKey(String cADocumentNumber, String cARepetitionItemNumber, String cABPItemNumber, String cASubItemNumber) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("CADocumentNumber", cADocumentNumber);
        key.put("CARepetitionItemNumber", cARepetitionItemNumber);
        key.put("CABPItemNumber", cABPItemNumber);
        key.put("CASubItemNumber", cASubItemNumber);
        return new GetByKeyRequestBuilder(this.servicePath, CADocBPItemLogical.class, key, "BPItemLogical");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<CADocBPItemPaymentData> getAllBPItemPaytData() {
        return new GetAllRequestBuilder(this.servicePath, CADocBPItemPaymentData.class, "BPItemPaytData");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<CADocBPItemPaymentData> countBPItemPaytData() {
        return new CountRequestBuilder(this.servicePath, CADocBPItemPaymentData.class, "BPItemPaytData");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<CADocBPItemPaymentData> getBPItemPaytDataByKey(String cADocumentNumber, String cAGroupingForPayment) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("CADocumentNumber", cADocumentNumber);
        key.put("CAGroupingForPayment", cAGroupingForPayment);
        return new GetByKeyRequestBuilder(this.servicePath, CADocBPItemPaymentData.class, key, "BPItemPaytData");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<CADocHeader> getAllDocumentHeader() {
        return new GetAllRequestBuilder(this.servicePath, CADocHeader.class, "DocumentHeader");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<CADocHeader> countDocumentHeader() {
        return new CountRequestBuilder(this.servicePath, CADocHeader.class, "DocumentHeader");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<CADocHeader> getDocumentHeaderByKey(String cADocumentNumber) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("CADocumentNumber", cADocumentNumber);
        return new GetByKeyRequestBuilder(this.servicePath, CADocHeader.class, key, "DocumentHeader");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<CADocHeader> updateDocumentHeader(@Nonnull CADocHeader cADocHeader) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)cADocHeader, "DocumentHeader");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<CADocGLItem> getAllGLItem() {
        return new GetAllRequestBuilder(this.servicePath, CADocGLItem.class, "GLItem");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<CADocGLItem> countGLItem() {
        return new CountRequestBuilder(this.servicePath, CADocGLItem.class, "GLItem");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<CADocGLItem> getGLItemByKey(String cADocumentNumber, String cAGLItemNumber) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("CADocumentNumber", cADocumentNumber);
        key.put("CAGLItemNumber", cAGLItemNumber);
        return new GetByKeyRequestBuilder(this.servicePath, CADocGLItem.class, key, "GLItem");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<CADocGLItemPaymentData> getAllGLItemPaytData() {
        return new GetAllRequestBuilder(this.servicePath, CADocGLItemPaymentData.class, "GLItemPaytData");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<CADocGLItemPaymentData> countGLItemPaytData() {
        return new CountRequestBuilder(this.servicePath, CADocGLItemPaymentData.class, "GLItemPaytData");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<CADocGLItemPaymentData> getGLItemPaytDataByKey(String cADocumentNumber, String cAGLItemNumber) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("CADocumentNumber", cADocumentNumber);
        key.put("CAGLItemNumber", cAGLItemNumber);
        return new GetByKeyRequestBuilder(this.servicePath, CADocGLItemPaymentData.class, key, "GLItemPaytData");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

