/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.defect.Defect;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.defect.DefectDetailedDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefectService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultDefectService")
public class DefaultDefectService
implements ServiceWithNavigableEntities,
DefectService {
    @Nonnull
    private final String servicePath;

    public DefaultDefectService() {
        this.servicePath = "/sap/opu/odata4/sap/api_defect/srvd_a2x/sap/defect/0001";
    }

    private DefaultDefectService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultDefectService withServicePath(@Nonnull String servicePath) {
        return new DefaultDefectService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<Defect> getAllDefect() {
        return new GetAllRequestBuilder(this.servicePath, Defect.class, "Defect");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<Defect> countDefect() {
        return new CountRequestBuilder(this.servicePath, Defect.class, "Defect");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<Defect> getDefectByKey(String defectInternalID) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("DefectInternalID", defectInternalID);
        return new GetByKeyRequestBuilder(this.servicePath, Defect.class, key, "Defect");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<Defect> createDefect(@Nonnull Defect defect) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)defect, "Defect");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<Defect> updateDefect(@Nonnull Defect defect) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)defect, "Defect");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<DefectDetailedDescription> getAllDefectDetailedDescription() {
        return new GetAllRequestBuilder(this.servicePath, DefectDetailedDescription.class, "DefectDetailedDescription");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<DefectDetailedDescription> countDefectDetailedDescription() {
        return new CountRequestBuilder(this.servicePath, DefectDetailedDescription.class, "DefectDetailedDescription");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<DefectDetailedDescription> getDefectDetailedDescriptionByKey(String defectInternalID, Short longTextInternalNumber, String language) {
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("DefectInternalID", defectInternalID);
        key.put("LongTextInternalNumber", longTextInternalNumber);
        key.put("Language", language);
        return new GetByKeyRequestBuilder(this.servicePath, DefectDetailedDescription.class, key, "DefectDetailedDescription");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<DefectDetailedDescription> updateDefectDetailedDescription(@Nonnull DefectDetailedDescription defectDetailedDescription) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)defectDetailedDescription, "DefectDetailedDescription");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<DefectDetailedDescription> deleteDefectDetailedDescription(@Nonnull DefectDetailedDescription defectDetailedDescription) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)defectDetailedDescription, "DefectDetailedDescription");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

