/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.equipmenthierarchy.EquipmentStrucList;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.EquipmentHierarchyService;
import java.time.LocalDate;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultEquipmentHierarchyService")
public class DefaultEquipmentHierarchyService
implements ServiceWithNavigableEntities,
EquipmentHierarchyService {
    @Nonnull
    private final String servicePath;

    public DefaultEquipmentHierarchyService() {
        this.servicePath = "/sap/opu/odata4/sap/api_equipment_struclist/srvd_a2x/sap/equipmentstruclist/0001";
    }

    private DefaultEquipmentHierarchyService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultEquipmentHierarchyService withServicePath(@Nonnull String servicePath) {
        return new DefaultEquipmentHierarchyService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<EquipmentStrucList> getAllEquipmentStructureList() {
        return new GetAllRequestBuilder(this.servicePath, EquipmentStrucList.class, "EquipmentStructureList");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<EquipmentStrucList> countEquipmentStructureList() {
        return new CountRequestBuilder(this.servicePath, EquipmentStrucList.class, "EquipmentStructureList");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<EquipmentStrucList> getEquipmentStructureListByKey(String equipment, LocalDate validityEndDate) {
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("Equipment", equipment);
        key.put("ValidityEndDate", validityEndDate);
        return new GetByKeyRequestBuilder(this.servicePath, EquipmentStrucList.class, key, "EquipmentStructureList");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

