/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.handlingunit.HandlingUnit;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.handlingunit.HandlingUnitItem;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.handlingunit.HandlingUnitReferenceDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.handlingunit.HandlingUnitSerialNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.HandlingUnitService;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultHandlingUnitService")
public class DefaultHandlingUnitService
implements ServiceWithNavigableEntities,
HandlingUnitService {
    @Nonnull
    private final String servicePath;

    public DefaultHandlingUnitService() {
        this.servicePath = "/sap/opu/odata4/sap/api_handlingunit/srvd_a2x/sap/handlingunit/0001";
    }

    private DefaultHandlingUnitService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultHandlingUnitService withServicePath(@Nonnull String servicePath) {
        return new DefaultHandlingUnitService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<HandlingUnit> getAllHandlingUnit() {
        return new GetAllRequestBuilder(this.servicePath, HandlingUnit.class, "HandlingUnit");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<HandlingUnit> countHandlingUnit() {
        return new CountRequestBuilder(this.servicePath, HandlingUnit.class, "HandlingUnit");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<HandlingUnit> getHandlingUnitByKey(String handlingUnitExternalID, String warehouse) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("HandlingUnitExternalID", handlingUnitExternalID);
        key.put("Warehouse", warehouse);
        return new GetByKeyRequestBuilder(this.servicePath, HandlingUnit.class, key, "HandlingUnit");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<HandlingUnit> createHandlingUnit(@Nonnull HandlingUnit handlingUnit) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)handlingUnit, "HandlingUnit");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<HandlingUnit> deleteHandlingUnit(@Nonnull HandlingUnit handlingUnit) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)handlingUnit, "HandlingUnit");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<HandlingUnitItem> getAllHandlingUnitItem() {
        return new GetAllRequestBuilder(this.servicePath, HandlingUnitItem.class, "HandlingUnitItem");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<HandlingUnitItem> countHandlingUnitItem() {
        return new CountRequestBuilder(this.servicePath, HandlingUnitItem.class, "HandlingUnitItem");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<HandlingUnitItem> getHandlingUnitItemByKey(String handlingUnitExternalID, String warehouse, UUID stockItemUUID) {
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("HandlingUnitExternalID", handlingUnitExternalID);
        key.put("Warehouse", warehouse);
        key.put("StockItemUUID", stockItemUUID);
        return new GetByKeyRequestBuilder(this.servicePath, HandlingUnitItem.class, key, "HandlingUnitItem");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<HandlingUnitItem> createHandlingUnitItem(@Nonnull HandlingUnitItem handlingUnitItem) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)handlingUnitItem, "HandlingUnitItem");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<HandlingUnitItem> deleteHandlingUnitItem(@Nonnull HandlingUnitItem handlingUnitItem) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)handlingUnitItem, "HandlingUnitItem");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<HandlingUnitReferenceDoc> getAllHandlingUnitReferenceDocument() {
        return new GetAllRequestBuilder(this.servicePath, HandlingUnitReferenceDoc.class, "HandlingUnitReferenceDocument");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<HandlingUnitReferenceDoc> countHandlingUnitReferenceDocument() {
        return new CountRequestBuilder(this.servicePath, HandlingUnitReferenceDoc.class, "HandlingUnitReferenceDocument");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<HandlingUnitReferenceDoc> getHandlingUnitReferenceDocumentByKey(String warehouse, String handlingUnitExternalID, String handlingUnitReferenceDocument) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("Warehouse", warehouse);
        key.put("HandlingUnitExternalID", handlingUnitExternalID);
        key.put("HandlingUnitReferenceDocument", handlingUnitReferenceDocument);
        return new GetByKeyRequestBuilder(this.servicePath, HandlingUnitReferenceDoc.class, key, "HandlingUnitReferenceDocument");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<HandlingUnitSerialNumber> getAllHandlingUnitSerialNumber() {
        return new GetAllRequestBuilder(this.servicePath, HandlingUnitSerialNumber.class, "HandlingUnitSerialNumber");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<HandlingUnitSerialNumber> countHandlingUnitSerialNumber() {
        return new CountRequestBuilder(this.servicePath, HandlingUnitSerialNumber.class, "HandlingUnitSerialNumber");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<HandlingUnitSerialNumber> getHandlingUnitSerialNumberByKey(String handlingUnitItem, String handlingUnitExternalID, String warehouse, UUID stockItemUUID, String serialNumber) {
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("HandlingUnitItem", handlingUnitItem);
        key.put("HandlingUnitExternalID", handlingUnitExternalID);
        key.put("Warehouse", warehouse);
        key.put("StockItemUUID", stockItemUUID);
        key.put("SerialNumber", serialNumber);
        return new GetByKeyRequestBuilder(this.servicePath, HandlingUnitSerialNumber.class, key, "HandlingUnitSerialNumber");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

