/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measurementdocument.FailedMeasurementReading;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measurementdocument.MeasurementDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measurementdocument.MsmtDocumentLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MeasurementDocumentService;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultMeasurementDocumentService")
public class DefaultMeasurementDocumentService
implements ServiceWithNavigableEntities,
MeasurementDocumentService {
    @Nonnull
    private final String servicePath;

    public DefaultMeasurementDocumentService() {
        this.servicePath = "/sap/opu/odata4/sap/api_measurementdocument/srvd_a2x/sap/measurementdocument/0001";
    }

    private DefaultMeasurementDocumentService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMeasurementDocumentService withServicePath(@Nonnull String servicePath) {
        return new DefaultMeasurementDocumentService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<FailedMeasurementReading> getAllFailedMeasurementReading() {
        return new GetAllRequestBuilder(this.servicePath, FailedMeasurementReading.class, "FailedMeasurementReading");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<FailedMeasurementReading> countFailedMeasurementReading() {
        return new CountRequestBuilder(this.servicePath, FailedMeasurementReading.class, "FailedMeasurementReading");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<FailedMeasurementReading> getFailedMeasurementReadingByKey(LocalDate msmtRdngDate, LocalTime msmtRdngTime, String msmtRdngSourceMeasurementDoc, String measuringPoint) {
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("MsmtRdngDate", msmtRdngDate);
        key.put("MsmtRdngTime", msmtRdngTime);
        key.put("MsmtRdngSourceMeasurementDoc", msmtRdngSourceMeasurementDoc);
        key.put("MeasuringPoint", measuringPoint);
        return new GetByKeyRequestBuilder(this.servicePath, FailedMeasurementReading.class, key, "FailedMeasurementReading");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<FailedMeasurementReading> createFailedMeasurementReading(@Nonnull FailedMeasurementReading failedMeasurementReading) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)failedMeasurementReading, "FailedMeasurementReading");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<MeasurementDocument> getAllMeasurementDocument() {
        return new GetAllRequestBuilder(this.servicePath, MeasurementDocument.class, "MeasurementDocument");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<MeasurementDocument> countMeasurementDocument() {
        return new CountRequestBuilder(this.servicePath, MeasurementDocument.class, "MeasurementDocument");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<MeasurementDocument> getMeasurementDocumentByKey(String measurementDocument) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("MeasurementDocument", measurementDocument);
        return new GetByKeyRequestBuilder(this.servicePath, MeasurementDocument.class, key, "MeasurementDocument");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<MeasurementDocument> createMeasurementDocument(@Nonnull MeasurementDocument measurementDocument) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)measurementDocument, "MeasurementDocument");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<MeasurementDocument> updateMeasurementDocument(@Nonnull MeasurementDocument measurementDocument) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)measurementDocument, "MeasurementDocument");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<MsmtDocumentLongText> getAllMsmtDocumentLongText() {
        return new GetAllRequestBuilder(this.servicePath, MsmtDocumentLongText.class, "MsmtDocumentLongText");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<MsmtDocumentLongText> countMsmtDocumentLongText() {
        return new CountRequestBuilder(this.servicePath, MsmtDocumentLongText.class, "MsmtDocumentLongText");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<MsmtDocumentLongText> getMsmtDocumentLongTextByKey(String measurementDocument) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("MeasurementDocument", measurementDocument);
        return new GetByKeyRequestBuilder(this.servicePath, MsmtDocumentLongText.class, key, "MsmtDocumentLongText");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<MsmtDocumentLongText> createMsmtDocumentLongText(@Nonnull MsmtDocumentLongText msmtDocumentLongText) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)msmtDocumentLongText, "MsmtDocumentLongText");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<MsmtDocumentLongText> updateMsmtDocumentLongText(@Nonnull MsmtDocumentLongText msmtDocumentLongText) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)msmtDocumentLongText, "MsmtDocumentLongText");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

