/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.merchandisecategory.MerchandiseCategory;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.merchandisecategory.MerchandiseCategoryText;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.merchandisecategory.MrchdsCatCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.merchandisecategory.MrchdsCatCharcValRstrcn;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MerchandiseCategoryService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultMerchandiseCategoryService")
public class DefaultMerchandiseCategoryService
implements ServiceWithNavigableEntities,
MerchandiseCategoryService {
    @Nonnull
    private final String servicePath;

    public DefaultMerchandiseCategoryService() {
        this.servicePath = "/sap/opu/odata4/sap/api_merchandisecategory/srvd_a2x/sap/merchandisecategory/0001";
    }

    private DefaultMerchandiseCategoryService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultMerchandiseCategoryService withServicePath(@Nonnull String servicePath) {
        return new DefaultMerchandiseCategoryService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<MerchandiseCategory> getAllMerchandiseCategory() {
        return new GetAllRequestBuilder(this.servicePath, MerchandiseCategory.class, "MerchandiseCategory");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<MerchandiseCategory> countMerchandiseCategory() {
        return new CountRequestBuilder(this.servicePath, MerchandiseCategory.class, "MerchandiseCategory");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<MerchandiseCategory> getMerchandiseCategoryByKey(String merchandiseCategory) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("MerchandiseCategory", merchandiseCategory);
        return new GetByKeyRequestBuilder(this.servicePath, MerchandiseCategory.class, key, "MerchandiseCategory");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<MerchandiseCategory> createMerchandiseCategory(@Nonnull MerchandiseCategory merchandiseCategory) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)merchandiseCategory, "MerchandiseCategory");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<MerchandiseCategory> updateMerchandiseCategory(@Nonnull MerchandiseCategory merchandiseCategory) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)merchandiseCategory, "MerchandiseCategory");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<MerchandiseCategory> deleteMerchandiseCategory(@Nonnull MerchandiseCategory merchandiseCategory) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)merchandiseCategory, "MerchandiseCategory");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<MerchandiseCategoryText> getAllMerchandiseCategoryText() {
        return new GetAllRequestBuilder(this.servicePath, MerchandiseCategoryText.class, "MerchandiseCategoryText");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<MerchandiseCategoryText> countMerchandiseCategoryText() {
        return new CountRequestBuilder(this.servicePath, MerchandiseCategoryText.class, "MerchandiseCategoryText");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<MerchandiseCategoryText> getMerchandiseCategoryTextByKey(String merchandiseCategory, String language) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("MerchandiseCategory", merchandiseCategory);
        key.put("Language", language);
        return new GetByKeyRequestBuilder(this.servicePath, MerchandiseCategoryText.class, key, "MerchandiseCategoryText");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<MerchandiseCategoryText> updateMerchandiseCategoryText(@Nonnull MerchandiseCategoryText merchandiseCategoryText) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)merchandiseCategoryText, "MerchandiseCategoryText");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<MerchandiseCategoryText> deleteMerchandiseCategoryText(@Nonnull MerchandiseCategoryText merchandiseCategoryText) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)merchandiseCategoryText, "MerchandiseCategoryText");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<MrchdsCatCharacteristic> getAllMrchdsCatCharacteristic() {
        return new GetAllRequestBuilder(this.servicePath, MrchdsCatCharacteristic.class, "MrchdsCatCharacteristic");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<MrchdsCatCharacteristic> countMrchdsCatCharacteristic() {
        return new CountRequestBuilder(this.servicePath, MrchdsCatCharacteristic.class, "MrchdsCatCharacteristic");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<MrchdsCatCharacteristic> getMrchdsCatCharacteristicByKey(String merchandiseCategory, String characteristic) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("MerchandiseCategory", merchandiseCategory);
        key.put("Characteristic", characteristic);
        return new GetByKeyRequestBuilder(this.servicePath, MrchdsCatCharacteristic.class, key, "MrchdsCatCharacteristic");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<MrchdsCatCharacteristic> deleteMrchdsCatCharacteristic(@Nonnull MrchdsCatCharacteristic mrchdsCatCharacteristic) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)mrchdsCatCharacteristic, "MrchdsCatCharacteristic");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<MrchdsCatCharcValRstrcn> getAllMrchdsCatCharcValRstrcn() {
        return new GetAllRequestBuilder(this.servicePath, MrchdsCatCharcValRstrcn.class, "MrchdsCatCharcValRstrcn");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<MrchdsCatCharcValRstrcn> countMrchdsCatCharcValRstrcn() {
        return new CountRequestBuilder(this.servicePath, MrchdsCatCharcValRstrcn.class, "MrchdsCatCharcValRstrcn");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<MrchdsCatCharcValRstrcn> getMrchdsCatCharcValRstrcnByKey(String merchandiseCategory, String characteristic, String clfnCharcValuePositionNumber) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("MerchandiseCategory", merchandiseCategory);
        key.put("Characteristic", characteristic);
        key.put("ClfnCharcValuePositionNumber", clfnCharcValuePositionNumber);
        return new GetByKeyRequestBuilder(this.servicePath, MrchdsCatCharcValRstrcn.class, key, "MrchdsCatCharcValRstrcn");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<MrchdsCatCharcValRstrcn> deleteMrchdsCatCharcValRstrcn(@Nonnull MrchdsCatCharcValRstrcn mrchdsCatCharcValRstrcn) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)mrchdsCatCharcValRstrcn, "MrchdsCatCharcValRstrcn");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

