/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.packcontainer.ShipmentItem;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.packcontainer.ShptContainerUnit;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.packcontainer.ShptHandlingUnit;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.packcontainer.ShptStageAssgmtItm;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.packcontainer.ShptStgeAssgmtCtn;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.PackContainerService;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultPackContainerService")
public class DefaultPackContainerService
implements ServiceWithNavigableEntities,
PackContainerService {
    @Nonnull
    private final String servicePath;

    public DefaultPackContainerService() {
        this.servicePath = "/sap/opu/odata4/sap/api_shipmentcontainerpackg/srvd_a2x/sap/shipmentcontainerunit/0001";
    }

    private DefaultPackContainerService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPackContainerService withServicePath(@Nonnull String servicePath) {
        return new DefaultPackContainerService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ShptContainerUnit> getAllShipmentContainer() {
        return new GetAllRequestBuilder(this.servicePath, ShptContainerUnit.class, "ShipmentContainer");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ShptContainerUnit> countShipmentContainer() {
        return new CountRequestBuilder(this.servicePath, ShptContainerUnit.class, "ShipmentContainer");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ShptContainerUnit> getShipmentContainerByKey(UUID fldLogsContainerUnitUUID) {
        HashMap<String, UUID> key = new HashMap<String, UUID>();
        key.put("FldLogsContainerUnitUUID", fldLogsContainerUnitUUID);
        return new GetByKeyRequestBuilder(this.servicePath, ShptContainerUnit.class, key, "ShipmentContainer");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<ShptContainerUnit> createShipmentContainer(@Nonnull ShptContainerUnit shptContainerUnit) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)shptContainerUnit, "ShipmentContainer");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<ShptContainerUnit> updateShipmentContainer(@Nonnull ShptContainerUnit shptContainerUnit) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)shptContainerUnit, "ShipmentContainer");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ShipmentItem> getAllShipmentContainerItem() {
        return new GetAllRequestBuilder(this.servicePath, ShipmentItem.class, "ShipmentContainerItem");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ShipmentItem> countShipmentContainerItem() {
        return new CountRequestBuilder(this.servicePath, ShipmentItem.class, "ShipmentContainerItem");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ShipmentItem> getShipmentContainerItemByKey(UUID fldLogsShptItemUUID) {
        HashMap<String, UUID> key = new HashMap<String, UUID>();
        key.put("FldLogsShptItemUUID", fldLogsShptItemUUID);
        return new GetByKeyRequestBuilder(this.servicePath, ShipmentItem.class, key, "ShipmentContainerItem");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<ShipmentItem> createShipmentContainerItem(@Nonnull ShipmentItem shipmentItem) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)shipmentItem, "ShipmentContainerItem");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ShptStgeAssgmtCtn> getAllShipmentCtnStageAssgnmt() {
        return new GetAllRequestBuilder(this.servicePath, ShptStgeAssgmtCtn.class, "ShipmentCtnStageAssgnmt");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ShptStgeAssgmtCtn> countShipmentCtnStageAssgnmt() {
        return new CountRequestBuilder(this.servicePath, ShptStgeAssgmtCtn.class, "ShipmentCtnStageAssgnmt");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ShptStgeAssgmtCtn> getShipmentCtnStageAssgnmtByKey(UUID fldLogsShptVoyageUUID, UUID fldLogsVoyStgeAssgmtUUID) {
        HashMap<String, UUID> key = new HashMap<String, UUID>();
        key.put("FldLogsShptVoyageUUID", fldLogsShptVoyageUUID);
        key.put("FldLogsVoyStgeAssgmtUUID", fldLogsVoyStgeAssgmtUUID);
        return new GetByKeyRequestBuilder(this.servicePath, ShptStgeAssgmtCtn.class, key, "ShipmentCtnStageAssgnmt");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<ShptStgeAssgmtCtn> deleteShipmentCtnStageAssgnmt(@Nonnull ShptStgeAssgmtCtn shptStgeAssgmtCtn) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)shptStgeAssgmtCtn, "ShipmentCtnStageAssgnmt");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ShptHandlingUnit> getAllShipmentItem() {
        return new GetAllRequestBuilder(this.servicePath, ShptHandlingUnit.class, "ShipmentItem");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ShptHandlingUnit> countShipmentItem() {
        return new CountRequestBuilder(this.servicePath, ShptHandlingUnit.class, "ShipmentItem");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ShptHandlingUnit> getShipmentItemByKey(UUID fldLogsShptItemUUID) {
        HashMap<String, UUID> key = new HashMap<String, UUID>();
        key.put("FldLogsShptItemUUID", fldLogsShptItemUUID);
        return new GetByKeyRequestBuilder(this.servicePath, ShptHandlingUnit.class, key, "ShipmentItem");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<ShptHandlingUnit> createShipmentItem(@Nonnull ShptHandlingUnit shptHandlingUnit) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)shptHandlingUnit, "ShipmentItem");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<ShptHandlingUnit> updateShipmentItem(@Nonnull ShptHandlingUnit shptHandlingUnit) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)shptHandlingUnit, "ShipmentItem");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ShptStageAssgmtItm> getAllShipmentItemStageAssgnmt() {
        return new GetAllRequestBuilder(this.servicePath, ShptStageAssgmtItm.class, "ShipmentItemStageAssgnmt");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ShptStageAssgmtItm> countShipmentItemStageAssgnmt() {
        return new CountRequestBuilder(this.servicePath, ShptStageAssgmtItm.class, "ShipmentItemStageAssgnmt");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ShptStageAssgmtItm> getShipmentItemStageAssgnmtByKey(UUID fldLogsShptVoyageUUID, UUID fldLogsVoyStgeAssgmtUUID) {
        HashMap<String, UUID> key = new HashMap<String, UUID>();
        key.put("FldLogsShptVoyageUUID", fldLogsShptVoyageUUID);
        key.put("FldLogsVoyStgeAssgmtUUID", fldLogsVoyStgeAssgmtUUID);
        return new GetByKeyRequestBuilder(this.servicePath, ShptStageAssgmtItm.class, key, "ShipmentItemStageAssgnmt");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<ShptStageAssgmtItm> deleteShipmentItemStageAssgnmt(@Nonnull ShptStageAssgmtItm shptStageAssgmtItm) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)shptStageAssgmtItm, "ShipmentItemStageAssgnmt");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

