/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.plannedorder.PlannedOrderCapacity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.plannedorder.PlannedOrderComponent;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.plannedorder.PlannedOrderHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.PlannedOrderService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultPlannedOrderService")
public class DefaultPlannedOrderService
implements ServiceWithNavigableEntities,
PlannedOrderService {
    @Nonnull
    private final String servicePath;

    public DefaultPlannedOrderService() {
        this.servicePath = "/sap/opu/odata4/sap/api_plannedorder/srvd_a2x/sap/plannedorder/0001";
    }

    private DefaultPlannedOrderService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPlannedOrderService withServicePath(@Nonnull String servicePath) {
        return new DefaultPlannedOrderService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<PlannedOrderCapacity> getAllPlannedOrderCapacity() {
        return new GetAllRequestBuilder(this.servicePath, PlannedOrderCapacity.class, "PlannedOrderCapacity");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<PlannedOrderCapacity> countPlannedOrderCapacity() {
        return new CountRequestBuilder(this.servicePath, PlannedOrderCapacity.class, "PlannedOrderCapacity");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<PlannedOrderCapacity> getPlannedOrderCapacityByKey(String plannedOrder, String capacityRequirement, String capacityRequirementItem, String capacityRqmtItemCapacity) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("PlannedOrder", plannedOrder);
        key.put("CapacityRequirement", capacityRequirement);
        key.put("CapacityRequirementItem", capacityRequirementItem);
        key.put("CapacityRqmtItemCapacity", capacityRqmtItemCapacity);
        return new GetByKeyRequestBuilder(this.servicePath, PlannedOrderCapacity.class, key, "PlannedOrderCapacity");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<PlannedOrderCapacity> createPlannedOrderCapacity(@Nonnull PlannedOrderCapacity plannedOrderCapacity) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)plannedOrderCapacity, "PlannedOrderCapacity");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<PlannedOrderComponent> getAllPlannedOrderComponent() {
        return new GetAllRequestBuilder(this.servicePath, PlannedOrderComponent.class, "PlannedOrderComponent");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<PlannedOrderComponent> countPlannedOrderComponent() {
        return new CountRequestBuilder(this.servicePath, PlannedOrderComponent.class, "PlannedOrderComponent");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<PlannedOrderComponent> getPlannedOrderComponentByKey(String plannedOrder, String reservation, String reservationItem) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("PlannedOrder", plannedOrder);
        key.put("Reservation", reservation);
        key.put("ReservationItem", reservationItem);
        return new GetByKeyRequestBuilder(this.servicePath, PlannedOrderComponent.class, key, "PlannedOrderComponent");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<PlannedOrderComponent> updatePlannedOrderComponent(@Nonnull PlannedOrderComponent plannedOrderComponent) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)plannedOrderComponent, "PlannedOrderComponent");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<PlannedOrderComponent> deletePlannedOrderComponent(@Nonnull PlannedOrderComponent plannedOrderComponent) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)plannedOrderComponent, "PlannedOrderComponent");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<PlannedOrderHeader> getAllPlannedOrderHeader() {
        return new GetAllRequestBuilder(this.servicePath, PlannedOrderHeader.class, "PlannedOrderHeader");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<PlannedOrderHeader> countPlannedOrderHeader() {
        return new CountRequestBuilder(this.servicePath, PlannedOrderHeader.class, "PlannedOrderHeader");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<PlannedOrderHeader> getPlannedOrderHeaderByKey(String plannedOrder) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("PlannedOrder", plannedOrder);
        return new GetByKeyRequestBuilder(this.servicePath, PlannedOrderHeader.class, key, "PlannedOrderHeader");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<PlannedOrderHeader> createPlannedOrderHeader(@Nonnull PlannedOrderHeader plannedOrderHeader) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)plannedOrderHeader, "PlannedOrderHeader");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<PlannedOrderHeader> updatePlannedOrderHeader(@Nonnull PlannedOrderHeader plannedOrderHeader) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)plannedOrderHeader, "PlannedOrderHeader");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<PlannedOrderHeader> deletePlannedOrderHeader(@Nonnull PlannedOrderHeader plannedOrderHeader) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)plannedOrderHeader, "PlannedOrderHeader");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

