/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.praunittractparticipation.UnitTrCtr;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.praunittractparticipation.UnitTract;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.PraUnitTractParticipationService;
import java.time.LocalDate;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultPraUnitTractParticipationService")
public class DefaultPraUnitTractParticipationService
implements ServiceWithNavigableEntities,
PraUnitTractParticipationService {
    @Nonnull
    private final String servicePath;

    public DefaultPraUnitTractParticipationService() {
        this.servicePath = "/sap/opu/odata4/sap/api_pramaintunitvntctrl_o4/srvd_a2x/sap/pramaintunitvntrctrl/0001";
    }

    private DefaultPraUnitTractParticipationService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultPraUnitTractParticipationService withServicePath(@Nonnull String servicePath) {
        return new DefaultPraUnitTractParticipationService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<UnitTract> getAllTract() {
        return new GetAllRequestBuilder(this.servicePath, UnitTract.class, "Tract");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<UnitTract> countTract() {
        return new CountRequestBuilder(this.servicePath, UnitTract.class, "Tract");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<UnitTract> getTractByKey(String companyCode, String pRAUnitVenture, String pRACombinedProductCode, LocalDate pRAUnitVentureEffctvFrmDte, String pRAUnitVentureUseCtrlNmbr, String pRAUnitVentureTractSqncNmbr) {
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("CompanyCode", companyCode);
        key.put("PRAUnitVenture", pRAUnitVenture);
        key.put("PRACombinedProductCode", pRACombinedProductCode);
        key.put("PRAUnitVentureEffctvFrmDte", pRAUnitVentureEffctvFrmDte);
        key.put("PRAUnitVentureUseCtrlNmbr", pRAUnitVentureUseCtrlNmbr);
        key.put("PRAUnitVentureTractSqncNmbr", pRAUnitVentureTractSqncNmbr);
        return new GetByKeyRequestBuilder(this.servicePath, UnitTract.class, key, "Tract");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<UnitTract> updateTract(@Nonnull UnitTract unitTract) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)unitTract, "Tract");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<UnitTrCtr> getAllUseControl() {
        return new GetAllRequestBuilder(this.servicePath, UnitTrCtr.class, "UseControl");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<UnitTrCtr> countUseControl() {
        return new CountRequestBuilder(this.servicePath, UnitTrCtr.class, "UseControl");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<UnitTrCtr> getUseControlByKey(String companyCode, String pRAUnitVenture, String pRACombinedProductCode, LocalDate pRAUnitVentureEffctvFrmDte) {
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("CompanyCode", companyCode);
        key.put("PRAUnitVenture", pRAUnitVenture);
        key.put("PRACombinedProductCode", pRACombinedProductCode);
        key.put("PRAUnitVentureEffctvFrmDte", pRAUnitVentureEffctvFrmDte);
        return new GetByKeyRequestBuilder(this.servicePath, UnitTrCtr.class, key, "UseControl");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<UnitTrCtr> createUseControl(@Nonnull UnitTrCtr unitTrCtr) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)unitTrCtr, "UseControl");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<UnitTrCtr> updateUseControl(@Nonnull UnitTrCtr unitTrCtr) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)unitTrCtr, "UseControl");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

